/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.metrics;

import com.atlassian.jira.migration.metrics.MetricsInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\fJC\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0012\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/metrics/TimingMetrics;", "", "()V", "log", "Lorg/slf4j/Logger;", "printSummary", "", "metricsMap", "", "", "Lcom/atlassian/jira/migration/metrics/MetricsInfo;", "logTimeMetricsFeatureFlag", "", "time", "R", "", "tag", "block", "Lkotlin/Function0;", "(Ljava/util/Map;ZLjava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nTimingMetrics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimingMetrics.kt\ncom/atlassian/jira/migration/metrics/TimingMetrics\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n372#2,7:56\n1054#3:63\n1549#3:64\n1620#3,3:65\n*S KotlinDebug\n*F\n+ 1 TimingMetrics.kt\ncom/atlassian/jira/migration/metrics/TimingMetrics\n*L\n29#1:56,7\n46#1:63\n47#1:64\n47#1:65,3\n*E\n"})
public final class TimingMetrics {
    @NotNull
    private final Logger log;

    public TimingMetrics() {
        Logger logger2 = LoggerFactory.getLogger(TimingMetrics.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        this.log = logger2;
    }

    public final <R> R time(@NotNull Map<String, MetricsInfo> metricsMap, boolean logTimeMetricsFeatureFlag, @NotNull String tag, @NotNull Function0<? extends R> block) {
        MetricsInfo metricsInfo;
        MetricsInfo metricsInfo2;
        Intrinsics.checkNotNullParameter(metricsMap, (String)"metricsMap");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (!logTimeMetricsFeatureFlag) {
            return (R)block.invoke();
        }
        long startTime = System.currentTimeMillis();
        Object result2 = block.invoke();
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        Map<String, MetricsInfo> $this$getOrPut$iv = metricsMap;
        boolean $i$f$getOrPut = false;
        MetricsInfo value$iv = $this$getOrPut$iv.get(tag);
        if (value$iv == null) {
            boolean bl = false;
            MetricsInfo answer$iv = new MetricsInfo(null, null, 3, null);
            $this$getOrPut$iv.put(tag, answer$iv);
            metricsInfo2 = answer$iv;
        } else {
            metricsInfo2 = value$iv;
        }
        MetricsInfo $this$time_u24lambda_u241 = metricsInfo = metricsInfo2;
        boolean bl = false;
        $this$time_u24lambda_u241.getNumberOfEntities().incrementAndGet();
        $this$time_u24lambda_u241.getTimeInMilliseconds().addAndGet(duration);
        return (R)result2;
    }

    /*
     * WARNING - void declaration
     */
    public final void printSummary(@NotNull Map<String, MetricsInfo> metricsMap, boolean logTimeMetricsFeatureFlag) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$sortedByDescending$iv;
        Intrinsics.checkNotNullParameter(metricsMap, (String)"metricsMap");
        if (!logTimeMetricsFeatureFlag) {
            return;
        }
        String header = StringsKt.padStart$default((String)"Time Taken", (int)12, (char)'\u0000', (int)2, null) + " | " + StringsKt.padStart$default((String)"Count", (int)16, (char)'\u0000', (int)2, null) + " | Entity";
        this.log.info(header);
        Iterable iterable = MapsKt.toList(metricsMap);
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)b;
                boolean bl = false;
                String key = (String)pair.component1();
                MetricsInfo metrics = (MetricsInfo)pair.component2();
                pair = (Pair)a;
                Comparable comparable = Long.valueOf(metrics.getTimeInMilliseconds().get());
                bl = false;
                key = (String)pair.component1();
                metrics = (MetricsInfo)pair.component2();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Long.valueOf(metrics.getTimeInMilliseconds().get()));
            }
        });
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String key = (String)pair.component1();
            MetricsInfo metrics = (MetricsInfo)pair.component2();
            String paddedMilliseconds = StringsKt.padStart$default((String)(metrics.getTimeInMilliseconds() + " ms"), (int)12, (char)'\u0000', (int)2, null);
            String paddedCount = StringsKt.padStart$default((String)(metrics.getNumberOfEntities() + " entities"), (int)16, (char)'\u0000', (int)2, null);
            this.log.info(paddedMilliseconds + " | " + paddedCount + " | " + key);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        this.log.info("* exportByEntity call count is accurate, however some durations are double counted.");
    }
}

