/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.migration;

import com.atlassian.jira.migration.db.FileAttachmentTable;
import com.atlassian.jira.migration.db.JiraIssueTable;
import com.atlassian.jira.migration.migration.MigratedFileEntity;
import com.atlassian.jira.migration.migration.MigratedFileRepository;
import com.atlassian.jira.migration.migration.MigratedFileTable;
import com.atlassian.jira.migration.utility.RetryUtilityKt;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.querydsl.core.QueryException;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.sql.BatchUpdateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\bJ\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\t\u001a\u00020\bJ\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\bJ&\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0015j\b\u0012\u0004\u0012\u00020\u0007`\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\bJ\u0014\u0010\u0018\u001a\u00020\u00192\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ4\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u001c\u001a\u00020\u00192\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/migration/MigratedFileRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "allMigratedFileIds", "", "", "", "mediaClientId", "batchInsertMigratedFile", "", "chunk", "", "Lcom/atlassian/jira/migration/migration/MigratedFileRepository$MigratedFileData;", "findAllFilesToMigrate", "Lkotlin/sequences/Sequence;", "Lcom/atlassian/jira/migration/migration/MigratedFileEntity;", "findMigratedFile", "fileServerId", "getMigratedFileIdsByProject", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "projectId", "insertMigratedFile", "", "recordMigration", "fileMediaId", "migrated", "uploadId", "Companion", "MigratedFileData", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigratedFileRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigratedFileRepository.kt\ncom/atlassian/jira/migration/migration/MigratedFileRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,229:1\n1549#2:230\n1620#2,3:231\n1208#2,2:234\n1238#2,4:236\n1549#2:240\n1620#2,3:241\n1855#2,2:245\n1#3:244\n*S KotlinDebug\n*F\n+ 1 MigratedFileRepository.kt\ncom/atlassian/jira/migration/migration/MigratedFileRepository\n*L\n123#1:230\n123#1:231,3\n135#1:234,2\n135#1:236,4\n151#1:240\n151#1:241,3\n164#1:245,2\n*E\n"})
public final class MigratedFileRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private static final Logger log = LoggerFactory.getLogger(MigratedFileRepository.class);
    private static final int MAX_ATTEMPTS = 3;

    @Inject
    public MigratedFileRepository(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    public final void recordMigration(long fileServerId, @NotNull String fileMediaId, @NotNull String mediaClientId, boolean migrated, @Nullable String uploadId) {
        Intrinsics.checkNotNullParameter((Object)fileMediaId, (String)"fileMediaId");
        Intrinsics.checkNotNullParameter((Object)mediaClientId, (String)"mediaClientId");
        MigratedFileEntity result2 = this.findMigratedFile(fileServerId, mediaClientId);
        if (result2 != null) {
            this.databaseAccessor.run(arg_0 -> MigratedFileRepository.recordMigration$lambda$0(fileMediaId, migrated, uploadId, result2, arg_0), MigratedFileRepository::recordMigration$lambda$1);
        } else {
            this.databaseAccessor.run(arg_0 -> MigratedFileRepository.recordMigration$lambda$2(fileServerId, fileMediaId, mediaClientId, migrated, uploadId, arg_0), MigratedFileRepository::recordMigration$lambda$3);
        }
    }

    public static /* synthetic */ void recordMigration$default(MigratedFileRepository migratedFileRepository, long l, String string, String string2, boolean bl, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        migratedFileRepository.recordMigration(l, string, string2, bl, string3);
    }

    @Nullable
    public final MigratedFileEntity findMigratedFile(long fileServerId, @NotNull String mediaClientId) {
        Intrinsics.checkNotNullParameter((Object)mediaClientId, (String)"mediaClientId");
        return (MigratedFileEntity)this.databaseAccessor.run(arg_0 -> MigratedFileRepository.findMigratedFile$lambda$4(fileServerId, mediaClientId, arg_0), MigratedFileRepository::findMigratedFile$lambda$5);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Sequence<MigratedFileEntity> findAllFilesToMigrate(@NotNull String mediaClientId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)mediaClientId, (String)"mediaClientId");
        Object object = this.databaseAccessor.run(arg_0 -> MigratedFileRepository.findAllFilesToMigrate$lambda$6(mediaClientId, arg_0), MigratedFileRepository::findAllFilesToMigrate$lambda$7);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        Iterable iterable = (Iterable)object;
        MigratedFileTable migratedFileTable = MigratedFileTable.INSTANCE;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(migratedFileTable.toMigratedFileRecord((Tuple)p0));
        }
        return CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Long, String> allMigratedFileIds(@NotNull String mediaClientId) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mediaClientId, (String)"mediaClientId");
        Object object = this.databaseAccessor.run(arg_0 -> MigratedFileRepository.allMigratedFileIds$lambda$9(mediaClientId, arg_0), MigratedFileRepository::allMigratedFileIds$lambda$10);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        Iterable $this$associateBy$iv = (Iterable)object;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Tuple it;
            Tuple tuple = (Tuple)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Object object2 = it.get((Expression)MigratedFileTable.INSTANCE.getFILE_SERVER_ID());
            Intrinsics.checkNotNull((Object)object2);
            it = (Tuple)element$iv$iv;
            Long l = (Long)object2;
            boolean bl2 = false;
            Object object3 = it.get((Expression)MigratedFileTable.INSTANCE.getFILE_MEDIA_ID());
            Intrinsics.checkNotNull((Object)object3);
            String string = (String)object3;
            map.put(l, string);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HashSet<Long> getMigratedFileIdsByProject(long projectId, @NotNull String mediaClientId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)mediaClientId, (String)"mediaClientId");
        Object object = this.databaseAccessor.run(arg_0 -> MigratedFileRepository.getMigratedFileIdsByProject$lambda$13(projectId, mediaClientId, arg_0), MigratedFileRepository::getMigratedFileIdsByProject$lambda$14);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        Iterable iterable = (Iterable)object;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object2 = it.get((Expression)MigratedFileTable.INSTANCE.getFILE_SERVER_ID());
            Intrinsics.checkNotNull((Object)object2);
            collection.add((Long)object2);
        }
        return CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
    }

    public final boolean insertMigratedFile(@NotNull List<MigratedFileData> chunk) {
        boolean bl;
        Intrinsics.checkNotNullParameter(chunk, (String)"chunk");
        try {
            this.databaseAccessor.run(arg_0 -> MigratedFileRepository.insertMigratedFile$lambda$18(chunk, arg_0), MigratedFileRepository::insertMigratedFile$lambda$19);
            bl = true;
        }
        catch (BatchUpdateException ex) {
            log.info("BatchUpdateException occurred: " + ex.getMessage());
            bl = false;
        }
        catch (QueryException ex) {
            log.info("QueryException occurred: " + ex.getMessage());
            bl = false;
        }
        return bl;
    }

    public final void batchInsertMigratedFile(@NotNull List<MigratedFileData> chunk) {
        Intrinsics.checkNotNullParameter(chunk, (String)"chunk");
        RetryUtilityKt.retryWithMaxAttempts(3, (Function0)new Function0<Boolean>(this, chunk){
            final /* synthetic */ MigratedFileRepository this$0;
            final /* synthetic */ List<MigratedFileData> $chunk;
            {
                this.this$0 = $receiver;
                this.$chunk = $chunk;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.this$0.insertMigratedFile(this.$chunk);
            }
        }, batchInsertMigratedFile.2.INSTANCE);
    }

    private static final Long recordMigration$lambda$0(String $fileMediaId, boolean $migrated, String $uploadId, MigratedFileEntity $result, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$fileMediaId, (String)"$fileMediaId");
        return db.update((RelationalPath)MigratedFileTable.INSTANCE).set((Path)MigratedFileTable.INSTANCE.getFILE_MEDIA_ID(), (Object)$fileMediaId).set((Path)MigratedFileTable.INSTANCE.getMIGRATED(), (Object)$migrated).set((Path)MigratedFileTable.INSTANCE.getUPLOAD_ID(), (Object)$uploadId).where((Predicate)MigratedFileTable.INSTANCE.getID().eq((Object)$result.getId())).execute();
    }

    private static final void recordMigration$lambda$1() {
    }

    private static final Long recordMigration$lambda$2(long $fileServerId, String $fileMediaId, String $mediaClientId, boolean $migrated, String $uploadId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$fileMediaId, (String)"$fileMediaId");
        Intrinsics.checkNotNullParameter((Object)$mediaClientId, (String)"$mediaClientId");
        return db.insert((RelationalPath)MigratedFileTable.INSTANCE).set((Path)MigratedFileTable.INSTANCE.getFILE_SERVER_ID(), (Object)$fileServerId).set((Path)MigratedFileTable.INSTANCE.getFILE_MEDIA_ID(), (Object)$fileMediaId).set((Path)MigratedFileTable.INSTANCE.getMEDIA_CLIENT_ID(), (Object)$mediaClientId).set((Path)MigratedFileTable.INSTANCE.getMIGRATED(), (Object)$migrated).set((Path)MigratedFileTable.INSTANCE.getUPLOAD_ID(), (Object)$uploadId).execute();
    }

    private static final void recordMigration$lambda$3() {
    }

    private static final MigratedFileEntity findMigratedFile$lambda$4(long $fileServerId, String $mediaClientId, DatabaseConnection db) {
        MigratedFileEntity migratedFileEntity;
        Intrinsics.checkNotNullParameter((Object)$mediaClientId, (String)"$mediaClientId");
        Tuple tuple = MigratedFileTable.INSTANCE.all();
        Tuple tuple2 = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(tuple, ((Path[])tuple).length)).from((Expression)MigratedFileTable.INSTANCE)).where((Predicate)MigratedFileTable.INSTANCE.getFILE_SERVER_ID().eq((Object)$fileServerId))).where((Predicate)MigratedFileTable.INSTANCE.getMEDIA_CLIENT_ID().eq((Object)$mediaClientId))).orderBy(MigratedFileTable.INSTANCE.getID().asc())).fetchFirst();
        if (tuple2 != null) {
            tuple = tuple2;
            MigratedFileTable migratedFileTable = MigratedFileTable.INSTANCE;
            Tuple p0 = tuple;
            boolean bl = false;
            migratedFileEntity = migratedFileTable.toMigratedFileRecord(p0);
        } else {
            migratedFileEntity = null;
        }
        return migratedFileEntity;
    }

    private static final void findMigratedFile$lambda$5() {
    }

    private static final List findAllFilesToMigrate$lambda$6(String $mediaClientId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$mediaClientId, (String)"$mediaClientId");
        Path[] pathArray = MigratedFileTable.INSTANCE.all();
        return ((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)MigratedFileTable.INSTANCE)).where((Predicate)MigratedFileTable.INSTANCE.getMEDIA_CLIENT_ID().eq((Object)$mediaClientId))).fetch();
    }

    private static final void findAllFilesToMigrate$lambda$7() {
    }

    private static final List allMigratedFileIds$lambda$9(String $mediaClientId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$mediaClientId, (String)"$mediaClientId");
        Expression[] expressionArray = new Expression[]{MigratedFileTable.INSTANCE.getFILE_SERVER_ID(), MigratedFileTable.INSTANCE.getFILE_MEDIA_ID()};
        return ((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)MigratedFileTable.INSTANCE)).where((Predicate)MigratedFileTable.INSTANCE.getMEDIA_CLIENT_ID().eq((Object)$mediaClientId))).fetch();
    }

    private static final void allMigratedFileIds$lambda$10() {
    }

    private static final List getMigratedFileIdsByProject$lambda$13(long $projectId, String $mediaClientId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$mediaClientId, (String)"$mediaClientId");
        Expression[] expressionArray = new Expression[]{MigratedFileTable.INSTANCE.getFILE_SERVER_ID(), MigratedFileTable.INSTANCE.getFILE_MEDIA_ID()};
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)MigratedFileTable.INSTANCE)).join((EntityPath)FileAttachmentTable.Companion.getFILE_ATTACHMENT_TABLE())).on((Predicate)FileAttachmentTable.Companion.getFILE_ATTACHMENT_TABLE().getID().eq((Expression)MigratedFileTable.INSTANCE.getFILE_SERVER_ID()))).join((EntityPath)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE())).on((Predicate)FileAttachmentTable.Companion.getFILE_ATTACHMENT_TABLE().getISSUEID().eq((Expression)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getID()))).where((Predicate)JiraIssueTable.Companion.getJIRA_ISSUE_TABLE().getPROJECT().eq((Object)$projectId))).where((Predicate)MigratedFileTable.INSTANCE.getMEDIA_CLIENT_ID().eq((Object)$mediaClientId))).fetch();
    }

    private static final void getMigratedFileIdsByProject$lambda$14() {
    }

    private static final SQLInsertClause insertMigratedFile$lambda$18(List $chunk, DatabaseConnection db) {
        SQLInsertClause sQLInsertClause;
        Intrinsics.checkNotNullParameter((Object)$chunk, (String)"$chunk");
        SQLInsertClause $this$insertMigratedFile_u24lambda_u2418_u24lambda_u2417 = sQLInsertClause = db.insert((RelationalPath)MigratedFileTable.INSTANCE);
        boolean bl = false;
        Iterable $this$forEach$iv = $chunk;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MigratedFileData it = (MigratedFileData)element$iv;
            boolean bl2 = false;
            $this$insertMigratedFile_u24lambda_u2418_u24lambda_u2417.set((Path)MigratedFileTable.INSTANCE.getFILE_SERVER_ID(), (Object)it.getFileServerId());
            $this$insertMigratedFile_u24lambda_u2418_u24lambda_u2417.set((Path)MigratedFileTable.INSTANCE.getFILE_MEDIA_ID(), (Object)it.getFileMediaId());
            $this$insertMigratedFile_u24lambda_u2418_u24lambda_u2417.set((Path)MigratedFileTable.INSTANCE.getMEDIA_CLIENT_ID(), (Object)it.getMediaClientId());
            $this$insertMigratedFile_u24lambda_u2418_u24lambda_u2417.set((Path)MigratedFileTable.INSTANCE.getMIGRATED(), (Object)false);
            $this$insertMigratedFile_u24lambda_u2418_u24lambda_u2417.addBatch();
        }
        $this$insertMigratedFile_u24lambda_u2418_u24lambda_u2417.execute();
        return sQLInsertClause;
    }

    private static final void insertMigratedFile$lambda$19() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/migration/MigratedFileRepository$Companion;", "", "()V", "MAX_ATTEMPTS", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/migration/MigratedFileRepository$MigratedFileData;", "", "fileServerId", "", "fileMediaId", "", "mediaClientId", "(JLjava/lang/String;Ljava/lang/String;)V", "getFileMediaId", "()Ljava/lang/String;", "getFileServerId", "()J", "getMediaClientId", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-migration-plugin"})
    public static final class MigratedFileData {
        private final long fileServerId;
        @NotNull
        private final String fileMediaId;
        @NotNull
        private final String mediaClientId;

        public MigratedFileData(long fileServerId, @NotNull String fileMediaId, @NotNull String mediaClientId) {
            Intrinsics.checkNotNullParameter((Object)fileMediaId, (String)"fileMediaId");
            Intrinsics.checkNotNullParameter((Object)mediaClientId, (String)"mediaClientId");
            this.fileServerId = fileServerId;
            this.fileMediaId = fileMediaId;
            this.mediaClientId = mediaClientId;
        }

        public final long getFileServerId() {
            return this.fileServerId;
        }

        @NotNull
        public final String getFileMediaId() {
            return this.fileMediaId;
        }

        @NotNull
        public final String getMediaClientId() {
            return this.mediaClientId;
        }

        public final long component1() {
            return this.fileServerId;
        }

        @NotNull
        public final String component2() {
            return this.fileMediaId;
        }

        @NotNull
        public final String component3() {
            return this.mediaClientId;
        }

        @NotNull
        public final MigratedFileData copy(long fileServerId, @NotNull String fileMediaId, @NotNull String mediaClientId) {
            Intrinsics.checkNotNullParameter((Object)fileMediaId, (String)"fileMediaId");
            Intrinsics.checkNotNullParameter((Object)mediaClientId, (String)"mediaClientId");
            return new MigratedFileData(fileServerId, fileMediaId, mediaClientId);
        }

        public static /* synthetic */ MigratedFileData copy$default(MigratedFileData migratedFileData, long l, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                l = migratedFileData.fileServerId;
            }
            if ((n & 2) != 0) {
                string = migratedFileData.fileMediaId;
            }
            if ((n & 4) != 0) {
                string2 = migratedFileData.mediaClientId;
            }
            return migratedFileData.copy(l, string, string2);
        }

        @NotNull
        public String toString() {
            return "MigratedFileData(fileServerId=" + this.fileServerId + ", fileMediaId=" + this.fileMediaId + ", mediaClientId=" + this.mediaClientId + ')';
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.fileServerId);
            result2 = result2 * 31 + this.fileMediaId.hashCode();
            result2 = result2 * 31 + this.mediaClientId.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MigratedFileData)) {
                return false;
            }
            MigratedFileData migratedFileData = (MigratedFileData)other;
            if (this.fileServerId != migratedFileData.fileServerId) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fileMediaId, (Object)migratedFileData.fileMediaId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.mediaClientId, (Object)migratedFileData.mediaClientId);
        }
    }
}

