/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.migration;

import com.atlassian.jira.migration.migration.MigrationCommand;
import com.atlassian.jira.migration.migration.MigrationCommandTable;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0006J\u0016\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/migration/MigrationCommandRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "findBy", "Lcom/atlassian/jira/migration/migration/MigrationCommand;", "migrationId", "", "commandId", "fromTupleToMigration", "tuple", "Lcom/querydsl/core/Tuple;", "removeStaleCommands", "", "save", "migrationCommand", "updateVersion", "version", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationCommandRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationCommandRepository.kt\ncom/atlassian/jira/migration/migration/MigrationCommandRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1#2:153\n*E\n"})
public final class MigrationCommandRepository {
    @NotNull
    private final DatabaseAccessor databaseAccessor;

    @Inject
    public MigrationCommandRepository(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    @Nullable
    public final MigrationCommand findBy(@NotNull String migrationId, @NotNull String commandId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        return (MigrationCommand)this.databaseAccessor.run(arg_0 -> MigrationCommandRepository.findBy$lambda$1(migrationId, commandId, this, arg_0), MigrationCommandRepository::findBy$lambda$2);
    }

    public final void save(@NotNull MigrationCommand migrationCommand) {
        Intrinsics.checkNotNullParameter((Object)migrationCommand, (String)"migrationCommand");
        this.databaseAccessor.run(arg_0 -> MigrationCommandRepository.save$lambda$3(migrationCommand, arg_0), MigrationCommandRepository::save$lambda$4);
    }

    public final void removeStaleCommands() {
        long timePeriod = Instant.now().minus(15L, ChronoUnit.DAYS).toEpochMilli();
        this.databaseAccessor.run(arg_0 -> MigrationCommandRepository.removeStaleCommands$lambda$5(timePeriod, arg_0), OnRollback.NOOP);
    }

    public final void updateVersion(@NotNull MigrationCommand migrationCommand, int version) {
        Intrinsics.checkNotNullParameter((Object)migrationCommand, (String)"migrationCommand");
        this.databaseAccessor.run(arg_0 -> MigrationCommandRepository.updateVersion$lambda$6(version, migrationCommand, arg_0), OnRollback.NOOP);
    }

    private final MigrationCommand fromTupleToMigration(Tuple tuple) {
        Object object = tuple.get((Expression)MigrationCommandTable.INSTANCE.getMIGRATION_ID());
        Intrinsics.checkNotNull((Object)object);
        String string = (String)object;
        Object object2 = tuple.get((Expression)MigrationCommandTable.INSTANCE.getCOMMAND_ID());
        Intrinsics.checkNotNull((Object)object2);
        String string2 = (String)object2;
        Object object3 = tuple.get((Expression)MigrationCommandTable.INSTANCE.getVERSION());
        Intrinsics.checkNotNull((Object)object3);
        int n = ((Number)object3).intValue();
        Object object4 = tuple.get((Expression)MigrationCommandTable.INSTANCE.getCREATED_TIMESTAMP());
        Intrinsics.checkNotNull((Object)object4);
        long l = ((Number)object4).longValue();
        Object object5 = tuple.get((Expression)MigrationCommandTable.INSTANCE.getUPDATED_TIMESTAMP());
        Intrinsics.checkNotNull((Object)object5);
        return new MigrationCommand(string, string2, n, l, ((Number)object5).longValue());
    }

    private static final MigrationCommand findBy$lambda$1(String $migrationId, String $commandId, MigrationCommandRepository this$0, DatabaseConnection db) {
        MigrationCommand migrationCommand;
        Intrinsics.checkNotNullParameter((Object)$migrationId, (String)"$migrationId");
        Intrinsics.checkNotNullParameter((Object)$commandId, (String)"$commandId");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Path[] pathArray = MigrationCommandTable.INSTANCE.all();
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)MigrationCommandTable.INSTANCE)).where((Predicate)MigrationCommandTable.INSTANCE.getMIGRATION_ID().eq((Object)$migrationId).and((Predicate)MigrationCommandTable.INSTANCE.getCOMMAND_ID().eq((Object)$commandId)))).fetchOne();
        if (tuple != null) {
            Tuple it = tuple;
            boolean bl = false;
            migrationCommand = this$0.fromTupleToMigration(it);
        } else {
            migrationCommand = null;
        }
        return migrationCommand;
    }

    private static final void findBy$lambda$2() {
    }

    private static final Long save$lambda$3(MigrationCommand $migrationCommand, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$migrationCommand, (String)"$migrationCommand");
        return db.insert((RelationalPath)MigrationCommandTable.INSTANCE).set((Path)MigrationCommandTable.INSTANCE.getMIGRATION_ID(), (Object)$migrationCommand.getMigrationId()).set((Path)MigrationCommandTable.INSTANCE.getCOMMAND_ID(), (Object)$migrationCommand.getCommandId()).set((Path)MigrationCommandTable.INSTANCE.getVERSION(), (Object)$migrationCommand.getVersion()).set((Path)MigrationCommandTable.INSTANCE.getCREATED_TIMESTAMP(), (Object)$migrationCommand.getCreatedAt()).set((Path)MigrationCommandTable.INSTANCE.getUPDATED_TIMESTAMP(), (Object)$migrationCommand.getUpdatedAt()).execute();
    }

    private static final void save$lambda$4() {
    }

    private static final Long removeStaleCommands$lambda$5(long $timePeriod, DatabaseConnection db) {
        return db.delete((RelationalPath)MigrationCommandTable.INSTANCE).where((Predicate)MigrationCommandTable.INSTANCE.getCREATED_TIMESTAMP().loe((Number)$timePeriod)).execute();
    }

    private static final Long updateVersion$lambda$6(int $version, MigrationCommand $migrationCommand, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$migrationCommand, (String)"$migrationCommand");
        long now = Instant.now().toEpochMilli();
        return db.update((RelationalPath)MigrationCommandTable.INSTANCE).set((Path)MigrationCommandTable.INSTANCE.getVERSION(), (Object)$version).set((Path)MigrationCommandTable.INSTANCE.getUPDATED_TIMESTAMP(), (Object)now).where((Predicate)MigrationCommandTable.INSTANCE.getMIGRATION_ID().eq((Object)$migrationCommand.getMigrationId()).and((Predicate)MigrationCommandTable.INSTANCE.getCOMMAND_ID().eq((Object)$migrationCommand.getCommandId()))).execute();
    }
}

