/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.migration;

import com.atlassian.jira.migration.migration.MigrationCommand;
import com.atlassian.jira.migration.migration.MigrationCommandRepository;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/migration/MigrationCommandService;", "", "migrationCommandRepository", "Lcom/atlassian/jira/migration/migration/MigrationCommandRepository;", "(Lcom/atlassian/jira/migration/migration/MigrationCommandRepository;)V", "cleanUp", "", "find", "Lcom/atlassian/jira/migration/migration/MigrationCommand;", "migrationId", "", "commandId", "upsertVersion", "Companion", "jira-migration-plugin"})
public final class MigrationCommandService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationCommandRepository migrationCommandRepository;
    public static final int DEFAULT_VERSION = 1;

    @Inject
    public MigrationCommandService(@NotNull MigrationCommandRepository migrationCommandRepository) {
        Intrinsics.checkNotNullParameter((Object)migrationCommandRepository, (String)"migrationCommandRepository");
        this.migrationCommandRepository = migrationCommandRepository;
    }

    @NotNull
    public final MigrationCommand upsertVersion(@NotNull String migrationId, @NotNull String commandId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        MigrationCommand migrationCommand = this.migrationCommandRepository.findBy(migrationId, commandId);
        if (migrationCommand == null) {
            migrationCommand = new MigrationCommand(migrationId, commandId, 1, 0L, 0L, 24, null);
            this.migrationCommandRepository.save(migrationCommand);
        } else {
            migrationCommand.setVersion(migrationCommand.getVersion() + 1);
            this.migrationCommandRepository.updateVersion(migrationCommand, migrationCommand.getVersion());
        }
        return migrationCommand;
    }

    @Nullable
    public final MigrationCommand find(@NotNull String migrationId, @NotNull String commandId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        return this.migrationCommandRepository.findBy(migrationId, commandId);
    }

    public final void cleanUp() {
        this.migrationCommandRepository.removeStaleCommands();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/migration/MigrationCommandService$Companion;", "", "()V", "DEFAULT_VERSION", "", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

