/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.migration;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.migration.migration.MigrationIncrement;
import com.atlassian.jira.migration.migration.MigrationIncrementEntity;
import com.atlassian.jira.migration.migration.MigrationIncrementRepositoryException;
import com.atlassian.jira.migration.migration.MigrationIncrementStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/migration/MigrationIncrementRepository;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;)V", "create", "", "migrationIncrement", "Lcom/atlassian/jira/migration/migration/MigrationIncrement;", "findAllByStatus", "", "projectId", "", "planId", "", "migrationIncrementStatus", "Lcom/atlassian/jira/migration/migration/MigrationIncrementStatus;", "findLatest", "findLatestByStatus", "getIncrementForProjectAndMigration", "migrationId", "hasFinalIncrement", "", "save", "toMigrationIncrement", "entity", "Lcom/atlassian/jira/migration/migration/MigrationIncrementEntity;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationIncrementRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationIncrementRepository.kt\ncom/atlassian/jira/migration/migration/MigrationIncrementRepository\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,188:1\n11065#2:189\n11400#2,3:190\n11065#2:193\n11400#2,3:194\n11065#2:197\n11400#2,3:198\n11065#2:201\n11400#2,3:202\n*S KotlinDebug\n*F\n+ 1 MigrationIncrementRepository.kt\ncom/atlassian/jira/migration/migration/MigrationIncrementRepository\n*L\n60#1:189\n60#1:190,3\n75#1:193\n75#1:194,3\n88#1:197\n88#1:198,3\n96#1:201\n96#1:202,3\n*E\n"})
public final class MigrationIncrementRepository {
    @NotNull
    private final ActiveObjects ao;

    @Inject
    public MigrationIncrementRepository(@NotNull ActiveObjects ao) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        this.ao = ao;
    }

    public final void create(@NotNull MigrationIncrement migrationIncrement) {
        Intrinsics.checkNotNullParameter((Object)migrationIncrement, (String)"migrationIncrement");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ID", (Object)migrationIncrement.getId()), TuplesKt.to((Object)"START_TIME", (Object)migrationIncrement.getStartTime()), TuplesKt.to((Object)"PLAN_ID", (Object)migrationIncrement.getPlanId()), TuplesKt.to((Object)"MIGRATION_ID", (Object)migrationIncrement.getMigrationId()), TuplesKt.to((Object)"CLOUD_ID", (Object)migrationIncrement.getCloudId()), TuplesKt.to((Object)"PROJECT_ID", (Object)migrationIncrement.getProjectId()), TuplesKt.to((Object)"CUTOFF", (Object)migrationIncrement.getCutoff()), TuplesKt.to((Object)"STATUS", (Object)migrationIncrement.getStatus().toString()), TuplesKt.to((Object)"FINAL", (Object)migrationIncrement.getFinal())};
        this.ao.create(MigrationIncrementEntity.class, MapsKt.mapOf((Pair[])pairArray));
    }

    public final void save(@NotNull MigrationIncrement migrationIncrement) {
        block2: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)migrationIncrement, (String)"migrationIncrement");
            MigrationIncrementEntity migrationIncrementEntity = (MigrationIncrementEntity)this.ao.get(MigrationIncrementEntity.class, (Object)migrationIncrement.getId());
            if (migrationIncrementEntity != null) {
                MigrationIncrementEntity it = migrationIncrementEntity;
                boolean bl = false;
                it.setId(migrationIncrement.getId());
                it.setStartTime(migrationIncrement.getStartTime());
                it.setPlanId(migrationIncrement.getPlanId());
                it.setMigrationId(migrationIncrement.getMigrationId());
                it.setCloudId(migrationIncrement.getCloudId());
                it.setProjectId(migrationIncrement.getProjectId());
                it.setCutoff(migrationIncrement.getCutoff());
                it.setStatus(migrationIncrement.getStatus().name());
                it.setFinal(migrationIncrement.getFinal());
                it.save();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block2;
            this.create(migrationIncrement);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MigrationIncrement findLatest(long projectId, @NotNull String planId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Object[] objectArray = new Object[]{projectId, planId};
        RawEntity[] rawEntityArray = this.ao.find(MigrationIncrementEntity.class, Query.select().where("PROJECT_ID = ? AND PLAN_ID = ?", objectArray).order("CUTOFF DESC").limit(1));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Object[] objectArray2 = rawEntityArray;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MigrationIncrementEntity migrationIncrementEntity = (MigrationIncrementEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.toMigrationIncrement((MigrationIncrementEntity)it));
        }
        return (MigrationIncrement)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MigrationIncrement findLatestByStatus(long projectId, @NotNull String planId, @NotNull MigrationIncrementStatus migrationIncrementStatus) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)((Object)migrationIncrementStatus), (String)"migrationIncrementStatus");
        Object[] objectArray = new Object[]{projectId, planId, migrationIncrementStatus};
        RawEntity[] rawEntityArray = this.ao.find(MigrationIncrementEntity.class, Query.select().where("PROJECT_ID = ? AND PLAN_ID = ? AND STATUS = ?", objectArray).order("CUTOFF DESC").limit(1));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Object[] objectArray2 = rawEntityArray;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MigrationIncrementEntity migrationIncrementEntity = (MigrationIncrementEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.toMigrationIncrement((MigrationIncrementEntity)it));
        }
        return (MigrationIncrement)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MigrationIncrement> findAllByStatus(long projectId, @NotNull String planId, @NotNull MigrationIncrementStatus migrationIncrementStatus) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)((Object)migrationIncrementStatus), (String)"migrationIncrementStatus");
        Object[] objectArray = new Object[]{projectId, planId, migrationIncrementStatus};
        RawEntity[] rawEntityArray = this.ao.find(MigrationIncrementEntity.class, Query.select().where("PROJECT_ID = ? AND PLAN_ID = ? AND STATUS = ?", objectArray).order("CUTOFF DESC"));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Object[] objectArray2 = rawEntityArray;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MigrationIncrementEntity migrationIncrementEntity = (MigrationIncrementEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.toMigrationIncrement((MigrationIncrementEntity)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MigrationIncrement getIncrementForProjectAndMigration(long projectId, @NotNull String migrationId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Object[] objectArray = new Object[]{projectId, migrationId};
        RawEntity[] rawEntityArray = this.ao.find(MigrationIncrementEntity.class, Query.select().where("PROJECT_ID = ? AND MIGRATION_ID = ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Object[] objectArray2 = rawEntityArray;
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MigrationIncrementEntity migrationIncrementEntity = (MigrationIncrementEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.toMigrationIncrement((MigrationIncrementEntity)it));
        }
        List increments = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (increments.size() != 1) {
            throw new MigrationIncrementRepositoryException("Expected there to be exactly one increment for migration" + migrationId + " and project " + projectId + " but found " + increments.size() + '.');
        }
        return (MigrationIncrement)increments.get(0);
    }

    public final boolean hasFinalIncrement(@NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Object[] objectArray = new Object[]{planId, true};
        int hasFinalIncrement = this.ao.count(MigrationIncrementEntity.class, Query.select().where("PLAN_ID = ? AND FINAL = ?", objectArray));
        return hasFinalIncrement > 0;
    }

    private final MigrationIncrement toMigrationIncrement(MigrationIncrementEntity entity) {
        return new MigrationIncrement(entity.getId(), entity.getStartTime(), entity.getPlanId(), entity.getMigrationId(), entity.getCloudId(), entity.getProjectId(), entity.getCutoff(), MigrationIncrementStatus.valueOf(entity.getStatus()), entity.getFinal());
    }
}

