/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.migration;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.migration.migration.MigrationPreflight;
import com.atlassian.jira.migration.migration.MigrationPreflightTable;
import com.atlassian.migration.api.MigrationId;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\fJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/migration/MigrationPreflightRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;)V", "fromTupleToMigration", "Lcom/atlassian/jira/migration/migration/MigrationPreflight;", "tuple", "Lcom/querydsl/core/Tuple;", "getCountFromPlanName", "", "planName", "", "getPlanIdByExecutionId", "executionId", "getPlanIdByPreflightId", "preflightId", "save", "", "preflight", "update", "planId", "jira-migration-plugin"})
public final class MigrationPreflightRepository {
    @NotNull
    private final DatabaseAccessor databaseAccessor;

    @Inject
    public MigrationPreflightRepository(@NotNull DatabaseAccessor databaseAccessor) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        this.databaseAccessor = databaseAccessor;
    }

    public final void save(@NotNull MigrationPreflight preflight) {
        Intrinsics.checkNotNullParameter((Object)preflight, (String)"preflight");
        this.databaseAccessor.run(arg_0 -> MigrationPreflightRepository.save$lambda$0(preflight, arg_0), MigrationPreflightRepository::save$lambda$1);
    }

    public final void update(@NotNull String planId, @NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        this.databaseAccessor.run(arg_0 -> MigrationPreflightRepository.update$lambda$2(planId, executionId, arg_0), OnRollback.NOOP);
    }

    public final long getCountFromPlanName(@NotNull String planName) {
        Intrinsics.checkNotNullParameter((Object)planName, (String)"planName");
        Object object = this.databaseAccessor.run(arg_0 -> MigrationPreflightRepository.getCountFromPlanName$lambda$3(planName, arg_0), MigrationPreflightRepository::getCountFromPlanName$lambda$4);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return ((Number)object).longValue();
    }

    @Nullable
    public final String getPlanIdByExecutionId(@NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        return (String)this.databaseAccessor.run(arg_0 -> MigrationPreflightRepository.getPlanIdByExecutionId$lambda$5(executionId, arg_0), MigrationPreflightRepository::getPlanIdByExecutionId$lambda$6);
    }

    @Nullable
    public final String getPlanIdByPreflightId(@NotNull String preflightId) {
        Intrinsics.checkNotNullParameter((Object)preflightId, (String)"preflightId");
        return (String)this.databaseAccessor.run(arg_0 -> MigrationPreflightRepository.getPlanIdByPreflightId$lambda$7(preflightId, arg_0), MigrationPreflightRepository::getPlanIdByPreflightId$lambda$8);
    }

    @VisibleForTesting
    @NotNull
    public final MigrationPreflight fromTupleToMigration(@NotNull Tuple tuple) {
        Intrinsics.checkNotNullParameter((Object)tuple, (String)"tuple");
        Object object = tuple.get((Expression)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getPREFLIGHT_ID());
        Intrinsics.checkNotNull((Object)object);
        MigrationId migrationId = new MigrationId((String)object);
        String string = (String)tuple.get((Expression)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getPLAN_ID());
        Object object2 = tuple.get((Expression)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getPLAN_NAME());
        Intrinsics.checkNotNull((Object)object2);
        String string2 = (String)object2;
        Object object3 = tuple.get((Expression)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getEXECUTION_ID());
        Intrinsics.checkNotNull((Object)object3);
        String string3 = (String)object3;
        String string4 = (String)tuple.get((Expression)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getNODE_ID());
        if (string4 == null) {
            string4 = "";
        }
        Object object4 = tuple.get((Expression)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getCREATED_TIMESTAMP());
        Intrinsics.checkNotNull((Object)object4);
        return new MigrationPreflight(migrationId, string, string2, string3, string4, ((Number)object4).longValue());
    }

    private static final Long save$lambda$0(MigrationPreflight $preflight, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$preflight, (String)"$preflight");
        return db.insert((RelationalPath)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE()).set((Path)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getPREFLIGHT_ID(), (Object)$preflight.getPreflightId().toString()).set((Path)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getPLAN_ID(), (Object)$preflight.getPlanId()).set((Path)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getPLAN_NAME(), (Object)$preflight.getPlanName()).set((Path)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getEXECUTION_ID(), (Object)$preflight.getExecutionId()).set((Path)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getNODE_ID(), (Object)$preflight.getNodeId()).set((Path)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getCREATED_TIMESTAMP(), (Object)$preflight.getCreatedAt()).execute();
    }

    private static final void save$lambda$1() {
    }

    private static final Long update$lambda$2(String $planId, String $executionId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$planId, (String)"$planId");
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Predicate[] predicateArray = new Predicate[]{MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getEXECUTION_ID().eq((Object)$executionId), MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getPLAN_ID().isNull()};
        return db.update((RelationalPath)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE()).set((Path)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getPLAN_ID(), (Object)$planId).where(predicateArray).execute();
    }

    private static final Long getCountFromPlanName$lambda$3(String $planName, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$planName, (String)"$planName");
        Path[] pathArray = MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().all();
        return ((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE())).where((Predicate)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getPLAN_NAME().eq((Object)$planName))).fetchCount();
    }

    private static final void getCountFromPlanName$lambda$4() {
    }

    private static final String getPlanIdByExecutionId$lambda$5(String $executionId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        return (String)((SQLQuery)((SQLQuery)db.select((Expression)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getPLAN_ID()).from((Expression)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE())).where((Predicate)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getEXECUTION_ID().eq((Object)$executionId))).fetchFirst();
    }

    private static final void getPlanIdByExecutionId$lambda$6() {
    }

    private static final String getPlanIdByPreflightId$lambda$7(String $preflightId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$preflightId, (String)"$preflightId");
        return (String)((SQLQuery)((SQLQuery)db.select((Expression)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getPLAN_ID()).from((Expression)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE())).where((Predicate)MigrationPreflightTable.Companion.getMIG_PREFLIGHT_TABLE().getPREFLIGHT_ID().eq((Object)$preflightId))).fetchFirst();
    }

    private static final void getPlanIdByPreflightId$lambda$8() {
    }
}

