/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.migration;

import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.migration.DuplicateMigrationException;
import com.atlassian.jira.migration.migration.InProgressStatus;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationProtocol;
import com.atlassian.jira.migration.migration.MigrationRepositoryException;
import com.atlassian.jira.migration.migration.MigrationTable;
import com.atlassian.jira.migration.migration.StartMigrationContext;
import com.atlassian.jira.migration.orchestratorclient.GetTaskStatusResponse;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTask;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressItem;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.progress.AppProgress;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u000fJ\b\u0010\u0016\u001a\u0004\u0018\u00010\u0013J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u001eJ\u0014\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 H\u0002J \u0010\"\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001e2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001eH\u0002J\u000e\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u0013J.\u0010'\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020)0(2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0016\u0010*\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u000fJ\u0016\u0010,\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u0011J&\u0010.\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u001e2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0016\u0010/\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u0011J&\u00101\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\u001e2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0018\u00102\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/atlassian/jira/migration/migration/MigrationRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "clearAppStatusForRerun", "", "migrationId", "", "updated", "Ljava/time/Instant;", "findByMigrationId", "Lcom/atlassian/jira/migration/migration/Migration;", "findLatestByPlanId", "planId", "findLatestCompletedMigration", "findPlanIdByMigrationId", "findProtocolByMigrationId", "Lcom/atlassian/jira/migration/migration/MigrationProtocol;", "fromTupleToMigration", "tuple", "Lcom/querydsl/core/Tuple;", "getInProgressMigrations", "", "removeIncompatiblePropertiesInProgressStatus", "Lcom/atlassian/jira/migration/migration/InProgressStatus;", "status", "removeIncompatiblePropertiesInTaskProgress", "Lcom/atlassian/jira/migration/orchestratorclient/GetTaskStatusResponse$TaskProgress;", "outcome", "save", "migration", "saveAppStatus", "", "Lcom/atlassian/jira/migration/progress/AppProgress;", "saveDataMovementId", "dataMovementId", "saveEndUserMigrationTime", "endTime", "saveOutcome", "saveStartUserMigrationTime", "startTime", "saveStatus", "touch", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationRepository.kt\ncom/atlassian/jira/migration/migration/MigrationRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,532:1\n1549#2:533\n1620#2,2:534\n1238#2,4:538\n1622#2:542\n1549#2:543\n1620#2,2:544\n1238#2,4:548\n1622#2:552\n1549#2:560\n1620#2,3:561\n1549#2:564\n1620#2,3:565\n453#3:536\n403#3:537\n453#3:546\n403#3:547\n1#4:553\n51#5:554\n51#5:555\n51#5:556\n51#5:557\n51#5:558\n51#5:559\n*S KotlinDebug\n*F\n+ 1 MigrationRepository.kt\ncom/atlassian/jira/migration/migration/MigrationRepository\n*L\n170#1:533\n170#1:534,2\n172#1:538,4\n170#1:542\n188#1:543\n188#1:544,2\n190#1:548,4\n188#1:552\n148#1:560\n148#1:561,3\n314#1:564\n314#1:565,3\n172#1:536\n172#1:537\n190#1:546\n190#1:547\n410#1:554\n413#1:555\n415#1:556\n417#1:557\n420#1:558\n130#1:559\n*E\n"})
public final class MigrationRepository {
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    private final Logger log;
    @NotNull
    private final ObjectMapper mapper;

    @Inject
    public MigrationRepository(@NotNull DatabaseAccessor databaseAccessor, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.databaseAccessor = databaseAccessor;
        this.log = LoggerFactory.getLogger(MigrationRepository.class);
        this.mapper = objectMapperFactory.createObjectMapper();
    }

    @Nullable
    public final Migration findLatestByPlanId(@NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        return (Migration)this.databaseAccessor.run(arg_0 -> MigrationRepository.findLatestByPlanId$lambda$0(planId, this, arg_0), MigrationRepository::findLatestByPlanId$lambda$1);
    }

    @Nullable
    public final Migration findByMigrationId(@NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        return (Migration)this.databaseAccessor.run(arg_0 -> MigrationRepository.findByMigrationId$lambda$3(migrationId, this, arg_0), MigrationRepository::findByMigrationId$lambda$4);
    }

    @Nullable
    public final String findPlanIdByMigrationId(@NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        return (String)this.databaseAccessor.run(arg_0 -> MigrationRepository.findPlanIdByMigrationId$lambda$5(migrationId, arg_0), MigrationRepository::findPlanIdByMigrationId$lambda$6);
    }

    @Nullable
    public final MigrationProtocol findProtocolByMigrationId(@NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        return (MigrationProtocol)((Object)this.databaseAccessor.run(arg_0 -> MigrationRepository.findProtocolByMigrationId$lambda$9(migrationId, this, arg_0), MigrationRepository::findProtocolByMigrationId$lambda$10));
    }

    @NotNull
    public final List<Migration> getInProgressMigrations() {
        Object object = this.databaseAccessor.run(arg_0 -> MigrationRepository.getInProgressMigrations$lambda$12(this, arg_0), MigrationRepository::getInProgressMigrations$lambda$13);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"run(...)");
        return (List)object;
    }

    @Nullable
    public final Migration findLatestCompletedMigration() {
        return (Migration)this.databaseAccessor.run(arg_0 -> MigrationRepository.findLatestCompletedMigration$lambda$15(this, arg_0), MigrationRepository::findLatestCompletedMigration$lambda$16);
    }

    /*
     * WARNING - void declaration
     */
    private final List<GetTaskStatusResponse.TaskProgress> removeIncompatiblePropertiesInTaskProgress(List<GetTaskStatusResponse.TaskProgress> outcome) {
        List list;
        try {
            List list2;
            List<GetTaskStatusResponse.TaskProgress> list3 = outcome;
            if (list3 != null) {
                void $this$mapTo$iv$iv;
                List<GetTaskStatusResponse.TaskProgress> it = list3;
                boolean bl = false;
                Iterable $this$map$iv = it;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Map map;
                    void $this$mapValuesTo$iv$iv;
                    void $this$mapValues$iv;
                    void taskProgress;
                    GetTaskStatusResponse.TaskProgress taskProgress2 = (GetTaskStatusResponse.TaskProgress)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    Map<ProgressUnit, ProgressItem> map2 = taskProgress.getProgressItems();
                    MigrationTask migrationTask = null;
                    void var17_17 = taskProgress;
                    boolean $i$f$mapValues = false;
                    void var19_19 = $this$mapValues$iv;
                    Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void it$iv$iv;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        Map map3 = destination$iv$iv2;
                        boolean bl3 = false;
                        Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                        Object k = it$iv$iv.getKey();
                        map = map3;
                        boolean bl4 = false;
                        ProgressItem progressItem = (ProgressItem)entry2.getValue();
                        ProgressItem progressItem2 = ProgressItem.copy$default(progressItem, 0L, 0L, null, false, null, null, null, null, null, 255, null);
                        map.put(k, progressItem2);
                    }
                    map = destination$iv$iv2;
                    collection.add(GetTaskStatusResponse.TaskProgress.copy$default((GetTaskStatusResponse.TaskProgress)var17_17, migrationTask, map, 1, null));
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = null;
            }
            list = list2;
        }
        catch (Exception e) {
            this.log.error("Failed to remove incompatible properties from outcome ", (Throwable)e);
            list = null;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final InProgressStatus removeIncompatiblePropertiesInProgressStatus(InProgressStatus status) {
        InProgressStatus inProgressStatus;
        try {
            InProgressStatus inProgressStatus2;
            InProgressStatus inProgressStatus3 = status;
            if (inProgressStatus3 != null) {
                Collection<GetTaskStatusResponse.TaskProgress> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                InProgressStatus it = inProgressStatus3;
                boolean bl = false;
                Iterable iterable = it.getStatus();
                Instant instant = null;
                InProgressStatus inProgressStatus4 = it;
                boolean $i$f$map = false;
                void var9_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Map map;
                    void $this$mapValuesTo$iv$iv;
                    void $this$mapValues$iv;
                    void taskProgress;
                    GetTaskStatusResponse.TaskProgress taskProgress2 = (GetTaskStatusResponse.TaskProgress)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    Map<ProgressUnit, ProgressItem> map2 = taskProgress.getProgressItems();
                    MigrationTask migrationTask = null;
                    void var19_19 = taskProgress;
                    boolean $i$f$mapValues = false;
                    void var21_21 = $this$mapValues$iv;
                    Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void it$iv$iv;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        Map map3 = destination$iv$iv2;
                        boolean bl3 = false;
                        Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                        Object k = it$iv$iv.getKey();
                        map = map3;
                        boolean bl4 = false;
                        ProgressItem progressItem = (ProgressItem)entry2.getValue();
                        ProgressItem progressItem2 = ProgressItem.copy$default(progressItem, 0L, 0L, null, false, null, null, null, null, null, 255, null);
                        map.put(k, progressItem2);
                    }
                    map = destination$iv$iv2;
                    collection.add(GetTaskStatusResponse.TaskProgress.copy$default((GetTaskStatusResponse.TaskProgress)var19_19, migrationTask, map, 1, null));
                }
                collection = (List)destination$iv$iv;
                inProgressStatus2 = InProgressStatus.copy$default(inProgressStatus4, instant, (List)collection, 1, null);
            } else {
                inProgressStatus2 = null;
            }
            inProgressStatus = inProgressStatus2;
        }
        catch (Exception e) {
            this.log.error("Failed to remove incompatible properties from in-progress status ", (Throwable)e);
            inProgressStatus = null;
        }
        return inProgressStatus;
    }

    public final void saveOutcome(@NotNull String migrationId, @NotNull List<GetTaskStatusResponse.TaskProgress> outcome, @NotNull Instant updated) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter(outcome, (String)"outcome");
        Intrinsics.checkNotNullParameter((Object)updated, (String)"updated");
        List<GetTaskStatusResponse.TaskProgress> updatedOutcome = this.removeIncompatiblePropertiesInTaskProgress(outcome);
        this.databaseAccessor.run(arg_0 -> MigrationRepository.saveOutcome$lambda$23(this, outcome, migrationId, updatedOutcome, updated, arg_0), MigrationRepository::saveOutcome$lambda$24);
    }

    public static /* synthetic */ void saveOutcome$default(MigrationRepository migrationRepository, String string, List list, Instant instant, int n, Object object) {
        if ((n & 4) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            instant = instant2;
        }
        migrationRepository.saveOutcome(string, list, instant);
    }

    public final void saveStartUserMigrationTime(@NotNull String migrationId, @NotNull Instant startTime) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        this.databaseAccessor.run(arg_0 -> MigrationRepository.saveStartUserMigrationTime$lambda$25(startTime, migrationId, arg_0), MigrationRepository::saveStartUserMigrationTime$lambda$26);
    }

    public final void saveEndUserMigrationTime(@NotNull String migrationId, @NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        this.databaseAccessor.run(arg_0 -> MigrationRepository.saveEndUserMigrationTime$lambda$27(endTime, migrationId, arg_0), MigrationRepository::saveEndUserMigrationTime$lambda$28);
    }

    public final void saveDataMovementId(@NotNull String migrationId, @NotNull String dataMovementId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)dataMovementId, (String)"dataMovementId");
        this.databaseAccessor.run(arg_0 -> MigrationRepository.saveDataMovementId$lambda$29(dataMovementId, migrationId, arg_0), MigrationRepository::saveDataMovementId$lambda$30);
    }

    public final void saveStatus(@NotNull String migrationId, @NotNull List<GetTaskStatusResponse.TaskProgress> status, @NotNull Instant updated) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter(status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)updated, (String)"updated");
        List<GetTaskStatusResponse.TaskProgress> updatedStatus = this.removeIncompatiblePropertiesInTaskProgress(status);
        this.databaseAccessor.run(arg_0 -> MigrationRepository.saveStatus$lambda$32(this, status, migrationId, updatedStatus, updated, arg_0), MigrationRepository::saveStatus$lambda$33);
    }

    public static /* synthetic */ void saveStatus$default(MigrationRepository migrationRepository, String string, List list, Instant instant, int n, Object object) {
        if ((n & 4) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            instant = instant2;
        }
        migrationRepository.saveStatus(string, list, instant);
    }

    public final void saveAppStatus(@NotNull String planId, @NotNull String migrationId, @NotNull Set<AppProgress> status, @NotNull Instant updated) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter(status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)updated, (String)"updated");
        this.databaseAccessor.run(arg_0 -> MigrationRepository.saveAppStatus$lambda$35(status, this, planId, migrationId, updated, arg_0), MigrationRepository::saveAppStatus$lambda$36);
    }

    public static /* synthetic */ void saveAppStatus$default(MigrationRepository migrationRepository, String string, String string2, Set set, Instant instant, int n, Object object) {
        if ((n & 8) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            instant = instant2;
        }
        migrationRepository.saveAppStatus(string, string2, set, instant);
    }

    public final void clearAppStatusForRerun(@NotNull String migrationId, @NotNull Instant updated) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)updated, (String)"updated");
        this.databaseAccessor.run(arg_0 -> MigrationRepository.clearAppStatusForRerun$lambda$37(updated, migrationId, arg_0), MigrationRepository::clearAppStatusForRerun$lambda$38);
    }

    public static /* synthetic */ void clearAppStatusForRerun$default(MigrationRepository migrationRepository, String string, Instant instant, int n, Object object) {
        if ((n & 2) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            instant = instant2;
        }
        migrationRepository.clearAppStatusForRerun(string, instant);
    }

    public final void touch(@NotNull String migrationId, @NotNull Instant updated) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)updated, (String)"updated");
        this.databaseAccessor.run(arg_0 -> MigrationRepository.touch$lambda$39(updated, migrationId, arg_0), MigrationRepository::touch$lambda$40);
    }

    public static /* synthetic */ void touch$default(MigrationRepository migrationRepository, String string, Instant instant, int n, Object object) {
        if ((n & 2) != 0) {
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
            instant = instant2;
        }
        migrationRepository.touch(string, instant);
    }

    @NotNull
    public final Migration save(@NotNull Migration migration) {
        InProgressStatus inProgressStatus;
        List<GetTaskStatusResponse.TaskProgress> list;
        Intrinsics.checkNotNullParameter((Object)migration, (String)"migration");
        if (this.findByMigrationId(migration.getMigrationId()) != null) {
            throw new DuplicateMigrationException();
        }
        List<GetTaskStatusResponse.TaskProgress> list2 = migration.getOutcome();
        if (list2 != null) {
            List<GetTaskStatusResponse.TaskProgress> it = list2;
            boolean bl = false;
            list = this.removeIncompatiblePropertiesInTaskProgress(migration.getOutcome());
        } else {
            list = null;
        }
        List<GetTaskStatusResponse.TaskProgress> updatedOutcome = list;
        InProgressStatus inProgressStatus2 = migration.getStatus();
        if (inProgressStatus2 != null) {
            InProgressStatus it = inProgressStatus2;
            boolean bl = false;
            inProgressStatus = this.removeIncompatiblePropertiesInProgressStatus(migration.getStatus());
        } else {
            inProgressStatus = null;
        }
        InProgressStatus updatedInProgressStatus = inProgressStatus;
        try {
            this.databaseAccessor.run(arg_0 -> MigrationRepository.save$lambda$48(migration, this, updatedOutcome, updatedInProgressStatus, arg_0), MigrationRepository::save$lambda$49);
            this.log.info("Migration for plan " + migration.getPlanId() + " saved under migration id " + migration.getMigrationId());
        }
        catch (RuntimeException e) {
            throw new MigrationRepositoryException("Failure when trying to save migration entity", e);
        }
        catch (IOException e) {
            throw new MigrationRepositoryException("JSON serialization error for migrationId=" + migration.getMigrationId(), e);
        }
        return migration;
    }

    private final Migration fromTupleToMigration(Tuple tuple) {
        StartMigrationContext startMigrationContext = null;
        List outcome = null;
        Set appOutcome = null;
        InProgressStatus status = null;
        MigrationProtocol protocol = null;
        try {
            MigrationProtocol migrationProtocol;
            String protocolJson;
            String string;
            InProgressStatus inProgressStatus;
            String string2;
            Set set;
            List list;
            boolean $i$f$jacksonTypeRef;
            Object it;
            StartMigrationContext startMigrationContext2;
            String string3 = (String)tuple.get((Expression)MigrationTable.Companion.getMIGRATION_TABLE().getSTART_MIGRATION_CONTEXT_JSON());
            if (string3 != null) {
                String it2 = string3;
                boolean bl = false;
                boolean $i$f$jacksonTypeRef2 = false;
                startMigrationContext2 = (StartMigrationContext)this.mapper.readValue(it2, (TypeReference)new TypeReference<StartMigrationContext>(){});
            } else {
                startMigrationContext2 = null;
            }
            Object object = startMigrationContext2;
            startMigrationContext = object == null ? new StartMigrationContext(MapsKt.emptyMap()) : object;
            String string4 = (String)tuple.get((Expression)MigrationTable.Companion.getMIGRATION_TABLE().getOUTCOME_JSON_V2());
            if (string4 == null) {
                string4 = (String)tuple.get((Expression)MigrationTable.Companion.getMIGRATION_TABLE().getOUTCOME_JSON());
            }
            if ((object = string4) != null) {
                it = object;
                boolean bl = false;
                $i$f$jacksonTypeRef = false;
                list = (List)this.mapper.readValue((String)it, (TypeReference)new TypeReference<List<? extends GetTaskStatusResponse.TaskProgress>>(){});
            } else {
                list = null;
            }
            outcome = list;
            object = (String)tuple.get((Expression)MigrationTable.Companion.getMIGRATION_TABLE().getAPP_OUTCOME_JSON());
            if (object != null) {
                it = object;
                boolean bl = false;
                $i$f$jacksonTypeRef = false;
                set = (Set)this.mapper.readValue((String)it, (TypeReference)new TypeReference<Set<? extends AppProgress>>(){});
            } else {
                set = appOutcome = null;
            }
            if ((string2 = (String)tuple.get((Expression)MigrationTable.Companion.getMIGRATION_TABLE().getIN_PROGRESS_STATUS_JSON_V2())) == null) {
                string2 = (String)tuple.get((Expression)MigrationTable.Companion.getMIGRATION_TABLE().getIN_PROGRESS_STATUS_JSON());
            }
            if ((object = string2) != null) {
                it = object;
                boolean bl = false;
                $i$f$jacksonTypeRef = false;
                inProgressStatus = (InProgressStatus)this.mapper.readValue((String)it, (TypeReference)new TypeReference<InProgressStatus>(){});
            } else {
                inProgressStatus = status = null;
            }
            if ((string = (String)tuple.get((Expression)MigrationTable.Companion.getMIGRATION_TABLE().getNEW_PROTOCOL_JSON())) == null) {
                string = (String)tuple.get((Expression)MigrationTable.Companion.getMIGRATION_TABLE().getPROTOCOL_JSON());
            }
            if ((protocolJson = string) != null) {
                it = protocolJson;
                boolean bl = false;
                $i$f$jacksonTypeRef = false;
                migrationProtocol = (MigrationProtocol)((Object)this.mapper.readValue((String)it, (TypeReference)new TypeReference<MigrationProtocol>(){}));
            } else {
                migrationProtocol = null;
            }
            protocol = migrationProtocol;
        }
        catch (IOException e) {
            throw new MigrationRepositoryException("JSON deserialization error for migrationId=" + (String)tuple.get((Expression)MigrationTable.Companion.getMIGRATION_TABLE().getMIGRATION_ID()), e);
        }
        Object object = tuple.get((Expression)MigrationTable.Companion.getMIGRATION_TABLE().getMIGRATION_ID());
        Intrinsics.checkNotNull((Object)object);
        String string = (String)object;
        Object object2 = tuple.get((Expression)MigrationTable.Companion.getMIGRATION_TABLE().getPLAN_ID());
        Intrinsics.checkNotNull((Object)object2);
        String string5 = (String)object2;
        MigrationProtocol migrationProtocol = protocol;
        if (migrationProtocol == null) {
            migrationProtocol = MigrationProtocol.V3;
        }
        String string6 = (String)tuple.get((Expression)MigrationTable.Companion.getMIGRATION_TABLE().getSTARTED_BY());
        Long l = (Long)tuple.get((Expression)MigrationTable.Companion.getMIGRATION_TABLE().getCREATED_TIMESTAMP());
        if (l == null) {
            l = 0L;
        }
        Instant instant = Instant.ofEpochMilli(((Number)l).longValue());
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
        Long l2 = (Long)tuple.get((Expression)MigrationTable.Companion.getMIGRATION_TABLE().getUPDATED_TIMESTAMP());
        if (l2 == null) {
            l2 = 0L;
        }
        Instant instant2 = Instant.ofEpochMilli(((Number)l2).longValue());
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"ofEpochMilli(...)");
        return new Migration(string, string5, startMigrationContext, migrationProtocol, outcome, appOutcome, string6, instant, instant2, status, null, null, (String)tuple.get((Expression)MigrationTable.Companion.getMIGRATION_TABLE().getDATA_MOVEMENT_ID()), 3072, null);
    }

    private static final Migration findLatestByPlanId$lambda$0(String $planId, MigrationRepository this$0, DatabaseConnection db) {
        Migration migration;
        Intrinsics.checkNotNullParameter((Object)$planId, (String)"$planId");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Path[] pathArray = MigrationTable.Companion.getMIGRATION_TABLE().all();
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)MigrationTable.Companion.getMIGRATION_TABLE())).where((Predicate)MigrationTable.Companion.getMIGRATION_TABLE().getPLAN_ID().eq((Object)$planId))).orderBy(MigrationTable.Companion.getMIGRATION_TABLE().getCREATED_TIMESTAMP().desc())).fetchFirst();
        if (tuple != null) {
            Tuple p0 = tuple;
            boolean bl = false;
            migration = this$0.fromTupleToMigration(p0);
        } else {
            migration = null;
        }
        return migration;
    }

    private static final void findLatestByPlanId$lambda$1() {
    }

    private static final Migration findByMigrationId$lambda$3(String $migrationId, MigrationRepository this$0, DatabaseConnection db) {
        Migration migration;
        Intrinsics.checkNotNullParameter((Object)$migrationId, (String)"$migrationId");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Path[] pathArray = MigrationTable.Companion.getMIGRATION_TABLE().all();
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)MigrationTable.Companion.getMIGRATION_TABLE())).where((Predicate)MigrationTable.Companion.getMIGRATION_TABLE().getMIGRATION_ID().eq((Object)$migrationId))).fetchOne();
        if (tuple != null) {
            Tuple p0 = tuple;
            boolean bl = false;
            migration = this$0.fromTupleToMigration(p0);
        } else {
            migration = null;
        }
        return migration;
    }

    private static final void findByMigrationId$lambda$4() {
    }

    private static final String findPlanIdByMigrationId$lambda$5(String $migrationId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$migrationId, (String)"$migrationId");
        return (String)((SQLQuery)((SQLQuery)db.select((Expression)MigrationTable.Companion.getMIGRATION_TABLE().getPLAN_ID()).from((Expression)MigrationTable.Companion.getMIGRATION_TABLE())).where((Predicate)MigrationTable.Companion.getMIGRATION_TABLE().getMIGRATION_ID().eq((Object)$migrationId))).fetchOne();
    }

    private static final void findPlanIdByMigrationId$lambda$6() {
    }

    private static final MigrationProtocol findProtocolByMigrationId$lambda$9(String $migrationId, MigrationRepository this$0, DatabaseConnection db) {
        MigrationProtocol migrationProtocol;
        Intrinsics.checkNotNullParameter((Object)$migrationId, (String)"$migrationId");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string = (String)((SQLQuery)((SQLQuery)db.select((Expression)MigrationTable.Companion.getMIGRATION_TABLE().getNEW_PROTOCOL_JSON()).from((Expression)MigrationTable.Companion.getMIGRATION_TABLE())).where((Predicate)MigrationTable.Companion.getMIGRATION_TABLE().getMIGRATION_ID().eq((Object)$migrationId))).fetchOne();
        if (string != null) {
            Object object;
            String it = string;
            boolean bl = false;
            Object object2 = this$0;
            try {
                MigrationRepository $this$findProtocolByMigrationId_u24lambda_u249_u24lambda_u248_u24lambda_u247 = object2;
                boolean bl2 = false;
                boolean $i$f$jacksonTypeRef = false;
                object = Result.constructor-impl((Object)((Object)((MigrationProtocol)((Object)$this$findProtocolByMigrationId_u24lambda_u249_u24lambda_u248_u24lambda_u247.mapper.readValue(it, (TypeReference)new TypeReference<MigrationProtocol>(){})))));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            migrationProtocol = (MigrationProtocol)((Object)(Result.isFailure-impl((Object)object2) ? null : object2));
        } else {
            migrationProtocol = null;
        }
        return migrationProtocol;
    }

    private static final void findProtocolByMigrationId$lambda$10() {
    }

    /*
     * WARNING - void declaration
     */
    private static final List getInProgressMigrations$lambda$12(MigrationRepository this$0, DatabaseConnection db) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Path[] pathArray = MigrationTable.Companion.getMIGRATION_TABLE().all();
        SQLQuery sQLQuery = (SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)MigrationTable.Companion.getMIGRATION_TABLE());
        pathArray = new Predicate[]{MigrationTable.Companion.getMIGRATION_TABLE().getOUTCOME_JSON_V2().isNull(), MigrationTable.Companion.getMIGRATION_TABLE().getOUTCOME_JSON().isNull()};
        List list = ((SQLQuery)sQLQuery.where((Predicate[])pathArray)).fetch();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fetch(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0.fromTupleToMigration((Tuple)p0));
        }
        return (List)destination$iv$iv;
    }

    private static final void getInProgressMigrations$lambda$13() {
    }

    private static final Migration findLatestCompletedMigration$lambda$15(MigrationRepository this$0, DatabaseConnection db) {
        Migration migration;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Path[] pathArray = MigrationTable.Companion.getMIGRATION_TABLE().all();
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)db.select((Expression[])Arrays.copyOf(pathArray, pathArray.length)).from((Expression)MigrationTable.Companion.getMIGRATION_TABLE())).orderBy(MigrationTable.Companion.getMIGRATION_TABLE().getUPDATED_TIMESTAMP().desc())).fetchFirst();
        if (tuple != null) {
            Tuple p0 = tuple;
            boolean bl = false;
            migration = this$0.fromTupleToMigration(p0);
        } else {
            migration = null;
        }
        return migration;
    }

    private static final void findLatestCompletedMigration$lambda$16() {
    }

    private static final Long saveOutcome$lambda$23(MigrationRepository this$0, List $outcome, String $migrationId, List $updatedOutcome, Instant $updated, DatabaseConnection db) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$outcome, (String)"$outcome");
        Intrinsics.checkNotNullParameter((Object)$migrationId, (String)"$migrationId");
        Intrinsics.checkNotNullParameter((Object)$updated, (String)"$updated");
        try {
            string2 = this$0.mapper.writeValueAsString((Object)$outcome);
        }
        catch (IOException e) {
            throw new MigrationRepositoryException("JSON serialization error for migrationId=" + $migrationId, e);
        }
        String outcomeJson = string2;
        try {
            string = this$0.mapper.writeValueAsString((Object)$updatedOutcome);
        }
        catch (IOException e) {
            throw new MigrationRepositoryException("JSON serialization error for migrationId=" + $migrationId, e);
        }
        String outcomeJsonOld = string;
        return db.update((RelationalPath)MigrationTable.Companion.getMIGRATION_TABLE()).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getOUTCOME_JSON_V2(), (Object)outcomeJson).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getOUTCOME_JSON(), (Object)outcomeJsonOld).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getIN_PROGRESS_STATUS_JSON_V2(), null).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getIN_PROGRESS_STATUS_JSON(), null).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getUPDATED_TIMESTAMP(), (Object)$updated.toEpochMilli()).where((Predicate)MigrationTable.Companion.getMIGRATION_TABLE().getMIGRATION_ID().eq((Object)$migrationId)).execute();
    }

    private static final void saveOutcome$lambda$24() {
    }

    private static final Long saveStartUserMigrationTime$lambda$25(Instant $startTime, String $migrationId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$startTime, (String)"$startTime");
        Intrinsics.checkNotNullParameter((Object)$migrationId, (String)"$migrationId");
        return db.update((RelationalPath)MigrationTable.Companion.getMIGRATION_TABLE()).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getUSER_MIGRATION_START_TIME(), (Object)$startTime.toEpochMilli()).where((Predicate)MigrationTable.Companion.getMIGRATION_TABLE().getMIGRATION_ID().eq((Object)$migrationId)).execute();
    }

    private static final void saveStartUserMigrationTime$lambda$26() {
    }

    private static final Long saveEndUserMigrationTime$lambda$27(Instant $endTime, String $migrationId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$endTime, (String)"$endTime");
        Intrinsics.checkNotNullParameter((Object)$migrationId, (String)"$migrationId");
        return db.update((RelationalPath)MigrationTable.Companion.getMIGRATION_TABLE()).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getUSER_MIGRATION_END_TIME(), (Object)$endTime.toEpochMilli()).where((Predicate)MigrationTable.Companion.getMIGRATION_TABLE().getMIGRATION_ID().eq((Object)$migrationId)).execute();
    }

    private static final void saveEndUserMigrationTime$lambda$28() {
    }

    private static final Long saveDataMovementId$lambda$29(String $dataMovementId, String $migrationId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$dataMovementId, (String)"$dataMovementId");
        Intrinsics.checkNotNullParameter((Object)$migrationId, (String)"$migrationId");
        return db.update((RelationalPath)MigrationTable.Companion.getMIGRATION_TABLE()).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getDATA_MOVEMENT_ID(), (Object)$dataMovementId).where((Predicate)MigrationTable.Companion.getMIGRATION_TABLE().getMIGRATION_ID().eq((Object)$migrationId)).execute();
    }

    private static final void saveDataMovementId$lambda$30() {
    }

    /*
     * WARNING - void declaration
     */
    private static final Long saveStatus$lambda$32(MigrationRepository this$0, List $status, String $migrationId, List $updatedStatus, Instant $updated, DatabaseConnection db) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$status, (String)"$status");
        Intrinsics.checkNotNullParameter((Object)$migrationId, (String)"$migrationId");
        Intrinsics.checkNotNullParameter((Object)$updated, (String)"$updated");
        try {
            ObjectMapper objectMapper2 = this$0.mapper;
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            string2 = objectMapper2.writeValueAsString((Object)new InProgressStatus(instant, $status));
        }
        catch (IOException e) {
            throw new MigrationRepositoryException("JSON serialization error for migrationId=" + $migrationId, e);
        }
        String inProgressStatusJson = string2;
        try {
            InProgressStatus inProgressStatus;
            ObjectMapper objectMapper3 = this$0.mapper;
            List list = $updatedStatus;
            if (list != null) {
                void it;
                List list2 = list;
                ObjectMapper objectMapper4 = objectMapper3;
                boolean bl = false;
                Instant instant = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
                inProgressStatus = new InProgressStatus(instant, (List<GetTaskStatusResponse.TaskProgress>)it);
                objectMapper3 = objectMapper4;
            } else {
                inProgressStatus = null;
            }
            string = objectMapper3.writeValueAsString(inProgressStatus);
        }
        catch (IOException e) {
            throw new MigrationRepositoryException("JSON serialization error for migrationId=" + $migrationId, e);
        }
        String inProgressStatusJsonOld = string;
        return db.update((RelationalPath)MigrationTable.Companion.getMIGRATION_TABLE()).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getIN_PROGRESS_STATUS_JSON_V2(), (Object)inProgressStatusJson).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getIN_PROGRESS_STATUS_JSON(), (Object)inProgressStatusJsonOld).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getUPDATED_TIMESTAMP(), (Object)$updated.toEpochMilli()).where((Predicate)MigrationTable.Companion.getMIGRATION_TABLE().getMIGRATION_ID().eq((Object)$migrationId)).execute();
    }

    private static final void saveStatus$lambda$33() {
    }

    /*
     * WARNING - void declaration
     */
    private static final Long saveAppStatus$lambda$35(Set $status, MigrationRepository this$0, String $planId, String $migrationId, Instant $updated, DatabaseConnection db) {
        String string;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$status, (String)"$status");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$planId, (String)"$planId");
        Intrinsics.checkNotNullParameter((Object)$migrationId, (String)"$migrationId");
        Intrinsics.checkNotNullParameter((Object)$updated, (String)"$updated");
        Iterable $this$map$iv = $status;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AppProgress appProgress = (AppProgress)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(AppProgress.copy$default((AppProgress)it, null, null, null, 0, false, null, null, null, null, null, null, null, false, null, 8191, null));
        }
        Set progresses = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        try {
            string = this$0.mapper.writeValueAsString((Object)progresses);
        }
        catch (IOException e) {
            throw new MigrationRepositoryException("JSON serialization error for planId=" + $planId + " migrationId=" + $migrationId, e);
        }
        String appProgresses = string;
        return db.update((RelationalPath)MigrationTable.Companion.getMIGRATION_TABLE()).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getAPP_OUTCOME_JSON(), (Object)appProgresses).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getUPDATED_TIMESTAMP(), (Object)$updated.toEpochMilli()).where((Predicate)MigrationTable.Companion.getMIGRATION_TABLE().getMIGRATION_ID().eq((Object)$migrationId)).execute();
    }

    private static final void saveAppStatus$lambda$36() {
    }

    private static final Long clearAppStatusForRerun$lambda$37(Instant $updated, String $migrationId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$updated, (String)"$updated");
        Intrinsics.checkNotNullParameter((Object)$migrationId, (String)"$migrationId");
        return db.update((RelationalPath)MigrationTable.Companion.getMIGRATION_TABLE()).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getAPP_OUTCOME_JSON(), null).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getUPDATED_TIMESTAMP(), (Object)$updated.toEpochMilli()).where((Predicate)MigrationTable.Companion.getMIGRATION_TABLE().getMIGRATION_ID().eq((Object)$migrationId)).execute();
    }

    private static final void clearAppStatusForRerun$lambda$38() {
    }

    private static final Long touch$lambda$39(Instant $updated, String $migrationId, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$updated, (String)"$updated");
        Intrinsics.checkNotNullParameter((Object)$migrationId, (String)"$migrationId");
        return db.update((RelationalPath)MigrationTable.Companion.getMIGRATION_TABLE()).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getUPDATED_TIMESTAMP(), (Object)$updated.toEpochMilli()).where((Predicate)MigrationTable.Companion.getMIGRATION_TABLE().getMIGRATION_ID().eq((Object)$migrationId)).execute();
    }

    private static final void touch$lambda$40() {
    }

    /*
     * WARNING - void declaration
     */
    private static final Long save$lambda$48(Migration $migration, MigrationRepository this$0, List $updatedOutcome, InProgressStatus $updatedInProgressStatus, DatabaseConnection db) {
        String string;
        String string2;
        String string3;
        String string4;
        Object p0;
        Object object;
        String string5;
        String string6;
        SQLInsertClause sQLInsertClause;
        Path path;
        Object object2;
        Object object3;
        Intrinsics.checkNotNullParameter((Object)$migration, (String)"$migration");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SQLInsertClause sQLInsertClause2 = db.insert((RelationalPath)MigrationTable.Companion.getMIGRATION_TABLE()).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getMIGRATION_ID(), (Object)$migration.getMigrationId()).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getPLAN_ID(), (Object)$migration.getPlanId()).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getSTART_MIGRATION_CONTEXT_JSON(), (Object)this$0.mapper.writeValueAsString((Object)$migration.getStartMigrationContext()));
        Path path2 = (Path)MigrationTable.Companion.getMIGRATION_TABLE().getOUTCOME_JSON_V2();
        ObjectMapper objectMapper2 = $migration.getOutcome();
        if (objectMapper2 != null) {
            void p02;
            object3 = objectMapper2;
            object2 = this$0.mapper;
            ObjectMapper objectMapper3 = object3;
            path = path2;
            sQLInsertClause = sQLInsertClause2;
            boolean bl = false;
            string6 = object2.writeValueAsString((Object)p02);
            sQLInsertClause2 = sQLInsertClause;
            path2 = path;
            string5 = string6;
        } else {
            string5 = null;
        }
        SQLInsertClause sQLInsertClause3 = sQLInsertClause2.set(path2, string5);
        Path path3 = (Path)MigrationTable.Companion.getMIGRATION_TABLE().getOUTCOME_JSON();
        List list = $updatedOutcome;
        if (list != null) {
            object = list;
            object3 = this$0.mapper;
            object2 = object;
            path = path3;
            sQLInsertClause = sQLInsertClause3;
            boolean bl = false;
            string6 = object3.writeValueAsString(p0);
            sQLInsertClause3 = sQLInsertClause;
            path3 = path;
            string4 = string6;
        } else {
            string4 = null;
        }
        SQLInsertClause sQLInsertClause4 = sQLInsertClause3.set(path3, string4);
        Path path4 = (Path)MigrationTable.Companion.getMIGRATION_TABLE().getAPP_OUTCOME_JSON();
        Set<AppProgress> set = $migration.getAppOutcome();
        if (set != null) {
            void p03;
            object3 = set;
            p0 = this$0.mapper;
            Object bl = object3;
            path = path4;
            sQLInsertClause = sQLInsertClause4;
            boolean bl2 = false;
            string6 = p0.writeValueAsString((Object)p03);
            sQLInsertClause4 = sQLInsertClause;
            path4 = path;
            string3 = string6;
        } else {
            string3 = null;
        }
        SQLInsertClause sQLInsertClause5 = sQLInsertClause4.set(path4, string3).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getSTARTED_BY(), (Object)$migration.getStartedBy());
        Path path5 = (Path)MigrationTable.Companion.getMIGRATION_TABLE().getIN_PROGRESS_STATUS_JSON_V2();
        InProgressStatus inProgressStatus = $migration.getStatus();
        if (inProgressStatus != null) {
            object3 = inProgressStatus;
            p0 = this$0.mapper;
            Object p03 = object3;
            path = path5;
            sQLInsertClause = sQLInsertClause5;
            boolean bl = false;
            string6 = p0.writeValueAsString(p03);
            sQLInsertClause5 = sQLInsertClause;
            path5 = path;
            string2 = string6;
        } else {
            string2 = null;
        }
        SQLInsertClause sQLInsertClause6 = sQLInsertClause5.set(path5, string2);
        Path path6 = (Path)MigrationTable.Companion.getMIGRATION_TABLE().getIN_PROGRESS_STATUS_JSON();
        InProgressStatus inProgressStatus2 = $updatedInProgressStatus;
        if (inProgressStatus2 != null) {
            object = inProgressStatus2;
            object3 = this$0.mapper;
            p0 = object;
            path = path6;
            sQLInsertClause = sQLInsertClause6;
            boolean bl = false;
            string6 = object3.writeValueAsString(p0);
            sQLInsertClause6 = sQLInsertClause;
            path6 = path;
            string = string6;
        } else {
            string = null;
        }
        return sQLInsertClause6.set(path6, string).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getCREATED_TIMESTAMP(), (Object)$migration.getCreated().toEpochMilli()).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getUPDATED_TIMESTAMP(), (Object)$migration.getUpdated().toEpochMilli()).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getNEW_PROTOCOL_JSON(), (Object)this$0.mapper.writeValueAsString((Object)$migration.getProtocol())).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getUSER_MIGRATION_START_TIME(), (Object)$migration.getUserMigrationStartTime().toEpochMilli()).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getUSER_MIGRATION_END_TIME(), (Object)$migration.getUserMigrationEndTime().toEpochMilli()).set((Path)MigrationTable.Companion.getMIGRATION_TABLE().getDATA_MOVEMENT_ID(), (Object)$migration.getDataMovementId()).execute();
    }

    private static final void save$lambda$49() {
    }
}

