/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.migrationservice;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.migration.migrationservice.CachedProjectMigratedServiceKt;
import com.atlassian.jira.migration.migrationservice.MigrationServiceClient;
import com.atlassian.jira.migration.serverdataextractors.ProjectsReader;
import com.atlassian.jira.project.Project;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/migrationservice/CachedProjectMigratedService;", "", "migrationServiceClient", "Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "projectsReader", "Lcom/atlassian/jira/migration/serverdataextractors/ProjectsReader;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "(Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;Lcom/atlassian/jira/migration/serverdataextractors/ProjectsReader;Lcom/atlassian/cache/CacheManager;)V", "log", "Lorg/slf4j/Logger;", "projectMigratedCache", "Lcom/atlassian/cache/Cache;", "", "", "getProjectMigratedCache", "()Lcom/atlassian/cache/Cache;", "projectMigratedCache$delegate", "Lkotlin/Lazy;", "clearCache", "", "isProjectMigrated", "projectId", "containerToken", "", "jira-migration-plugin"})
public final class CachedProjectMigratedService {
    @NotNull
    private final MigrationServiceClient migrationServiceClient;
    @NotNull
    private final ProjectsReader projectsReader;
    @NotNull
    private final CacheManager cacheManager;
    @NotNull
    private final Logger log;
    @NotNull
    private final Lazy projectMigratedCache$delegate;

    @Inject
    public CachedProjectMigratedService(@NotNull MigrationServiceClient migrationServiceClient, @NotNull ProjectsReader projectsReader, @NotNull CacheManager cacheManager) {
        Intrinsics.checkNotNullParameter((Object)migrationServiceClient, (String)"migrationServiceClient");
        Intrinsics.checkNotNullParameter((Object)projectsReader, (String)"projectsReader");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        this.migrationServiceClient = migrationServiceClient;
        this.projectsReader = projectsReader;
        this.cacheManager = cacheManager;
        Logger logger2 = LoggerFactory.getLogger(CachedProjectMigratedService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
        this.log = logger2;
        this.projectMigratedCache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Cache<Long, Boolean>>(this){
            final /* synthetic */ CachedProjectMigratedService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Cache<Long, Boolean> invoke() {
                return CachedProjectMigratedService.access$getCacheManager$p(this.this$0).getCache("PROJECT_MIGRATED_CACHE", null, new CacheSettingsBuilder().expireAfterAccess(2L, CachedProjectMigratedServiceKt.access$getCACHE_TIME_UNIT$p()).remote().build());
            }
        }));
    }

    private final Cache<Long, Boolean> getProjectMigratedCache() {
        Lazy lazy = this.projectMigratedCache$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Cache)object;
    }

    public final boolean isProjectMigrated(long projectId, @NotNull String containerToken) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        String it = containerToken;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)it, (Object)"dummyToken") && this.getProjectMigratedCache().get((Object)projectId) == null) {
            this.log.info("Project " + projectId + " is not in the cache and the token provide isn't valid, returning false");
            return false;
        }
        Boolean bl2 = (Boolean)this.getProjectMigratedCache().get((Object)projectId, () -> CachedProjectMigratedService.isProjectMigrated$lambda$2$lambda$1(this, projectId, it));
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"let(...)");
        return bl2;
    }

    public final void clearCache() {
        this.getProjectMigratedCache().removeAll();
    }

    private static final Boolean isProjectMigrated$lambda$2$lambda$1(CachedProjectMigratedService this$0, long $projectId, String $it) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        this$0.log.info("Checking if project " + $projectId + " is present in cloud");
        Project project = this$0.projectsReader.getProjectById($projectId);
        if (project != null) {
            boolean bl2;
            Project project2 = project;
            boolean bl3 = false;
            try {
                MigrationServiceClient migrationServiceClient = this$0.migrationServiceClient;
                String string = project2.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
                String string2 = project2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                bl2 = migrationServiceClient.isProjectInCloud($it, string, string2);
            }
            catch (RuntimeException e) {
                this$0.log.error("Error while checking if project is present in cloud", (Throwable)e);
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ CacheManager access$getCacheManager$p(CachedProjectMigratedService $this) {
        return $this.cacheManager;
    }
}

