/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.migrationservice;

import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpClient;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpRequest;
import com.atlassian.jira.migration.httpclient.MigrationUserAgentProvider;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.jira.migration.migrationservice.TokenExpiry;
import com.fasterxml.jackson.core.type.TypeReference;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0018\u001a\u00020\u0016J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService;", "Lcom/atlassian/migration/udc/auth/ContainerTokenTTLService;", "migrationServicesConfiguration", "Lcom/atlassian/jira/migration/MigrationServicesConfiguration;", "userAgentProvider", "Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "httpClient", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;", "(Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;)V", "checkTokenExpiry", "Lcom/atlassian/jira/migration/migrationservice/TokenExpiry;", "containerToken", "", "getTokenValidityUri", "Ljava/net/URI;", "isTTLValid", "", "tokenExpiry", "durationInDays", "", "isValidToken", "tokenTTL", "timeUntilExpiry", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nContainerTokenTTLService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContainerTokenTTLService.kt\ncom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,119:1\n51#2:120\n*S KotlinDebug\n*F\n+ 1 ContainerTokenTTLService.kt\ncom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService\n*L\n55#1:120\n*E\n"})
public final class ContainerTokenTTLService
implements com.atlassian.migration.udc.auth.ContainerTokenTTLService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationServicesConfiguration migrationServicesConfiguration;
    @NotNull
    private final MigrationPluginHttpClient httpClient;
    @NotNull
    private static final String TOKEN_VALIDITY_URI = "/migration/token/validation";
    private static final long TTL_VALIDITY_IN_DAYS = 19L;
    private static final int MILLISECONDS_IN_SECOND = 1000;
    @NotNull
    public static final String CONTAINER_TOKEN_HEADER = "credential.username";
    @NotNull
    public static final String CONTAINER_TOKEN_HEADER_VALUE = "x-container-token";
    private static final Logger log = LoggerFactory.getLogger(ContainerTokenTTLService.class);

    public ContainerTokenTTLService(@NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull MigrationPluginHttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        this.migrationServicesConfiguration = migrationServicesConfiguration;
        this.httpClient = httpClient;
    }

    @Inject
    public ContainerTokenTTLService(@NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull MigrationUserAgentProvider userAgentProvider, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)userAgentProvider, (String)"userAgentProvider");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this(migrationServicesConfiguration, new MigrationPluginHttpClient(userAgentProvider, objectMapperFactory.createObjectMapper()));
    }

    private final URI getTokenValidityUri() {
        URI baseURI = this.migrationServicesConfiguration.getMigrationServiceBaseURI();
        URI tokenValidityUri = baseURI.resolve(TOKEN_VALIDITY_URI);
        log.info("token validity baseurl : " + tokenValidityUri);
        Intrinsics.checkNotNull((Object)tokenValidityUri);
        return tokenValidityUri;
    }

    private final TokenExpiry checkTokenExpiry(String containerToken) {
        boolean $i$f$jacksonTypeRef = false;
        return (TokenExpiry)this.httpClient.execute(new MigrationPluginHttpRequest("GET", this.getTokenValidityUri(), null, null, null, null, 60, null).addHeader(CONTAINER_TOKEN_HEADER, CONTAINER_TOKEN_HEADER_VALUE).acceptsJson().authorization("Bearer " + containerToken), (TypeReference)new TypeReference<TokenExpiry>(){});
    }

    public final boolean isValidToken(@NotNull String containerToken, long tokenTTL) {
        boolean validToken;
        block2: {
            Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
            validToken = false;
            try {
                validToken = this.isTTLValid(this.checkTokenExpiry(containerToken), tokenTTL);
            }
            catch (UnexpectedStatusCodeException unexpectedStatusCode) {
                log.error("TTL Service incurred an error |{}|", (Throwable)unexpectedStatusCode);
                if (unexpectedStatusCode.getStatusCode() == 401) break block2;
                throw unexpectedStatusCode;
            }
        }
        return validToken;
    }

    public static /* synthetic */ boolean isValidToken$default(ContainerTokenTTLService containerTokenTTLService, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 19L;
        }
        return containerTokenTTLService.isValidToken(string, l);
    }

    public final long timeUntilExpiry(@NotNull String containerToken) {
        Instant expiryDate;
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        TokenExpiry tokenExpiry = this.checkTokenExpiry(containerToken);
        Date date = tokenExpiry.getExpiry();
        Instant it = expiryDate = date != null ? date.toInstant() : null;
        boolean bl = false;
        Duration duration = Duration.between(Instant.now(), it);
        return duration.toMillis() / (long)1000;
    }

    private final boolean isTTLValid(TokenExpiry tokenExpiry, long durationInDays) {
        Duration containerTokenTTL = Duration.ofDays(durationInDays);
        log.info("token expiry date {}", (Object)tokenExpiry);
        Date date = tokenExpiry.getExpiry();
        Intrinsics.checkNotNull((Object)date);
        Instant expiryDate = date.toInstant();
        return Duration.between(Instant.now(), expiryDate).compareTo(containerTokenTTL) >= 0;
    }

    public boolean isValidToken(@NotNull String containerToken) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        return this.isValidToken(containerToken, 19L);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService$Companion;", "", "()V", "CONTAINER_TOKEN_HEADER", "", "CONTAINER_TOKEN_HEADER_VALUE", "MILLISECONDS_IN_SECOND", "", "TOKEN_VALIDITY_URI", "TTL_VALIDITY_IN_DAYS", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

