/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.migrationservice;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/migrationservice/ISO8601DateDeserializer;", "Lorg/codehaus/jackson/map/JsonDeserializer;", "Ljava/util/Date;", "()V", "ISO_8601_FORMAT", "", "configDateFormat", "Ljava/text/SimpleDateFormat;", "deserialize", "value", "Lorg/codehaus/jackson/JsonParser;", "context", "Lorg/codehaus/jackson/map/DeserializationContext;", "jira-migration-plugin"})
public final class ISO8601DateDeserializer
extends JsonDeserializer<Date> {
    @NotNull
    public static final ISO8601DateDeserializer INSTANCE = new ISO8601DateDeserializer();
    @NotNull
    private static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    @NotNull
    private static final SimpleDateFormat configDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    private ISO8601DateDeserializer() {
    }

    @NotNull
    public Date deserialize(@NotNull JsonParser value, @Nullable DeserializationContext context) throws IOException, JsonProcessingException {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Date date = configDateFormat.parse(value.getText());
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"parse(...)");
        return date;
    }
}

