/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.migrationservice;

import com.atlassian.cmpt.domain.Edition;
import com.atlassian.cmpt.domain.Product;
import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.httpclient.AbstractPluginHttpClientKt;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpClient;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpRequest;
import com.atlassian.jira.migration.httpclient.MigrationUserAgentProvider;
import com.atlassian.jira.migration.lio.model.RecipeExecutionRequest;
import com.atlassian.jira.migration.lio.model.WorkplanConfigRequest;
import com.atlassian.jira.migration.lio.model.WorkplanConfigResponse;
import com.atlassian.jira.migration.migrationservice.ActivationIdResponse;
import com.atlassian.jira.migration.migrationservice.CloudProject;
import com.atlassian.jira.migration.migrationservice.MediaToken;
import com.atlassian.jira.migration.migrationservice.ProductEditionDetails;
import com.atlassian.jira.migration.migrationservice.ProjectConflictRequest;
import com.atlassian.jira.migration.migrationservice.ProjectConflictResponse;
import com.atlassian.jira.migration.migrationservice.SiteDetailsRequest;
import com.atlassian.jira.migration.migrationservice.SiteDetailsResponse;
import com.atlassian.jira.migration.migrationservice.shadow.AnonymiseMappingData;
import com.atlassian.jira.migration.migrationservice.shadow.AnonymiseMappingRequest;
import com.atlassian.jira.migration.migrationservice.shadow.AnonymiseMappingResponse;
import com.atlassian.jira.migration.migrationservice.shadow.CloudSiteCreateRequest;
import com.atlassian.jira.migration.migrationservice.shadow.CloudSiteCreateResponse;
import com.atlassian.jira.migration.migrationservice.shadow.CloudSiteDeleteRequest;
import com.atlassian.jira.migration.migrationservice.shadow.CloudSiteDeleteResponse;
import com.atlassian.jira.migration.migrationservice.shadow.MigrationServiceTimeoutException;
import com.atlassian.jira.migration.migrationservice.shadow.Products;
import com.atlassian.jira.migration.migrationservice.shadow.ShadowJobFailureException;
import com.atlassian.jira.migration.migrationservice.shadow.ShadowMigrationJobId;
import com.atlassian.jira.migration.migrationservice.shadow.ShadowMigrationJobResponse;
import com.atlassian.jira.migration.orchestratorclient.ServiceStatusResponse;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.migration.api.ContainerToken;
import com.atlassian.migration.api.MigrationId;
import com.fasterxml.jackson.core.type.TypeReference;
import java.net.URI;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 ]2\u00020\u0001:\u0001]B'\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\rB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dJ<\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u001a2\b\u0010$\u001a\u0004\u0018\u00010\u001a2\u0006\u0010%\u001a\u00020\u001aJ&\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001aJ&\u0010,\u001a\u00020-2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u001aJ&\u00101\u001a\u0002022\u0006\u0010\u001b\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u001aJ.\u00106\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u00104\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001a2\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020:2\u0006\u0010\u001b\u001a\u00020\u001aJ\u0016\u0010;\u001a\u00020<2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020>J\u000e\u0010?\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ0\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A2\u0006\u0010\u001b\u001a\u00020\u001a2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u001a0A2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001a0AJ=\u0010E\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001b\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u0010F\u001a\u00020\u001a2\u0006\u0010G\u001a\u00020H2\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u001a\u00a2\u0006\u0002\u0010IJ\b\u0010J\u001a\u00020KH\u0002J\u000e\u0010L\u001a\u00020-2\u0006\u0010\u001b\u001a\u00020\u001aJ\u001e\u0010M\u001a\u00020-2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010N\u001a\u00020\u001a2\u0006\u0010O\u001a\u00020\u001aJ`\u0010P\u001a\u00020Q2\u0006\u00100\u001a\u00020\u001a2\u0006\u0010R\u001a\u00020\u001a2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u000e\u0010S\u001a\n\u0012\u0006\b\u0001\u0012\u00020Q0TH\u0002J\u001a\u0010U\u001a\u00020V2\b\u0010$\u001a\u0004\u0018\u00010\u001a2\u0006\u0010%\u001a\u00020\u001aH\u0002J\u0010\u0010W\u001a\u00020X2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aJ$\u0010Y\u001a\u00020Z*\u00020Z2\u0006\u0010\u001b\u001a\u0002032\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u001aH\u0002J\u0014\u0010[\u001a\u00020Z*\u00020Z2\u0006\u0010\u001b\u001a\u000203H\u0002JH\u0010\\\u001a\u00020Z*\u00020Z2\u0006\u0010\u001b\u001a\u0002032\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u001a2\b\u0010#\u001a\u0004\u0018\u00010\u001a2\b\u0010\"\u001a\u0004\u0018\u00010\u001a2\b\u0010.\u001a\u0004\u0018\u00010\u001a2\b\u0010/\u001a\u0004\u0018\u00010\u001aH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient;", "", "migrationServicesConfiguration", "Lcom/atlassian/jira/migration/MigrationServicesConfiguration;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "userAgentProvider", "Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "(Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;Lcom/atlassian/jira/migration/sen/SENSupplier;)V", "httpClient", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;", "(Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;Lcom/atlassian/jira/migration/sen/SENSupplier;)V", "pollingInterval", "Lkotlin/Function1;", "", "", "pollingTimeout", "(Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;Lkotlin/jvm/functions/Function1;JLcom/atlassian/jira/migration/sen/SENSupplier;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "anonymizeCustomerMappings", "Lcom/atlassian/jira/migration/migrationservice/shadow/AnonymiseMappingResponse;", "fileId", "", "containerToken", "request", "Lcom/atlassian/jira/migration/migrationservice/shadow/AnonymiseMappingData;", "anonymizeUserMappings", "createCloudSite", "Lkotlin/Pair;", "Lcom/atlassian/jira/migration/migrationservice/shadow/CloudSiteCreateResponse;", "originalMigrationId", "originalMigrationScopeId", "region", "shard", "createWorkplanConfig", "Lcom/atlassian/jira/migration/lio/model/WorkplanConfigResponse;", "workplanConfigRequest", "Lcom/atlassian/jira/migration/lio/model/WorkplanConfigRequest;", "cloudRegion", "migrationScopeId", "deleteCloudSite", "", "shadowMigrationScopeId", "shadowMigrationId", "jobId", "downloadPMRALogsViaMS", "Lorg/apache/http/client/methods/CloseableHttpResponse;", "Lcom/atlassian/migration/api/ContainerToken;", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "executeRecipe", "recipeExecutionRequest", "Lcom/atlassian/jira/migration/lio/model/RecipeExecutionRequest;", "fetchProductEditionDetails", "Lcom/atlassian/jira/migration/migrationservice/ProductEditionDetails;", "fetchSiteDetails", "Lcom/atlassian/jira/migration/migrationservice/SiteDetailsResponse;", "requestBody", "Lcom/atlassian/jira/migration/migrationservice/SiteDetailsRequest;", "getActivationId", "getConflictingCloudProjects", "", "Lcom/atlassian/jira/migration/migrationservice/CloudProject;", "keys", "names", "getDownloadLogsSignedUrlViaMS", "sourceId", "file", "Ljava/nio/file/Path;", "(Lcom/atlassian/migration/api/ContainerToken;Lcom/atlassian/migration/api/MigrationId;Ljava/lang/String;Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Long;", "getMigrationServiceBaseURI", "Ljava/net/URI;", "isInMaintenance", "isProjectInCloud", "key", "name", "pollForShadowMigrationJob", "Lcom/atlassian/jira/migration/migrationservice/shadow/ShadowMigrationJobResponse;", "path", "responseClass", "Ljava/lang/Class;", "prepareCreateCloudSiteRequest", "Lcom/atlassian/jira/migration/migrationservice/shadow/CloudSiteCreateRequest;", "requestMediaToken", "Lcom/atlassian/jira/migration/migrationservice/MediaToken;", "withDefaultAndCirHeaders", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;", "withDefaultHeaders", "withDefaultShadowHeaders", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationServiceClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationServiceClient.kt\ncom/atlassian/jira/migration/migrationservice/MigrationServiceClient\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,522:1\n51#2:523\n51#2:524\n51#2:525\n51#2:526\n51#2:527\n51#2:528\n51#2:529\n51#2:530\n1#3:531\n*S KotlinDebug\n*F\n+ 1 MigrationServiceClient.kt\ncom/atlassian/jira/migration/migrationservice/MigrationServiceClient\n*L\n93#1:523\n104#1:524\n114#1:525\n127#1:526\n143#1:527\n158#1:528\n290#1:529\n320#1:530\n*E\n"})
public final class MigrationServiceClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationServicesConfiguration migrationServicesConfiguration;
    @NotNull
    private final MigrationPluginHttpClient httpClient;
    @NotNull
    private final Function1<Long, Unit> pollingInterval;
    private final long pollingTimeout;
    @NotNull
    private final SENSupplier senSupplier;
    private final Logger log;
    @NotNull
    private static final String CREATE_WORKPLAN_CONFIG = "workplan/jira/config";
    @NotNull
    private static final String CREATE_CLOUD_SITE_PATH = "shadow/createCloudSite";
    @NotNull
    private static final String CREATE_CLOUD_SITE_POLL_PATH = "shadow/createCloudSite/{jobId}";
    @NotNull
    private static final String DELETE_CLOUD_SITE_PATH = "shadow/deleteCloudSite";
    @NotNull
    private static final String ANONIMISE_CUSTOMER_PATH = "shadow/anonymiseS2CCustomerPII";
    @NotNull
    private static final String ANONIMISE_USER_PATH = "shadow/anonymiseS2CJiraUserGroupPII";
    @NotNull
    private static final String ANONIMISE_USER_POLL_PATH = "shadow/anonymiseS2CJiraUserGroupPII/{jobId}";
    @NotNull
    private static final String ANONIMISE_CUSTOMER_POLL_PATH = "shadow/anonymiseS2CCustomerPII/{jobId}";
    @NotNull
    private static final String MIGRATION_SERVICE_STARGATE_URI = "/migration/";
    @NotNull
    private static final String EXECUTE_RECIPE_VIA_MS = "lithium/jira/{migrationId}/lio/recipes/{recipeName}/executions";
    @NotNull
    private static final String DOWNLOAD_LOGS_VIA_MS = "mrc/jira/logs/{migrationId}/{sourceId}";
    public static final long MIGRATION_SERVICE_POLLING_TIMEOUT = 10800000L;
    public static final long MIGRATION_SERVICE_POLL_INTERVAL_IN_MILLIS = 20000L;
    @NotNull
    private static final String MIGRATION_HEALTH_CHECK = "health-status/jira";
    @NotNull
    private static final String DOWNLOAD_PMRA_LOGS_VIA_MS = "mrc/jira/pmra/{migrationId}";

    public MigrationServiceClient(@NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull MigrationPluginHttpClient httpClient, @NotNull Function1<? super Long, Unit> pollingInterval, long pollingTimeout, @NotNull SENSupplier senSupplier) {
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter(pollingInterval, (String)"pollingInterval");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        this.migrationServicesConfiguration = migrationServicesConfiguration;
        this.httpClient = httpClient;
        this.pollingInterval = pollingInterval;
        this.pollingTimeout = pollingTimeout;
        this.senSupplier = senSupplier;
        this.log = LoggerFactory.getLogger(MigrationServiceClient.class);
        URI migrationServiceBaseURI = this.getMigrationServiceBaseURI();
        this.log.info("migration service base url : " + migrationServiceBaseURI);
    }

    @Inject
    public MigrationServiceClient(@NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull MigrationUserAgentProvider userAgentProvider, @NotNull SENSupplier senSupplier) {
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)userAgentProvider, (String)"userAgentProvider");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        this(migrationServicesConfiguration, new MigrationPluginHttpClient(userAgentProvider, objectMapperFactory.createObjectMapper()), (Function1<? super Long, Unit>)((Function1)1.INSTANCE), 10800000L, senSupplier);
    }

    public MigrationServiceClient(@NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull MigrationPluginHttpClient httpClient, @NotNull SENSupplier senSupplier) {
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        this(migrationServicesConfiguration, httpClient, (Function1<? super Long, Unit>)((Function1)2.INSTANCE), 10800000L, senSupplier);
    }

    private final URI getMigrationServiceBaseURI() {
        URI baseURI = this.migrationServicesConfiguration.getMigrationServiceBaseURI();
        URI uRI = baseURI.resolve(MIGRATION_SERVICE_STARGATE_URI);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"resolve(...)");
        return uRI;
    }

    @NotNull
    public final MediaToken requestMediaToken(@Nullable String containerToken) {
        MigrationPluginHttpRequest migrationPluginHttpRequest = new MigrationPluginHttpRequest("GET", AbstractPluginHttpClientKt.buildURI$default(this.getMigrationServiceBaseURI(), "jira/token", new String[0], null, 8, null), null, null, null, null, 60, null);
        String string = this.senSupplier.getFirstSen();
        if (string == null) {
            string = "";
        }
        boolean $i$f$jacksonTypeRef = false;
        return (MediaToken)this.httpClient.execute(migrationPluginHttpRequest.addHeader("X-ASEN", string).acceptsJson().authorization("Bearer " + containerToken), (TypeReference)new TypeReference<MediaToken>(){});
    }

    @NotNull
    public final SiteDetailsResponse fetchSiteDetails(@NotNull String containerToken, @NotNull SiteDetailsRequest requestBody) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        URI uRI = AbstractPluginHttpClientKt.buildURI$default(this.getMigrationServiceBaseURI(), "jira/sitedetails", new String[0], null, 8, null);
        MigrationPluginHttpRequest migrationPluginHttpRequest = new MigrationPluginHttpRequest("POST", uRI, null, requestBody, null, null, 52, null);
        String string = this.senSupplier.getFirstSen();
        if (string == null) {
            string = "";
        }
        boolean $i$f$jacksonTypeRef = false;
        return (SiteDetailsResponse)this.httpClient.execute(migrationPluginHttpRequest.addHeader("X-ASEN", string).contentTypeJson().acceptsJson().authorization("Bearer " + containerToken), (TypeReference)new TypeReference<SiteDetailsResponse>(){});
    }

    @NotNull
    public final ProductEditionDetails fetchProductEditionDetails(@NotNull String containerToken) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        MigrationPluginHttpRequest migrationPluginHttpRequest = new MigrationPluginHttpRequest("GET", AbstractPluginHttpClientKt.buildURI$default(this.getMigrationServiceBaseURI(), "jira/producteditiondetails", new String[0], null, 8, null), null, null, null, null, 60, null);
        String string = this.senSupplier.getFirstSen();
        if (string == null) {
            string = "";
        }
        boolean $i$f$jacksonTypeRef = false;
        return (ProductEditionDetails)this.httpClient.execute(migrationPluginHttpRequest.addHeader("X-ASEN", string).acceptsJson().authorization("Bearer " + containerToken), (TypeReference)new TypeReference<ProductEditionDetails>(){});
    }

    @NotNull
    public final List<CloudProject> getConflictingCloudProjects(@NotNull String containerToken, @NotNull List<String> keys, @NotNull List<String> names) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(names, (String)"names");
        ProjectConflictRequest requestBody = new ProjectConflictRequest(CollectionsKt.toSet((Iterable)keys), CollectionsKt.toSet((Iterable)names));
        URI uRI = AbstractPluginHttpClientKt.buildURI$default(this.getMigrationServiceBaseURI(), "jira/projectconflicts", new String[0], null, 8, null);
        MigrationPluginHttpRequest migrationPluginHttpRequest = new MigrationPluginHttpRequest("POST", uRI, null, requestBody, null, null, 52, null);
        String string = this.senSupplier.getFirstSen();
        if (string == null) {
            string = "";
        }
        boolean $i$f$jacksonTypeRef = false;
        ProjectConflictResponse projectConflictResponse = (ProjectConflictResponse)this.httpClient.execute(migrationPluginHttpRequest.addHeader("X-ASEN", string).contentTypeJson().acceptsJson().authorization("Bearer " + containerToken), (TypeReference)new TypeReference<ProjectConflictResponse>(){});
        return projectConflictResponse.getProjects();
    }

    public final boolean isProjectInCloud(@NotNull String containerToken, @NotNull String key, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return !((Collection)this.getConflictingCloudProjects(containerToken, CollectionsKt.listOf((Object)key), CollectionsKt.listOf((Object)name))).isEmpty();
    }

    @NotNull
    public final String getActivationId(@NotNull String containerToken) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        MigrationPluginHttpRequest migrationPluginHttpRequest = new MigrationPluginHttpRequest("GET", AbstractPluginHttpClientKt.buildURI$default(this.getMigrationServiceBaseURI(), "jira/activationid", new String[0], null, 8, null), null, null, null, null, 60, null);
        String string = this.senSupplier.getFirstSen();
        if (string == null) {
            string = "";
        }
        boolean $i$f$jacksonTypeRef = false;
        ActivationIdResponse response2 = (ActivationIdResponse)this.httpClient.execute(migrationPluginHttpRequest.addHeader("X-ASEN", string).acceptsJson().authorization("Bearer " + containerToken), (TypeReference)new TypeReference<ActivationIdResponse>(){});
        return response2.getActivationId();
    }

    @NotNull
    public final WorkplanConfigResponse createWorkplanConfig(@NotNull WorkplanConfigRequest workplanConfigRequest, @NotNull String containerToken, @NotNull String cloudRegion, @NotNull String migrationScopeId2) {
        Intrinsics.checkNotNullParameter((Object)workplanConfigRequest, (String)"workplanConfigRequest");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)cloudRegion, (String)"cloudRegion");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        URI uRI = AbstractPluginHttpClientKt.buildURI$default(this.getMigrationServiceBaseURI(), CREATE_WORKPLAN_CONFIG, new String[0], null, 8, null);
        MigrationPluginHttpRequest migrationPluginHttpRequest = new MigrationPluginHttpRequest("POST", uRI, null, workplanConfigRequest, null, null, 52, null).addCloudRegion(cloudRegion).addMigrationScopeId(migrationScopeId2);
        String string = this.senSupplier.getFirstSen();
        if (string == null) {
            string = "";
        }
        boolean $i$f$jacksonTypeRef = false;
        WorkplanConfigResponse workplanConfigResponse = (WorkplanConfigResponse)this.httpClient.execute(migrationPluginHttpRequest.addHeader("X-ASEN", string).contentTypeJson().acceptsJson().authorization("Bearer " + containerToken), (TypeReference)new TypeReference<WorkplanConfigResponse>(){});
        return workplanConfigResponse;
    }

    private final CloudSiteCreateRequest prepareCreateCloudSiteRequest(String region, String shard) {
        Object[] objectArray = new Products[]{new Products(Product.JIRA_SOFTWARE, Edition.PREMIUM), new Products(Product.JIRA_SERVICEDESK, Edition.PREMIUM), new Products(Product.JIRA_CORE, Edition.PREMIUM)};
        return new CloudSiteCreateRequest(region, shard, "JIRA", CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final Pair<String, CloudSiteCreateResponse> createCloudSite(@NotNull String containerToken, @NotNull String originalMigrationId, @NotNull String originalMigrationScopeId, @Nullable String region, @NotNull String shard) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)originalMigrationId, (String)"originalMigrationId");
        Intrinsics.checkNotNullParameter((Object)originalMigrationScopeId, (String)"originalMigrationScopeId");
        Intrinsics.checkNotNullParameter((Object)shard, (String)"shard");
        CloudSiteCreateRequest cloudSiteCreateRequest = this.prepareCreateCloudSiteRequest(region, shard);
        Object object = AbstractPluginHttpClientKt.buildURI$default(this.getMigrationServiceBaseURI(), CREATE_CLOUD_SITE_PATH, new String[0], null, 8, null);
        MigrationPluginHttpRequest migrationPluginHttpRequest = new MigrationPluginHttpRequest("POST", (URI)object, null, cloudSiteCreateRequest, null, null, 52, null).addOriginalMigrationScopeId(originalMigrationScopeId).addOriginalMigrationId(originalMigrationId).addMigrationType();
        String string = this.senSupplier.getFirstSen();
        if (string == null) {
            string = "";
        }
        ShadowMigrationJobId response2 = this.httpClient.execute(migrationPluginHttpRequest.addHeader("X-ASEN", string).contentTypeJson().acceptsJson().authorization("Bearer " + containerToken), ShadowMigrationJobId.class);
        Object object2 = object = response2.getJobId();
        Class<CloudSiteCreateResponse> clazz = CloudSiteCreateResponse.class;
        ShadowMigrationJobResponse shadowMigrationJobResponse = MigrationServiceClient.pollForShadowMigrationJob$default(this, (String)object, CREATE_CLOUD_SITE_POLL_PATH, null, null, originalMigrationScopeId, originalMigrationId, containerToken, clazz, 12, null);
        Intrinsics.checkNotNull((Object)shadowMigrationJobResponse, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.migrationservice.shadow.CloudSiteCreateResponse");
        return new Pair(object2, (Object)((CloudSiteCreateResponse)shadowMigrationJobResponse));
    }

    public final boolean deleteCloudSite(@NotNull String containerToken, @NotNull String shadowMigrationScopeId, @NotNull String shadowMigrationId, @NotNull String jobId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)shadowMigrationScopeId, (String)"shadowMigrationScopeId");
        Intrinsics.checkNotNullParameter((Object)shadowMigrationId, (String)"shadowMigrationId");
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        try {
            CloudSiteDeleteRequest cloudSiteDeleteRequest = new CloudSiteDeleteRequest(jobId);
            URI uRI = AbstractPluginHttpClientKt.buildURI$default(this.getMigrationServiceBaseURI(), DELETE_CLOUD_SITE_PATH, new String[0], null, 8, null);
            bl = Intrinsics.areEqual((Object)this.httpClient.execute(new MigrationPluginHttpRequest("POST", uRI, null, cloudSiteDeleteRequest, null, null, 52, null).addShadowMigrationId(shadowMigrationId).addShadowMigrationScopeId(shadowMigrationScopeId).contentTypeJson().acceptsJson().authorization("Bearer " + containerToken), CloudSiteDeleteResponse.class).getStatus(), (Object)"SUCCESS");
        }
        catch (Exception e) {
            this.log.info("Failed to cleanup cloud site for shadow " + e);
            bl = false;
        }
        return bl;
    }

    private final ShadowMigrationJobResponse pollForShadowMigrationJob(String jobId, String path, String shadowMigrationId, String shadowMigrationScopeId, String originalMigrationScopeId, String originalMigrationId, String containerToken, Class<? extends ShadowMigrationJobResponse> responseClass) {
        Instant timeout = Instant.now().plusMillis(this.pollingTimeout);
        while (Instant.now().compareTo(timeout) < 0) {
            String[] stringArray = new String[]{jobId};
            MigrationPluginHttpRequest migrationPluginHttpRequest = new MigrationPluginHttpRequest("GET", AbstractPluginHttpClientKt.buildURI$default(this.getMigrationServiceBaseURI(), path, stringArray, null, 8, null), null, null, null, null, 60, null);
            ShadowMigrationJobResponse response2 = this.httpClient.execute(this.withDefaultShadowHeaders(migrationPluginHttpRequest, (ContainerToken)(stringArray = new ContainerToken(containerToken)), null, originalMigrationScopeId, originalMigrationId, shadowMigrationScopeId, shadowMigrationId), responseClass);
            if (StringsKt.equals((String)response2.getStatus(), (String)"SUCCESS", (boolean)true)) {
                return response2;
            }
            if (StringsKt.equals((String)response2.getStatus(), (String)"FAILED", (boolean)true)) {
                throw new ShadowJobFailureException("Shadow Migration Job with id: " + jobId + " failed");
            }
            this.pollingInterval.invoke((Object)20000L);
        }
        throw new MigrationServiceTimeoutException("Polling timeout while polling for " + path + " api after " + this.pollingTimeout + " milliseconds");
    }

    static /* synthetic */ ShadowMigrationJobResponse pollForShadowMigrationJob$default(MigrationServiceClient migrationServiceClient, String string, String string2, String string3, String string4, String string5, String string6, String string7, Class clazz, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            string5 = null;
        }
        if ((n & 0x20) != 0) {
            string6 = null;
        }
        return migrationServiceClient.pollForShadowMigrationJob(string, string2, string3, string4, string5, string6, string7, clazz);
    }

    @NotNull
    public final AnonymiseMappingResponse anonymizeUserMappings(@NotNull String fileId, @NotNull String containerToken, @NotNull AnonymiseMappingData request) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        AnonymiseMappingRequest anonymiseMappingRequest = new AnonymiseMappingRequest(fileId);
        URI uRI = AbstractPluginHttpClientKt.buildURI$default(this.getMigrationServiceBaseURI(), ANONIMISE_USER_PATH, new String[0], null, 8, null);
        Set set = SetsKt.setOf((Object)200);
        boolean $i$f$jacksonTypeRef = false;
        ShadowMigrationJobId response2 = (ShadowMigrationJobId)this.httpClient.execute(this.withDefaultShadowHeaders(new MigrationPluginHttpRequest("POST", uRI, set, anonymiseMappingRequest, null, null, 48, null), new ContainerToken(containerToken), request.getCloudRegion(), request.getOriginalMigrationScopeId(), request.getOriginalMigrationId(), request.getShadowMigrationScopeId(), request.getShadowMigrationId()), (TypeReference)new TypeReference<ShadowMigrationJobId>(){});
        ShadowMigrationJobResponse shadowMigrationJobResponse = MigrationServiceClient.pollForShadowMigrationJob$default(this, response2.getJobId(), ANONIMISE_USER_POLL_PATH, request.getShadowMigrationId(), request.getShadowMigrationScopeId(), null, null, containerToken, AnonymiseMappingResponse.class, 48, null);
        Intrinsics.checkNotNull((Object)shadowMigrationJobResponse, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.migrationservice.shadow.AnonymiseMappingResponse");
        return (AnonymiseMappingResponse)shadowMigrationJobResponse;
    }

    @NotNull
    public final AnonymiseMappingResponse anonymizeCustomerMappings(@NotNull String fileId, @NotNull String containerToken, @NotNull AnonymiseMappingData request) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        AnonymiseMappingRequest anonymiseMappingRequest = new AnonymiseMappingRequest(fileId);
        URI uRI = AbstractPluginHttpClientKt.buildURI$default(this.getMigrationServiceBaseURI(), ANONIMISE_CUSTOMER_PATH, new String[0], null, 8, null);
        Set set = SetsKt.setOf((Object)200);
        boolean $i$f$jacksonTypeRef = false;
        ShadowMigrationJobId response2 = (ShadowMigrationJobId)this.httpClient.execute(this.withDefaultShadowHeaders(new MigrationPluginHttpRequest("POST", uRI, set, anonymiseMappingRequest, null, null, 48, null), new ContainerToken(containerToken), request.getCloudRegion(), request.getOriginalMigrationScopeId(), request.getOriginalMigrationId(), request.getShadowMigrationScopeId(), request.getShadowMigrationId()), (TypeReference)new TypeReference<ShadowMigrationJobId>(){});
        ShadowMigrationJobResponse shadowMigrationJobResponse = MigrationServiceClient.pollForShadowMigrationJob$default(this, response2.getJobId(), ANONIMISE_CUSTOMER_POLL_PATH, request.getShadowMigrationId(), request.getShadowMigrationScopeId(), null, null, containerToken, AnonymiseMappingResponse.class, 48, null);
        Intrinsics.checkNotNull((Object)shadowMigrationJobResponse, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.migrationservice.shadow.AnonymiseMappingResponse");
        return (AnonymiseMappingResponse)shadowMigrationJobResponse;
    }

    public final void executeRecipe(@NotNull String containerToken, @NotNull String migrationId, @NotNull String cloudRegion, @NotNull String migrationScopeId2, @NotNull RecipeExecutionRequest recipeExecutionRequest) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)cloudRegion, (String)"cloudRegion");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)recipeExecutionRequest, (String)"recipeExecutionRequest");
        Object object = new String[]{migrationId, recipeExecutionRequest.getName()};
        URI uRI = AbstractPluginHttpClientKt.buildURI$default(this.getMigrationServiceBaseURI(), EXECUTE_RECIPE_VIA_MS, object, null, 8, null);
        Object[] objectArray = new Integer[]{202, 200};
        object = SetsKt.setOf((Object[])objectArray);
        this.httpClient.execute(this.withDefaultAndCirHeaders(new MigrationPluginHttpRequest("POST", uRI, (Set)object, recipeExecutionRequest, null, null, 48, null), new ContainerToken(containerToken), cloudRegion, migrationScopeId2));
    }

    public final boolean isInMaintenance(@NotNull String containerToken) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        MigrationPluginHttpRequest migrationPluginHttpRequest = this.withDefaultHeaders(new MigrationPluginHttpRequest("GET", AbstractPluginHttpClientKt.buildURI$default(this.getMigrationServiceBaseURI(), MIGRATION_HEALTH_CHECK, new String[0], null, 8, null), null, null, null, null, 60, null), new ContainerToken(containerToken));
        String string = this.senSupplier.getFirstSen();
        if (string == null) {
            string = "";
        }
        return this.httpClient.execute(migrationPluginHttpRequest.addHeader("X-ASEN", string), ServiceStatusResponse.class).getMaintenance();
    }

    private final MigrationPluginHttpRequest withDefaultShadowHeaders(MigrationPluginHttpRequest $this$withDefaultShadowHeaders, ContainerToken containerToken, String cloudRegion, String originalMigrationScopeId, String originalMigrationId, String shadowMigrationScopeId, String shadowMigrationId) {
        MigrationPluginHttpRequest migrationPluginHttpRequest;
        block4: {
            String it;
            MigrationPluginHttpRequest $this$withDefaultShadowHeaders_u24lambda_u245 = migrationPluginHttpRequest = $this$withDefaultShadowHeaders;
            boolean bl = false;
            this.withDefaultHeaders($this$withDefaultShadowHeaders_u24lambda_u245, containerToken);
            String string = originalMigrationScopeId;
            if (string != null) {
                it = string;
                boolean bl2 = false;
                $this$withDefaultShadowHeaders_u24lambda_u245.addOriginalMigrationScopeId(originalMigrationScopeId);
            }
            String string2 = originalMigrationId;
            if (string2 != null) {
                it = string2;
                boolean bl3 = false;
                $this$withDefaultShadowHeaders_u24lambda_u245.addOriginalMigrationId(originalMigrationId);
            }
            String string3 = shadowMigrationId;
            if (string3 != null) {
                it = string3;
                boolean bl4 = false;
                $this$withDefaultShadowHeaders_u24lambda_u245.addShadowMigrationId(shadowMigrationId);
            }
            String string4 = shadowMigrationScopeId;
            if (string4 != null) {
                it = string4;
                boolean bl5 = false;
                $this$withDefaultShadowHeaders_u24lambda_u245.addShadowMigrationScopeId(shadowMigrationScopeId);
            }
            String string5 = cloudRegion;
            if (string5 == null) break block4;
            it = string5;
            boolean bl6 = false;
            $this$withDefaultShadowHeaders_u24lambda_u245.addCloudRegionForShadow(cloudRegion);
        }
        return migrationPluginHttpRequest;
    }

    static /* synthetic */ MigrationPluginHttpRequest withDefaultShadowHeaders$default(MigrationServiceClient migrationServiceClient, MigrationPluginHttpRequest migrationPluginHttpRequest, ContainerToken containerToken, String string, String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return migrationServiceClient.withDefaultShadowHeaders(migrationPluginHttpRequest, containerToken, string, string2, string3, string4, string5);
    }

    private final MigrationPluginHttpRequest withDefaultAndCirHeaders(MigrationPluginHttpRequest $this$withDefaultAndCirHeaders, ContainerToken containerToken, String cloudRegion, String migrationScopeId2) {
        MigrationPluginHttpRequest migrationPluginHttpRequest;
        MigrationPluginHttpRequest $this$withDefaultAndCirHeaders_u24lambda_u246 = migrationPluginHttpRequest = $this$withDefaultAndCirHeaders;
        boolean bl = false;
        this.withDefaultHeaders($this$withDefaultAndCirHeaders_u24lambda_u246, containerToken);
        $this$withDefaultAndCirHeaders_u24lambda_u246.addCloudRegion(cloudRegion);
        $this$withDefaultAndCirHeaders_u24lambda_u246.addMigrationScopeId(migrationScopeId2);
        return migrationPluginHttpRequest;
    }

    private final MigrationPluginHttpRequest withDefaultHeaders(MigrationPluginHttpRequest $this$withDefaultHeaders, ContainerToken containerToken) {
        MigrationPluginHttpRequest migrationPluginHttpRequest;
        MigrationPluginHttpRequest $this$withDefaultHeaders_u24lambda_u247 = migrationPluginHttpRequest = $this$withDefaultHeaders;
        boolean bl = false;
        $this$withDefaultHeaders_u24lambda_u247.authorization("Bearer " + (String)((Object)containerToken.getValue()));
        $this$withDefaultHeaders_u24lambda_u247.contentTypeJson();
        $this$withDefaultHeaders_u24lambda_u247.acceptsJson();
        return migrationPluginHttpRequest;
    }

    @Nullable
    public final Long getDownloadLogsSignedUrlViaMS(@NotNull ContainerToken containerToken, @NotNull MigrationId migrationId, @NotNull String sourceId, @NotNull Path file2, @NotNull String migrationScopeId2, @NotNull String cloudRegion) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)cloudRegion, (String)"cloudRegion");
        URI uRI = this.getMigrationServiceBaseURI();
        String[] stringArray = new String[2];
        Intrinsics.checkNotNullExpressionValue((Object)migrationId.toString(), (String)"toString(...)");
        stringArray[1] = sourceId;
        return this.httpClient.execute(this.withDefaultAndCirHeaders(new MigrationPluginHttpRequest("GET", AbstractPluginHttpClientKt.buildURI$default(uRI, DOWNLOAD_LOGS_VIA_MS, stringArray, null, 8, null), SetsKt.setOf((Object)200), null, null, null, 56, null), containerToken, cloudRegion, migrationScopeId2), file2);
    }

    @NotNull
    public final CloseableHttpResponse downloadPMRALogsViaMS(@NotNull ContainerToken containerToken, @NotNull MigrationId migrationId, @NotNull String migrationScopeId2, @NotNull String cloudRegion) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)migrationScopeId2, (String)"migrationScopeId");
        Intrinsics.checkNotNullParameter((Object)cloudRegion, (String)"cloudRegion");
        URI uRI = this.getMigrationServiceBaseURI();
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)migrationId.toString(), (String)"toString(...)");
        return this.httpClient.getResponse(this.withDefaultAndCirHeaders(new MigrationPluginHttpRequest("GET", AbstractPluginHttpClientKt.buildURI$default(uRI, DOWNLOAD_PMRA_LOGS_VIA_MS, stringArray, null, 8, null), SetsKt.setOf((Object)200), null, null, null, 56, null), containerToken, cloudRegion, migrationScopeId2));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/migrationservice/MigrationServiceClient$Companion;", "", "()V", "ANONIMISE_CUSTOMER_PATH", "", "ANONIMISE_CUSTOMER_POLL_PATH", "ANONIMISE_USER_PATH", "ANONIMISE_USER_POLL_PATH", "CREATE_CLOUD_SITE_PATH", "CREATE_CLOUD_SITE_POLL_PATH", "CREATE_WORKPLAN_CONFIG", "DELETE_CLOUD_SITE_PATH", "DOWNLOAD_LOGS_VIA_MS", "DOWNLOAD_PMRA_LOGS_VIA_MS", "EXECUTE_RECIPE_VIA_MS", "MIGRATION_HEALTH_CHECK", "MIGRATION_SERVICE_POLLING_TIMEOUT", "", "MIGRATION_SERVICE_POLL_INTERVAL_IN_MILLIS", "MIGRATION_SERVICE_STARGATE_URI", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

