/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.orchestratorclient;

import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.context.RequestContext;
import com.atlassian.jira.migration.context.RequestContextBuilder;
import com.atlassian.jira.migration.httpclient.AbstractPluginHttpClientKt;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpClient;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpRequest;
import com.atlassian.jira.migration.httpclient.exceptions.HttpCommunicationException;
import com.atlassian.jira.migration.httpclient.exceptions.HttpProtocolException;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.jira.migration.orchestratorclient.BaseOrchestratorException;
import com.atlassian.jira.migration.orchestratorclient.MigrationOrchestratorClientKt;
import com.atlassian.jira.migration.orchestratorclient.OrchestratorExceptions;
import com.atlassian.jira.migration.orchestratorclient.ServiceStatusResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.http.Header;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Deprecated(message="All migration orchestrator calls should be made via PlatformService")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u0007\u0018\u0000 -2\u00020\u0001:\u0002-.B\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eJ)\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0002JX\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00172\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u001a2\u0006\u0010$\u001a\u00020%H\u0002J\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001aJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002J\u0014\u0010,\u001a\u00020\u0012*\u00020\u00122\u0006\u0010(\u001a\u00020\u001aH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/atlassian/jira/migration/orchestratorclient/MigrationOrchestratorClient;", "", "migrationServicesConfiguration", "Lcom/atlassian/jira/migration/MigrationServicesConfiguration;", "factory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "requestContextBuilder", "Lcom/atlassian/jira/migration/context/RequestContextBuilder;", "(Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/context/RequestContextBuilder;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/atlassian/jira/migration/context/RequestContextBuilder;)V", "migrationPluginHttpClient", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;", "(Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;Lcom/atlassian/jira/migration/context/RequestContextBuilder;)V", "execute", "T", "request", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;", "responseClass", "Ljava/lang/Class;", "(Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;Ljava/lang/Class;)Ljava/lang/Object;", "getMigrationOrchestratorBaseURI", "Ljava/net/URI;", "getMigrationPluginHttpRequest", "method", "", "uri", "expectedStatusCodes", "", "", "body", "headers", "", "Lorg/apache/http/Header;", "contentType", "requestContext", "Lcom/atlassian/jira/migration/context/RequestContext;", "isInMaintenance", "", "containerToken", "toMOException", "", "it", "withDefaultHeaders", "Companion", "Routes", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationOrchestratorClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationOrchestratorClient.kt\ncom/atlassian/jira/migration/orchestratorclient/MigrationOrchestratorClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
public final class MigrationOrchestratorClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationServicesConfiguration migrationServicesConfiguration;
    @NotNull
    private final MigrationPluginHttpClient migrationPluginHttpClient;
    @NotNull
    private final RequestContextBuilder requestContextBuilder;
    private static final Logger log = LoggerFactory.getLogger(MigrationOrchestratorClient.class);

    @VisibleForTesting
    public MigrationOrchestratorClient(@NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull MigrationPluginHttpClient migrationPluginHttpClient, @NotNull RequestContextBuilder requestContextBuilder) {
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)migrationPluginHttpClient, (String)"migrationPluginHttpClient");
        Intrinsics.checkNotNullParameter((Object)requestContextBuilder, (String)"requestContextBuilder");
        this.migrationServicesConfiguration = migrationServicesConfiguration;
        this.migrationPluginHttpClient = migrationPluginHttpClient;
        this.requestContextBuilder = requestContextBuilder;
        URI migrationOrchestratorBaseURI = this.getMigrationOrchestratorBaseURI();
        log.info("orchestrator base url: {}", (Object)migrationOrchestratorBaseURI);
    }

    @Inject
    public MigrationOrchestratorClient(@NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull ObjectMapperFactory factory, @NotNull RequestContextBuilder requestContextBuilder) {
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)requestContextBuilder, (String)"requestContextBuilder");
        this(migrationServicesConfiguration, factory.createObjectMapperHandlingUnknownFields(), requestContextBuilder);
    }

    public MigrationOrchestratorClient(@NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull ObjectMapper objectMapper2, @NotNull RequestContextBuilder requestContextBuilder) {
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)objectMapper2, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)requestContextBuilder, (String)"requestContextBuilder");
        this(migrationServicesConfiguration, MigrationOrchestratorClientKt.buildClient(objectMapper2), requestContextBuilder);
    }

    private final URI getMigrationOrchestratorBaseURI() {
        URI baseURI = this.migrationServicesConfiguration.getMigrationOrchestratorBaseURI();
        URI uRI = baseURI.resolve("/migration/orchestrator/api/plugin/");
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"resolve(...)");
        return uRI;
    }

    public final boolean isInMaintenance(@NotNull String containerToken) {
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        return this.execute(this.withDefaultHeaders(MigrationOrchestratorClient.getMigrationPluginHttpRequest$default(this, "GET", AbstractPluginHttpClientKt.buildURI$default(this.getMigrationOrchestratorBaseURI(), "migrations/service-status", new String[0], null, 8, null), null, null, null, null, this.requestContextBuilder.build(), 60, null), containerToken), ServiceStatusResponse.class).getMaintenance();
    }

    private final <T> T execute(MigrationPluginHttpRequest request, Class<T> responseClass) {
        Object $this$execute_u24lambda_u240;
        Object object = this;
        try {
            $this$execute_u24lambda_u240 = object;
            boolean bl = false;
            $this$execute_u24lambda_u240 = Result.constructor-impl(((MigrationOrchestratorClient)$this$execute_u24lambda_u240).migrationPluginHttpClient.execute(request, responseClass));
        }
        catch (Throwable bl) {
            $this$execute_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$execute_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw this.toMOException(it);
        }
        return (T)object;
    }

    private final Throwable toMOException(Throwable it) {
        Throwable throwable = it;
        return throwable instanceof UnexpectedStatusCodeException ? (Throwable)(((UnexpectedStatusCodeException)it).getStatusCode() >= 500 ? (BaseOrchestratorException)OrchestratorExceptions.INSTANCE.serverError("request to Migration Orchestrator failed", it) : (((UnexpectedStatusCodeException)it).getStatusCode() == 404 ? (BaseOrchestratorException)OrchestratorExceptions.INSTANCE.clientError("request to Migration Orchestrator failed with status code " + ((UnexpectedStatusCodeException)it).getStatusCode(), it, true) : (BaseOrchestratorException)OrchestratorExceptions.clientError$default(OrchestratorExceptions.INSTANCE, "request to Migration Orchestrator failed", it, false, 4, null))) : (throwable instanceof HttpProtocolException ? (Throwable)OrchestratorExceptions.clientError$default(OrchestratorExceptions.INSTANCE, "protocol violation error", it, false, 4, null) : (throwable instanceof HttpCommunicationException ? (Throwable)OrchestratorExceptions.INSTANCE.serverError("failed to send a request to server", it) : it));
    }

    private final MigrationPluginHttpRequest withDefaultHeaders(MigrationPluginHttpRequest $this$withDefaultHeaders, String containerToken) {
        block0: {
            Object object;
            log.debug("Requesting: {}", (Object)$this$withDefaultHeaders.getUri());
            $this$withDefaultHeaders.authorization("Bearer " + containerToken);
            Object object2 = $this$withDefaultHeaders.getBody();
            if (object2 == null) break block0;
            Object $this$withDefaultHeaders_u24lambda_u242 = object = object2;
            boolean bl = false;
            $this$withDefaultHeaders.contentTypeJson();
        }
        return $this$withDefaultHeaders.acceptsJson();
    }

    private final MigrationPluginHttpRequest getMigrationPluginHttpRequest(String method, URI uri, Set<Integer> expectedStatusCodes, Object body, List<Header> headers, String contentType, RequestContext requestContext) {
        return new MigrationPluginHttpRequest(method, uri, expectedStatusCodes, body, CollectionsKt.toMutableList((Collection)CollectionsKt.plus((Collection)headers, (Iterable)requestContext.toHttpHeaders())), contentType);
    }

    static /* synthetic */ MigrationPluginHttpRequest getMigrationPluginHttpRequest$default(MigrationOrchestratorClient migrationOrchestratorClient, String string, URI uRI, Set set, Object object, List list, String string2, RequestContext requestContext, int n, Object object2) {
        if ((n & 4) != 0) {
            set = SetsKt.setOf((Object)200);
        }
        if ((n & 8) != 0) {
            object = null;
        }
        if ((n & 0x10) != 0) {
            list = new ArrayList();
        }
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        return migrationOrchestratorClient.getMigrationPluginHttpRequest(string, uRI, set, object, list, string2, requestContext);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/orchestratorclient/MigrationOrchestratorClient$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @VisibleForTesting
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/orchestratorclient/MigrationOrchestratorClient$Routes;", "", "()V", "MAINTENANCE_CHECK", "", "MIGRATION_ORCHESTRATOR_STARGATE_BASE_URI", "jira-migration-plugin"})
    public static final class Routes {
        @NotNull
        public static final Routes INSTANCE = new Routes();
        @NotNull
        public static final String MIGRATION_ORCHESTRATOR_STARGATE_BASE_URI = "/migration/orchestrator/api/plugin/";
        @NotNull
        public static final String MAINTENANCE_CHECK = "migrations/service-status";

        private Routes() {
        }
    }
}

