/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.plan;

import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.execution.model.MigrationMetaData;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.migration.Migration;
import com.atlassian.jira.migration.migration.MigrationChain;
import com.atlassian.jira.migration.migration.MigrationChainRepository;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.orchestratorclient.GetTaskStatusResponse;
import com.atlassian.jira.migration.orchestratorclient.tasks.MigrationTaskType;
import com.atlassian.jira.migration.orchestratorclient.tasks.ProgressUnit;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.migration.api.MigrationChainId;
import com.atlassian.migration.api.MigrationId;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\u0018\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/plan/ParallelMigrationCheckService;", "", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "migrationChainRepository", "Lcom/atlassian/jira/migration/migration/MigrationChainRepository;", "(Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/jira/migration/migration/MigrationChainRepository;)V", "checkOrSaveMapping", "", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "migrationMetadata", "Lcom/atlassian/jira/migration/execution/model/MigrationMetaData;", "checkParallelMigrations", "Lcom/atlassian/jira/migration/migration/Migration;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "getParallelMigrationChainId", "Lcom/atlassian/migration/api/MigrationChainId;", "isLongRunningMigration", "", "migration", "isSameCloudSite", "isShadowMigration", "populateMigrationChainId", "shouldAllowParallelMigrationUsingChainId", "isV4Enabled", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nParallelMigrationCheckService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParallelMigrationCheckService.kt\ncom/atlassian/jira/migration/plan/ParallelMigrationCheckService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1#2:98\n766#3:99\n857#3,2:100\n1054#3:102\n288#3:103\n1747#3,3:104\n289#3:107\n*S KotlinDebug\n*F\n+ 1 ParallelMigrationCheckService.kt\ncom/atlassian/jira/migration/plan/ParallelMigrationCheckService\n*L\n64#1:99\n64#1:100,2\n67#1:102\n67#1:103\n68#1:104,3\n67#1:107\n*E\n"})
public final class ParallelMigrationCheckService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final MigrationChainRepository migrationChainRepository;
    @NotNull
    private static final List<MigrationTaskType> blockedMigrationTasks;
    private static final long TTL_IN_HOURS = 24L;

    @Inject
    public ParallelMigrationCheckService(@NotNull MigrationRepository migrationRepository, @NotNull MigrationFeatures migrationFeatures, @NotNull DiscoveryService discoveryService, @NotNull MigrationChainRepository migrationChainRepository) {
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)migrationChainRepository, (String)"migrationChainRepository");
        this.migrationRepository = migrationRepository;
        this.migrationFeatures = migrationFeatures;
        this.discoveryService = discoveryService;
        this.migrationChainRepository = migrationChainRepository;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final MigrationChainId getParallelMigrationChainId(@NotNull Plan plan) {
        Intrinsics.checkNotNullParameter((Object)plan, (String)"plan");
        migration = this.checkParallelMigrations(plan);
        v0 = migration;
        if (v0 == null) ** GOTO lbl-1000
        it = v0;
        $i$a$-let-ParallelMigrationCheckService$getParallelMigrationChainId$migrationChainId$1 = false;
        v1 = this.migrationChainRepository.findBy(it.getMigrationId());
        v0 = v1;
        if (v1 != null && (v0 = v0.getMigrationChainId()) != null) {
            it = v0;
            $i$a$-let-ParallelMigrationCheckService$getParallelMigrationChainId$migrationChainId$2 = false;
            v2 = new MigrationChainId((String)it);
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        if ((v3 = (migrationChainId = v2)) == null) {
            v3 = new MigrationChainId(UUID.randomUUID().toString());
        }
        return v3;
    }

    public final void checkOrSaveMapping(@NotNull MigrationId migrationId, @NotNull MigrationMetaData migrationMetadata2) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)migrationMetadata2, (String)"migrationMetadata");
        String string = migrationId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        if (this.migrationChainRepository.findBy(string) == null) {
            String string2 = migrationId.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String string3 = migrationMetadata2.getMigrationChainId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            this.migrationChainRepository.save(new MigrationChain(string2, string3, 0L, 4, null));
        }
    }

    @Nullable
    public final MigrationChainId populateMigrationChainId(@NotNull MigrationMetaData migrationMetadata2) {
        Intrinsics.checkNotNullParameter((Object)migrationMetadata2, (String)"migrationMetadata");
        return migrationMetadata2.getShouldPopulateMigrationChainId() ? migrationMetadata2.getMigrationChainId() : null;
    }

    public final boolean shouldAllowParallelMigrationUsingChainId(boolean isV4Enabled) {
        return this.migrationFeatures.getEnableV4ParallelMigrationChainFeature() && isV4Enabled || this.migrationFeatures.getEnableV3ParallelMigrationChainFeature() && !isV4Enabled;
    }

    /*
     * Unable to fully structure code
     */
    private final Migration checkParallelMigrations(Plan plan) {
        block6: {
            $this$filter$iv = this.migrationRepository.getInProgressMigrations();
            $i$f$filter = false;
            var5_4 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (Migration)element$iv$iv;
                $i$a$-filter-ParallelMigrationCheckService$checkParallelMigrations$inProgressMigrationIds$1 = false;
                if (!(this.isShadowMigration(it) == false && this.isSameCloudSite(it, plan) != false && it.getStatus() != null && this.isLongRunningMigration(it) == false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            inProgressMigrationIds = (List)destination$iv$iv;
            $this$sortedByDescending$iv = inProgressMigrationIds;
            $i$f$sortedByDescending = false;
            $this$firstOrNull$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Migration it = (Migration)b;
                    boolean bl = false;
                    Comparable comparable = it.getUpdated();
                    it = (Migration)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getUpdated());
                }
            });
            $i$f$firstOrNull = false;
            for (E element$iv : $this$firstOrNull$iv) {
                block5: {
                    block7: {
                        migration = (Migration)element$iv;
                        $i$a$-firstOrNull-ParallelMigrationCheckService$checkParallelMigrations$2 = false;
                        v0 = migration.getStatus();
                        Intrinsics.checkNotNull((Object)v0);
                        $this$any$iv = v0.getStatus();
                        $i$f$any = false;
                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block7;
                        v1 = false;
                        break block5;
                    }
                    for (T element$iv : $this$any$iv) {
                        it = (GetTaskStatusResponse.TaskProgress)element$iv;
                        $i$a$-any-ParallelMigrationCheckService$checkParallelMigrations$2$1 = false;
                        if (!ParallelMigrationCheckService.blockedMigrationTasks.contains((Object)it.getTask().getMigrationTaskType())) ** GOTO lbl-1000
                        if (it.getProgressItems().isEmpty()) ** GOTO lbl-1000
                        var15_19 = it.getProgressItems().get((Object)ProgressUnit.PROJECT);
                        if (var15_19 != null ? !var15_19.getCompleted() : false) ** GOTO lbl-1000
                        var15_19 = it.getProgressItems().get((Object)ProgressUnit.CROSS_PROJECT_ENTITY);
                        v2 = var15_19 != null ? !var15_19.getCompleted() : false;
                        if (v2) lbl-1000:
                        // 3 sources

                        {
                            v3 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v3 = false;
                        }
                        if (!v3) continue;
                        v1 = true;
                        break block5;
                    }
                    v1 = false;
                }
                if (!v1) continue;
                v4 = element$iv;
                break block6;
            }
            v4 = null;
        }
        return v4;
    }

    private final boolean isSameCloudSite(Migration migration, Plan plan2) {
        CloudSite cloudSite2 = DiscoveryService.retrieveCloudSiteFor$default(this.discoveryService, migration.getMigrationId(), false, 2, null);
        return Intrinsics.areEqual((Object)plan2.getCloudId(), (Object)(cloudSite2 != null ? cloudSite2.getCloudId() : null));
    }

    private final boolean isShadowMigration(Migration migration) {
        Plan plan2 = DiscoveryService.retrievePlanFor$default(this.discoveryService, migration.getMigrationId(), false, 2, null);
        return plan2 != null ? Intrinsics.areEqual((Object)plan2.isShadowPlan(), (Object)true) : false;
    }

    private final boolean isLongRunningMigration(Migration migration) {
        return Instant.now().minus(24L, ChronoUnit.HOURS).compareTo(migration.getCreated()) > 0;
    }

    static {
        MigrationTaskType[] migrationTaskTypeArray = new MigrationTaskType[]{MigrationTaskType.PROJECT_DATA_MIGRATION, MigrationTaskType.PROJECT_DATA_UPLOAD, MigrationTaskType.CROSS_PROJECT_DATA_UPLOAD, MigrationTaskType.CROSS_PROJECT_DATA_MIGRATION};
        blockedMigrationTasks = CollectionsKt.listOf((Object[])migrationTaskTypeArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/plan/ParallelMigrationCheckService$Companion;", "", "()V", "TTL_IN_HOURS", "", "blockedMigrationTasks", "", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/MigrationTaskType;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

