/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.plan;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.plan.DuplicatedPlanException;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanActiveStatus;
import com.atlassian.jira.migration.plan.PlanEntity;
import com.atlassian.jira.migration.plan.PlanNotFoundException;
import com.atlassian.jira.migration.plan.PlanRepositoryCodecModule;
import com.atlassian.jira.migration.plan.PlanRepositoryException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\fJ\u0018\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u000e0\u000e2\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0002J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\fJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\fJ\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\f2\b\b\u0002\u0010\u001c\u001a\u00020\fJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010\u001f\u001a\u00020\fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\fJ\u001a\u0010\"\u001a\u0004\u0018\u00010\u00112\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u0001H\u0002J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001eJ\u000e\u0010&\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010'\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0018\u0010(\u001a\n \u0015*\u0004\u0018\u00010\f0\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u000e\u0010)\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0018\u0010*\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010+\u001a\u00020,H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/atlassian/jira/migration/plan/PlanRepository;", "", "ao", "Lcom/atlassian/activeobjects/external/ActiveObjects;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/activeobjects/external/ActiveObjects;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "archive", "", "id", "", "create", "Lcom/atlassian/jira/migration/plan/Plan;", "plan", "delete", "Lcom/atlassian/jira/migration/plan/PlanEntity;", "fetchFirstOrNullShadowPlan", "originalMigrationId", "fromEntityToPlan", "kotlin.jvm.PlatformType", "planEntity", "get", "getByExecutionId", "executionId", "getByName", "name", "planId", "getByNameBeginningWith", "", "namePrefix", "getMigrationTypeForPlan", "Lcom/atlassian/jira/migration/plan/MigrationType;", "getPlanEntityBy", "clause", "value", "list", "restoreArchive", "safeFromEntityToPlan", "toJson", "update", "updatePlanActiveStatus", "planActiveStatus", "Lcom/atlassian/jira/migration/plan/PlanActiveStatus;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPlanRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanRepository.kt\ncom/atlassian/jira/migration/plan/PlanRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,287:1\n1#2:288\n1#2:299\n1#2:312\n11383#3,9:289\n13309#3:298\n13310#3:300\n11392#3:301\n11383#3,9:302\n13309#3:311\n13310#3:313\n11392#3:314\n288#4,2:315\n*S KotlinDebug\n*F\n+ 1 PlanRepository.kt\ncom/atlassian/jira/migration/plan/PlanRepository\n*L\n53#1:299\n61#1:312\n53#1:289,9\n53#1:298\n53#1:300\n53#1:301\n61#1:302,9\n61#1:311\n61#1:313\n61#1:314\n153#1:315,2\n*E\n"})
public final class PlanRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActiveObjects ao;
    @NotNull
    private final ObjectMapper mapper;
    private static final Logger log = LoggerFactory.getLogger(CloudSiteRepository.class);

    @Inject
    public PlanRepository(@NotNull ActiveObjects ao, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)ao, (String)"ao");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.ao = ao;
        ObjectMapper objectMapper2 = objectMapperFactory.createObjectMapper().registerModule((Module)new PlanRepositoryCodecModule());
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper2, (String)"registerModule(...)");
        this.mapper = objectMapper2;
    }

    @Nullable
    public final Plan get(@NotNull String id) {
        Plan plan2;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        PlanEntity planEntity = this.getPlanEntityBy("ID = ?", id);
        if (planEntity != null) {
            PlanEntity p0 = planEntity;
            boolean bl = false;
            plan2 = this.fromEntityToPlan(p0);
        } else {
            plan2 = null;
        }
        return plan2;
    }

    @NotNull
    public final MigrationType getMigrationTypeForPlan(@NotNull String planId) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Plan plan2 = this.get(planId);
        MigrationType migrationType = plan2 != null ? plan2.getMigrationType() : null;
        Intrinsics.checkNotNull((Object)((Object)migrationType));
        return migrationType;
    }

    @Nullable
    public final Plan getByName(@NotNull String name) {
        Plan plan2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PlanEntity planEntity = this.getPlanEntityBy("PLAN_NAME = ?", name);
        if (planEntity != null) {
            PlanEntity p0 = planEntity;
            boolean bl = false;
            plan2 = this.fromEntityToPlan(p0);
        } else {
            plan2 = null;
        }
        return plan2;
    }

    @Nullable
    public final Plan getByName(@NotNull String name, @NotNull String planId) {
        Plan plan2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Object[] objectArray = new Object[]{name, planId};
        RawEntity[] rawEntityArray = this.ao.find(PlanEntity.class, Query.select().where("PLAN_NAME = ? AND ID != ?", objectArray).limit(1));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        PlanEntity planEntity = (PlanEntity)ArraysKt.firstOrNull((Object[])rawEntityArray);
        if (planEntity != null) {
            PlanEntity p0 = planEntity;
            boolean bl = false;
            plan2 = this.fromEntityToPlan(p0);
        } else {
            plan2 = null;
        }
        return plan2;
    }

    public static /* synthetic */ Plan getByName$default(PlanRepository planRepository, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return planRepository.getByName(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Plan> getByNameBeginningWith(@NotNull String namePrefix) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)namePrefix, (String)"namePrefix");
        Object[] objectArray = new Object[]{namePrefix + '%'};
        RawEntity[] rawEntityArray = this.ao.find(PlanEntity.class, Query.select((String)"PLAN_NAME").where("PLAN_NAME like ?", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Object[] $this$mapNotNull$iv = rawEntityArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Plan it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            PlanEntity p0 = (PlanEntity)element$iv$iv;
            boolean bl2 = false;
            if (this.safeFromEntityToPlan(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final Plan getByExecutionId(@NotNull String executionId) {
        Plan plan2;
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Object[] objectArray = new Object[]{'%' + executionId + '%'};
        RawEntity[] rawEntityArray = this.ao.find(PlanEntity.class, Query.select().where("JSON LIKE ?", objectArray).limit(1));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        PlanEntity planEntity = (PlanEntity)ArraysKt.firstOrNull((Object[])rawEntityArray);
        if (planEntity != null) {
            PlanEntity p0 = planEntity;
            boolean bl = false;
            plan2 = this.fromEntityToPlan(p0);
        } else {
            plan2 = null;
        }
        return plan2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Plan> list() {
        void $this$mapNotNullTo$iv$iv;
        RawEntity[] rawEntityArray = this.ao.find(PlanEntity.class, Query.select().order("CREATED_TIMESTAMP DESC"));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        Object[] $this$mapNotNull$iv = rawEntityArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Plan it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            PlanEntity p0 = (PlanEntity)element$iv$iv;
            boolean bl2 = false;
            if (this.safeFromEntityToPlan(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Plan safeFromEntityToPlan(PlanEntity planEntity) {
        Plan plan2;
        try {
            plan2 = this.fromEntityToPlan(planEntity);
        }
        catch (PlanRepositoryException e) {
            log.error("Unexpected error reading plans from DB for planEntityId=" + planEntity.getId() + ", will skip record", (Throwable)e);
            plan2 = null;
        }
        return plan2;
    }

    @NotNull
    public final Plan create(@NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        if (this.getPlanEntityBy("ID = ?", plan2.getId()) != null) {
            throw new DuplicatedPlanException();
        }
        RawEntity rawEntity = new RawEntity[]{TuplesKt.to((Object)"ID", (Object)plan2.getId()), TuplesKt.to((Object)"PLAN_NAME", (Object)plan2.getPlanName())};
        rawEntity = this.ao.create(PlanEntity.class, MapsKt.mapOf((Pair[])rawEntity));
        PlanEntity $this$create_u24lambda_u245 = (PlanEntity)rawEntity;
        boolean bl = false;
        long now = System.currentTimeMillis();
        $this$create_u24lambda_u245.setCreatedTimestamp(plan2.getCreatedTimestamp() > 0L ? plan2.getCreatedTimestamp() : now);
        $this$create_u24lambda_u245.setUpdatedTimestamp(now);
        String string = this.toJson(plan2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        $this$create_u24lambda_u245.setJson(string);
        $this$create_u24lambda_u245.save();
        PlanEntity it = (PlanEntity)rawEntity;
        boolean bl2 = false;
        log.debug("PlanEntity with id=" + it.getId() + " and planName=" + it.getPlanName() + " was created successfully.");
        return plan2;
    }

    @NotNull
    public final Plan update(@NotNull Plan plan2) {
        PlanEntity planEntity;
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        PlanEntity planEntity2 = this.getPlanEntityBy("ID = ?", plan2.getId());
        if (planEntity2 == null) {
            log.error("Update migration plan failed. Cannot update a plan " + plan2.getId() + " that does not exist.");
            throw new PlanNotFoundException();
        }
        PlanEntity $this$update_u24lambda_u247 = planEntity = planEntity2;
        boolean bl = false;
        String string = this.toJson(plan2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        $this$update_u24lambda_u247.setJson(string);
        $this$update_u24lambda_u247.setUpdatedTimestamp(System.currentTimeMillis());
        $this$update_u24lambda_u247.setPlanName(plan2.getPlanName());
        $this$update_u24lambda_u247.save();
        PlanEntity it = planEntity;
        boolean bl2 = false;
        log.debug("PlanEntity with id=" + it.getId() + " was updated successfully.");
        return plan2;
    }

    public final void archive(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.updatePlanActiveStatus(id, PlanActiveStatus.ARCHIVED);
    }

    public final void restoreArchive(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.updatePlanActiveStatus(id, PlanActiveStatus.ACTIVE);
    }

    @Nullable
    public final PlanEntity delete(@NotNull String id) {
        PlanEntity planEntity;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        PlanEntity planEntity2 = this.getPlanEntityBy("ID = ?", id);
        if (planEntity2 != null) {
            PlanEntity planEntity3;
            PlanEntity it = planEntity3 = planEntity2;
            boolean bl = false;
            RawEntity[] rawEntityArray = new RawEntity[]{it};
            this.ao.delete(rawEntityArray);
            planEntity = planEntity3;
        } else {
            planEntity = null;
        }
        return planEntity;
    }

    private final String toJson(Plan plan2) {
        String string;
        try {
            string = this.mapper.writeValueAsString((Object)plan2);
        }
        catch (IOException e) {
            throw new PlanRepositoryException("JSON serialization error for planId=" + plan2.getId() + " and planName=" + plan2.getPlanName(), e);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Plan fromEntityToPlan(PlanEntity planEntity) {
        void var2_2;
        try {
            Plan plan2 = (Plan)this.mapper.readValue(planEntity.getJson(), Plan.class);
            plan2.setCreatedTimestamp(planEntity.getCreatedTimestamp());
        }
        catch (IOException e) {
            throw new PlanRepositoryException("JSON deserialization error for planEntityId=" + planEntity.getId() + " planEntityName=" + planEntity.getPlanName(), e);
        }
        return var2_2;
    }

    private final void updatePlanActiveStatus(String id, PlanActiveStatus planActiveStatus) {
        PlanEntity planEntity;
        PlanEntity planEntity2 = this.getPlanEntityBy("ID = ?", id);
        if (planEntity2 == null) {
            log.error("For plan " + id + ", failed to update state of the plan to " + (Object)((Object)planActiveStatus) + '.');
            throw new PlanNotFoundException();
        }
        Plan plan2 = this.fromEntityToPlan(planEntity2);
        plan2.setActiveStatus(planActiveStatus);
        PlanEntity $this$updatePlanActiveStatus_u24lambda_u2410 = planEntity = planEntity2;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)plan2);
        String string = this.toJson(plan2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        $this$updatePlanActiveStatus_u24lambda_u2410.setJson(string);
        $this$updatePlanActiveStatus_u24lambda_u2410.setUpdatedTimestamp(System.currentTimeMillis());
        $this$updatePlanActiveStatus_u24lambda_u2410.save();
        PlanEntity it = planEntity;
        boolean bl2 = false;
        log.debug("PlanEntity with id=" + it.getId() + " was updated successfully.");
    }

    private final PlanEntity getPlanEntityBy(String clause, Object value) {
        Object[] objectArray = new Object[]{value};
        RawEntity[] rawEntityArray = this.ao.find(PlanEntity.class, Query.select().where(clause, objectArray).limit(1));
        Intrinsics.checkNotNullExpressionValue((Object)rawEntityArray, (String)"find(...)");
        return (PlanEntity)ArraysKt.firstOrNull((Object[])rawEntityArray);
    }

    @Nullable
    public final Plan fetchFirstOrNullShadowPlan(@NotNull String originalMigrationId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)originalMigrationId, (String)"originalMigrationId");
            Iterable $this$firstOrNull$iv = this.list();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Plan it = (Plan)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getOriginalMigrationId(), (Object)originalMigrationId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/plan/PlanRepository$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

