/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.plan;

import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/plan/PlanUtil;", "", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "(Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/plan/PlanRepository;)V", "getPlanFromMigrationId", "Lcom/atlassian/jira/migration/plan/Plan;", "migrationId", "", "jira-migration-plugin"})
public final class PlanUtil {
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final PlanRepository planRepository;

    @Inject
    public PlanUtil(@NotNull MigrationRepository migrationRepository, @NotNull PlanRepository planRepository) {
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        this.migrationRepository = migrationRepository;
        this.planRepository = planRepository;
    }

    @Nullable
    public final Plan getPlanFromMigrationId(@NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        String string = this.migrationRepository.findPlanIdByMigrationId(migrationId);
        if (string == null) {
            throw new IllegalStateException("Could not find plan for migration id " + migrationId + " when generating post summary report data");
        }
        String planId = string;
        Plan plan2 = this.planRepository.get(planId);
        if (plan2 == null) {
            throw new IllegalStateException("Could not find plan " + planId + " when generating post summary report data");
        }
        return plan2;
    }
}

