/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.plan.liftandshift;

import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.LiftAndShiftMode;
import com.atlassian.jira.migration.plan.MigrationTag;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.liftandshift.MigrationIntent;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0007R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/jira/migration/plan/liftandshift/BulkImportRequestBuilder;", "", "filename", "", "fileId", "(Ljava/lang/String;Ljava/lang/String;)V", "build", "", "Companion", "jira-migration-plugin"})
public final class BulkImportRequestBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String filename;
    @Nullable
    private final String fileId;

    public BulkImportRequestBuilder(@Nullable String filename, @Nullable String fileId) {
        this.filename = filename;
        this.fileId = fileId;
    }

    @NotNull
    public final Map<String, Object> build() {
        Pair[] pairArray = new Pair[3];
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"name", (Object)this.filename), TuplesKt.to((Object)"id", (Object)this.fileId)};
        pairArray[0] = TuplesKt.to((Object)"dataRestore", (Object)CollectionsKt.listOf((Object)MapsKt.mapOf((Pair[])pairArray2)));
        pairArray[1] = TuplesKt.to((Object)"importUserConfigurationMode", (Object)"SKIP");
        pairArray[2] = TuplesKt.to((Object)"client", (Object)"JCMA");
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/plan/liftandshift/BulkImportRequestBuilder$Companion;", "", "()V", "getBulkImportCompatibleValues", "Lcom/atlassian/jira/migration/plan/liftandshift/MigrationIntent;", "intent", "Lcom/atlassian/jira/migration/plan/MigrationTag;", "getMigrationProperties", "", "", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, Object> getMigrationProperties(@NotNull Plan plan2, @NotNull MigrationFeatures migrationFeatures) {
            Map map;
            Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
            Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
            if (plan2.isLiftAndShift()) {
                Pair[] pairArray = new Pair[3];
                LiftAndShiftMode liftAndShiftMode = plan2.getLiftAndShiftMode();
                if (liftAndShiftMode == null) {
                    liftAndShiftMode = LiftAndShiftMode.AUTOMATIC;
                }
                pairArray[0] = TuplesKt.to((Object)"dataGenerationType", (Object)((Object)liftAndShiftMode));
                pairArray[1] = TuplesKt.to((Object)"exportMode", (Object)(migrationFeatures.getEnableSinglePathLZ4MCS() ? "LZ4_WITH_MCS" : "ZIPPER_WITH_MEDIA"));
                MigrationTag migrationTag = plan2.getMigrationTag();
                if (migrationTag == null) {
                    migrationTag = MigrationTag.NOT_SPECIFIED;
                }
                pairArray[2] = TuplesKt.to((Object)"migrationIntent", (Object)((Object)this.getBulkImportCompatibleValues(migrationTag)));
                map = MapsKt.mapOf((Pair[])pairArray);
            } else {
                map = MapsKt.emptyMap();
            }
            return map;
        }

        private final MigrationIntent getBulkImportCompatibleValues(MigrationTag intent) {
            MigrationIntent migrationIntent;
            switch (WhenMappings.$EnumSwitchMapping$0[intent.ordinal()]) {
                case 1: {
                    migrationIntent = MigrationIntent.PRODUCTION;
                    break;
                }
                case 2: {
                    migrationIntent = MigrationIntent.TEST;
                    break;
                }
                case 3: {
                    migrationIntent = MigrationIntent.UNKNOWN;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return migrationIntent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[MigrationTag.values().length];
                try {
                    nArray[MigrationTag.PROD.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MigrationTag.TEST.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MigrationTag.NOT_SPECIFIED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

