/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.plan.rest;

import com.atlassian.jira.migration.infrastructure.rest.ErrorResponse;
import com.atlassian.jira.migration.plan.DuplicatedPlanException;
import com.atlassian.jira.migration.plan.PlanNotFoundException;
import com.atlassian.jira.migration.plan.PlanRepositoryException;
import com.atlassian.jira.migration.plan.rest.FetchPlanListException;
import com.atlassian.jira.migration.plan.rest.UpdateNotAllowedException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/plan/rest/PlanRepositoryExceptionMapper;", "Ljavax/ws/rs/ext/ExceptionMapper;", "Lcom/atlassian/jira/migration/plan/PlanRepositoryException;", "()V", "toResponse", "Ljavax/ws/rs/core/Response;", "e", "Companion", "jira-migration-plugin"})
public final class PlanRepositoryExceptionMapper
implements ExceptionMapper<PlanRepositoryException> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(PlanRepositoryExceptionMapper.class);

    @NotNull
    public Response toResponse(@NotNull PlanRepositoryException e) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        log.error("Error occurred when working with plans", (Throwable)e);
        PlanRepositoryException planRepositoryException = e;
        if (planRepositoryException instanceof DuplicatedPlanException) {
            Response response3 = PlanRepositoryExceptionMapper.Companion.handleDuplicatedPlanException();
            response2 = response3;
            Intrinsics.checkNotNullExpressionValue((Object)response3, (String)"access$handleDuplicatedPlanException(...)");
        } else if (planRepositoryException instanceof UpdateNotAllowedException) {
            Response response4 = PlanRepositoryExceptionMapper.Companion.handleUpdateNotAllowedException();
            response2 = response4;
            Intrinsics.checkNotNullExpressionValue((Object)response4, (String)"access$handleUpdateNotAllowedException(...)");
        } else if (planRepositoryException instanceof PlanNotFoundException) {
            Response response5 = PlanRepositoryExceptionMapper.Companion.handlePlanNotFoundException();
            response2 = response5;
            Intrinsics.checkNotNullExpressionValue((Object)response5, (String)"access$handlePlanNotFoundException(...)");
        } else if (planRepositoryException instanceof FetchPlanListException) {
            Response response6 = PlanRepositoryExceptionMapper.Companion.handleFetchPlanListException();
            response2 = response6;
            Intrinsics.checkNotNullExpressionValue((Object)response6, (String)"access$handleFetchPlanListException(...)");
        } else {
            Response response7 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorResponse("PLAN_REPOSITORY_ERROR")).build();
            response2 = response7;
            Intrinsics.checkNotNullExpressionValue((Object)response7, (String)"build(...)");
        }
        return response2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007H\u0002J\u0010\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007H\u0002J\u0010\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007H\u0002J\u0010\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/plan/rest/PlanRepositoryExceptionMapper$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "handleDuplicatedPlanException", "Ljavax/ws/rs/core/Response;", "handleFetchPlanListException", "handlePlanNotFoundException", "handleUpdateNotAllowedException", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final Response handleDuplicatedPlanException() {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorResponse("PLAN_DUPLICATED_ERROR")).build();
        }

        private final Response handleUpdateNotAllowedException() {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorResponse("CANNOT_UPDATE_STARTED_MIGRATIONS_ERROR")).build();
        }

        private final Response handlePlanNotFoundException() {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorResponse("PLAN_NOT_FOUND_ERROR")).build();
        }

        private final Response handleFetchPlanListException() {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorResponse("PLAN_LIST_FETCH_ERROR")).build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

