/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.plan.rest;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.migration.GroupedThreadFactory;
import com.atlassian.jira.migration.advancedroadmaps.AdvancedRoadmapsProjectsService;
import com.atlassian.jira.migration.assessment.AppAssessmentService;
import com.atlassian.jira.migration.cloud.CloudSiteDto;
import com.atlassian.jira.migration.eventHandlers.PlanEventHandler;
import com.atlassian.jira.migration.execution.MigrationExecutionService;
import com.atlassian.jira.migration.execution.PlanExecutionService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.infrastructure.rest.ResponseUtils;
import com.atlassian.jira.migration.log.MigrationLogsService;
import com.atlassian.jira.migration.migration.MigrationRepository;
import com.atlassian.jira.migration.plan.AdvancedRoadmapsMigrationOption;
import com.atlassian.jira.migration.plan.AppsMigrationOption;
import com.atlassian.jira.migration.plan.AssetsDataMigrationMode;
import com.atlassian.jira.migration.plan.AssetsSchemaKey;
import com.atlassian.jira.migration.plan.AttachmentFilters;
import com.atlassian.jira.migration.plan.CrossProjectBoardsAndFiltersMigrationOption;
import com.atlassian.jira.migration.plan.DashboardsMigrationMode;
import com.atlassian.jira.migration.plan.IssueFilters;
import com.atlassian.jira.migration.plan.JiraDataMigrationOption;
import com.atlassian.jira.migration.plan.LiftAndShiftMode;
import com.atlassian.jira.migration.plan.MigrationTag;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.plan.PbpMigrationMode;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanActiveStatus;
import com.atlassian.jira.migration.plan.PlanEntity;
import com.atlassian.jira.migration.plan.PlanPhase;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.plan.PlanSource;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.plan.SinglePathMode;
import com.atlassian.jira.migration.plan.UsersGroupsMigrationOption;
import com.atlassian.jira.migration.plan.rest.CopyPlanResponse;
import com.atlassian.jira.migration.plan.rest.FetchPlanListException;
import com.atlassian.jira.migration.plan.rest.PlanConfig;
import com.atlassian.jira.migration.plan.rest.PlanDetails;
import com.atlassian.jira.migration.plan.rest.PlanMonitor;
import com.atlassian.jira.migration.plan.rest.PlanViewBuilder;
import com.atlassian.jira.migration.plan.rest.ProjectKeyList;
import com.atlassian.jira.migration.plan.rest.UpdateNotAllowedException;
import com.atlassian.jira.migration.preflight.PreflightService;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.progress.InfraStatus;
import com.atlassian.jira.migration.progress.MigrationStatus;
import com.atlassian.jira.migration.progress.PlanProgress;
import com.atlassian.jira.migration.serverdataextractors.ServerDataAggregator;
import com.atlassian.jira.migration.serverdataextractors.ServerProjectDto;
import com.atlassian.jira.migration.shadow.ShadowMigrationProtocol;
import com.atlassian.jira.migration.utils.CloudUtil;
import com.atlassian.jira.migration.validation.PlanValidation;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.function.Predicate;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(name="Plans REST API", description="These REST endpoints include all things Plan related. From the UI\n perspective, a Plan is an object graph that models the migration plan, the\n content stats, and the execution status of such a plan.")
@javax.ws.rs.Path(value="plan")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u0000 g2\u00020\u0001:\u0001gB\u0081\u0001\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 J\u0012\u0010%\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0007J>\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020(2\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u00020(2\u000e\b\u0002\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0002J\u001c\u00104\u001a\u00020&2\b\b\u0001\u00105\u001a\u00020(2\b\b\u0001\u00106\u001a\u000207H\u0007J\u001c\u00108\u001a\u00020&2\b\b\u0001\u00105\u001a\u00020(2\b\b\u0003\u00109\u001a\u00020/H\u0007J\u001c\u0010:\u001a\u00020&2\b\b\u0001\u00105\u001a\u00020(2\b\b\u0003\u00109\u001a\u00020/H\u0007J\u001a\u0010;\u001a\u00020,2\u0006\u0010<\u001a\u00020*2\b\b\u0002\u0010=\u001a\u00020>H\u0002J\u0012\u0010?\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0007J\u0010\u0010@\u001a\u00020A2\u0006\u0010<\u001a\u00020*H\u0002J\u0012\u0010B\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0007J\u0012\u0010C\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0007J.\u0010D\u001a\u00020,2\u0006\u00105\u001a\u00020(2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020(0F2\u0006\u0010G\u001a\u00020H2\u0006\u0010<\u001a\u00020*H\u0002J\u0012\u0010I\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0007J\u0010\u0010J\u001a\u00020H2\u0006\u0010<\u001a\u00020*H\u0002J\u001e\u0010K\u001a\b\u0012\u0004\u0012\u00020(0F2\u0006\u0010L\u001a\u00020,2\u0006\u0010M\u001a\u00020,H\u0002J\u0010\u0010N\u001a\u00020(2\u0006\u0010O\u001a\u00020(H\u0007J\b\u0010P\u001a\u00020&H\u0007J/\u0010Q\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(2\n\b\u0001\u0010R\u001a\u0004\u0018\u00010S2\n\b\u0001\u0010T\u001a\u0004\u0018\u00010SH\u0007\u00a2\u0006\u0002\u0010UJ/\u0010V\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(2\n\b\u0001\u0010R\u001a\u0004\u0018\u00010S2\n\b\u0001\u0010T\u001a\u0004\u0018\u00010SH\u0007\u00a2\u0006\u0002\u0010UJ\u0012\u0010W\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0007J\u0012\u0010X\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0007J\u0012\u0010Y\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0007J\u0010\u0010Z\u001a\u00020(2\u0006\u0010[\u001a\u00020(H\u0002J\u0012\u0010\\\u001a\u00020&2\b\b\u0001\u0010<\u001a\u00020*H\u0007J\u0012\u0010]\u001a\u00020&2\b\b\u0001\u0010<\u001a\u00020*H\u0007J\u0012\u0010^\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0007J\u0010\u0010_\u001a\u00020`2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010a\u001a\u00020`H\u0007J\u0010\u0010b\u001a\u00020\u00012\u0006\u0010+\u001a\u00020,H\u0002J\u0012\u0010b\u001a\u00020&2\b\b\u0001\u0010'\u001a\u00020(H\u0007J\u0012\u0010c\u001a\u00020&2\b\b\u0001\u00105\u001a\u00020(H\u0007J\u001c\u0010d\u001a\u00020&2\b\b\u0001\u00105\u001a\u00020(2\b\b\u0001\u0010<\u001a\u00020*H\u0007J\u0018\u0010e\u001a\u00020,2\u0006\u00105\u001a\u00020(2\u0006\u0010<\u001a\u00020*H\u0002J\u001e\u0010f\u001a\u00020>2\b\b\u0001\u0010-\u001a\u00020(2\n\b\u0003\u00105\u001a\u0004\u0018\u00010(H\u0007R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006h"}, d2={"Lcom/atlassian/jira/migration/plan/rest/PlanResource;", "", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "migrationRepository", "Lcom/atlassian/jira/migration/migration/MigrationRepository;", "planViewBuilder", "Lcom/atlassian/jira/migration/plan/rest/PlanViewBuilder;", "execution", "Lcom/atlassian/jira/migration/execution/PlanExecutionService;", "planValidation", "Lcom/atlassian/jira/migration/validation/PlanValidation;", "migrationLogsService", "Lcom/atlassian/jira/migration/log/MigrationLogsService;", "preflightService", "Lcom/atlassian/jira/migration/preflight/PreflightService;", "appAssessmentService", "Lcom/atlassian/jira/migration/assessment/AppAssessmentService;", "serverDataAggregator", "Lcom/atlassian/jira/migration/serverdataextractors/ServerDataAggregator;", "migrationExecutionService", "Lcom/atlassian/jira/migration/execution/MigrationExecutionService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "executor", "Ljava/util/concurrent/ExecutorService;", "planEventHandler", "Lcom/atlassian/jira/migration/eventHandlers/PlanEventHandler;", "advancedRoadmapsProjectsService", "Lcom/atlassian/jira/migration/advancedroadmaps/AdvancedRoadmapsProjectsService;", "cloudUtil", "Lcom/atlassian/jira/migration/utils/CloudUtil;", "(Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/migration/MigrationRepository;Lcom/atlassian/jira/migration/plan/rest/PlanViewBuilder;Lcom/atlassian/jira/migration/execution/PlanExecutionService;Lcom/atlassian/jira/migration/validation/PlanValidation;Lcom/atlassian/jira/migration/log/MigrationLogsService;Lcom/atlassian/jira/migration/preflight/PreflightService;Lcom/atlassian/jira/migration/assessment/AppAssessmentService;Lcom/atlassian/jira/migration/serverdataextractors/ServerDataAggregator;Lcom/atlassian/jira/migration/execution/MigrationExecutionService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Ljava/util/concurrent/ExecutorService;Lcom/atlassian/jira/migration/eventHandlers/PlanEventHandler;Lcom/atlassian/jira/migration/advancedroadmaps/AdvancedRoadmapsProjectsService;Lcom/atlassian/jira/migration/utils/CloudUtil;)V", "forkJoinPool", "Ljava/util/concurrent/ForkJoinPool;", "planResourceWorkerFactory", "Ljava/util/concurrent/ForkJoinPool$ForkJoinWorkerThreadFactory;", "archivePlan", "Ljavax/ws/rs/core/Response;", "id", "", "buildPlanConfig", "Lcom/atlassian/jira/migration/plan/rest/PlanConfig;", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "name", "creationTime", "", "preflightCheckExecutionId", "preflightChecksToOverride", "Ljava/util/EnumSet;", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "cancelProject", "planId", "projectKeyList", "Lcom/atlassian/jira/migration/plan/rest/ProjectKeyList;", "copyPlan", "copyCreatedTime", "copyPlanV2", "createPlanInRepository", "planConfig", "removeInvalidProjectKeys", "", "deletePlan", "getJiraDataMigrationOption", "Lcom/atlassian/jira/migration/plan/JiraDataMigrationOption;", "getLogs", "getPlanConfiguration", "getPlanFromConfig", "sortedProjectKeys", "", "dataMigrationMode", "Lcom/atlassian/jira/migration/plan/ProjectDataMigrationMode;", "getPlanWithContentStatsAndStatus", "getProjectDataMigrationMode", "getRemovedProjectKeys", "basePlan", "copiedPlan", "getUniquePlanName", "planName", "listPlans", "planDetails", "projectOffset", "", "projectLimit", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Ljavax/ws/rs/core/Response;", "planDetailsProgress", "planProgress", "planProjects", "restoreArchivedPlan", "sanitiseString", "stringToSanitise", "saveAndStartPlan", "savePlan", "scheduleFinalIncrement", "sendPlanSavedEventAsync", "", "shutdown", "startPlan", "updatePlanApps", "updatePlanConfiguration", "updatePlanInRepository", "validatePlanName", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPlanResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanResource.kt\ncom/atlassian/jira/migration/plan/rest/PlanResource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,972:1\n1#2:973\n1#2:992\n1#2:1005\n1#2:1025\n1549#3:974\n1620#3,3:975\n1549#3:978\n1620#3,3:979\n1603#3,9:982\n1855#3:991\n1856#3:993\n1612#3:994\n1603#3,9:995\n1855#3:1004\n1856#3:1006\n1612#3:1007\n1549#3:1008\n1620#3,3:1009\n766#3:1012\n857#3,2:1013\n1603#3,9:1015\n1855#3:1024\n1856#3:1026\n1612#3:1027\n*S KotlinDebug\n*F\n+ 1 PlanResource.kt\ncom/atlassian/jira/migration/plan/rest/PlanResource\n*L\n907#1:992\n911#1:1005\n582#1:1025\n830#1:974\n830#1:975,3\n878#1:978\n878#1:979,3\n907#1:982,9\n907#1:991\n907#1:993\n907#1:994\n911#1:995,9\n911#1:1004\n911#1:1006\n911#1:1007\n912#1:1008\n912#1:1009,3\n581#1:1012\n581#1:1013,2\n582#1:1015,9\n582#1:1024\n582#1:1026\n582#1:1027\n*E\n"})
public final class PlanResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final MigrationRepository migrationRepository;
    @NotNull
    private final PlanViewBuilder planViewBuilder;
    @NotNull
    private final PlanExecutionService execution;
    @NotNull
    private final PlanValidation planValidation;
    @NotNull
    private final MigrationLogsService migrationLogsService;
    @NotNull
    private final PreflightService preflightService;
    @NotNull
    private final AppAssessmentService appAssessmentService;
    @NotNull
    private final ServerDataAggregator serverDataAggregator;
    @NotNull
    private final MigrationExecutionService migrationExecutionService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final PlanEventHandler planEventHandler;
    @NotNull
    private final AdvancedRoadmapsProjectsService advancedRoadmapsProjectsService;
    @NotNull
    private final CloudUtil cloudUtil;
    @NotNull
    private final ForkJoinPool.ForkJoinWorkerThreadFactory planResourceWorkerFactory;
    @NotNull
    private final ForkJoinPool forkJoinPool;
    private static final Logger log = LoggerFactory.getLogger(PlanResource.class);
    @NotNull
    private static final String APPLICATION_ZIP = "application/zip";
    @NotNull
    public static final String COPIED_PLAN_PREFIX = "Copied - ";
    @NotNull
    private static final Regex COPIED_PLAN_SUFFIX = new Regex("_(\\d+$)");

    @Inject
    public PlanResource(@NotNull PlanRepository planRepository, @NotNull MigrationRepository migrationRepository, @NotNull PlanViewBuilder planViewBuilder, @NotNull PlanExecutionService execution, @NotNull PlanValidation planValidation, @NotNull MigrationLogsService migrationLogsService, @NotNull PreflightService preflightService, @NotNull AppAssessmentService appAssessmentService, @NotNull ServerDataAggregator serverDataAggregator, @NotNull MigrationExecutionService migrationExecutionService, @NotNull MigrationFeatures migrationFeatures, @NotNull ExecutorService executor, @NotNull PlanEventHandler planEventHandler, @NotNull AdvancedRoadmapsProjectsService advancedRoadmapsProjectsService, @NotNull CloudUtil cloudUtil) {
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)migrationRepository, (String)"migrationRepository");
        Intrinsics.checkNotNullParameter((Object)planViewBuilder, (String)"planViewBuilder");
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        Intrinsics.checkNotNullParameter((Object)planValidation, (String)"planValidation");
        Intrinsics.checkNotNullParameter((Object)migrationLogsService, (String)"migrationLogsService");
        Intrinsics.checkNotNullParameter((Object)preflightService, (String)"preflightService");
        Intrinsics.checkNotNullParameter((Object)appAssessmentService, (String)"appAssessmentService");
        Intrinsics.checkNotNullParameter((Object)serverDataAggregator, (String)"serverDataAggregator");
        Intrinsics.checkNotNullParameter((Object)migrationExecutionService, (String)"migrationExecutionService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)planEventHandler, (String)"planEventHandler");
        Intrinsics.checkNotNullParameter((Object)advancedRoadmapsProjectsService, (String)"advancedRoadmapsProjectsService");
        Intrinsics.checkNotNullParameter((Object)cloudUtil, (String)"cloudUtil");
        this.planRepository = planRepository;
        this.migrationRepository = migrationRepository;
        this.planViewBuilder = planViewBuilder;
        this.execution = execution;
        this.planValidation = planValidation;
        this.migrationLogsService = migrationLogsService;
        this.preflightService = preflightService;
        this.appAssessmentService = appAssessmentService;
        this.serverDataAggregator = serverDataAggregator;
        this.migrationExecutionService = migrationExecutionService;
        this.migrationFeatures = migrationFeatures;
        this.executor = executor;
        this.planEventHandler = planEventHandler;
        this.advancedRoadmapsProjectsService = advancedRoadmapsProjectsService;
        this.cloudUtil = cloudUtil;
        this.planResourceWorkerFactory = PlanResource::planResourceWorkerFactory$lambda$1;
        this.forkJoinPool = new ForkJoinPool(10, this.planResourceWorkerFactory, null, false);
    }

    public /* synthetic */ PlanResource(PlanRepository planRepository, MigrationRepository migrationRepository, PlanViewBuilder planViewBuilder, PlanExecutionService planExecutionService, PlanValidation planValidation, MigrationLogsService migrationLogsService, PreflightService preflightService, AppAssessmentService appAssessmentService, ServerDataAggregator serverDataAggregator, MigrationExecutionService migrationExecutionService, MigrationFeatures migrationFeatures, ExecutorService executorService, PlanEventHandler planEventHandler, AdvancedRoadmapsProjectsService advancedRoadmapsProjectsService, CloudUtil cloudUtil, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x800) != 0) {
            ExecutorService executorService2 = Executors.newFixedThreadPool(1, new GroupedThreadFactory("PlanResource"));
            Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"newFixedThreadPool(...)");
            executorService = executorService2;
        }
        this(planRepository, migrationRepository, planViewBuilder, planExecutionService, planValidation, migrationLogsService, preflightService, appAssessmentService, serverDataAggregator, migrationExecutionService, migrationFeatures, executorService, planEventHandler, advancedRoadmapsProjectsService, cloudUtil);
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @javax.ws.rs.Path(value="/{id}")
    @Operation(description="Retrieve a plan", responses={@ApiResponse(description="Plan retrieved", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanMonitor.class))}), @ApiResponse(description="No such plan", responseCode="404")})
    @Produces(value={"application/json"})
    @NotNull
    public final Response getPlanWithContentStatsAndStatus(@PathParam(value="id") @Parameter(name="id", description="Plan ID") @NotNull String id) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ResponseUtils responseUtils = ResponseUtils.INSTANCE;
        Plan plan2 = this.planRepository.get(id);
        if (plan2 != null) {
            void it;
            Plan plan3 = plan2;
            ResponseUtils responseUtils2 = responseUtils;
            boolean bl = false;
            object = it.isIncremental() ? PlanViewBuilder.incrementalPlanMonitor$default(this.planViewBuilder, (Plan)it, false, 2, null) : (it.isLiftAndShift() ? PlanViewBuilder.liftAndShiftPlanMonitor$default(this.planViewBuilder, (Plan)it, false, 2, null) : PlanViewBuilder.classicPlanMonitor$default(this.planViewBuilder, (Plan)it, false, 2, null));
            responseUtils = responseUtils2;
        } else {
            object = null;
        }
        return responseUtils.okOrNotFound(object);
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @javax.ws.rs.Path(value="/details/{id}")
    @Operation(description="Retrieve plan details", responses={@ApiResponse(description="Details retrieved", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanDetails.class))}), @ApiResponse(description="No such plan", responseCode="404")})
    @Produces(value={"application/json"})
    @NotNull
    public final Response planDetails(@PathParam(value="id") @Parameter(name="id", description="Plan ID") @NotNull String id, @QueryParam(value="projectOffset") @Parameter(name="projectOffset", description="Start of project list") @Nullable Integer projectOffset, @QueryParam(value="projectLimit") @Parameter(name="projectLimit", description="Number of projects") @Nullable Integer projectLimit) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ResponseUtils responseUtils = ResponseUtils.INSTANCE;
        Plan plan2 = this.planRepository.get(id);
        if (plan2 != null) {
            void it;
            Plan plan3 = plan2;
            ResponseUtils responseUtils2 = responseUtils;
            boolean bl = false;
            object = it.isIncremental() ? this.planViewBuilder.incrementalPlanDetails((Plan)it, projectOffset, projectLimit) : this.planViewBuilder.classicPlanDetails((Plan)it, projectOffset, projectLimit);
            responseUtils = responseUtils2;
        } else {
            object = null;
        }
        return responseUtils.okOrNotFound(object);
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @javax.ws.rs.Path(value="/progress/{id}")
    @Operation(description="Retrieve plan progress", responses={@ApiResponse(description="Progress retrieved", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=MigrationStatus.class))}), @ApiResponse(description="No such plan", responseCode="404")})
    @NotNull
    public final Response planProgress(@PathParam(value="id") @Parameter(name="id", description="Plan ID") @NotNull String id) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ResponseUtils responseUtils = ResponseUtils.INSTANCE;
        Plan plan2 = this.planRepository.get(id);
        if (plan2 != null) {
            void it;
            Plan plan3 = plan2;
            ResponseUtils responseUtils2 = responseUtils;
            boolean bl = false;
            object = it.isIncremental() ? this.execution.getIncrementalMigrationStatus((Plan)it) : (it.isLiftAndShift() ? this.execution.getLiftAndShiftMigrationStatus((Plan)it) : this.execution.getClassicMigrationStatus((Plan)it));
            responseUtils = responseUtils2;
        } else {
            object = null;
        }
        return responseUtils.okOrNotFound(object);
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @javax.ws.rs.Path(value="/progress/{id}/details")
    @Operation(description="Retrieve plan details progress", responses={@ApiResponse(description="Details retrieved", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanProgress.class))}), @ApiResponse(description="No such plan", responseCode="404")})
    @NotNull
    public final Response planDetailsProgress(@PathParam(value="id") @Parameter(name="id", description="Plan ID") @NotNull String id, @QueryParam(value="projectOffset") @Parameter(name="projectOffset", description="Start of project list") @Nullable Integer projectOffset, @QueryParam(value="projectLimit") @Parameter(name="projectLimit", description="Number of projects") @Nullable Integer projectLimit) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ResponseUtils responseUtils = ResponseUtils.INSTANCE;
        Plan plan2 = this.planRepository.get(id);
        if (plan2 != null) {
            void it;
            Plan plan3 = plan2;
            ResponseUtils responseUtils2 = responseUtils;
            boolean bl = false;
            object = it.isIncremental() ? this.execution.incrementalPlanDetailsProgress((Plan)it, projectOffset, projectLimit) : (it.isLiftAndShift() ? this.execution.liftAndShiftPlanDetailsProgress((Plan)it) : this.execution.classicPlanDetailsProgress((Plan)it, projectOffset, projectLimit));
            responseUtils = responseUtils2;
        } else {
            object = null;
        }
        return responseUtils.okOrNotFound(object);
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @javax.ws.rs.Path(value="/{id}/projects")
    @Operation(description="Retrieve plan projects", responses={@ApiResponse(description="Projects retrieved", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=ServerProjectDto.class))}), @ApiResponse(description="No such plan", responseCode="404")})
    @NotNull
    public final Response planProjects(@PathParam(value="id") @Parameter(name="id", description="Plan ID") @NotNull String id) {
        List<ServerProjectDto> list;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ResponseUtils responseUtils = ResponseUtils.INSTANCE;
        Plan plan2 = this.planRepository.get(id);
        if (plan2 != null) {
            void it;
            Plan plan3 = plan2;
            ResponseUtils responseUtils2 = responseUtils;
            boolean bl = false;
            list = this.serverDataAggregator.getProjects(it.getProjectKeys());
            responseUtils = responseUtils2;
        } else {
            list = null;
        }
        return responseUtils.okOrNotFound(list);
    }

    @GET
    @javax.ws.rs.Path(value="/validate")
    @Operation(description="Validate a plan")
    public final boolean validatePlanName(@QueryParam(value="name") @Parameter(name="name", description="Plan Name") @NotNull String name, @QueryParam(value="planId") @Parameter(name="planId", description="Plan ID") @Nullable String planId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = ((Object)StringsKt.trim((CharSequence)name)).toString();
        String string2 = planId;
        if (string2 == null) {
            string2 = "";
        }
        return this.planRepository.getByName(string, string2) == null;
    }

    public static /* synthetic */ boolean validatePlanName$default(PlanResource planResource, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return planResource.validatePlanName(string, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @javax.ws.rs.Path(value="/{id}/start")
    @Operation(description="Start a plan", responses={@ApiResponse(description="Started", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanMonitor.class))}), @ApiResponse(description="No such plan", responseCode="404")})
    @NotNull
    public final Response startPlan(@PathParam(value="id") @Parameter(name="id", description="Plan ID") @NotNull String id) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Plan plan2 = this.planRepository.get(id);
        if (plan2 != null) {
            Response response3;
            Plan it = plan2;
            boolean bl = false;
            try {
                response3 = ResponseUtils.INSTANCE.accepted(this.startPlan(it));
            }
            catch (IllegalArgumentException e) {
                response3 = ResponseUtils.INSTANCE.badRequest("Failed to start the plan: " + e.getMessage());
            }
            Response response4 = response3;
            if (response4 != null) {
                response2 = response4;
                return response2;
            }
        }
        response2 = ResponseUtils.INSTANCE.notFound();
        return response2;
    }

    @DELETE
    @javax.ws.rs.Path(value="/{id}")
    @Operation(description="Delete a plan", responses={@ApiResponse(description="Deleted", responseCode="200"), @ApiResponse(description="No such plan", responseCode="404")})
    @NotNull
    public final Response deletePlan(@PathParam(value="id") @Parameter(name="id", description="Plan ID") @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        PlanEntity planEntity = this.planRepository.delete(id);
        return ResponseUtils.INSTANCE.okOrNotFound(planEntity != null ? planEntity.getPlanName() : null);
    }

    @PUT
    @javax.ws.rs.Path(value="/{id}/archive")
    @Operation(description="Archive a plan")
    @NotNull
    public final Response archivePlan(@PathParam(value="id") @Parameter(name="id", description="Plan ID") @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        PlanResource $this$archivePlan_u24lambda_u248 = this;
        boolean bl = false;
        $this$archivePlan_u24lambda_u248.planRepository.archive(id);
        return ResponseUtils.INSTANCE.ok("SUCCESS");
    }

    @PUT
    @javax.ws.rs.Path(value="/{id}/restore")
    @Operation(description="Restore a plan")
    @NotNull
    public final Response restoreArchivedPlan(@PathParam(value="id") @Parameter(name="id", description="Plan ID") @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        PlanResource $this$restoreArchivedPlan_u24lambda_u249 = this;
        boolean bl = false;
        $this$restoreArchivedPlan_u24lambda_u249.planRepository.restoreArchive(id);
        return ResponseUtils.INSTANCE.ok("SUCCESS");
    }

    /*
     * Enabled aggressive block sorting
     */
    @POST
    @javax.ws.rs.Path(value="/{id}/cutover")
    @Operation(description="Cutover an incremental plan", responses={@ApiResponse(description="Retrieved", responseCode="200"), @ApiResponse(description="No such plan", responseCode="404")})
    @NotNull
    public final Response scheduleFinalIncrement(@PathParam(value="id") @Parameter(name="id", description="Plan ID") @NotNull String id) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Plan plan2 = this.planRepository.get(this.sanitiseString(id));
        if (plan2 != null) {
            Plan it = plan2;
            boolean bl = false;
            this.execution.scheduleIncrementalPlanExecution(it, true);
            Response response3 = ResponseUtils.INSTANCE.accepted(PlanViewBuilder.incrementalPlanMonitor$default(this.planViewBuilder, it, false, 2, null));
            if (response3 != null) {
                response2 = response3;
                return response2;
            }
        }
        response2 = ResponseUtils.INSTANCE.notFound();
        return response2;
    }

    @POST
    @javax.ws.rs.Path(value="/save")
    @Operation(description="Save a plan", responses={@ApiResponse(description="Saved", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanMonitor.class))}), @ApiResponse(description="Invalid data provided", responseCode="400")})
    @NotNull
    public final Response savePlan(@Parameter(name="planConfig", description="Plan Configuration") @NotNull PlanConfig planConfig) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)planConfig, (String)"planConfig");
        try {
            Plan created = PlanResource.createPlanInRepository$default(this, planConfig, false, 2, null);
            response2 = ResponseUtils.INSTANCE.ok(created.isIncremental() ? PlanViewBuilder.incrementalPlanMonitor$default(this.planViewBuilder, created, false, 2, null) : PlanViewBuilder.classicPlanMonitor$default(this.planViewBuilder, created, false, 2, null));
        }
        catch (Exception e) {
            response2 = ResponseUtils.INSTANCE.badRequest("Failed to save the plan: " + e.getMessage());
        }
        return response2;
    }

    @POST
    @javax.ws.rs.Path(value="/save-and-start")
    @Operation(description="Save and start a plan", responses={@ApiResponse(description="Saved", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanMonitor.class))}), @ApiResponse(description="Invalid data provided", responseCode="400")})
    @Consumes(value={"application/json"})
    @NotNull
    public final Response saveAndStartPlan(@Parameter(name="planConfig", description="Plan Configuration") @NotNull PlanConfig planConfig) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)planConfig, (String)"planConfig");
        try {
            Plan created = PlanResource.createPlanInRepository$default(this, planConfig, false, 2, null);
            Object response3 = this.startPlan(created);
            response2 = ResponseUtils.INSTANCE.accepted(response3);
        }
        catch (Exception e) {
            response2 = ResponseUtils.INSTANCE.badRequest("Failed to save the plan: " + e.getMessage());
        }
        return response2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @POST
    @javax.ws.rs.Path(value="/{planId}/copy")
    @Operation(description="Copy a plan", responses={@ApiResponse(description="Copied", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanMonitor.class))}), @ApiResponse(description="No such plan", responseCode="404")})
    @Produces(value={"application/json"})
    @Deprecated(message="Use v2 copy endpoint instead")
    @NotNull
    public final Response copyPlan(@PathParam(value="planId") @Parameter(name="planId", description="Plan ID") @NotNull String planId, @QueryParam(value="copyCreatedTime") @Parameter(name="copyCreatedTime", description="Time at which plan's copy was created'") long copyCreatedTime) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Plan plan2 = this.planRepository.get(planId);
        if (plan2 != null) {
            Plan it = plan2;
            boolean bl = false;
            String string = this.getUniquePlanName(it.getPlanName());
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            PlanConfig planConfig = this.buildPlanConfig(it, string, copyCreatedTime, string2, CheckType.Companion.getEmptyCheckTypeSet());
            Response response3 = this.savePlan(planConfig);
            if (response3 != null) {
                response2 = response3;
                return response2;
            }
        }
        response2 = ResponseUtils.INSTANCE.notFound();
        return response2;
    }

    public static /* synthetic */ Response copyPlan$default(PlanResource planResource, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = System.currentTimeMillis();
        }
        return planResource.copyPlan(string, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    @POST
    @javax.ws.rs.Path(value="v2/{planId}/copy")
    @Operation(description="Copy a plan whilst removing invalid project keys from original plan if any.", responses={@ApiResponse(description="Copied", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=CopyPlanResponse.class))}), @ApiResponse(description="No such plan", responseCode="404")})
    @Produces(value={"application/json"})
    @NotNull
    public final Response copyPlanV2(@PathParam(value="planId") @Parameter(name="planId", description="Plan ID") @NotNull String planId, @QueryParam(value="copyCreatedTime") @Parameter(name="copyCreatedTime", description="Time at which plan's copy was created'") long copyCreatedTime) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Plan plan2 = this.planRepository.get(planId);
        if (plan2 != null) {
            Plan it = plan2;
            boolean bl = false;
            String string = this.getUniquePlanName(it.getPlanName());
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            PlanConfig planConfig = this.buildPlanConfig(it, string, copyCreatedTime, string2, CheckType.Companion.getEmptyCheckTypeSet());
            Plan copiedPlan = this.createPlanInRepository(planConfig, true);
            Response response3 = ResponseUtils.INSTANCE.ok(new CopyPlanResponse(copiedPlan.getId(), this.getRemovedProjectKeys(it, copiedPlan)));
            if (response3 != null) {
                response2 = response3;
                return response2;
            }
        }
        response2 = ResponseUtils.INSTANCE.notFound();
        return response2;
    }

    public static /* synthetic */ Response copyPlanV2$default(PlanResource planResource, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = System.currentTimeMillis();
        }
        return planResource.copyPlanV2(string, l);
    }

    @GET
    @javax.ws.rs.Path(value="/")
    @Operation(description="List all plans", responses={@ApiResponse(description="Retrieved", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanMonitor.class))})})
    @Produces(value={"application/json"})
    @NotNull
    public final Response listPlans() {
        Predicate<Plan> classicPlansOnly = PlanResource::listPlans$lambda$13;
        Predicate<Plan> nonShadowPlansOnly = PlanResource::listPlans$lambda$14;
        Predicate<Plan> allPlans = PlanResource::listPlans$lambda$15;
        Predicate<Plan> planFilter = !this.migrationFeatures.getEnableIncrementalMigrations() ? classicPlansOnly : allPlans;
        try {
            return ResponseUtils.INSTANCE.ok(((ForkJoinTask)this.forkJoinPool.submit(() -> PlanResource.listPlans$lambda$21(this, planFilter, nonShadowPlansOnly))).get());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new FetchPlanListException("Interrupted when trying to fetch plan list", e);
        }
        catch (ExecutionException e) {
            throw new FetchPlanListException("Error occurred when trying to fetch plan list", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @javax.ws.rs.Path(value="/config/{id}")
    @Operation(description="Retrieve a plan configuration", responses={@ApiResponse(description="Config retrieved", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanConfig.class))}), @ApiResponse(description="No such plan", responseCode="404")})
    @Produces(value={"application/json"})
    @NotNull
    public final Response getPlanConfiguration(@PathParam(value="id") @Parameter(name="id", description="Plan ID") @NotNull String id) {
        PlanConfig planConfig;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ResponseUtils responseUtils = ResponseUtils.INSTANCE;
        Plan plan2 = this.planRepository.get(id);
        if (plan2 != null) {
            void p0;
            Plan plan3 = plan2;
            ResponseUtils responseUtils2 = responseUtils;
            boolean bl = false;
            planConfig = PlanResource.buildPlanConfig$default(this, (Plan)p0, null, 0L, null, null, 30, null);
            responseUtils = responseUtils2;
        } else {
            planConfig = null;
        }
        return responseUtils.okOrNotFound(planConfig);
    }

    @PUT
    @javax.ws.rs.Path(value="/config/{id}")
    @Operation(description="Update a plan configuration", responses={@ApiResponse(description="Config updated", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=PlanConfig.class))}), @ApiResponse(description="No such plan", responseCode="404")})
    @Produces(value={"application/json"})
    @NotNull
    public final Response updatePlanConfiguration(@PathParam(value="id") @Parameter(name="id", description="Plan ID") @NotNull String planId, @Parameter(name="planConfig", description="Plan Configuration") @NotNull PlanConfig planConfig) {
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)planConfig, (String)"planConfig");
        Plan updated = this.updatePlanInRepository(planId, planConfig);
        return ResponseUtils.INSTANCE.ok(PlanResource.buildPlanConfig$default(this, updated, null, 0L, null, null, 30, null));
    }

    @PUT
    @javax.ws.rs.Path(value="/{id}/apps")
    @Operation(description="Update a plan's apps from app assessment", responses={@ApiResponse(description="Plan apps updated", responseCode="200"), @ApiResponse(description="No such plan", responseCode="404")})
    @Produces(value={"application/json"})
    @NotNull
    public final Response updatePlanApps(@PathParam(value="id") @Parameter(name="id", description="Plan ID") @NotNull String planId) {
        Plan plan2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
                plan2 = this.planRepository.get(planId);
                if (plan2 == null) break block2;
                Plan it = plan2;
                boolean bl = false;
                AppsMigrationOption updatedOption = AppAssessmentService.getUpdatedAppsMigrationOption$default(this.appAssessmentService, it.getAppsMigrationOption(), it.getProjectDataMigrationMode(), null, 4, null);
                it.setAppsMigrationOption(updatedOption);
                Plan updated = this.planRepository.update(it);
                Response response2 = ResponseUtils.INSTANCE.ok(PlanResource.buildPlanConfig$default(this, updated, null, 0L, null, null, 30, null));
                plan2 = response2;
                if (response2 != null) break block3;
            }
            plan2 = ResponseUtils.INSTANCE.notFound();
        }
        return plan2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @javax.ws.rs.Path(value="/{id}/cancel-project")
    @Operation(description="Cancel a plan", responses={@ApiResponse(description="Plan cancelled", responseCode="200"), @ApiResponse(description="No such plan", responseCode="404")})
    @NotNull
    public final Response cancelProject(@PathParam(value="id") @Parameter(name="id", description="Plan ID") @NotNull String planId, @Parameter(name="ProjectKeyList", description="List of projects") @NotNull ProjectKeyList projectKeyList) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)planId, (String)"planId");
        Intrinsics.checkNotNullParameter((Object)projectKeyList, (String)"projectKeyList");
        Plan plan2 = this.planRepository.get(planId);
        if (plan2 != null) {
            Response response3;
            Response response4;
            Plan it = plan2;
            boolean bl = false;
            try {
                this.migrationExecutionService.cancelProjectIncrement(planId, projectKeyList.getProjectKeys(), it);
                response4 = ResponseUtils.INSTANCE.accepted(PlanViewBuilder.incrementalPlanMonitor$default(this.planViewBuilder, it, false, 2, null));
            }
            catch (IllegalArgumentException exception) {
                String string = exception.getMessage();
                if (string == null) {
                    string = "";
                }
                response4 = ResponseUtils.INSTANCE.badRequest(string);
            }
            if ((response3 = response4) != null) {
                response2 = response3;
                return response2;
            }
        }
        response2 = ResponseUtils.INSTANCE.notFound();
        return response2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @GET
    @Produces(value={"application/zip"})
    @javax.ws.rs.Path(value="/{id}/logs")
    @Operation(description="Retrieve logs for a plan", responses={@ApiResponse(description="Logs retrieved", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=File.class))}), @ApiResponse(description="No such plan", responseCode="404")})
    @NotNull
    public final Response getLogs(@PathParam(value="id") @Parameter(name="id", description="Plan ID") @NotNull String id) {
        Response response2;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Path path = this.migrationLogsService.getLogsForPlan(this.sanitiseString(id));
        if (path != null) {
            Path it = path;
            boolean bl = false;
            Plan plan2 = this.planRepository.get(id);
            Intrinsics.checkNotNull((Object)plan2);
            String string = plan2.getPlanName();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            CharSequence charSequence = StringsKt.replace$default((String)string2, (char)'-', (char)' ', (boolean)false, (int)4, null);
            Object object = new Regex("[^\\w\\s]");
            String string3 = "";
            CharSequence charSequence2 = ((Object)StringsKt.trim((CharSequence)object.replace(charSequence, string3))).toString();
            object = new Regex("\\s+");
            string3 = "-";
            String planName = object.replace(charSequence2, string3);
            String string4 = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm"));
            object = ResponseUtils.INSTANCE;
            string3 = string4 + '-' + planName + "-logs.zip";
            Response response3 = ((ResponseUtils)object).ok(it, string3, APPLICATION_ZIP);
            if (response3 != null) {
                response2 = response3;
                return response2;
            }
        }
        response2 = ResponseUtils.INSTANCE.notFound();
        return response2;
    }

    private final Plan createPlanInRepository(PlanConfig planConfig, boolean removeInvalidProjectKeys) {
        PlanValidation.ProjectKeysValidationResult result2 = this.planValidation.validateProjectKeys(planConfig.getProjectKeys(), removeInvalidProjectKeys);
        this.planValidation.validateAssetsSchemaKeys(planConfig.getAssetsSchemaKeys());
        List projectKeys = CollectionsKt.toList((Iterable)CollectionsKt.subtract((Iterable)planConfig.getProjectKeys(), (Iterable)result2.getInvalidProjectKeys()));
        List<String> sortedProjectKeys = this.planValidation.sortProjectsByIssueCount(projectKeys);
        ProjectDataMigrationMode dataMigrationMode = this.getProjectDataMigrationMode(planConfig);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Plan plan2 = this.getPlanFromConfig(string, sortedProjectKeys, dataMigrationMode, planConfig);
        this.preflightService.persistPreflightInPlan(plan2.getId(), plan2.getPreflightCheckExecutionId());
        this.sendPlanSavedEventAsync(plan2);
        return this.planRepository.create(plan2);
    }

    static /* synthetic */ Plan createPlanInRepository$default(PlanResource planResource, PlanConfig planConfig, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return planResource.createPlanInRepository(planConfig, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ProjectDataMigrationMode getProjectDataMigrationMode(PlanConfig planConfig) {
        ProjectDataMigrationMode projectDataMigrationMode;
        if (!this.migrationFeatures.getDisableSinglePathMigration() && planConfig.getSinglePathMode() == SinglePathMode.LIFT_AND_SHIFT) {
            projectDataMigrationMode = ProjectDataMigrationMode.LIFT_AND_SHIFT;
            return projectDataMigrationMode;
        }
        if (this.migrationFeatures.getAppDataPreloadEnabledGA()) {
            AppsMigrationOption appsMigrationOption = planConfig.getAppsMigrationOption();
            boolean bl = appsMigrationOption != null ? appsMigrationOption.getPreload() : false;
            if (bl) {
                projectDataMigrationMode = ProjectDataMigrationMode.APP_DATA_PRELOAD;
                return projectDataMigrationMode;
            }
        }
        projectDataMigrationMode = planConfig.getProjectDataMigrationMode();
        return projectDataMigrationMode;
    }

    private final Plan updatePlanInRepository(String planId, PlanConfig planConfig) {
        if (this.migrationRepository.findLatestByPlanId(planId) != null) {
            log.error("Update migration plan failed. Cannot update migration plan " + planId + ", as this plan is already started.");
            throw new UpdateNotAllowedException();
        }
        PlanValidation.validateProjectKeys$default(this.planValidation, planConfig.getProjectKeys(), false, 2, null);
        this.planValidation.validateAssetsSchemaKeys(planConfig.getAssetsSchemaKeys());
        List<String> sortedProjectKeys = this.planValidation.sortProjectsByIssueCount(planConfig.getProjectKeys());
        ProjectDataMigrationMode dataMigrationMode = this.getProjectDataMigrationMode(planConfig);
        Plan plan2 = this.getPlanFromConfig(planId, sortedProjectKeys, dataMigrationMode, planConfig);
        this.sendPlanSavedEventAsync(plan2);
        return this.planRepository.update(plan2);
    }

    /*
     * WARNING - void declaration
     */
    private final Plan getPlanFromConfig(String planId, List<String> sortedProjectKeys, ProjectDataMigrationMode dataMigrationMode, PlanConfig planConfig) {
        Collection<AssetsSchemaKey> collection;
        MigrationTag migrationTag;
        PlanConfig $this$getPlanFromConfig_u24lambda_u2426 = planConfig;
        boolean bl = false;
        String string = planId;
        String string2 = ((Object)StringsKt.trim((CharSequence)$this$getPlanFromConfig_u24lambda_u2426.getName())).toString();
        String string3 = $this$getPlanFromConfig_u24lambda_u2426.getCloudSite().getCloudId();
        String string4 = $this$getPlanFromConfig_u24lambda_u2426.getCloudSite().getCloudUrl();
        List<String> list = sortedProjectKeys;
        AdvancedRoadmapsMigrationOption advancedRoadmapsMigrationOption = $this$getPlanFromConfig_u24lambda_u2426.getAdvancedRoadmapsMigrationOption();
        List<Long> list2 = this.advancedRoadmapsProjectsService.getPlanIds(sortedProjectKeys, advancedRoadmapsMigrationOption != null ? advancedRoadmapsMigrationOption.getAdvancedRoadmapsMigrationMode() : null, $this$getPlanFromConfig_u24lambda_u2426.getPlanIds());
        UsersGroupsMigrationOption usersGroupsMigrationOption = $this$getPlanFromConfig_u24lambda_u2426.getUsersGroupsMigrationOption();
        AppsMigrationOption appsMigrationOption = AppAssessmentService.getUpdatedAppsMigrationOption$default(this.appAssessmentService, $this$getPlanFromConfig_u24lambda_u2426.getAppsMigrationOption(), planConfig.getProjectDataMigrationMode(), null, 4, null);
        ProjectDataMigrationMode projectDataMigrationMode = dataMigrationMode;
        Boolean bl2 = planConfig.getForceRelinking();
        MigrationType migrationType = $this$getPlanFromConfig_u24lambda_u2426.getMigrationType();
        String string5 = $this$getPlanFromConfig_u24lambda_u2426.getPreflightCheckExecutionId();
        EnumSet<CheckType> enumSet = $this$getPlanFromConfig_u24lambda_u2426.getPreflightChecksToOverride();
        if (enumSet == null) {
            enumSet = this.preflightService.getOverriddenChecks(planConfig.getPreflightCheckExecutionId());
        }
        Boolean bl3 = $this$getPlanFromConfig_u24lambda_u2426.isCustomFieldsDeleted();
        PlanActiveStatus planActiveStatus = PlanActiveStatus.ACTIVE;
        long l = planConfig.getCreatedTimestamp();
        SinglePathMode singlePathMode = planConfig.getSinglePathMode();
        if (singlePathMode == null) {
            singlePathMode = SinglePathMode.PROJECT_BY_PROJECT;
        }
        if ((migrationTag = planConfig.getMigrationTag()) == null) {
            migrationTag = MigrationTag.NOT_SPECIFIED;
        }
        String string6 = planConfig.getManualImportFile();
        LiftAndShiftMode liftAndShiftMode = planConfig.getLiftAndShiftMode();
        if (liftAndShiftMode == null) {
            liftAndShiftMode = LiftAndShiftMode.AUTOMATIC;
        }
        JiraDataMigrationOption jiraDataMigrationOption = this.getJiraDataMigrationOption(planConfig);
        CrossProjectBoardsAndFiltersMigrationOption crossProjectBoardsAndFiltersMigrationOption = planConfig.getCrossProjectBoardsAndFiltersMigrationOption();
        DashboardsMigrationMode dashboardsMigrationMode = planConfig.getDashboardsMigrationMode();
        List<String> list3 = planConfig.getAssetsSchemaKeys();
        if (list3 != null) {
            Collection<AssetsSchemaKey> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list3;
            DashboardsMigrationMode dashboardsMigrationMode2 = dashboardsMigrationMode;
            CrossProjectBoardsAndFiltersMigrationOption crossProjectBoardsAndFiltersMigrationOption2 = crossProjectBoardsAndFiltersMigrationOption;
            JiraDataMigrationOption jiraDataMigrationOption2 = jiraDataMigrationOption;
            LiftAndShiftMode liftAndShiftMode2 = liftAndShiftMode;
            String string7 = string6;
            MigrationTag migrationTag2 = migrationTag;
            SinglePathMode singlePathMode2 = singlePathMode;
            long l2 = l;
            PlanActiveStatus planActiveStatus2 = planActiveStatus;
            Boolean bl4 = bl3;
            EnumSet<CheckType> enumSet2 = enumSet;
            String string8 = string5;
            MigrationType migrationType2 = migrationType;
            Boolean bl5 = bl2;
            ProjectDataMigrationMode projectDataMigrationMode2 = projectDataMigrationMode;
            AppsMigrationOption appsMigrationOption2 = appsMigrationOption;
            UsersGroupsMigrationOption usersGroupsMigrationOption2 = usersGroupsMigrationOption;
            List<Long> list4 = list2;
            List<String> list5 = list;
            String string9 = string4;
            String string10 = string3;
            String string11 = string2;
            String string12 = string;
            boolean $i$f$map = false;
            void var33_32 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string13 = (String)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl6 = false;
                collection2.add(new AssetsSchemaKey((String)it, null, 2, null));
            }
            collection2 = (List)destination$iv$iv;
            string = string12;
            string2 = string11;
            string3 = string10;
            string4 = string9;
            list = list5;
            list2 = list4;
            usersGroupsMigrationOption = usersGroupsMigrationOption2;
            appsMigrationOption = appsMigrationOption2;
            projectDataMigrationMode = projectDataMigrationMode2;
            bl2 = bl5;
            migrationType = migrationType2;
            string5 = string8;
            enumSet = enumSet2;
            bl3 = bl4;
            planActiveStatus = planActiveStatus2;
            l = l2;
            singlePathMode = singlePathMode2;
            migrationTag = migrationTag2;
            string6 = string7;
            liftAndShiftMode = liftAndShiftMode2;
            jiraDataMigrationOption = jiraDataMigrationOption2;
            crossProjectBoardsAndFiltersMigrationOption = crossProjectBoardsAndFiltersMigrationOption2;
            dashboardsMigrationMode = dashboardsMigrationMode2;
            collection = collection2;
        } else {
            collection = null;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 33;
        int n2 = -234881024;
        AttachmentFilters attachmentFilters = planConfig.getAttachmentFilters();
        IssueFilters issueFilters = planConfig.getIssueFilters();
        InfraStatus infraStatus = null;
        AdvancedRoadmapsMigrationOption advancedRoadmapsMigrationOption2 = planConfig.getAdvancedRoadmapsMigrationOption();
        List<String> list6 = planConfig.getExcludedProjectKeys();
        PbpMigrationMode pbpMigrationMode = planConfig.getPbpMigrationMode();
        String string14 = this.cloudUtil.getCloudSiteRegion($this$getPlanFromConfig_u24lambda_u2426.getCloudSite().getCloudId());
        ShadowMigrationProtocol shadowMigrationProtocol = null;
        Set set = null;
        Boolean bl7 = null;
        String string15 = null;
        Boolean bl8 = null;
        Boolean bl9 = planConfig.getMigrateArchivedIssues();
        Boolean bl10 = planConfig.getUserPreMigration();
        PlanSource planSource = null;
        AssetsDataMigrationMode assetsDataMigrationMode = planConfig.getAssetsDataMigrationMode();
        Collection<AssetsSchemaKey> collection3 = collection;
        DashboardsMigrationMode dashboardsMigrationMode3 = dashboardsMigrationMode;
        CrossProjectBoardsAndFiltersMigrationOption crossProjectBoardsAndFiltersMigrationOption3 = crossProjectBoardsAndFiltersMigrationOption;
        JiraDataMigrationOption jiraDataMigrationOption3 = jiraDataMigrationOption;
        LiftAndShiftMode liftAndShiftMode3 = liftAndShiftMode;
        String string16 = string6;
        MigrationTag migrationTag3 = migrationTag;
        SinglePathMode singlePathMode3 = singlePathMode;
        long l3 = l;
        PlanActiveStatus planActiveStatus3 = planActiveStatus;
        Boolean bl11 = bl3;
        EnumSet<CheckType> enumSet3 = enumSet;
        String string17 = string5;
        MigrationType migrationType3 = migrationType;
        Boolean bl12 = bl2;
        ProjectDataMigrationMode projectDataMigrationMode3 = projectDataMigrationMode;
        AppsMigrationOption appsMigrationOption3 = appsMigrationOption;
        UsersGroupsMigrationOption usersGroupsMigrationOption3 = usersGroupsMigrationOption;
        List<Long> list7 = list2;
        List<String> list8 = list;
        String string18 = string4;
        String string19 = string3;
        String string20 = string2;
        String string21 = string;
        return new Plan(string21, string20, string19, string18, list8, list7, usersGroupsMigrationOption3, appsMigrationOption3, projectDataMigrationMode3, bl12, migrationType3, string17, enumSet3, bl11, planActiveStatus3, l3, singlePathMode3, migrationTag3, string16, liftAndShiftMode3, jiraDataMigrationOption3, crossProjectBoardsAndFiltersMigrationOption3, dashboardsMigrationMode3, (List)collection3, assetsDataMigrationMode, planSource, bl10, bl9, bl8, string15, bl7, set, shadowMigrationProtocol, string14, pbpMigrationMode, list6, advancedRoadmapsMigrationOption2, infraStatus, issueFilters, attachmentFilters, n2, n, defaultConstructorMarker);
    }

    private final JiraDataMigrationOption getJiraDataMigrationOption(PlanConfig planConfig) {
        JiraDataMigrationOption jiraDataMigrationOption;
        if (planConfig.getSinglePathMode() == SinglePathMode.PROJECT_BY_PROJECT && this.migrationFeatures.getSkipAttachmentMigration()) {
            jiraDataMigrationOption = new JiraDataMigrationOption(JiraDataMigrationOption.AttachmentsMigrationMode.NONE);
        } else {
            jiraDataMigrationOption = planConfig.getJiraDataMigrationOption();
            if (jiraDataMigrationOption == null) {
                jiraDataMigrationOption = new JiraDataMigrationOption(null, 1, null);
            }
        }
        return jiraDataMigrationOption;
    }

    /*
     * WARNING - void declaration
     */
    private final PlanConfig buildPlanConfig(Plan plan2, String name, long creationTime, String preflightCheckExecutionId, EnumSet<CheckType> preflightChecksToOverride) {
        Collection<String> collection;
        String string = name;
        List<String> list = plan2.getProjectKeys();
        List<Long> list2 = plan2.getAdvancedRoadmapsPlanIds();
        CloudSiteDto cloudSiteDto = new CloudSiteDto(plan2.getCloudId(), plan2.getCloudUrl(), null, null, null, 28, null);
        UsersGroupsMigrationOption usersGroupsMigrationOption = plan2.getUsersGroupsMigrationOption();
        AppsMigrationOption appsMigrationOption = plan2.getAppsMigrationOption();
        ProjectDataMigrationMode projectDataMigrationMode = plan2.getProjectDataMigrationMode();
        Boolean bl = plan2.getForceRelinking();
        MigrationType migrationType = plan2.getMigrationType();
        String string2 = preflightCheckExecutionId;
        EnumSet<CheckType> enumSet = CheckType.Companion.getEmptyCheckTypeSet();
        EnumSet<CheckType> enumSet2 = preflightChecksToOverride;
        Boolean bl2 = null;
        long l = creationTime;
        SinglePathMode singlePathMode = plan2.getSinglePathMode();
        MigrationTag migrationTag = plan2.getMigrationTag();
        if (migrationTag == null) {
            migrationTag = MigrationTag.NOT_SPECIFIED;
        }
        String string3 = plan2.getManualImportFile();
        LiftAndShiftMode liftAndShiftMode = plan2.getLiftAndShiftMode();
        JiraDataMigrationOption jiraDataMigrationOption = plan2.getJiraDataMigrationOption();
        CrossProjectBoardsAndFiltersMigrationOption crossProjectBoardsAndFiltersMigrationOption = plan2.getCrossProjectBoardsAndFiltersMigrationOption();
        DashboardsMigrationMode dashboardsMigrationMode = plan2.getDashboardsMigrationMode();
        PlanPhase planPhase = null;
        List<AssetsSchemaKey> list3 = plan2.getAssetsSchemaKeys();
        if (list3 != null) {
            Collection<String> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list3;
            PlanPhase planPhase2 = planPhase;
            DashboardsMigrationMode dashboardsMigrationMode2 = dashboardsMigrationMode;
            CrossProjectBoardsAndFiltersMigrationOption crossProjectBoardsAndFiltersMigrationOption2 = crossProjectBoardsAndFiltersMigrationOption;
            JiraDataMigrationOption jiraDataMigrationOption2 = jiraDataMigrationOption;
            LiftAndShiftMode liftAndShiftMode2 = liftAndShiftMode;
            String string4 = string3;
            MigrationTag migrationTag2 = migrationTag;
            SinglePathMode singlePathMode2 = singlePathMode;
            long l2 = l;
            Boolean bl3 = bl2;
            EnumSet<CheckType> enumSet3 = enumSet2;
            EnumSet<CheckType> enumSet4 = enumSet;
            String string5 = string2;
            MigrationType migrationType2 = migrationType;
            Boolean bl4 = bl;
            ProjectDataMigrationMode projectDataMigrationMode2 = projectDataMigrationMode;
            AppsMigrationOption appsMigrationOption2 = appsMigrationOption;
            UsersGroupsMigrationOption usersGroupsMigrationOption2 = usersGroupsMigrationOption;
            CloudSiteDto cloudSiteDto2 = cloudSiteDto;
            List<Long> list4 = list2;
            List<String> list5 = list;
            String string6 = string;
            boolean $i$f$map = false;
            void var9_30 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AssetsSchemaKey assetsSchemaKey = (AssetsSchemaKey)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl5 = false;
                collection2.add(it.getSchemaKey());
            }
            collection2 = (List)destination$iv$iv;
            string = string6;
            list = list5;
            list2 = list4;
            cloudSiteDto = cloudSiteDto2;
            usersGroupsMigrationOption = usersGroupsMigrationOption2;
            appsMigrationOption = appsMigrationOption2;
            projectDataMigrationMode = projectDataMigrationMode2;
            bl = bl4;
            migrationType = migrationType2;
            string2 = string5;
            enumSet = enumSet4;
            enumSet2 = enumSet3;
            bl2 = bl3;
            l = l2;
            singlePathMode = singlePathMode2;
            migrationTag = migrationTag2;
            string3 = string4;
            liftAndShiftMode = liftAndShiftMode2;
            jiraDataMigrationOption = jiraDataMigrationOption2;
            crossProjectBoardsAndFiltersMigrationOption = crossProjectBoardsAndFiltersMigrationOption2;
            dashboardsMigrationMode = dashboardsMigrationMode2;
            planPhase = planPhase2;
            collection = collection2;
        } else {
            collection = null;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 0x201000;
        AttachmentFilters attachmentFilters = plan2.getAttachmentFilters();
        IssueFilters issueFilters = plan2.getIssueFilters();
        AdvancedRoadmapsMigrationOption advancedRoadmapsMigrationOption = plan2.getAdvancedRoadmapsMigrationOption();
        List<String> list6 = plan2.getExcludedProjectKeys();
        PbpMigrationMode pbpMigrationMode = plan2.getPbpMigrationMode();
        Boolean bl6 = plan2.getMigrateArchivedIssues();
        Boolean bl7 = plan2.getUserPreMigration();
        AssetsDataMigrationMode assetsDataMigrationMode = plan2.getAssetsDataMigrationMode();
        Collection<String> collection3 = collection;
        PlanPhase planPhase3 = planPhase;
        DashboardsMigrationMode dashboardsMigrationMode3 = dashboardsMigrationMode;
        CrossProjectBoardsAndFiltersMigrationOption crossProjectBoardsAndFiltersMigrationOption3 = crossProjectBoardsAndFiltersMigrationOption;
        JiraDataMigrationOption jiraDataMigrationOption3 = jiraDataMigrationOption;
        LiftAndShiftMode liftAndShiftMode3 = liftAndShiftMode;
        String string7 = string3;
        MigrationTag migrationTag3 = migrationTag;
        SinglePathMode singlePathMode3 = singlePathMode;
        long l3 = l;
        Boolean bl8 = bl2;
        EnumSet<CheckType> enumSet5 = enumSet2;
        EnumSet<CheckType> enumSet6 = enumSet;
        String string8 = string2;
        MigrationType migrationType3 = migrationType;
        Boolean bl9 = bl;
        ProjectDataMigrationMode projectDataMigrationMode3 = projectDataMigrationMode;
        AppsMigrationOption appsMigrationOption3 = appsMigrationOption;
        UsersGroupsMigrationOption usersGroupsMigrationOption3 = usersGroupsMigrationOption;
        CloudSiteDto cloudSiteDto3 = cloudSiteDto;
        List<Long> list7 = list2;
        List<String> list8 = list;
        String string9 = string;
        return new PlanConfig(string9, list8, list7, cloudSiteDto3, usersGroupsMigrationOption3, appsMigrationOption3, projectDataMigrationMode3, bl9, migrationType3, string8, enumSet6, enumSet5, bl8, l3, singlePathMode3, migrationTag3, string7, liftAndShiftMode3, jiraDataMigrationOption3, crossProjectBoardsAndFiltersMigrationOption3, dashboardsMigrationMode3, planPhase3, (List)collection3, assetsDataMigrationMode, bl7, bl6, pbpMigrationMode, list6, advancedRoadmapsMigrationOption, issueFilters, attachmentFilters, n, defaultConstructorMarker);
    }

    static /* synthetic */ PlanConfig buildPlanConfig$default(PlanResource planResource, Plan plan2, String string, long l, String string2, EnumSet enumSet, int n, Object object) {
        if ((n & 2) != 0) {
            string = plan2.getPlanName();
        }
        if ((n & 4) != 0) {
            l = plan2.getCreatedTimestamp();
        }
        if ((n & 8) != 0) {
            string2 = plan2.getPreflightCheckExecutionId();
        }
        if ((n & 0x10) != 0) {
            enumSet = plan2.getPreflightChecksToOverride();
        }
        return planResource.buildPlanConfig(plan2, string, l, string2, enumSet);
    }

    private final void sendPlanSavedEventAsync(Plan plan2) {
        this.executor.execute(() -> PlanResource.sendPlanSavedEventAsync$lambda$30(this, plan2));
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final String getUniquePlanName(@NotNull String planName) {
        String string;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)planName, (String)"planName");
        String candidateName = StringsKt.startsWith$default((String)planName, (String)COPIED_PLAN_PREFIX, (boolean)false, (int)2, null) ? (Regex.find$default((Regex)COPIED_PLAN_SUFFIX, (CharSequence)planName, (int)0, (int)2, null) != null ? StringsKt.substringBeforeLast$default((String)planName, (char)'_', null, (int)2, null) : planName) : COPIED_PLAN_PREFIX + planName;
        Iterable $this$mapNotNull$iv = this.planRepository.getByNameBeginningWith(candidateName);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Plan it = (Plan)element$iv$iv;
            boolean bl2 = false;
            if (it.getPlanName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List possibleDuplicates = (List)destination$iv$iv;
        if (!((Collection)possibleDuplicates).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$mapNotNullTo$iv$iv2;
            Regex copiedPlanPattern = new Regex(candidateName + "_(\\d+$)");
            Iterable $this$mapNotNull$iv2 = possibleDuplicates;
            boolean $i$f$mapNotNull2 = false;
            $this$forEach$iv$iv$iv = $this$mapNotNull$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach2 = false;
            MatchResult bl = $this$forEach$iv$iv$iv2.iterator();
            while (bl.hasNext()) {
                MatchResult it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = bl.next();
                boolean bl4 = false;
                String it = (String)element$iv$iv;
                boolean bl5 = false;
                if (Regex.find$default((Regex)copiedPlanPattern, (CharSequence)it, (int)0, (int)2, null) == null) continue;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            $this$mapNotNull$iv2 = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$mapNotNullTo$iv$iv2 = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                bl = (MatchResult)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl7 = false;
                MatchGroup matchGroup = it.getGroups().get(1);
                collection.add(Integer.parseInt(String.valueOf(matchGroup != null ? matchGroup.getValue() : null)));
            }
            Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2));
            int countSuffix = n != null ? n : 0;
            string = candidateName + '_' + (countSuffix + 1);
        } else {
            string = candidateName;
        }
        return string;
    }

    @PreDestroy
    public final void shutdown() {
        this.forkJoinPool.shutdownNow();
        this.executor.shutdownNow();
    }

    private final Object startPlan(Plan plan2) {
        this.planEventHandler.sendPlanStartedEvent(plan2);
        if (plan2.isIncremental()) {
            this.execution.scheduleIncrementalPlanExecution(plan2, false);
        } else {
            this.execution.scheduleClassicPlanExecution(plan2);
        }
        return plan2.isIncremental() ? PlanViewBuilder.incrementalPlanMonitor$default(this.planViewBuilder, plan2, false, 2, null) : PlanViewBuilder.classicPlanMonitor$default(this.planViewBuilder, plan2, false, 2, null);
    }

    private final String sanitiseString(String stringToSanitise) {
        CharSequence charSequence = stringToSanitise;
        if (!new Regex("^[a-zA-Z0-9,-_$]*$").matches(charSequence)) {
            throw new IllegalArgumentException("Invalid input: '" + stringToSanitise + "'. The string must only contain alphanumeric characters and -,_$");
        }
        return stringToSanitise;
    }

    private final List<String> getRemovedProjectKeys(Plan basePlan, Plan copiedPlan) {
        return CollectionsKt.minus((Iterable)basePlan.getProjectKeys(), (Iterable)CollectionsKt.toSet((Iterable)copiedPlan.getProjectKeys()));
    }

    private static final ForkJoinWorkerThread planResourceWorkerFactory$lambda$1(ForkJoinPool it) {
        ForkJoinWorkerThread forkJoinWorkerThread;
        ForkJoinWorkerThread $this$planResourceWorkerFactory_u24lambda_u241_u24lambda_u240 = forkJoinWorkerThread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(it);
        boolean bl = false;
        $this$planResourceWorkerFactory_u24lambda_u241_u24lambda_u240.setName("JCMA-PlanResource-worker-pool-" + $this$planResourceWorkerFactory_u24lambda_u241_u24lambda_u240.getPoolIndex() + "-thread-" + $this$planResourceWorkerFactory_u24lambda_u241_u24lambda_u240.getId());
        return forkJoinWorkerThread;
    }

    private static final boolean listPlans$lambda$13(Plan p) {
        return !p.isIncremental();
    }

    private static final boolean listPlans$lambda$14(Plan p) {
        return p.isShadowPlan() == null || Intrinsics.areEqual((Object)p.isShadowPlan(), (Object)false);
    }

    private static final boolean listPlans$lambda$15(Plan it) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final List listPlans$lambda$21(PlanResource this$0, Predicate $planFilter, Predicate $nonShadowPlansOnly) {
        void $this$mapNotNullTo$iv$iv;
        Plan it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$planFilter, (String)"$planFilter");
        Intrinsics.checkNotNullParameter((Object)$nonShadowPlansOnly, (String)"$nonShadowPlansOnly");
        Iterable $this$filter$iv = this$0.planRepository.list();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Plan)element$iv$iv;
            boolean bl = false;
            if (!$planFilter.test(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Plan)element$iv$iv;
            boolean bl = false;
            if (!$nonShadowPlansOnly.test(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object it$iv$iv;
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Plan it2 = (Plan)element$iv$iv;
            boolean bl2 = false;
            Object object2 = this$0;
            try {
                PlanResource $this$listPlans_u24lambda_u2421_u24lambda_u2420_u24lambda_u2418 = object2;
                boolean bl3 = false;
                object = Result.constructor-impl((Object)(it2.isIncremental() ? $this$listPlans_u24lambda_u2421_u24lambda_u2420_u24lambda_u2418.planViewBuilder.incrementalPlanMonitor(it2, false) : (it2.isLiftAndShift() ? $this$listPlans_u24lambda_u2421_u24lambda_u2420_u24lambda_u2418.planViewBuilder.liftAndShiftPlanMonitor(it2, false) : $this$listPlans_u24lambda_u2421_u24lambda_u2420_u24lambda_u2418.planViewBuilder.classicPlanMonitor(it2, false))));
            }
            catch (Throwable bl3) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object ex = object = throwable;
                boolean bl4 = false;
                log.error("Failed to retrieve plan info for planId " + it2.getId(), (Throwable)ex);
            }
            if ((Result.isFailure-impl((Object)object2) ? null : object2) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private static final void sendPlanSavedEventAsync$lambda$30(PlanResource this$0, Plan $plan) {
        block2: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$plan, (String)"$plan");
            Object object2 = this$0;
            try {
                PlanResource $this$sendPlanSavedEventAsync_u24lambda_u2430_u24lambda_u2428 = object2;
                boolean bl = false;
                $this$sendPlanSavedEventAsync_u24lambda_u2430_u24lambda_u2428.planEventHandler.sendPlanSavedEvent($plan);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object exception = object = throwable;
            boolean bl = false;
            log.error("Failed to send sendPlanSavedEvent for the plan " + $plan.getId() + ", Reason : " + ((Throwable)exception).getMessage() + '.');
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/plan/rest/PlanResource$Companion;", "", "()V", "APPLICATION_ZIP", "", "COPIED_PLAN_PREFIX", "COPIED_PLAN_SUFFIX", "Lkotlin/text/Regex;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

