/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.platform;

import com.atlassian.jira.migration.platform.AbstractMcsContainer;
import com.atlassian.jira.migration.platform.AppContainer;
import com.atlassian.jira.migration.platform.JiraProjectContainer;
import com.atlassian.jira.migration.platform.SiteContainer;
import com.atlassian.jira.migration.platform.UnknownContainer;
import com.atlassian.migration.app.ContainerType;
import com.atlassian.migration.app.ContainerV1;
import com.atlassian.migration.app.JiraProjectContainerV1;
import com.atlassian.migration.app.SiteContainerV1;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0005\u0006B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/platform/GsonFactory;", "", "()V", "createGson", "Lcom/google/gson/Gson;", "AbstractMcsContainerDeserializer", "ContainerV1Deserializer", "jira-migration-plugin"})
public final class GsonFactory {
    @NotNull
    public final Gson createGson() {
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)ContainerV1.class), (Object)new ContainerV1Deserializer()).registerTypeAdapter((Type)((Object)AbstractMcsContainer.class), (Object)new AbstractMcsContainerDeserializer()).setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        return gson;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/platform/GsonFactory$AbstractMcsContainerDeserializer;", "Lcom/google/gson/JsonDeserializer;", "Lcom/atlassian/jira/migration/platform/AbstractMcsContainer;", "()V", "deserialize", "jsonElement", "Lcom/google/gson/JsonElement;", "type", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "jira-migration-plugin"})
    private static final class AbstractMcsContainerDeserializer
    implements JsonDeserializer<AbstractMcsContainer> {
        @NotNull
        public AbstractMcsContainer deserialize(@NotNull JsonElement jsonElement, @NotNull Type type, @NotNull JsonDeserializationContext context) {
            block13: {
                JsonObject jsonObject;
                Intrinsics.checkNotNullParameter((Object)jsonElement, (String)"jsonElement");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                JsonObject jsonObject2 = jsonObject = jsonElement.getAsJsonObject();
                Intrinsics.checkNotNull((Object)jsonObject2);
                JsonElement jsonElement2 = jsonObject2.get("type");
                Intrinsics.checkNotNull((Object)jsonElement2);
                String string = jsonElement2.getAsString();
                if (string == null) break block13;
                int n = -1;
                switch (string.hashCode()) {
                    case 66049: {
                        if (string.equals("App")) {
                            n = 1;
                        }
                        break;
                    }
                    case 2577255: {
                        if (string.equals("Site")) {
                            n = 2;
                        }
                        break;
                    }
                    case -271621269: {
                        if (string.equals("JiraProject")) {
                            n = 3;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        Object object = new Gson().fromJson(jsonElement, AppContainer.class);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                        return (AbstractMcsContainer)object;
                    }
                    case 3: {
                        Object object = new Gson().fromJson(jsonElement, JiraProjectContainer.class);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                        return (AbstractMcsContainer)object;
                    }
                    case 2: {
                        Object object = new Gson().fromJson(jsonElement, SiteContainer.class);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                        return (AbstractMcsContainer)object;
                    }
                }
            }
            Object object = new Gson().fromJson(jsonElement, UnknownContainer.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            return (AbstractMcsContainer)object;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/platform/GsonFactory$ContainerV1Deserializer;", "Lcom/google/gson/JsonDeserializer;", "Lcom/atlassian/migration/app/ContainerV1;", "()V", "deserialize", "jsonElement", "Lcom/google/gson/JsonElement;", "type", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "jira-migration-plugin"})
    private static final class ContainerV1Deserializer
    implements JsonDeserializer<ContainerV1> {
        @NotNull
        public ContainerV1 deserialize(@Nullable JsonElement jsonElement, @Nullable Type type, @Nullable JsonDeserializationContext context) {
            ContainerV1 containerV1;
            JsonElement jsonElement2 = jsonElement;
            Intrinsics.checkNotNull((Object)jsonElement2);
            String containerTypeAsString = jsonElement2.getAsJsonObject().get("type").getAsString();
            Intrinsics.checkNotNull((Object)containerTypeAsString);
            switch (WhenMappings.$EnumSwitchMapping$0[ContainerType.valueOf((String)containerTypeAsString).ordinal()]) {
                case 1: {
                    Object object = new Gson().fromJson(jsonElement, JiraProjectContainerV1.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                    containerV1 = (ContainerV1)object;
                    break;
                }
                case 2: {
                    Object object = new Gson().fromJson(jsonElement, SiteContainerV1.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
                    containerV1 = (ContainerV1)object;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid container type: " + containerTypeAsString);
                }
            }
            return containerV1;
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ContainerType.values().length];
                try {
                    nArray[ContainerType.JiraProject.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ContainerType.Site.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

