/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.platform;

import java.util.Map;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\u00120\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0002R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/platform/MaxConcurrencyPageLoopMode;", "", "()V", "APP_DATA_PRELOAD", "", "ATTACHMENT_EXPORT", "DATA_EXPORT", "DATA_IMPORT", "MAX_CONCURRENCY_PAGE_LOOP_MODE", "PROJECT_IMPORT_PARALLELISM", "", "SUPPORTED_EXPORT_CONCURRENCY", "Ljava/util/TreeSet;", "getSUPPORTED_EXPORT_CONCURRENCY$annotations", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getMaxConcurrencyPerLoop", "", "importConcurrency", "availableProcessor", "activeClusterNodes", "isShadowPlan", "", "getProjectExportParallelism", "jira-migration-plugin"})
public final class MaxConcurrencyPageLoopMode {
    @NotNull
    public static final MaxConcurrencyPageLoopMode INSTANCE = new MaxConcurrencyPageLoopMode();
    private static final Logger log = LoggerFactory.getLogger(MaxConcurrencyPageLoopMode.class);
    @NotNull
    public static final String MAX_CONCURRENCY_PAGE_LOOP_MODE = "MaxConcurrencyPageLoopMode";
    @NotNull
    public static final String DATA_EXPORT = "DATA_EXPORT";
    @NotNull
    public static final String DATA_IMPORT = "DATA_IMPORT";
    @NotNull
    public static final String ATTACHMENT_EXPORT = "ATTACHMENTS";
    public static final int PROJECT_IMPORT_PARALLELISM = 8;
    @NotNull
    public static final String APP_DATA_PRELOAD = "APP_DATA_PRELOAD";
    @NotNull
    private static final TreeSet<Integer> SUPPORTED_EXPORT_CONCURRENCY;

    private MaxConcurrencyPageLoopMode() {
    }

    @NotNull
    public final Map<String, Map<String, Integer>> getMaxConcurrencyPerLoop(int importConcurrency, int availableProcessor, int activeClusterNodes, boolean isShadowPlan) {
        int projectExportParallelism = this.getProjectExportParallelism(availableProcessor);
        if (activeClusterNodes > 0) {
            Integer n = SUPPORTED_EXPORT_CONCURRENCY.floor(projectExportParallelism * activeClusterNodes);
            projectExportParallelism = n == null ? 2 : n;
            log.info("No. of Active Nodes : {}", (Object)activeClusterNodes);
        }
        if (isShadowPlan) {
            projectExportParallelism = 2;
        }
        log.info("Export concurrency set to = " + projectExportParallelism + " and Import concurrency set to = " + importConcurrency);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)DATA_EXPORT, (Object)projectExportParallelism), TuplesKt.to((Object)DATA_IMPORT, (Object)importConcurrency), TuplesKt.to((Object)ATTACHMENT_EXPORT, (Object)2), TuplesKt.to((Object)APP_DATA_PRELOAD, (Object)2)};
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)MAX_CONCURRENCY_PAGE_LOOP_MODE, (Object)MapsKt.mapOf((Pair[])pairArray)));
    }

    public static /* synthetic */ Map getMaxConcurrencyPerLoop$default(MaxConcurrencyPageLoopMode maxConcurrencyPageLoopMode, int n, int n2, int n3, boolean bl, int n4, Object object) {
        if ((n4 & 8) != 0) {
            bl = false;
        }
        return maxConcurrencyPageLoopMode.getMaxConcurrencyPerLoop(n, n2, n3, bl);
    }

    public final int getProjectExportParallelism(int availableProcessor) {
        int exportParallelism = Math.min(Math.max(availableProcessor / 2, 2), 8);
        Integer n = SUPPORTED_EXPORT_CONCURRENCY.floor(exportParallelism);
        return n == null ? 2 : n;
    }

    private static /* synthetic */ void getSUPPORTED_EXPORT_CONCURRENCY$annotations() {
    }

    static {
        Object[] objectArray = new Integer[]{1, 2, 3, 4, 6, 8, 10, 12, 16, 32, 40};
        SUPPORTED_EXPORT_CONCURRENCY = SetsKt.sortedSetOf((Object[])objectArray);
    }
}

