/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.platform;

import com.atlassian.jira.migration.orchestratorclient.tasks.TaskCompletionStatus;
import com.atlassian.jira.migration.platform.ContainerStatus;
import com.atlassian.migration.statusrouter.model.CommandStatus;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u0004\u0018\u00010\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/platform/TransferStatus;", "", "(Ljava/lang/String;I)V", "adaptStatus", "containerStatus", "Lcom/atlassian/jira/migration/platform/ContainerStatus;", "isCompleted", "", "isUnsuccessful", "toCommandStatus", "Lcom/atlassian/migration/statusrouter/model/CommandStatus;", "toTaskCompletionStatus", "Lcom/atlassian/jira/migration/orchestratorclient/tasks/TaskCompletionStatus;", "READY", "IN_PROGRESS", "CANCELLING", "SUCCESS", "FAILED", "INCOMPLETE", "SKIPPED", "TIMED_OUT", "CANCELLED", "Companion", "jira-migration-plugin"})
public final class TransferStatus
extends Enum<TransferStatus> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final List<TransferStatus> transfersStatusesToAdaptWithContainerStatus;
    @NotNull
    private static final List<TransferStatus> unSuccessfulStatuses;
    public static final /* enum */ TransferStatus READY;
    public static final /* enum */ TransferStatus IN_PROGRESS;
    public static final /* enum */ TransferStatus CANCELLING;
    public static final /* enum */ TransferStatus SUCCESS;
    public static final /* enum */ TransferStatus FAILED;
    public static final /* enum */ TransferStatus INCOMPLETE;
    public static final /* enum */ TransferStatus SKIPPED;
    public static final /* enum */ TransferStatus TIMED_OUT;
    public static final /* enum */ TransferStatus CANCELLED;
    private static final /* synthetic */ TransferStatus[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    @Nullable
    public final TaskCompletionStatus toTaskCompletionStatus() {
        TaskCompletionStatus taskCompletionStatus;
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                taskCompletionStatus = TaskCompletionStatus.SUCCESS;
                break;
            }
            case 2: {
                taskCompletionStatus = TaskCompletionStatus.CANCELLED;
                break;
            }
            case 3: 
            case 4: {
                taskCompletionStatus = TaskCompletionStatus.FAILURE;
                break;
            }
            case 5: {
                taskCompletionStatus = TaskCompletionStatus.INCOMPLETE;
                break;
            }
            case 6: {
                taskCompletionStatus = TaskCompletionStatus.SKIPPED;
                break;
            }
            default: {
                taskCompletionStatus = null;
            }
        }
        return taskCompletionStatus;
    }

    public final boolean isCompleted() {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 7: 
            case 8: 
            case 9: {
                bl = false;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    public final boolean isUnsuccessful() {
        return unSuccessfulStatuses.contains((Object)this);
    }

    @NotNull
    public final TransferStatus adaptStatus(@NotNull ContainerStatus containerStatus) {
        TransferStatus transferStatus;
        Intrinsics.checkNotNullParameter((Object)((Object)containerStatus), (String)"containerStatus");
        if (transfersStatusesToAdaptWithContainerStatus.contains((Object)this)) {
            switch (WhenMappings.$EnumSwitchMapping$1[containerStatus.ordinal()]) {
                case 1: {
                    transferStatus = CANCELLING;
                    break;
                }
                case 2: {
                    transferStatus = CANCELLED;
                    break;
                }
                case 3: {
                    transferStatus = TIMED_OUT;
                    break;
                }
                case 4: {
                    transferStatus = FAILED;
                    break;
                }
                case 5: {
                    transferStatus = SUCCESS;
                    break;
                }
                default: {
                    transferStatus = this;
                    break;
                }
            }
        } else {
            transferStatus = this;
        }
        return transferStatus;
    }

    @NotNull
    public final CommandStatus toCommandStatus() {
        CommandStatus commandStatus;
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                commandStatus = CommandStatus.SUCCESS;
                break;
            }
            case 3: {
                commandStatus = CommandStatus.FAILED;
                break;
            }
            case 5: {
                commandStatus = CommandStatus.INCOMPLETE;
                break;
            }
            case 6: {
                commandStatus = CommandStatus.SKIPPED;
                break;
            }
            case 4: {
                commandStatus = CommandStatus.TIMED_OUT;
                break;
            }
            case 2: {
                commandStatus = CommandStatus.CANCELLED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported conversion to Command status of transfer status " + this.name());
            }
        }
        return commandStatus;
    }

    public static TransferStatus[] values() {
        return (TransferStatus[])$VALUES.clone();
    }

    public static TransferStatus valueOf(String value) {
        return Enum.valueOf(TransferStatus.class, value);
    }

    @NotNull
    public static EnumEntries<TransferStatus> getEntries() {
        return $ENTRIES;
    }

    static {
        READY = new TransferStatus();
        IN_PROGRESS = new TransferStatus();
        CANCELLING = new TransferStatus();
        SUCCESS = new TransferStatus();
        FAILED = new TransferStatus();
        INCOMPLETE = new TransferStatus();
        SKIPPED = new TransferStatus();
        TIMED_OUT = new TransferStatus();
        CANCELLED = new TransferStatus();
        $VALUES = transferStatusArray = new TransferStatus[]{TransferStatus.READY, TransferStatus.IN_PROGRESS, TransferStatus.CANCELLING, TransferStatus.SUCCESS, TransferStatus.FAILED, TransferStatus.INCOMPLETE, TransferStatus.SKIPPED, TransferStatus.TIMED_OUT, TransferStatus.CANCELLED};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        TransferStatus[] transferStatusArray = new TransferStatus[]{READY, IN_PROGRESS};
        transfersStatusesToAdaptWithContainerStatus = CollectionsKt.listOf((Object[])transferStatusArray);
        transferStatusArray = new TransferStatus[]{FAILED, INCOMPLETE, TIMED_OUT, CANCELLED};
        unSuccessfulStatuses = CollectionsKt.listOf((Object[])transferStatusArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/jira/migration/platform/TransferStatus$Companion;", "", "()V", "transfersStatusesToAdaptWithContainerStatus", "", "Lcom/atlassian/jira/migration/platform/TransferStatus;", "unSuccessfulStatuses", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TransferStatus.values().length];
            try {
                nArray[TransferStatus.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransferStatus.CANCELLED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransferStatus.FAILED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransferStatus.TIMED_OUT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransferStatus.INCOMPLETE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransferStatus.SKIPPED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransferStatus.READY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransferStatus.IN_PROGRESS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransferStatus.CANCELLING.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ContainerStatus.values().length];
            try {
                nArray[ContainerStatus.CANCELLING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContainerStatus.CANCELLED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContainerStatus.TIMED_OUT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContainerStatus.FAILED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContainerStatus.SUCCESS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

