/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.plugins.rest;

import com.atlassian.jira.migration.infrastructure.rest.ResponseUtils;
import com.atlassian.jira.migration.plugins.service.PluginsInformationService;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Tag(name="Plugins REST API", description="These REST endpoints include endpoints which provide\n information about plugins installed on the Jira instance.")
@Path(value="plugins")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
@SystemAdminOnly
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/plugins/rest/PluginsResource;", "", "pluginsInformationService", "Lcom/atlassian/jira/migration/plugins/service/PluginsInformationService;", "(Lcom/atlassian/jira/migration/plugins/service/PluginsInformationService;)V", "getPluginsInformation", "Ljavax/ws/rs/core/Response;", "pluginKeys", "", "", "jira-migration-plugin"})
public final class PluginsResource {
    @NotNull
    private final PluginsInformationService pluginsInformationService;

    @Inject
    public PluginsResource(@NotNull PluginsInformationService pluginsInformationService) {
        Intrinsics.checkNotNullParameter((Object)pluginsInformationService, (String)"pluginsInformationService");
        this.pluginsInformationService = pluginsInformationService;
    }

    @POST
    @Path(value="/information")
    @Operation(description="Checks if plugins with provided keys are installed on the Jira instance.")
    @NotNull
    public final Response getPluginsInformation(@NotNull List<String> pluginKeys) {
        Intrinsics.checkNotNullParameter(pluginKeys, (String)"pluginKeys");
        return ResponseUtils.INSTANCE.ok(this.pluginsInformationService.getForPlugins(pluginKeys));
    }
}

