/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.polly;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.polly.MigV4Command;
import com.atlassian.jira.migration.polly.NodeCommandCount;
import com.atlassian.migration.prc.model.Command;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.spi.querydsl.EnhancedRelationalPathBase;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001eB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\fJ\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\f0\u0016J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u001f\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/polly/MigV4CommandRepository;", "", "databaseAccessor", "Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/pocketknife/api/querydsl/DatabaseAccessor;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "deleteCommandByCommandId", "", "commandId", "", "deleteForDeadNodes", "", "liveNodes", "", "", "getCommandById", "Lcom/atlassian/migration/prc/model/Command;", "id", "getCurrentCommandCounts", "", "getNodeCommandCounts", "", "Lcom/atlassian/jira/migration/polly/NodeCommandCount;", "saveCommand", "command", "nodeId", "(Lcom/atlassian/migration/prc/model/Command;Ljava/lang/String;)Ljava/lang/Long;", "MigV4CommandTable", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigV4CommandRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigV4CommandRepository.kt\ncom/atlassian/jira/migration/polly/MigV4CommandRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n1#2:147\n1179#3,2:148\n1253#3,4:150\n1549#3:154\n1620#3,3:155\n*S KotlinDebug\n*F\n+ 1 MigV4CommandRepository.kt\ncom/atlassian/jira/migration/polly/MigV4CommandRepository\n*L\n57#1:148,2\n57#1:150,4\n73#1:154\n73#1:155,3\n*E\n"})
public final class MigV4CommandRepository {
    @NotNull
    private final DatabaseAccessor databaseAccessor;
    @NotNull
    private final ObjectMapper objectMapper;

    @Inject
    public MigV4CommandRepository(@NotNull DatabaseAccessor databaseAccessor, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)databaseAccessor, (String)"databaseAccessor");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.databaseAccessor = databaseAccessor;
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    @Nullable
    public final Long saveCommand(@NotNull Command command, @Nullable String nodeId) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        String commandJson = this.objectMapper.writeValueAsString((Object)command);
        return (Long)this.databaseAccessor.runInTransaction(arg_0 -> MigV4CommandRepository.saveCommand$lambda$2(command, commandJson, nodeId, arg_0), MigV4CommandRepository::saveCommand$lambda$3);
    }

    @Nullable
    public final Command getCommandById(long id) {
        Command command;
        Tuple tuple = (Tuple)this.databaseAccessor.runInTransaction(arg_0 -> MigV4CommandRepository.getCommandById$lambda$4(id, arg_0), MigV4CommandRepository::getCommandById$lambda$5);
        if (tuple != null) {
            String commandJson;
            Tuple record = tuple;
            boolean bl = false;
            String string = commandJson = (String)record.get((Expression)MigV4CommandTable.INSTANCE.getCOMMAND_JSON());
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                command = (Command)this.objectMapper.readValue(it, Command.class);
            } else {
                command = null;
            }
        } else {
            command = null;
        }
        return command;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Long> getCurrentCommandCounts() {
        void $this$associateTo$iv$iv;
        Object object = this.databaseAccessor.runInTransaction(MigV4CommandRepository::getCurrentCommandCounts$lambda$8, MigV4CommandRepository::getCurrentCommandCounts$lambda$9);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runInTransaction(...)");
        Iterable $this$associate$iv = (Iterable)object;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            long l;
            Long l2;
            Map map = destination$iv$iv;
            Tuple record = (Tuple)element$iv$iv;
            boolean bl = false;
            Object object2 = record.get((Expression)MigV4CommandTable.INSTANCE.getCOMMAND_NAME());
            Intrinsics.checkNotNull((Object)object2);
            String commandName = (String)object2;
            Long l3 = l2 = (Long)record.get(1, Long.TYPE);
            if (l3 == null) {
                l = 0L;
            } else {
                Intrinsics.checkNotNull((Object)l3);
                l = l2;
            }
            long count2 = l;
            Pair pair = TuplesKt.to((Object)commandName, (Object)count2);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<NodeCommandCount> getNodeCommandCounts() {
        void $this$mapTo$iv$iv;
        Object object = this.databaseAccessor.runInTransaction(MigV4CommandRepository::getNodeCommandCounts$lambda$11, MigV4CommandRepository::getNodeCommandCounts$lambda$12);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runInTransaction(...)");
        Iterable $this$map$iv = (Iterable)object;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            long l;
            Long l2;
            void record;
            Tuple tuple = (Tuple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object2 = record.get((Expression)MigV4CommandTable.INSTANCE.getNODE_ID());
            Intrinsics.checkNotNull((Object)object2);
            String nodeId = (String)object2;
            Object object3 = record.get((Expression)MigV4CommandTable.INSTANCE.getCOMMAND_NAME());
            Intrinsics.checkNotNull((Object)object3);
            String command = (String)object3;
            Long l3 = l2 = (Long)record.get(2, Long.TYPE);
            if (l3 == null) {
                l = 0L;
            } else {
                Intrinsics.checkNotNull((Object)l3);
                l = l2;
            }
            long count2 = l;
            collection.add(new NodeCommandCount(nodeId, command, count2));
        }
        return (List)destination$iv$iv;
    }

    public final boolean deleteCommandByCommandId(long commandId) {
        Object object = this.databaseAccessor.runInTransaction(arg_0 -> MigV4CommandRepository.deleteCommandByCommandId$lambda$14(commandId, arg_0), MigV4CommandRepository::deleteCommandByCommandId$lambda$15);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runInTransaction(...)");
        return (Boolean)object;
    }

    public final void deleteForDeadNodes(@NotNull Set<String> liveNodes) {
        Intrinsics.checkNotNullParameter(liveNodes, (String)"liveNodes");
        this.databaseAccessor.runInTransaction(arg_0 -> MigV4CommandRepository.deleteForDeadNodes$lambda$16(liveNodes, arg_0), MigV4CommandRepository::deleteForDeadNodes$lambda$17);
    }

    private static final Long saveCommand$lambda$2(Command $command, String $commandJson, String $nodeId, DatabaseConnection db) {
        SQLInsertClause sQLInsertClause;
        block0: {
            Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
            SQLInsertClause $this$saveCommand_u24lambda_u242_u24lambda_u241 = sQLInsertClause = db.insert((RelationalPath)MigV4CommandTable.INSTANCE).set((Path)MigV4CommandTable.INSTANCE.getCOMMAND_ID(), (Object)$command.getId()).set((Path)MigV4CommandTable.INSTANCE.getCOMMAND_JSON(), (Object)$commandJson).set((Path)MigV4CommandTable.INSTANCE.getCOMMAND_NAME(), (Object)$command.getName());
            boolean bl = false;
            String string = $nodeId;
            if (string == null) break block0;
            String it = string;
            boolean bl2 = false;
            $this$saveCommand_u24lambda_u242_u24lambda_u241.set((Path)MigV4CommandTable.INSTANCE.getNODE_ID(), (Object)it);
        }
        return (Long)sQLInsertClause.executeWithKey((Path)MigV4CommandTable.INSTANCE.getID());
    }

    private static final void saveCommand$lambda$3() {
    }

    private static final Tuple getCommandById$lambda$4(long $id, DatabaseConnection db) {
        Expression[] expressionArray = new Expression[]{MigV4CommandTable.INSTANCE.getID(), MigV4CommandTable.INSTANCE.getCOMMAND_ID(), MigV4CommandTable.INSTANCE.getCOMMAND_JSON(), MigV4CommandTable.INSTANCE.getCOMMAND_NAME()};
        return (Tuple)((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)MigV4CommandTable.INSTANCE)).where((Predicate)MigV4CommandTable.INSTANCE.getID().eq((Object)$id))).fetchFirst();
    }

    private static final void getCommandById$lambda$5() {
    }

    private static final List getCurrentCommandCounts$lambda$8(DatabaseConnection db) {
        Expression[] expressionArray = new Expression[]{MigV4CommandTable.INSTANCE.getCOMMAND_NAME(), MigV4CommandTable.INSTANCE.getCOMMAND_NAME().count()};
        return ((SQLQuery)((SQLQuery)db.select(expressionArray).from((Expression)MigV4CommandTable.INSTANCE)).groupBy((Expression)MigV4CommandTable.INSTANCE.getCOMMAND_NAME())).fetch();
    }

    private static final void getCurrentCommandCounts$lambda$9() {
    }

    private static final List getNodeCommandCounts$lambda$11(DatabaseConnection db) {
        Expression[] expressionArray = new Expression[]{MigV4CommandTable.INSTANCE.getNODE_ID(), MigV4CommandTable.INSTANCE.getCOMMAND_NAME()};
        ((SQLQuery)db.select(expressionArray).from((Expression)MigV4CommandTable.INSTANCE)).fetch();
        expressionArray = new Expression[]{MigV4CommandTable.INSTANCE.getNODE_ID(), MigV4CommandTable.INSTANCE.getCOMMAND_NAME(), MigV4CommandTable.INSTANCE.getCOMMAND_NAME().count()};
        SQLQuery sQLQuery = (SQLQuery)db.select(expressionArray).from((Expression)MigV4CommandTable.INSTANCE);
        expressionArray = new Expression[]{MigV4CommandTable.INSTANCE.getNODE_ID(), MigV4CommandTable.INSTANCE.getCOMMAND_NAME()};
        return ((SQLQuery)sQLQuery.groupBy(expressionArray)).fetch();
    }

    private static final void getNodeCommandCounts$lambda$12() {
    }

    private static final Boolean deleteCommandByCommandId$lambda$14(long $commandId, DatabaseConnection db) {
        return db.delete((RelationalPath)MigV4CommandTable.INSTANCE).where((Predicate)MigV4CommandTable.INSTANCE.getCOMMAND_ID().eq((Object)$commandId)).execute() > 0L;
    }

    private static final void deleteCommandByCommandId$lambda$15() {
    }

    private static final Long deleteForDeadNodes$lambda$16(Set $liveNodes, DatabaseConnection db) {
        Intrinsics.checkNotNullParameter((Object)$liveNodes, (String)"$liveNodes");
        return db.delete((RelationalPath)MigV4CommandTable.INSTANCE).where((Predicate)MigV4CommandTable.INSTANCE.getNODE_ID().notIn((Collection)$liveNodes)).execute();
    }

    private static final void deleteForDeadNodes$lambda$17() {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001f\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/jira/migration/polly/MigV4CommandRepository$MigV4CommandTable;", "Lcom/atlassian/pocketknife/spi/querydsl/EnhancedRelationalPathBase;", "()V", "COMMAND_ID", "Lcom/querydsl/core/types/dsl/NumberPath;", "", "kotlin.jvm.PlatformType", "getCOMMAND_ID", "()Lcom/querydsl/core/types/dsl/NumberPath;", "COMMAND_JSON", "Lcom/querydsl/core/types/dsl/StringPath;", "getCOMMAND_JSON", "()Lcom/querydsl/core/types/dsl/StringPath;", "COMMAND_NAME", "getCOMMAND_NAME", "ID", "getID", "NODE_ID", "getNODE_ID", "toMigV4Command", "Lcom/atlassian/jira/migration/polly/MigV4Command;", "record", "Lcom/querydsl/core/Tuple;", "jira-migration-plugin"})
    @VisibleForTesting
    public static final class MigV4CommandTable
    extends EnhancedRelationalPathBase<MigV4CommandTable> {
        @NotNull
        public static final MigV4CommandTable INSTANCE = new MigV4CommandTable();
        @NotNull
        private static final NumberPath<Long> ID;
        @NotNull
        private static final NumberPath<Long> COMMAND_ID;
        @NotNull
        private static final StringPath COMMAND_JSON;
        @NotNull
        private static final StringPath COMMAND_NAME;
        @NotNull
        private static final StringPath NODE_ID;

        private MigV4CommandTable() {
            super(MigV4CommandTable.class, "AO_6FF49D_MIG_V4_COMMAND_TABLE");
        }

        @NotNull
        public final NumberPath<Long> getID() {
            return ID;
        }

        @NotNull
        public final NumberPath<Long> getCOMMAND_ID() {
            return COMMAND_ID;
        }

        @NotNull
        public final StringPath getCOMMAND_JSON() {
            return COMMAND_JSON;
        }

        @NotNull
        public final StringPath getCOMMAND_NAME() {
            return COMMAND_NAME;
        }

        @NotNull
        public final StringPath getNODE_ID() {
            return NODE_ID;
        }

        @NotNull
        public final MigV4Command toMigV4Command(@NotNull Tuple record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            Object object = record.get((Expression)ID);
            Intrinsics.checkNotNull((Object)object);
            long l = ((Number)object).longValue();
            Object object2 = record.get((Expression)COMMAND_ID);
            Intrinsics.checkNotNull((Object)object2);
            long l2 = ((Number)object2).longValue();
            Object object3 = record.get((Expression)COMMAND_JSON);
            Intrinsics.checkNotNull((Object)object3);
            String string = (String)object3;
            Object object4 = record.get((Expression)COMMAND_NAME);
            Intrinsics.checkNotNull((Object)object4);
            String string2 = (String)object4;
            Object object5 = record.get((Expression)NODE_ID);
            Intrinsics.checkNotNull((Object)object5);
            return new MigV4Command(l, l2, string, string2, (String)object5);
        }

        static {
            Path path = INSTANCE.createNumberCol("ID", Long.TYPE).ofType(-5).asPrimaryKey().build();
            Intrinsics.checkNotNull((Object)path);
            ID = (NumberPath)path;
            Path path2 = INSTANCE.createNumberCol("COMMAND_ID", Long.TYPE).ofType(-5).build();
            Intrinsics.checkNotNull((Object)path2);
            COMMAND_ID = (NumberPath)path2;
            Path path3 = INSTANCE.createStringCol("COMMAND_JSON").ofType(-1).build();
            Intrinsics.checkNotNull((Object)path3);
            COMMAND_JSON = (StringPath)path3;
            Path path4 = INSTANCE.createStringCol("COMMAND_NAME").ofType(12).build();
            Intrinsics.checkNotNull((Object)path4);
            COMMAND_NAME = (StringPath)path4;
            Path path5 = INSTANCE.createStringCol("NODE_ID").ofType(12).build();
            Intrinsics.checkNotNull((Object)path5);
            NODE_ID = (StringPath)path5;
        }
    }
}

