/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.polly;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.jiraservice.JiraExtensionsKt;
import com.atlassian.jira.migration.jiraservice.JiraMetadataService;
import com.atlassian.jira.migration.polly.MigV4CommandRepository;
import com.atlassian.jira.migration.polly.MigrationPollerStatisticsCounter;
import com.atlassian.jira.migration.polly.NodeCommandCount;
import com.atlassian.jira.migration.prc.client.PrcHttpClient;
import com.atlassian.jira.migration.workers.app.PRCMigrationCommandWorkerHandler;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.migration.prc.client.Response;
import com.atlassian.migration.prc.client.model.config.OnDemandPollerConfig;
import com.atlassian.migration.prc.client.poller.OnDemandPrcPoller;
import com.atlassian.migration.prc.model.Command;
import com.atlassian.migration.prc.model.CommandName;
import com.atlassian.migration.prc.model.PrcRequest;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 S2\u00020\u00012\u00020\u0002:\u0002RSBg\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020%H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010+\u001a\u00020%H\u0002J\b\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020/2\u0006\u00101\u001a\u000202H\u0007J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020%04H\u0007J\u0010\u00105\u001a\u00020%2\u0006\u00106\u001a\u00020%H\u0007J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020/H\u0007J\u0010\u0010<\u001a\u00020/2\u0006\u0010+\u001a\u00020%H\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020>2\u0006\u0010+\u001a\u00020%H\u0007J\u0018\u0010B\u001a\u00020/2\u0006\u00101\u001a\u0002022\u0006\u0010+\u001a\u00020%H\u0007J\b\u0010C\u001a\u00020/H\u0002J\u0018\u0010D\u001a\u00020/2\u0006\u00109\u001a\u00020:2\u0006\u0010+\u001a\u00020%H\u0002J&\u0010E\u001a\u00020/2\b\u0010F\u001a\u0004\u0018\u00010%2\b\u0010G\u001a\u0004\u0018\u00010%2\b\u0010H\u001a\u0004\u0018\u00010%H\u0016J\b\u0010I\u001a\u00020/H\u0007J\u0010\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020MH\u0016J\b\u0010N\u001a\u00020/H\u0007J\u000e\u0010O\u001a\u00020/2\u0006\u0010+\u001a\u00020%J\u0010\u0010P\u001a\u00020/2\u0006\u0010+\u001a\u00020%H\u0002J\u000e\u0010Q\u001a\u00020/2\u0006\u0010+\u001a\u00020%R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lcom/atlassian/jira/migration/polly/MigrationPoller;", "Lcom/atlassian/scheduler/JobRunner;", "Lcom/atlassian/jira/cluster/ClusterMessageConsumer;", "executorHandler", "Lcom/atlassian/jira/migration/workers/app/PRCMigrationCommandWorkerHandler;", "prcHttpClient", "Lcom/atlassian/jira/migration/prc/client/PrcHttpClient;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "jiraMetadataService", "Lcom/atlassian/jira/migration/jiraservice/JiraMetadataService;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "clusterManager", "Lcom/atlassian/jira/cluster/ClusterManager;", "clusterMessageService", "Lcom/atlassian/jira/cluster/ClusterMessagingService;", "commandRepository", "Lcom/atlassian/jira/migration/polly/MigV4CommandRepository;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/workers/app/PRCMigrationCommandWorkerHandler;Lcom/atlassian/jira/migration/prc/client/PrcHttpClient;Lcom/atlassian/jira/migration/discovery/DiscoveryService;Lcom/atlassian/scheduler/SchedulerService;Lcom/atlassian/jira/migration/jiraservice/JiraMetadataService;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/cluster/ClusterManager;Lcom/atlassian/jira/cluster/ClusterMessagingService;Lcom/atlassian/jira/migration/polly/MigV4CommandRepository;Lcom/atlassian/cache/CacheManager;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "executorService", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "onDemandPrcPoller", "Lcom/atlassian/migration/prc/client/poller/OnDemandPrcPoller;", "pollerCache", "Lcom/atlassian/cache/Cache;", "", "", "pollerStatisticsCounter", "Lcom/atlassian/jira/migration/polly/MigrationPollerStatisticsCounter;", "buildJobId", "Lcom/atlassian/scheduler/config/JobId;", "migrationId", "buildJobKey", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "checkThrottling", "", "executeCommand", "command", "Lcom/atlassian/migration/prc/model/Command;", "getEligibleCommands", "", "getEligibleNodeForCommand", "commandName", "getPollerConfig", "Lcom/atlassian/migration/prc/client/model/config/OnDemandPollerConfig;", "cloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "initialise", "initiatePoller", "isMessageForCurrentNode", "", "commandMessage", "Lcom/atlassian/jira/migration/polly/MigrationPoller$CommandMessage;", "isPollerActive", "issueCommandToCluster", "logCurrentConcurrency", "poll", "receive", "channel", "message", "senderId", "refreshClusterStatus", "runJob", "Lcom/atlassian/scheduler/JobRunnerResponse;", "jobRunnerRequest", "Lcom/atlassian/scheduler/JobRunnerRequest;", "shutdown", "startPolling", "stopPoller", "stopPolling", "CommandMessage", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationPoller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationPoller.kt\ncom/atlassian/jira/migration/polly/MigrationPoller\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,395:1\n1603#2,9:396\n1855#2:405\n1856#2:407\n1612#2:408\n1603#2,9:409\n1855#2:418\n1856#2:420\n1612#2:421\n766#2:422\n857#2,2:423\n1271#2,2:425\n1285#2,2:427\n1288#2:430\n1271#2,2:438\n1285#2,2:440\n766#2:442\n857#2,2:443\n1288#2:445\n2333#2,14:446\n766#2:460\n857#2,2:461\n1#3:406\n1#3:419\n1#3:429\n526#4:431\n511#4,6:432\n215#5,2:463\n*S KotlinDebug\n*F\n+ 1 MigrationPoller.kt\ncom/atlassian/jira/migration/polly/MigrationPoller\n*L\n229#1:396,9\n229#1:405\n229#1:407\n229#1:408\n250#1:409,9\n250#1:418\n250#1:420\n250#1:421\n252#1:422\n252#1:423,2\n253#1:425,2\n253#1:427,2\n253#1:430\n261#1:438,2\n261#1:440,2\n262#1:442\n262#1:443,2\n261#1:445\n264#1:446,14\n337#1:460\n337#1:461,2\n229#1:406\n250#1:419\n258#1:431\n258#1:432,6\n348#1:463,2\n*E\n"})
public final class MigrationPoller
implements JobRunner,
ClusterMessageConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PRCMigrationCommandWorkerHandler executorHandler;
    @NotNull
    private final PrcHttpClient prcHttpClient;
    @NotNull
    private final DiscoveryService discoveryService;
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private final JiraMetadataService jiraMetadataService;
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ClusterManager clusterManager;
    @NotNull
    private final ClusterMessagingService clusterMessageService;
    @NotNull
    private final MigV4CommandRepository commandRepository;
    private final ExecutorService executorService;
    @NotNull
    private final OnDemandPrcPoller onDemandPrcPoller;
    @NotNull
    private final Cache<String, Long> pollerCache;
    @NotNull
    private final MigrationPollerStatisticsCounter pollerStatisticsCounter;
    @NotNull
    private final ObjectMapper objectMapper;
    private static final Logger log = Logger.getLogger(MigrationPoller.class);
    @NotNull
    private static final String CHANNEL_NAME_PREFIX = "jira-server-to-cloud-";
    @NotNull
    private static final String JOB_PREFIX = "migration-poller-job-";
    private static long JOB_INTERVAL = TimeUnit.MINUTES.toMillis(1L);
    private static final long INITIAL_BACKOFF_TIME = 1000L;
    public static final int LAST_POLL_TIME_THRESHOLD = 70000;
    public static final long MAX_BACKOFF_TIME = 60000L;
    private static final long THROTTLE_TIME = 5000L;
    @NotNull
    private static final String CLUSTER_MESSAGE_CHANNEL = "MIG_POLLER_CHANNEL";
    @NotNull
    private static final String POLLER_CACHE_NAME = "pollerCache";
    @NotNull
    private static final CacheSettings CACHE_SETTINGS;
    @NotNull
    private static final Map<String, Integer> CONCURRENCY_LIMITS;

    @Inject
    public MigrationPoller(@NotNull PRCMigrationCommandWorkerHandler executorHandler, @NotNull PrcHttpClient prcHttpClient, @NotNull DiscoveryService discoveryService, @NotNull SchedulerService schedulerService, @NotNull JiraMetadataService jiraMetadataService, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull MigrationFeatures migrationFeatures, @NotNull ClusterManager clusterManager, @NotNull ClusterMessagingService clusterMessageService, @NotNull MigV4CommandRepository commandRepository, @NotNull CacheManager cacheManager, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)executorHandler, (String)"executorHandler");
        Intrinsics.checkNotNullParameter((Object)prcHttpClient, (String)"prcHttpClient");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        Intrinsics.checkNotNullParameter((Object)jiraMetadataService, (String)"jiraMetadataService");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)clusterManager, (String)"clusterManager");
        Intrinsics.checkNotNullParameter((Object)clusterMessageService, (String)"clusterMessageService");
        Intrinsics.checkNotNullParameter((Object)commandRepository, (String)"commandRepository");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.executorHandler = executorHandler;
        this.prcHttpClient = prcHttpClient;
        this.discoveryService = discoveryService;
        this.schedulerService = schedulerService;
        this.jiraMetadataService = jiraMetadataService;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
        this.migrationFeatures = migrationFeatures;
        this.clusterManager = clusterManager;
        this.clusterMessageService = clusterMessageService;
        this.commandRepository = commandRepository;
        this.executorService = Executors.newCachedThreadPool();
        this.onDemandPrcPoller = new OnDemandPrcPoller(null, 1, null);
        Cache cache2 = cacheManager.getCache(POLLER_CACHE_NAME, null, CACHE_SETTINGS);
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"getCache(...)");
        this.pollerCache = cache2;
        this.pollerStatisticsCounter = new MigrationPollerStatisticsCounter();
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    @PostConstruct
    public final void initialise() {
        log.info((Object)("Registering MIG_POLLER_CHANNEL Listener on " + this.clusterManager.getNodeId()));
        this.clusterMessageService.registerListener(CLUSTER_MESSAGE_CHANNEL, (ClusterMessageConsumer)this);
    }

    @PreDestroy
    public final void shutdown() {
        this.executorService.shutdown();
        this.clusterMessageService.unregisterListener(CLUSTER_MESSAGE_CHANNEL, (ClusterMessageConsumer)this);
        log.info((Object)("Deregistering MIG_POLLER_CHANNEL Listener on " + this.clusterManager.getNodeId() + ", and shutting down MigrationPoller"));
    }

    @NotNull
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest jobRunnerRequest) {
        Intrinsics.checkNotNullParameter((Object)jobRunnerRequest, (String)"jobRunnerRequest");
        String string = jobRunnerRequest.getJobId().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String migrationId = StringsKt.removePrefix((String)string, (CharSequence)JOB_PREFIX);
        if (this.isPollerActive(migrationId)) {
            log.info((Object)("Polling already active for migration ID: " + migrationId + '.'));
        } else {
            log.info((Object)("No active polling for migration ID: " + migrationId + ". Starting new polling thread."));
            this.initiatePoller(migrationId);
        }
        JobRunnerResponse jobRunnerResponse = JobRunnerResponse.success((String)"Check job executed successfully.");
        Intrinsics.checkNotNullExpressionValue((Object)jobRunnerResponse, (String)"success(...)");
        return jobRunnerResponse;
    }

    public void receive(@Nullable String channel, @Nullable String message, @Nullable String senderId) {
        CommandMessage commandMessage = (CommandMessage)this.objectMapper.readValue(message, CommandMessage.class);
        Intrinsics.checkNotNull((Object)commandMessage);
        if (this.isMessageForCurrentNode(commandMessage)) {
            Command command = this.commandRepository.getCommandById(commandMessage.getCommandRepositoryId());
            StringBuilder stringBuilder = new StringBuilder().append("Command has been received for processing by ");
            String string = this.clusterManager.getNodeId();
            if (string == null) {
                string = "default";
            }
            log.info((Object)stringBuilder.append(string).toString());
            this.pollerStatisticsCounter.incrementExecution(commandMessage.getMigrationId(), commandMessage.getNodeId());
            Command command2 = command;
            Intrinsics.checkNotNull((Object)command2);
            this.executeCommand(command2);
        }
    }

    public final void startPolling(@NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        JobRunnerKey jobRunnerKey = this.buildJobKey(migrationId);
        this.schedulerService.registerJobRunner(jobRunnerKey, (JobRunner)this);
        this.schedulerService.scheduleJob(this.buildJobId(migrationId), JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)JOB_INTERVAL, (Date)Date.from(Instant.now()))));
        log.info((Object)("Started the Job for migration ID: " + migrationId + '.'));
    }

    public final void stopPolling(@NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        JobId jobId = this.buildJobId(migrationId);
        JobRunnerKey jobRunnerKey = this.buildJobKey(migrationId);
        this.schedulerService.unscheduleJob(jobId);
        this.schedulerService.unregisterJobRunner(jobRunnerKey);
        this.stopPoller(migrationId);
        log.info((Object)("Stopped polling for migration ID: " + migrationId + '.'));
    }

    private final void initiatePoller(String migrationId) {
        this.pollerCache.put((Object)migrationId, (Object)Instant.now().toEpochMilli());
        this.executorService.submit(() -> MigrationPoller.initiatePoller$lambda$0(this, migrationId));
    }

    private final void checkThrottling() {
        if (this.migrationFeatures.getShouldThrottleMigrationPoller()) {
            log.info((Object)"Throttling has occurred, poller is sleeping for 5000");
            Thread.sleep(5000L);
        }
    }

    private final synchronized void poll(CloudSite cloudSite2, String migrationId) {
        OnDemandPollerConfig pollerConfig = this.getPollerConfig(cloudSite2);
        log.info((Object)("Polling for Commands " + pollerConfig.getCommands()));
        if (pollerConfig.getCommands().isEmpty()) {
            log.info((Object)"No need to poll for commands");
            return;
        }
        this.pollerStatisticsCounter.incrementPoll(migrationId);
        Command command = this.onDemandPrcPoller.pollAndDeliver(pollerConfig);
        if (command != null) {
            log.info((Object)("Command received " + command));
            if (this.clusterManager.isClustered()) {
                this.issueCommandToCluster(command, migrationId);
            } else {
                log.info((Object)"Command being issued directly, no clustering");
                Long commandRepositoryId = this.commandRepository.saveCommand(command, this.clusterManager.getNodeId());
                log.info((Object)("Command " + commandRepositoryId + " has been saved to the database"));
                String string = this.clusterManager.getNodeId();
                Long l = commandRepositoryId;
                Intrinsics.checkNotNull((Object)l);
                CommandMessage message = new CommandMessage(string, migrationId, l);
                this.receive(CLUSTER_MESSAGE_CHANNEL, this.objectMapper.writeValueAsString((Object)message), null);
            }
        }
    }

    @VisibleForTesting
    public final void issueCommandToCluster(@NotNull Command command, @NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        this.refreshClusterStatus();
        String nodeId = this.getEligibleNodeForCommand(command.getName());
        Long commandRepositoryId = this.commandRepository.saveCommand(command, nodeId);
        log.info((Object)("Command " + commandRepositoryId + " has been saved to the database"));
        Long l = commandRepositoryId;
        Intrinsics.checkNotNull((Object)l);
        CommandMessage message = new CommandMessage(nodeId, migrationId, l);
        if (Intrinsics.areEqual((Object)nodeId, (Object)this.clusterManager.getNodeId())) {
            log.info((Object)"Command is for the current node in the cluster, will issue directly.");
            this.receive(CLUSTER_MESSAGE_CHANNEL, this.objectMapper.writeValueAsString((Object)message), this.clusterManager.getNodeId());
        } else {
            log.info((Object)("Command being passed to the clusterMessageService for node [" + nodeId + ']'));
            this.clusterMessageService.sendRemote(CLUSTER_MESSAGE_CHANNEL, this.objectMapper.writeValueAsString((Object)message));
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void refreshClusterStatus() {
        void $this$mapNotNullTo$iv$iv;
        this.clusterManager.refreshLiveNodes();
        Collection collection = this.clusterManager.findLiveNodes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findLiveNodes(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Node it = (Node)element$iv$iv;
            boolean bl2 = false;
            if (it.getNodeId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set liveNodes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.commandRepository.deleteForDeadNodes(liveNodes);
        this.logCurrentConcurrency();
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final String getEligibleNodeForCommand(@NotNull String commandName) {
        void $this$filterTo$iv$iv;
        Long l;
        Map map;
        Object object;
        Object element$iv$iv3;
        void $this$filterTo$iv$iv2;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
        Collection collection = this.clusterManager.findLiveNodes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findLiveNodes(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Node it = (Node)element$iv$iv2;
            boolean bl2 = false;
            if (it.getNodeId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set liveNodes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List<NodeCommandCount> nodeCommandCounts = this.commandRepository.getNodeCommandCounts();
        Iterable $this$filter$iv = nodeCommandCounts;
        boolean $i$f$filter = false;
        Iterable $i$f$mapNotNullTo22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv2) {
            NodeCommandCount it = (NodeCommandCount)element$iv$iv3;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getCommandName(), (Object)commandName)) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        List filteredCommandCounts = (List)destination$iv$iv2;
        Iterable $this$associateWith$iv = liveNodes;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv2 : $this$associateWithTo$iv$iv) {
            Object v1;
            block16: {
                String bl = (String)element$iv$iv2;
                object = element$iv$iv2;
                map = result$iv;
                boolean bl4 = false;
                Iterable bl2 = filteredCommandCounts;
                for (Object bl3 : bl2) {
                    void nodeId;
                    NodeCommandCount it = (NodeCommandCount)bl3;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)it.getNodeId(), (Object)nodeId)) continue;
                    v1 = bl3;
                    break block16;
                }
                v1 = null;
            }
            NodeCommandCount nodeCommandCount = v1;
            l = nodeCommandCount != null ? nodeCommandCount.getCount() : 0L;
            map.put(object, l);
        }
        Map liveNodeCommandCounts = result$iv;
        Long l2 = (Long)CollectionsKt.minOrNull((Iterable)liveNodeCommandCounts.values());
        if (l2 == null) {
            throw new NoSuchElementException("No live node found for processing: " + commandName);
        }
        long minCount = l2;
        Map $this$filter$iv2 = liveNodeCommandCounts;
        boolean $i$f$filter2 = false;
        element$iv$iv3 = $this$filter$iv2;
        Map destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$filterTo2 = false;
        Iterator bl4 = $this$filterTo$iv$iv.entrySet().iterator();
        while (bl4.hasNext()) {
            Map.Entry element$iv$iv4;
            Map.Entry it = element$iv$iv4 = bl4.next();
            boolean bl = false;
            if (!(((Number)it.getValue()).longValue() == minCount)) continue;
            destination$iv$iv3.put(element$iv$iv4.getKey(), element$iv$iv4.getValue());
        }
        Set nodesWithMinCount = destination$iv$iv3.keySet();
        if (nodesWithMinCount.size() > 1) {
            Object v4;
            Iterable $this$associateWith$iv2 = liveNodes;
            boolean $i$f$associateWith2 = false;
            LinkedHashMap result$iv2 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv2, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv2 = $this$associateWith$iv2;
            boolean $i$f$associateWithTo2 = false;
            for (Object element$iv$iv5 : $this$associateWithTo$iv$iv2) {
                void $this$filterTo$iv$iv3;
                String bl = (String)element$iv$iv5;
                object = element$iv$iv5;
                map = result$iv2;
                boolean bl6 = false;
                Iterable $this$filter$iv3 = nodeCommandCounts;
                boolean $i$f$filter3 = false;
                Iterable iterable2 = $this$filter$iv3;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv6 : $this$filterTo$iv$iv3) {
                    void nodeId;
                    NodeCommandCount it = (NodeCommandCount)element$iv$iv6;
                    boolean bl7 = false;
                    if (!Intrinsics.areEqual((Object)it.getNodeId(), (Object)nodeId)) continue;
                    destination$iv$iv4.add(element$iv$iv6);
                }
                Iterable iterable3 = (List)destination$iv$iv4;
                long l3 = 0L;
                for (Object t : iterable3) {
                    void it;
                    NodeCommandCount nodeCommandCount = (NodeCommandCount)t;
                    long l4 = l3;
                    boolean bl8 = false;
                    long l5 = it.getCount();
                    l3 = l4 + l5;
                }
                l = l3;
                map.put(object, l);
            }
            Map totalCommandCounts = result$iv2;
            Iterable $this$minByOrNull$iv = nodesWithMinCount;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v4 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v4 = minElem$iv;
                } else {
                    String it = (String)minElem$iv;
                    boolean bl = false;
                    Long l6 = (Long)totalCommandCounts.get(it);
                    long minValue$iv = l6 != null ? l6 : Long.MAX_VALUE;
                    do {
                        long v$iv;
                        Object e$iv = iterator$iv.next();
                        String it2 = (String)e$iv;
                        $i$a$-minByOrNull-MigrationPoller$getEligibleNodeForCommand$1 = false;
                        Long l7 = (Long)totalCommandCounts.get(it2);
                        long l8 = v$iv = l7 != null ? l7 : Long.MAX_VALUE;
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v4 = minElem$iv;
                }
            }
            String string = v4;
            if (string == null) {
                throw new NoSuchElementException("No eligible node found for processing: " + commandName);
            }
            return string;
        }
        return (String)CollectionsKt.first((Iterable)nodesWithMinCount);
    }

    private final JobRunnerKey buildJobKey(String migrationId) {
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)("migration-poller-job-key-" + migrationId));
        Intrinsics.checkNotNullExpressionValue((Object)jobRunnerKey, (String)"of(...)");
        return jobRunnerKey;
    }

    private final JobId buildJobId(String migrationId) {
        JobId jobId = JobId.of((String)(JOB_PREFIX + migrationId));
        Intrinsics.checkNotNullExpressionValue((Object)jobId, (String)"of(...)");
        return jobId;
    }

    private final void stopPoller(String migrationId) {
        this.pollerCache.remove((Object)migrationId);
        log.info((Object)("Removed migration ID: " + migrationId + " from cache to stop the poller."));
    }

    @VisibleForTesting
    public final boolean isPollerActive(@NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Long lastPolledTime = (Long)this.pollerCache.get((Object)migrationId);
        return lastPolledTime != null && Duration.between(Instant.ofEpochMilli(lastPolledTime), Instant.now()).toMillis() <= 70000L;
    }

    private final OnDemandPollerConfig getPollerConfig(CloudSite cloudSite2) {
        List<String> eligibleCommands = this.getEligibleCommands();
        String string = CHANNEL_NAME_PREFIX + this.jiraMetadataService.getJiraServerId();
        String string2 = cloudSite2.getCloudId();
        String string3 = cloudSite2.getContainerToken();
        Function4<URL, Map<String, String>, PrcRequest, Boolean, Response> function4 = this.prcHttpClient.getPushAndPollAsCallback();
        String string4 = this.prcHttpClient.getBaseUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return new OnDemandPollerConfig(string, string2, string3, function4, string4, eligibleCommands, null, true, 64, null);
    }

    @VisibleForTesting
    public final void executeCommand(@NotNull Command command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        log.info((Object)("Received command " + command.getName()));
        this.executorHandler.execute(command, (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this, command){
            final /* synthetic */ MigrationPoller this$0;
            final /* synthetic */ Command $command;
            {
                this.this$0 = $receiver;
                this.$command = $command;
                super(1);
            }

            public final void invoke(@Nullable Throwable throwable) {
                MigrationPoller.access$getCommandRepository$p(this.this$0).deleteCommandByCommandId(this.$command.getId());
                if (throwable != null) {
                    MigrationPoller.access$getLog$cp().error((Object)("Error executing command: " + this.$command), throwable);
                } else {
                    MigrationPoller.access$getLog$cp().info((Object)("Command executed successfully: " + this.$command));
                }
                MigrationPoller.access$logCurrentConcurrency(this.this$0);
            }
        }));
    }

    private final boolean isMessageForCurrentNode(CommandMessage commandMessage) {
        return commandMessage.isServer() || Intrinsics.areEqual((Object)this.clusterManager.getNodeId(), (Object)commandMessage.getNodeId());
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final List<String> getEligibleCommands() {
        void $this$filterTo$iv$iv;
        Map<String, Long> currentCommandCounts = this.commandRepository.getCurrentCommandCounts();
        Iterable $this$filter$iv = CONCURRENCY_LIMITS.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String command = (String)element$iv$iv;
            boolean bl = false;
            int maxConcurrency = ((Number)CONCURRENCY_LIMITS.getOrDefault(command, 1)).intValue();
            Long l = currentCommandCounts.get(command);
            long currentCount = l != null ? l : 0L;
            if (!(currentCount < (long)maxConcurrency)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void logCurrentConcurrency() {
        StringBuilder stringBuilder;
        Map<String, Long> commandCounts = this.commandRepository.getCurrentCommandCounts();
        StringBuilder $this$logCurrentConcurrency_u24lambda_u2413 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$logCurrentConcurrency_u24lambda_u2413.append("Total Concurrency Across All Commands: ");
        Map<String, Long> $this$forEach$iv = commandCounts;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Long>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Long> element$iv;
            Map.Entry<String, Long> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            String command = entry.getKey();
            long totalCount = ((Number)entry.getValue()).longValue();
            $this$logCurrentConcurrency_u24lambda_u2413.append('[' + command + ": " + totalCount + "] ");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String logMessage = string;
        log.info((Object)logMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void initiatePoller$lambda$0(MigrationPoller this$0, String $migrationId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$migrationId, (String)"$migrationId");
        try {
            JiraThreadLocalUtil jiraThreadLocalUtil = this$0.jiraThreadLocalUtil;
            Logger logger2 = log;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
            JiraExtensionsKt.wrap(jiraThreadLocalUtil, logger2, (Function0)new Function0<Unit>(this$0, $migrationId){
                final /* synthetic */ MigrationPoller this$0;
                final /* synthetic */ String $migrationId;
                {
                    this.this$0 = $receiver;
                    this.$migrationId = $migrationId;
                    super(0);
                }

                public final void invoke() {
                    long backoffTime = 1000L;
                    while (!Thread.currentThread().isInterrupted() && MigrationPoller.access$getPollerCache$p(this.this$0).get((Object)this.$migrationId) != null) {
                        try {
                            MigrationPoller.access$getPollerCache$p(this.this$0).put((Object)this.$migrationId, (Object)Instant.now().toEpochMilli());
                            MigrationPoller.access$checkThrottling(this.this$0);
                            CloudSite cloudSite2 = MigrationPoller.access$getDiscoveryService$p(this.this$0).retrieveCloudSiteFor(this.$migrationId, true);
                            if (cloudSite2 != null) {
                                MigrationPoller.access$poll(this.this$0, cloudSite2, this.$migrationId);
                                backoffTime = 1000L;
                                continue;
                            }
                            MigrationPoller.access$getLog$cp().warn((Object)("Could not retrieve CloudSite for migration ID: " + this.$migrationId + '.'));
                            break;
                        }
                        catch (Exception e) {
                            MigrationPoller.access$getLog$cp().error((Object)("Error in polling thread for migration ID: " + this.$migrationId + ". Backing off for " + backoffTime), (Throwable)e);
                            MigrationPoller.access$getPollerStatisticsCounter$p(this.this$0).incrementPollError(this.$migrationId);
                            Thread.sleep(backoffTime);
                            backoffTime = RangesKt.coerceAtMost((long)(backoffTime * (long)2), (long)60000L);
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            log.info((Object)("Polling thread interrupted for migration ID: " + $migrationId + '.'));
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error((Object)("Error in polling thread for migration ID: " + $migrationId + '.'), (Throwable)e);
        }
        finally {
            this$0.pollerCache.remove((Object)$migrationId);
        }
    }

    public static final /* synthetic */ MigV4CommandRepository access$getCommandRepository$p(MigrationPoller $this) {
        return $this.commandRepository;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ void access$logCurrentConcurrency(MigrationPoller $this) {
        $this.logCurrentConcurrency();
    }

    public static final /* synthetic */ Cache access$getPollerCache$p(MigrationPoller $this) {
        return $this.pollerCache;
    }

    public static final /* synthetic */ void access$checkThrottling(MigrationPoller $this) {
        $this.checkThrottling();
    }

    public static final /* synthetic */ DiscoveryService access$getDiscoveryService$p(MigrationPoller $this) {
        return $this.discoveryService;
    }

    public static final /* synthetic */ void access$poll(MigrationPoller $this, CloudSite cloudSite2, String migrationId) {
        $this.poll(cloudSite2, migrationId);
    }

    public static final /* synthetic */ MigrationPollerStatisticsCounter access$getPollerStatisticsCounter$p(MigrationPoller $this) {
        return $this.pollerStatisticsCounter;
    }

    static {
        CacheSettings cacheSettings = new CacheSettingsBuilder().replicateViaCopy().remote().build();
        Intrinsics.checkNotNullExpressionValue((Object)cacheSettings, (String)"build(...)");
        CACHE_SETTINGS = cacheSettings;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)CommandName.ALL_USER_UPLOAD.getValue(), (Object)2), TuplesKt.to((Object)CommandName.JIRA_PROJECT_UPLOAD.getValue(), (Object)8), TuplesKt.to((Object)CommandName.APP_DATA_PRELOAD_NOTIFICATION.getValue(), (Object)1), TuplesKt.to((Object)CommandName.APP_DATA_PRELOAD.getValue(), (Object)2), TuplesKt.to((Object)CommandName.JIRA_CROSS_PROJECT_UPLOAD.getValue(), (Object)1), TuplesKt.to((Object)CommandName.ALL_CUSTOMER_UPLOAD.getValue(), (Object)2), TuplesKt.to((Object)CommandName.JIRA_ATTACHMENT_UPLOAD.getValue(), (Object)2), TuplesKt.to((Object)CommandName.ASSETS_DATA_UPLOAD.getValue(), (Object)1)};
        CONCURRENCY_LIMITS = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/polly/MigrationPoller$CommandMessage;", "", "nodeId", "", "migrationId", "commandRepositoryId", "", "(Ljava/lang/String;Ljava/lang/String;J)V", "getCommandRepositoryId", "()J", "getMigrationId", "()Ljava/lang/String;", "getNodeId", "isServer", "", "jira-migration-plugin"})
    public static final class CommandMessage {
        @Nullable
        private final String nodeId;
        @NotNull
        private final String migrationId;
        private final long commandRepositoryId;

        public CommandMessage(@Nullable String nodeId, @NotNull String migrationId, long commandRepositoryId) {
            Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
            this.nodeId = nodeId;
            this.migrationId = migrationId;
            this.commandRepositoryId = commandRepositoryId;
        }

        @Nullable
        public final String getNodeId() {
            return this.nodeId;
        }

        @NotNull
        public final String getMigrationId() {
            return this.migrationId;
        }

        public final long getCommandRepositoryId() {
            return this.commandRepositoryId;
        }

        @JsonIgnore
        public final boolean isServer() {
            CharSequence charSequence = this.nodeId;
            return charSequence == null || charSequence.length() == 0;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/polly/MigrationPoller$Companion;", "", "()V", "CACHE_SETTINGS", "Lcom/atlassian/cache/CacheSettings;", "CHANNEL_NAME_PREFIX", "", "CLUSTER_MESSAGE_CHANNEL", "CONCURRENCY_LIMITS", "", "", "getCONCURRENCY_LIMITS", "()Ljava/util/Map;", "INITIAL_BACKOFF_TIME", "", "JOB_INTERVAL", "JOB_PREFIX", "LAST_POLL_TIME_THRESHOLD", "MAX_BACKOFF_TIME", "POLLER_CACHE_NAME", "THROTTLE_TIME", "log", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, Integer> getCONCURRENCY_LIMITS() {
            return CONCURRENCY_LIMITS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

