/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.polly;

import com.atlassian.jira.migration.metrics.PrometheusMetrics;
import io.prometheus.metrics.core.datapoints.CounterDataPoint;
import io.prometheus.metrics.core.metrics.Counter;
import io.prometheus.metrics.model.registry.Collector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/jira/migration/polly/MigrationPollerStatisticsCounter;", "", "()V", "executeCounter", "Lio/prometheus/metrics/core/metrics/Counter;", "pollCounter", "pollErrorCounter", "incrementExecution", "", "migrationId", "", "nodeId", "incrementPoll", "incrementPollError", "jira-migration-plugin"})
public final class MigrationPollerStatisticsCounter {
    @NotNull
    private final Counter pollCounter;
    @NotNull
    private final Counter executeCounter;
    @NotNull
    private final Counter pollErrorCounter;

    public MigrationPollerStatisticsCounter() {
        String[] stringArray = new String[]{"migration_id"};
        Collector collector = PrometheusMetrics.Companion.registerSilently((Collector)((Counter.Builder)Counter.builder().name("jcma.core.v4.migrationPoller.poll.count").labelNames(stringArray)).build());
        Intrinsics.checkNotNullExpressionValue((Object)collector, (String)"registerSilently(...)");
        this.pollCounter = (Counter)collector;
        stringArray = new String[]{"migration_id", "node_id"};
        Collector collector2 = PrometheusMetrics.Companion.registerSilently((Collector)((Counter.Builder)Counter.builder().name("jcma.core.v4.migrationPoller.execute.count").labelNames(stringArray)).build());
        Intrinsics.checkNotNullExpressionValue((Object)collector2, (String)"registerSilently(...)");
        this.executeCounter = (Counter)collector2;
        stringArray = new String[]{"migration_id"};
        Collector collector3 = PrometheusMetrics.Companion.registerSilently((Collector)((Counter.Builder)Counter.builder().name("jcma.core.v4.migrationPoller.poll.error.count").labelNames(stringArray)).build());
        Intrinsics.checkNotNullExpressionValue((Object)collector3, (String)"registerSilently(...)");
        this.pollErrorCounter = (Counter)collector3;
    }

    public final void incrementExecution(@NotNull String migrationId, @Nullable String nodeId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        String[] stringArray = new String[2];
        stringArray[0] = migrationId;
        String string = nodeId;
        if (string == null) {
            string = "default";
        }
        stringArray[1] = string;
        ((CounterDataPoint)this.executeCounter.labelValues(stringArray)).inc();
    }

    public final void incrementPoll(@NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        String[] stringArray = new String[]{migrationId};
        ((CounterDataPoint)this.pollCounter.labelValues(stringArray)).inc();
    }

    public final void incrementPollError(@NotNull String migrationId) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        String[] stringArray = new String[]{migrationId};
        ((CounterDataPoint)this.pollErrorCounter.labelValues(stringArray)).inc();
    }
}

