/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.prc;

import com.atlassian.jira.migration.GroupedThreadFactory;
import com.atlassian.jira.migration.prc.PollerConfigHandler;
import com.atlassian.jira.migration.prc.PollerMetadataCache;
import com.atlassian.jira.migration.prc.PollerSchedulerService;
import com.atlassian.jira.migration.progress.v3.ConvertorHelpers;
import com.atlassian.migration.prc.client.PollerExecutionService;
import com.atlassian.migration.prc.client.PrcServiceClient;
import com.atlassian.migration.prc.client.model.PrcErrorCode;
import com.atlassian.migration.prc.client.model.PrcException;
import com.atlassian.migration.prc.client.model.StartPollTaskResponse;
import com.atlassian.migration.prc.client.model.config.ScheduledPollerConfig;
import com.atlassian.migration.prc.client.poller.ScheduledPrcPoller;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.status.JobDetails;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0003./0B\u001f\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0016J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000fH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u000fH\u0002J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u000fH\u0007J\b\u0010&\u001a\u00020\u0014H\u0007J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u000fH\u0002J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\u0010\u0010-\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u000fH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/atlassian/jira/migration/prc/PollerExecutionServiceImpl;", "Lcom/atlassian/migration/prc/client/PollerExecutionService;", "Lcom/atlassian/scheduler/JobRunner;", "pollerSchedulerService", "Lcom/atlassian/jira/migration/prc/PollerSchedulerService;", "pollerConfigHandler", "Lcom/atlassian/jira/migration/prc/PollerConfigHandler;", "pollerMetadataCache", "Lcom/atlassian/jira/migration/prc/PollerMetadataCache;", "(Lcom/atlassian/jira/migration/prc/PollerSchedulerService;Lcom/atlassian/jira/migration/prc/PollerConfigHandler;Lcom/atlassian/jira/migration/prc/PollerMetadataCache;)V", "localExecutorService", "Ljava/util/concurrent/ScheduledExecutorService;", "taskPollers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/atlassian/jira/migration/prc/PollerExecutionServiceImpl$PollerTaskContext;", "(Lcom/atlassian/jira/migration/prc/PollerSchedulerService;Lcom/atlassian/jira/migration/prc/PollerConfigHandler;Lcom/atlassian/jira/migration/prc/PollerMetadataCache;Ljava/util/concurrent/ScheduledExecutorService;Ljava/util/concurrent/ConcurrentHashMap;)V", "prcServiceClient", "Lcom/atlassian/migration/prc/client/PrcServiceClient;", "cleanup", "", "createPollerIfNotExist", "requestStartTime", "", "pollerConfig", "Lcom/atlassian/migration/prc/client/model/config/ScheduledPollerConfig;", "getExistingScheduledPrcPoller", "Lcom/atlassian/migration/prc/client/poller/ScheduledPrcPoller;", "cloudId", "handlePollerException", "exception", "", "context", "handlePolling", "Lcom/atlassian/migration/prc/client/model/StartPollTaskResponse;", "initiatePolling", "pollerTaskContext", "pollTask", "postConstruct", "runJob", "Lcom/atlassian/scheduler/JobRunnerResponse;", "request", "Lcom/atlassian/scheduler/JobRunnerRequest;", "schedulePollerCheck", "stopPolling", "throwIfStaleJob", "Companion", "PollerTaskContext", "StalePollerJobException", "jira-migration-plugin"})
public final class PollerExecutionServiceImpl
implements PollerExecutionService,
JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PollerSchedulerService pollerSchedulerService;
    @NotNull
    private final PollerConfigHandler pollerConfigHandler;
    @NotNull
    private final PollerMetadataCache pollerMetadataCache;
    @NotNull
    private final ScheduledExecutorService localExecutorService;
    @NotNull
    private final ConcurrentHashMap<String, PollerTaskContext> taskPollers;
    @NotNull
    private final PrcServiceClient prcServiceClient;
    private static final Logger log = LoggerFactory.getLogger(PollerExecutionServiceImpl.class);
    @NotNull
    private static final String POLLER_STARTED = "Poller started successfully for cloudId = %s";
    private static final long INITIAL_DELAY_IN_SEC = 0L;
    private static final long ONE_MINUTE = 1L;
    @NotNull
    private static final String POLLER_TERMINATED = "Poller for cloudId = %s has been terminated due to exception";
    @NotNull
    private static final String STALE_JOB_EXCEPTION = "Terminating Poller having stale startTime = %s, whereas latest startTime = %s";

    public PollerExecutionServiceImpl(@NotNull PollerSchedulerService pollerSchedulerService, @NotNull PollerConfigHandler pollerConfigHandler, @NotNull PollerMetadataCache pollerMetadataCache, @NotNull ScheduledExecutorService localExecutorService, @NotNull ConcurrentHashMap<String, PollerTaskContext> taskPollers) {
        Intrinsics.checkNotNullParameter((Object)pollerSchedulerService, (String)"pollerSchedulerService");
        Intrinsics.checkNotNullParameter((Object)pollerConfigHandler, (String)"pollerConfigHandler");
        Intrinsics.checkNotNullParameter((Object)pollerMetadataCache, (String)"pollerMetadataCache");
        Intrinsics.checkNotNullParameter((Object)localExecutorService, (String)"localExecutorService");
        Intrinsics.checkNotNullParameter(taskPollers, (String)"taskPollers");
        this.pollerSchedulerService = pollerSchedulerService;
        this.pollerConfigHandler = pollerConfigHandler;
        this.pollerMetadataCache = pollerMetadataCache;
        this.localExecutorService = localExecutorService;
        this.taskPollers = taskPollers;
        this.prcServiceClient = new PrcServiceClient();
    }

    @Inject
    public PollerExecutionServiceImpl(@NotNull PollerSchedulerService pollerSchedulerService, @NotNull PollerConfigHandler pollerConfigHandler, @NotNull PollerMetadataCache pollerMetadataCache) {
        Intrinsics.checkNotNullParameter((Object)pollerSchedulerService, (String)"pollerSchedulerService");
        Intrinsics.checkNotNullParameter((Object)pollerConfigHandler, (String)"pollerConfigHandler");
        Intrinsics.checkNotNullParameter((Object)pollerMetadataCache, (String)"pollerMetadataCache");
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new GroupedThreadFactory("PollerExecutionServiceImpl"));
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor(...)");
        this(pollerSchedulerService, pollerConfigHandler, pollerMetadataCache, scheduledExecutorService, new ConcurrentHashMap<String, PollerTaskContext>());
    }

    @PostConstruct
    public final void postConstruct() {
        this.pollerSchedulerService.registerJobRunner(this);
    }

    @PreDestroy
    public final void cleanup() {
        this.pollerSchedulerService.unregisterJobRunner();
        this.localExecutorService.shutdown();
    }

    @Nullable
    public ScheduledPrcPoller getExistingScheduledPrcPoller(@NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        PollerTaskContext pollerTaskContext = this.taskPollers.get(cloudId2);
        return pollerTaskContext != null ? pollerTaskContext.getScheduledPrcPoller() : null;
    }

    @NotNull
    public StartPollTaskResponse handlePolling(@NotNull ScheduledPollerConfig pollerConfig) {
        PollerTaskContext pollerTaskContext;
        Intrinsics.checkNotNullParameter((Object)pollerConfig, (String)"pollerConfig");
        long pollStartTime = System.currentTimeMillis();
        Object object = this.taskPollers;
        Object[] objectArray = pollerConfig.getCloudId();
        PollerTaskContext context = pollerTaskContext = new PollerTaskContext(new ScheduledPrcPoller(pollerConfig, this.prcServiceClient), pollStartTime);
        boolean bl = false;
        this.initiatePolling(context);
        this.pollerMetadataCache.registerPollerExecutionTracker(context.getScheduledPrcPoller().getPollerConfig().getCloudId(), pollStartTime);
        this.schedulePollerCheck(context);
        object.put(objectArray, pollerTaskContext);
        object = POLLER_STARTED;
        objectArray = new Object[]{pollerConfig.getCloudId()};
        String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return new StartPollTaskResponse(string);
    }

    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest request) {
        PollerTaskContext pollerTaskContext;
        block6: {
            ScheduledPollerConfig pollerConfig;
            block5: {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Map map = request.getJobConfig().getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getParameters(...)");
                pollerConfig = this.pollerConfigHandler.getConfigFromFromParams(map);
                Long l = ConvertorHelpers.Companion.asLongOrNull(request.getJobConfig().getParameters().get("jobStartTime"));
                Intrinsics.checkNotNull((Object)l);
                long startTime = l;
                long pollerLastExecutionTime = this.pollerMetadataCache.getPollerLastExecutionTime(pollerConfig.getCloudId());
                if (TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - pollerLastExecutionTime) < 1L) {
                    return JobRunnerResponse.success();
                }
                pollerTaskContext = this.createPollerIfNotExist(startTime, pollerConfig);
                if (pollerTaskContext == null) break block5;
                PollerTaskContext pollerContext = pollerTaskContext;
                boolean bl = false;
                if (!pollerContext.getScheduledPrcPoller().isRunning()) {
                    this.initiatePolling(pollerContext);
                }
                JobRunnerResponse jobRunnerResponse = JobRunnerResponse.success();
                pollerTaskContext = jobRunnerResponse;
                if (jobRunnerResponse != null) break block6;
            }
            PollerExecutionServiceImpl $this$runJob_u24lambda_u242 = this;
            boolean bl = false;
            $this$runJob_u24lambda_u242.pollerSchedulerService.unscheduleJobForCloudId(pollerConfig.getCloudId());
            log.info("unscheduled Job for cloudId = " + pollerConfig.getCloudId() + " to stop PRC polling");
            pollerTaskContext = JobRunnerResponse.aborted((String)("Stop Poll check for cloudId = " + pollerConfig.getCloudId()));
        }
        return pollerTaskContext;
    }

    private final void initiatePolling(PollerTaskContext pollerTaskContext) {
        pollerTaskContext.getScheduledPrcPoller().setToRunning();
        this.localExecutorService.scheduleWithFixedDelay(() -> PollerExecutionServiceImpl.initiatePolling$lambda$3(this, pollerTaskContext), 0L, pollerTaskContext.getScheduledPrcPoller().getPollerConfig().getPollingDelayInSec(), TimeUnit.SECONDS);
    }

    @VisibleForTesting
    public final void pollTask(@NotNull PollerTaskContext context) {
        block2: {
            Throwable throwable;
            Object $this$pollTask_u24lambda_u244;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object = this;
            try {
                $this$pollTask_u24lambda_u244 = object;
                boolean bl = false;
                super.throwIfStaleJob(context);
                context.getScheduledPrcPoller().pollAndExecute();
                $this$pollTask_u24lambda_u244 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$pollTask_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            Object it = object = $this$pollTask_u24lambda_u244;
            boolean bl = false;
            this.pollerMetadataCache.updatePollerExecutionTime(context.getScheduledPrcPoller().getPollerConfig().getCloudId());
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 == null) break block2;
            Throwable exception = throwable = throwable2;
            boolean bl2 = false;
            this.handlePollerException(exception, context);
        }
    }

    private final void throwIfStaleJob(PollerTaskContext pollerTaskContext) {
        String cloudId2 = pollerTaskContext.getScheduledPrcPoller().getPollerConfig().getCloudId();
        long latestJobStartTime = this.pollerMetadataCache.getPollerLatestStartTime(cloudId2);
        if (latestJobStartTime > pollerTaskContext.getJobStartTime()) {
            this.taskPollers.remove(cloudId2, pollerTaskContext);
            String string = STALE_JOB_EXCEPTION;
            Object[] objectArray = new Object[]{pollerTaskContext.getJobStartTime(), latestJobStartTime};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new StalePollerJobException(string2);
        }
    }

    private final void handlePollerException(Throwable exception, PollerTaskContext context) {
        String cloudId2 = context.getScheduledPrcPoller().getPollerConfig().getCloudId();
        boolean shouldTerminatePolling = context.getScheduledPrcPoller().shouldBeTerminated(exception);
        if (shouldTerminatePolling) {
            this.stopPolling(cloudId2);
        }
        if (exception instanceof StalePollerJobException || shouldTerminatePolling) {
            String string = POLLER_TERMINATED;
            Object[] objectArray = new Object[]{cloudId2};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            log.error(string2, exception);
            throw new PrcException(PrcErrorCode.POLLER_TERMINATED, exception.getMessage(), null, 4, null);
        }
        log.debug("Error while polling from PRC for cloudId = " + cloudId2, exception);
    }

    /*
     * WARNING - void declaration
     */
    private final void schedulePollerCheck(PollerTaskContext context) {
        void it;
        HashMap<String, Serializable> hashMap;
        String cloudId2 = context.getScheduledPrcPoller().getPollerConfig().getCloudId();
        HashMap<String, Serializable> hashMap2 = hashMap = this.pollerConfigHandler.getJobParametersFromConfig(context.getScheduledPrcPoller().getPollerConfig());
        String string = cloudId2;
        PollerSchedulerService pollerSchedulerService = this.pollerSchedulerService;
        boolean bl = false;
        ((Map)it).put("jobStartTime", context.getJobStartTime());
        ((Map)it).put("triggeredByUserId", this.pollerMetadataCache.addApplicationUser(cloudId2));
        Unit unit = Unit.INSTANCE;
        pollerSchedulerService.scheduleJobForCloudId(string, (Map<String, ? extends Serializable>)hashMap);
        log.info("Successfully scheduled job for cloudId = " + cloudId2 + " at time " + Instant.now());
    }

    private final PollerTaskContext createPollerIfNotExist(long requestStartTime, ScheduledPollerConfig pollerConfig) {
        PollerTaskContext pollerTaskContext = this.taskPollers.get(pollerConfig.getCloudId());
        if (requestStartTime > (pollerTaskContext != null ? pollerTaskContext.getJobStartTime() : 0L)) {
            long expiryTime = pollerConfig.getPollerExpiryTimeInSec() - TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - requestStartTime);
            if (expiryTime > 0L) {
                log.info("Creating a new poller for cloudId = " + pollerConfig.getCloudId() + ", startTime = " + requestStartTime);
                ScheduledPollerConfig newPollerConfig = this.pollerConfigHandler.getScheduledPollerConfigWithCallbacksAndExpiry(pollerConfig.getChannelName(), pollerConfig.getCloudId(), pollerConfig.getContainerToken(), expiryTime);
                ((Map)this.taskPollers).put(pollerConfig.getCloudId(), new PollerTaskContext(new ScheduledPrcPoller(newPollerConfig, this.prcServiceClient), requestStartTime));
            } else {
                this.taskPollers.remove(pollerConfig.getCloudId());
                log.info("Removed context from taskPollers. cloudId=" + pollerConfig.getCloudId() + ", expiryTime=" + expiryTime);
            }
        }
        return this.taskPollers.get(pollerConfig.getCloudId());
    }

    private final void stopPolling(String cloudId2) {
        block2: {
            PollerTaskContext pollerTaskContext;
            PollerTaskContext pollerTaskContext2 = this.taskPollers.remove(cloudId2);
            if (pollerTaskContext2 == null) break block2;
            PollerTaskContext pollerContext = pollerTaskContext = pollerTaskContext2;
            boolean bl = false;
            log.info("Removed context from taskPollers for cloudId = " + cloudId2);
            JobDetails jobDetails = this.pollerSchedulerService.getScheduledJobForCloudId(cloudId2);
            if (jobDetails != null) {
                JobDetails jobDetails2;
                JobDetails jobDetails3;
                JobDetails it = jobDetails3 = jobDetails;
                boolean bl2 = false;
                Long l = ConvertorHelpers.Companion.asLongOrNull(it.getParameters().get("jobStartTime"));
                long l2 = pollerContext.getJobStartTime();
                Object object = jobDetails2 = l != null && l == l2 ? jobDetails3 : null;
                if (jobDetails2 != null) {
                    it = jobDetails2;
                    boolean bl3 = false;
                    this.pollerSchedulerService.unscheduleJobForCloudId(cloudId2);
                    log.info("unscheduled Job " + it.getJobId() + " for cloudId = " + cloudId2 + " to stop PRC polling");
                }
            }
        }
    }

    private static final void initiatePolling$lambda$3(PollerExecutionServiceImpl this$0, PollerTaskContext $pollerTaskContext) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$pollerTaskContext, (String)"$pollerTaskContext");
        this$0.pollTask($pollerTaskContext);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/prc/PollerExecutionServiceImpl$Companion;", "", "()V", "INITIAL_DELAY_IN_SEC", "", "ONE_MINUTE", "POLLER_STARTED", "", "POLLER_TERMINATED", "STALE_JOB_EXCEPTION", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/prc/PollerExecutionServiceImpl$PollerTaskContext;", "", "scheduledPrcPoller", "Lcom/atlassian/migration/prc/client/poller/ScheduledPrcPoller;", "jobStartTime", "", "(Lcom/atlassian/migration/prc/client/poller/ScheduledPrcPoller;J)V", "getJobStartTime", "()J", "getScheduledPrcPoller", "()Lcom/atlassian/migration/prc/client/poller/ScheduledPrcPoller;", "jira-migration-plugin"})
    public static final class PollerTaskContext {
        @NotNull
        private final ScheduledPrcPoller scheduledPrcPoller;
        private final long jobStartTime;

        public PollerTaskContext(@NotNull ScheduledPrcPoller scheduledPrcPoller, long jobStartTime) {
            Intrinsics.checkNotNullParameter((Object)scheduledPrcPoller, (String)"scheduledPrcPoller");
            this.scheduledPrcPoller = scheduledPrcPoller;
            this.jobStartTime = jobStartTime;
        }

        @NotNull
        public final ScheduledPrcPoller getScheduledPrcPoller() {
            return this.scheduledPrcPoller;
        }

        public final long getJobStartTime() {
            return this.jobStartTime;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/prc/PollerExecutionServiceImpl$StalePollerJobException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "jira-migration-plugin"})
    private static final class StalePollerJobException
    extends RuntimeException {
        @NotNull
        private final String message;

        public StalePollerJobException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
            this.message = message;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }
    }
}

