/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.prc;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.export.core.workflow.SwfExportFacadeKt;
import com.atlassian.jira.migration.prc.PollerSchedulerService;
import com.atlassian.jira.migration.progress.v3.ConvertorHelpers;
import com.atlassian.jira.migration.publicapi.model.PublicApiException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.scheduler.status.JobDetails;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 '2\u00020\u0001:\u0002'(B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000fJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u000fJ\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u000e\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000fJ\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000fJ\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u0016\u0010!\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u0011J\u0016\u0010#\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u000fR*\u0010\r\u001a\u001e\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00110\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u001e\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00150\u00150\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/atlassian/jira/migration/prc/PollerMetadataCache;", "", "jiraAuthenticationContext", "Lcom/atlassian/jira/security/JiraAuthenticationContext;", "userManager", "Lcom/atlassian/jira/user/util/UserManager;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "pollerSchedulerService", "Lcom/atlassian/jira/migration/prc/PollerSchedulerService;", "(Lcom/atlassian/jira/security/JiraAuthenticationContext;Lcom/atlassian/jira/user/util/UserManager;Lcom/atlassian/cache/CacheManager;Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/migration/prc/PollerSchedulerService;)V", "applicationUserCache", "Lcom/atlassian/cache/Cache;", "", "kotlin.jvm.PlatformType", "", "containerTokenLocalCache", "Lcom/google/common/cache/Cache;", "pollerExecutionCache", "Lcom/atlassian/jira/migration/prc/PollerMetadataCache$PollerExecutionTracker;", "addApplicationUser", "cloudId", "clearContainerTokenLocalCache", "", "getContainerTokenForCloudId", "getPollerExecutionStatistics", "getPollerLastExecutionTime", "getPollerLatestStartTime", "handleApplicationUserCacheMiss", "(Ljava/lang/String;)Ljava/lang/Long;", "handleExecutionTimeCacheMiss", "registerPollerExecutionTracker", "jobStartTime", "setUserContextOrThrow", "exception", "Lcom/atlassian/jira/migration/publicapi/model/PublicApiException;", "updatePollerExecutionTime", "Companion", "PollerExecutionTracker", "jira-migration-plugin"})
public final class PollerMetadataCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraAuthenticationContext jiraAuthenticationContext;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final PollerSchedulerService pollerSchedulerService;
    @NotNull
    private final com.atlassian.cache.Cache<String, Long> applicationUserCache;
    @NotNull
    private final Cache<String, String> containerTokenLocalCache;
    @NotNull
    private final com.atlassian.cache.Cache<String, PollerExecutionTracker> pollerExecutionCache;
    @NotNull
    private static final String CACHE_NAME_USER_DATA = PollerMetadataCache.class.getName() + ".prc.poller.user";
    @NotNull
    private static final String CACHE_NAME_POLLER_TRACKER = PollerMetadataCache.class.getName() + ".prc.poller.tracker";
    private static final long CACHE_EXPIRY_DAYS = 19L;
    private static final long MAXIMUM_CACHE_SIZE = 100L;
    private static final long TOKEN_TTL_HOURS = 1L;
    @NotNull
    private static final CacheSettings CACHE_SETTING;

    @Inject
    public PollerMetadataCache(@NotNull JiraAuthenticationContext jiraAuthenticationContext, @NotNull UserManager userManager, @NotNull CacheManager cacheManager, @NotNull CloudSiteRepository cloudSiteRepository, @NotNull PollerSchedulerService pollerSchedulerService) {
        Intrinsics.checkNotNullParameter((Object)jiraAuthenticationContext, (String)"jiraAuthenticationContext");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)pollerSchedulerService, (String)"pollerSchedulerService");
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userManager = userManager;
        this.cloudSiteRepository = cloudSiteRepository;
        this.pollerSchedulerService = pollerSchedulerService;
        com.atlassian.cache.Cache cache2 = cacheManager.getCache(CACHE_NAME_USER_DATA, null, CACHE_SETTING);
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"getCache(...)");
        this.applicationUserCache = cache2;
        Cache cache3 = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.HOURS).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache3, (String)"build(...)");
        this.containerTokenLocalCache = cache3;
        com.atlassian.cache.Cache cache4 = cacheManager.getCache(CACHE_NAME_POLLER_TRACKER, null, CACHE_SETTING);
        Intrinsics.checkNotNullExpressionValue((Object)cache4, (String)"getCache(...)");
        this.pollerExecutionCache = cache4;
    }

    public final long addApplicationUser(@NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Long userId = this.jiraAuthenticationContext.getLoggedInUser().getId();
        this.applicationUserCache.put((Object)cloudId2, (Object)userId);
        SwfExportFacadeKt.getLog().info("Added user key applicationUserCache, cloudId = " + cloudId2 + " and userId = " + userId);
        Intrinsics.checkNotNull((Object)userId);
        return userId;
    }

    public final void setUserContextOrThrow(@NotNull String cloudId2, @NotNull PublicApiException exception) {
        Long l;
        JiraAuthenticationContext jiraAuthenticationContext;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                Long l2 = (Long)this.applicationUserCache.get((Object)cloudId2);
                if (l2 == null) {
                    l2 = this.handleApplicationUserCacheMiss(cloudId2);
                }
                Long userId = l2;
                jiraAuthenticationContext = this.jiraAuthenticationContext;
                l = userId;
                if (l == null) break block4;
                long l3 = ((Number)l).longValue();
                JiraAuthenticationContext jiraAuthenticationContext2 = jiraAuthenticationContext;
                boolean bl = false;
                Optional optional = this.userManager.getUserById(userId);
                Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getUserById(...)");
                ApplicationUser applicationUser = (ApplicationUser)OptionalsKt.getOrNull((Optional)optional);
                jiraAuthenticationContext = jiraAuthenticationContext2;
                l = applicationUser;
                if (applicationUser != null) break block5;
            }
            throw exception;
        }
        jiraAuthenticationContext.setLoggedInUser((ApplicationUser)l);
    }

    @NotNull
    public final String getContainerTokenForCloudId(@NotNull String cloudId2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Object object = (String)this.containerTokenLocalCache.getIfPresent((Object)cloudId2);
        if (object == null) {
            PollerMetadataCache $this$getContainerTokenForCloudId_u24lambda_u242 = this;
            boolean bl = false;
            Object object2 = $this$getContainerTokenForCloudId_u24lambda_u242.cloudSiteRepository.getSite(cloudId2);
            if (object2 != null && (object2 = object2.getContainerToken()) != null) {
                Object object3;
                Object token = object3 = object2;
                boolean bl2 = false;
                $this$getContainerTokenForCloudId_u24lambda_u242.containerTokenLocalCache.put((Object)cloudId2, token);
                object = object3;
            } else {
                object = null;
            }
        }
        if ((string = object) == null) {
            throw new PublicApiException.ResourceNotFound("Can not find containerToken for cloudId = " + cloudId2);
        }
        return string;
    }

    public final void clearContainerTokenLocalCache(@NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        this.containerTokenLocalCache.invalidate((Object)cloudId2);
    }

    public final void registerPollerExecutionTracker(@NotNull String cloudId2, long jobStartTime) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        this.pollerExecutionCache.put((Object)cloudId2, (Object)new PollerExecutionTracker(jobStartTime, 0L));
    }

    public final void updatePollerExecutionTime(@NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        PollerExecutionTracker pollerExecutionTracker = this.getPollerExecutionStatistics(cloudId2);
        if (pollerExecutionTracker != null) {
            PollerExecutionTracker pollerExecutionTracker2;
            PollerExecutionTracker it = pollerExecutionTracker2 = pollerExecutionTracker;
            boolean bl = false;
            this.pollerExecutionCache.put((Object)cloudId2, (Object)new PollerExecutionTracker(it.getStartTime(), System.currentTimeMillis()));
        } else {
            this.handleExecutionTimeCacheMiss(cloudId2);
        }
    }

    public final long getPollerLastExecutionTime(@NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        PollerExecutionTracker pollerExecutionTracker = this.getPollerExecutionStatistics(cloudId2);
        return pollerExecutionTracker != null ? pollerExecutionTracker.getLastExecutionTime() : 0L;
    }

    public final long getPollerLatestStartTime(@NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        PollerExecutionTracker pollerExecutionTracker = this.getPollerExecutionStatistics(cloudId2);
        return pollerExecutionTracker != null ? pollerExecutionTracker.getStartTime() : 0L;
    }

    private final PollerExecutionTracker getPollerExecutionStatistics(String cloudId2) {
        Object object;
        Object object2 = this;
        try {
            PollerMetadataCache $this$getPollerExecutionStatistics_u24lambda_u244 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)((PollerExecutionTracker)$this$getPollerExecutionStatistics_u24lambda_u244.pollerExecutionCache.get((Object)cloudId2)));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (PollerExecutionTracker)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Long handleApplicationUserCacheMiss(String cloudId2) {
        JobDetails jobDetails = this.pollerSchedulerService.getScheduledJobForCloudId(cloudId2);
        if (jobDetails == null) return null;
        JobDetails jobDetails2 = jobDetails;
        boolean bl = false;
        Long l = ConvertorHelpers.Companion.asLongOrNull(jobDetails2.getParameters().get("triggeredByUserId"));
        if (l == null) return null;
        Long l2 = l;
        long userId = ((Number)l2).longValue();
        boolean bl2 = false;
        SwfExportFacadeKt.getLog().info("Handling cache miss for application user for cloudId = " + cloudId2);
        this.applicationUserCache.put((Object)cloudId2, (Object)userId);
        Long l3 = l2;
        return l3;
    }

    private final void handleExecutionTimeCacheMiss(String cloudId2) {
        block1: {
            JobDetails jobDetails = this.pollerSchedulerService.getScheduledJobForCloudId(cloudId2);
            if (jobDetails == null) break block1;
            JobDetails jobDetails2 = jobDetails;
            boolean bl = false;
            Long l = ConvertorHelpers.Companion.asLongOrNull(jobDetails2.getParameters().get("jobStartTime"));
            if (l != null) {
                Long l2 = l;
                long startTime = ((Number)l2).longValue();
                boolean bl2 = false;
                SwfExportFacadeKt.getLog().info("Handling cache miss for Execution time for cloudId = " + cloudId2);
                this.pollerExecutionCache.put((Object)cloudId2, (Object)new PollerExecutionTracker(startTime, System.currentTimeMillis()));
            }
        }
    }

    static {
        CacheSettings cacheSettings = new CacheSettingsBuilder().expireAfterWrite(19L, TimeUnit.DAYS).replicateViaCopy().remote().build();
        Intrinsics.checkNotNullExpressionValue((Object)cacheSettings, (String)"build(...)");
        CACHE_SETTING = cacheSettings;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/prc/PollerMetadataCache$Companion;", "", "()V", "CACHE_EXPIRY_DAYS", "", "CACHE_NAME_POLLER_TRACKER", "", "CACHE_NAME_USER_DATA", "CACHE_SETTING", "Lcom/atlassian/cache/CacheSettings;", "MAXIMUM_CACHE_SIZE", "TOKEN_TTL_HOURS", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/atlassian/jira/migration/prc/PollerMetadataCache$PollerExecutionTracker;", "Ljava/io/Serializable;", "startTime", "", "lastExecutionTime", "(JJ)V", "getLastExecutionTime", "()J", "getStartTime", "Companion", "jira-migration-plugin"})
    public static final class PollerExecutionTracker
    implements Serializable {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final long startTime;
        private final long lastExecutionTime;
        private static final long serialVersionUID = 1L;

        public PollerExecutionTracker(long startTime, long lastExecutionTime) {
            this.startTime = startTime;
            this.lastExecutionTime = lastExecutionTime;
        }

        public /* synthetic */ PollerExecutionTracker(long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            this(l, l2);
        }

        public final long getStartTime() {
            return this.startTime;
        }

        public final long getLastExecutionTime() {
            return this.lastExecutionTime;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/jira/migration/prc/PollerMetadataCache$PollerExecutionTracker$Companion;", "", "()V", "serialVersionUID", "", "jira-migration-plugin"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

