/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.prc;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\"\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00120\u0011J\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/jira/migration/prc/PollerSchedulerService;", "", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "(Lcom/atlassian/scheduler/SchedulerService;)V", "getJobId", "Lcom/atlassian/scheduler/config/JobId;", "cloudId", "", "getScheduledJobForCloudId", "Lcom/atlassian/scheduler/status/JobDetails;", "registerJobRunner", "", "jobRunner", "Lcom/atlassian/scheduler/JobRunner;", "scheduleJobForCloudId", "parameters", "", "Ljava/io/Serializable;", "unregisterJobRunner", "unscheduleJobForCloudId", "Companion", "jira-migration-plugin"})
public final class PollerSchedulerService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SchedulerService schedulerService;
    private static final Logger log = LoggerFactory.getLogger(PollerSchedulerService.class);
    @NotNull
    private static final JobRunnerKey JOB_RUNNER_KEY;
    @NotNull
    private static final String JOB_ID_PREFIX = "jira-migration-prc-poller-job-id-";
    private static final long ONE_MINUTE_SCHEDULE_INTERVAL;

    @Inject
    public PollerSchedulerService(@NotNull SchedulerService schedulerService) {
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        this.schedulerService = schedulerService;
    }

    public final void registerJobRunner(@NotNull JobRunner jobRunner) {
        Intrinsics.checkNotNullParameter((Object)jobRunner, (String)"jobRunner");
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, jobRunner);
    }

    public final void unregisterJobRunner() {
        Unit unit;
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        Unit it = unit = Unit.INSTANCE;
        boolean bl = false;
        log.info("Successfully unregistered scheduler in PollerExecutionService with name = " + JOB_RUNNER_KEY);
    }

    public final void scheduleJobForCloudId(@NotNull String cloudId2, @NotNull Map<String, ? extends Serializable> parameters) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        this.schedulerService.scheduleJob(this.getJobId(cloudId2), JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)ONE_MINUTE_SCHEDULE_INTERVAL, null)).withParameters(parameters));
    }

    public final void unscheduleJobForCloudId(@NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        this.schedulerService.unscheduleJob(this.getJobId(cloudId2));
    }

    @Nullable
    public final JobDetails getScheduledJobForCloudId(@NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        return this.schedulerService.getJobDetails(this.getJobId(cloudId2));
    }

    private final JobId getJobId(String cloudId2) {
        JobId jobId = JobId.of((String)(JOB_ID_PREFIX + cloudId2));
        Intrinsics.checkNotNullExpressionValue((Object)jobId, (String)"of(...)");
        return jobId;
    }

    static {
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"jira-migration-prc-poller-job-key");
        Intrinsics.checkNotNull((Object)jobRunnerKey);
        JOB_RUNNER_KEY = jobRunnerKey;
        ONE_MINUTE_SCHEDULE_INTERVAL = TimeUnit.MINUTES.toMillis(1L);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/prc/PollerSchedulerService$Companion;", "", "()V", "JOB_ID_PREFIX", "", "JOB_RUNNER_KEY", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "ONE_MINUTE_SCHEDULE_INTERVAL", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

