/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.prc;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.cloud.CloudSiteRepository;
import com.atlassian.jira.migration.migrationservice.ContainerTokenTTLService;
import com.atlassian.jira.migration.prc.PollerConfigHandler;
import com.atlassian.jira.migration.prc.PollerMetadataCache;
import com.atlassian.jira.migration.prc.PollerSchedulerService;
import com.atlassian.jira.migration.progress.v3.ConvertorHelpers;
import com.atlassian.jira.migration.publicapi.model.PublicApiException;
import com.atlassian.migration.prc.client.model.config.ScheduledPollerConfig;
import com.atlassian.migration.prc.client.poller.ScheduledPrcPollerManager;
import com.atlassian.scheduler.status.JobDetails;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/atlassian/jira/migration/prc/PollingService;", "", "cloudSiteRepository", "Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;", "applicationProperties", "Lcom/atlassian/jira/config/properties/ApplicationProperties;", "prcConfigHandler", "Lcom/atlassian/jira/migration/prc/PollerConfigHandler;", "containerTokenTTLService", "Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService;", "pollerMetadataCache", "Lcom/atlassian/jira/migration/prc/PollerMetadataCache;", "scheduledPrcPollerManager", "Lcom/atlassian/migration/prc/client/poller/ScheduledPrcPollerManager;", "pollerSchedulerService", "Lcom/atlassian/jira/migration/prc/PollerSchedulerService;", "(Lcom/atlassian/jira/migration/cloud/CloudSiteRepository;Lcom/atlassian/jira/config/properties/ApplicationProperties;Lcom/atlassian/jira/migration/prc/PollerConfigHandler;Lcom/atlassian/jira/migration/migrationservice/ContainerTokenTTLService;Lcom/atlassian/jira/migration/prc/PollerMetadataCache;Lcom/atlassian/migration/prc/client/poller/ScheduledPrcPollerManager;Lcom/atlassian/jira/migration/prc/PollerSchedulerService;)V", "getAndValidateCloudSite", "Lcom/atlassian/jira/migration/cloud/CloudSite;", "cloudUrl", "", "processStartPolling", "Ljava/time/Instant;", "cloudSite", "pollerConfig", "Lcom/atlassian/migration/prc/client/model/config/ScheduledPollerConfig;", "startPolling", "startPollingIfAbsent", "startPollingUntilContainerTokenExpiry", "Companion", "jira-migration-plugin"})
public final class PollingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CloudSiteRepository cloudSiteRepository;
    @NotNull
    private final ApplicationProperties applicationProperties;
    @NotNull
    private final PollerConfigHandler prcConfigHandler;
    @NotNull
    private final ContainerTokenTTLService containerTokenTTLService;
    @NotNull
    private final PollerMetadataCache pollerMetadataCache;
    @NotNull
    private final ScheduledPrcPollerManager scheduledPrcPollerManager;
    @NotNull
    private final PollerSchedulerService pollerSchedulerService;
    @NotNull
    private static final String SERVER_ID = "com.atlassian.analytics.client.configuration.serverid";
    @NotNull
    private static final String CHANNEL_NAME_PREFIX = "jira-server-to-cloud-";
    private static final long THIRTY_MIN_IN_SECONDS = 1800L;
    private static final long ONE_HOUR_IN_SECONDS = 3600L;
    private static final Logger log = LoggerFactory.getLogger(PollingService.class);

    @Inject
    public PollingService(@NotNull CloudSiteRepository cloudSiteRepository, @NotNull ApplicationProperties applicationProperties, @NotNull PollerConfigHandler prcConfigHandler, @NotNull ContainerTokenTTLService containerTokenTTLService, @NotNull PollerMetadataCache pollerMetadataCache, @NotNull ScheduledPrcPollerManager scheduledPrcPollerManager, @NotNull PollerSchedulerService pollerSchedulerService) {
        Intrinsics.checkNotNullParameter((Object)cloudSiteRepository, (String)"cloudSiteRepository");
        Intrinsics.checkNotNullParameter((Object)applicationProperties, (String)"applicationProperties");
        Intrinsics.checkNotNullParameter((Object)prcConfigHandler, (String)"prcConfigHandler");
        Intrinsics.checkNotNullParameter((Object)containerTokenTTLService, (String)"containerTokenTTLService");
        Intrinsics.checkNotNullParameter((Object)pollerMetadataCache, (String)"pollerMetadataCache");
        Intrinsics.checkNotNullParameter((Object)scheduledPrcPollerManager, (String)"scheduledPrcPollerManager");
        Intrinsics.checkNotNullParameter((Object)pollerSchedulerService, (String)"pollerSchedulerService");
        this.cloudSiteRepository = cloudSiteRepository;
        this.applicationProperties = applicationProperties;
        this.prcConfigHandler = prcConfigHandler;
        this.containerTokenTTLService = containerTokenTTLService;
        this.pollerMetadataCache = pollerMetadataCache;
        this.scheduledPrcPollerManager = scheduledPrcPollerManager;
        this.pollerSchedulerService = pollerSchedulerService;
    }

    @NotNull
    public final Instant startPolling(@NotNull String cloudUrl) {
        Intrinsics.checkNotNullParameter((Object)cloudUrl, (String)"cloudUrl");
        CloudSite cloudSite2 = this.getAndValidateCloudSite(((Object)StringsKt.trim((CharSequence)cloudUrl)).toString());
        ScheduledPollerConfig pollerConfig = this.prcConfigHandler.getScheduledPollerConfigWithCallbacks(CHANNEL_NAME_PREFIX + this.applicationProperties.getText(SERVER_ID), cloudSite2.getCloudId(), cloudSite2.getContainerToken());
        return this.processStartPolling(cloudSite2, pollerConfig);
    }

    @NotNull
    public final Instant startPollingIfAbsent(@NotNull String cloudUrl) {
        ScheduledPollerConfig pollerConfig;
        Intrinsics.checkNotNullParameter((Object)cloudUrl, (String)"cloudUrl");
        CloudSite cloudSite2 = this.getAndValidateCloudSite(((Object)StringsKt.trim((CharSequence)cloudUrl)).toString());
        JobDetails jobDetails = this.pollerSchedulerService.getScheduledJobForCloudId(cloudSite2.getCloudId());
        if (jobDetails != null) {
            Map map = jobDetails.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getParameters(...)");
            pollerConfig = this.prcConfigHandler.getConfigFromFromParams(map);
            Long l = ConvertorHelpers.Companion.asLongOrNull(jobDetails.getParameters().get("jobStartTime"));
            Intrinsics.checkNotNull((Object)l);
            long jobStartTime = l;
            long pollingExpiryTime = jobStartTime + TimeUnit.SECONDS.toMillis(pollerConfig.getPollerExpiryTimeInSec());
            if (pollingExpiryTime - System.currentTimeMillis() > TimeUnit.SECONDS.toMillis(1800L)) {
                Instant instant = Instant.ofEpochMilli(pollingExpiryTime);
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
                return instant;
            }
        }
        pollerConfig = this.prcConfigHandler.getScheduledPollerConfigWithCallbacksAndExpiry(CHANNEL_NAME_PREFIX + this.applicationProperties.getText(SERVER_ID), cloudSite2.getCloudId(), cloudSite2.getContainerToken(), 3600L);
        return this.processStartPolling(cloudSite2, pollerConfig);
    }

    @NotNull
    public final Instant startPollingUntilContainerTokenExpiry(@NotNull String cloudUrl) {
        Intrinsics.checkNotNullParameter((Object)cloudUrl, (String)"cloudUrl");
        CloudSite cloudSite2 = this.getAndValidateCloudSite(((Object)StringsKt.trim((CharSequence)cloudUrl)).toString());
        ScheduledPollerConfig pollerConfig = this.prcConfigHandler.getScheduledPollerConfigWithCallbacksAndExpiry(CHANNEL_NAME_PREFIX + this.applicationProperties.getText(SERVER_ID), cloudSite2.getCloudId(), cloudSite2.getContainerToken(), this.containerTokenTTLService.timeUntilExpiry(cloudSite2.getContainerToken()));
        return this.processStartPolling(cloudSite2, pollerConfig);
    }

    private final Instant processStartPolling(CloudSite cloudSite2, ScheduledPollerConfig pollerConfig) {
        Object $this$processStartPolling_u24lambda_u240;
        Object object = this;
        try {
            $this$processStartPolling_u24lambda_u240 = object;
            boolean bl = false;
            ((PollingService)$this$processStartPolling_u24lambda_u240).pollerMetadataCache.clearContainerTokenLocalCache(cloudSite2.getCloudId());
            ((PollingService)$this$processStartPolling_u24lambda_u240).scheduledPrcPollerManager.startPollingAsync(pollerConfig);
            log.info("Initiated poller for cloudUrl = " + cloudSite2.getCloudUrl());
            $this$processStartPolling_u24lambda_u240 = Result.constructor-impl((Object)Instant.ofEpochSecond(Instant.now().getEpochSecond() + pollerConfig.getPollerExpiryTimeInSec()));
        }
        catch (Throwable bl) {
            $this$processStartPolling_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$processStartPolling_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            log.error("Error while attaching poller: ", it);
            throw it;
        }
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrElse(...)");
        return (Instant)object2;
    }

    private final CloudSite getAndValidateCloudSite(String cloudUrl) {
        Object $this$getAndValidateCloudSite_u24lambda_u242;
        Object object = this;
        try {
            $this$getAndValidateCloudSite_u24lambda_u242 = object;
            boolean bl = false;
            CloudSite cloudSite2 = ((PollingService)$this$getAndValidateCloudSite_u24lambda_u242).cloudSiteRepository.getSiteByCloudUrl(((Object)StringsKt.trim((CharSequence)cloudUrl)).toString());
            if (cloudSite2 == null || !((PollingService)$this$getAndValidateCloudSite_u24lambda_u242).containerTokenTTLService.isValidToken(cloudSite2.getContainerToken())) {
                throw new PublicApiException.CloudSiteDoesNotExist(cloudUrl);
            }
            $this$getAndValidateCloudSite_u24lambda_u242 = Result.constructor-impl((Object)cloudSite2);
        }
        catch (Throwable bl) {
            $this$getAndValidateCloudSite_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$getAndValidateCloudSite_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            log.error("Error while validating container token for cloudUrl = {}", (Object)cloudUrl, (Object)it);
            throw it;
        }
        return (CloudSite)object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/prc/PollingService$Companion;", "", "()V", "CHANNEL_NAME_PREFIX", "", "ONE_HOUR_IN_SECONDS", "", "SERVER_ID", "THIRTY_MIN_IN_SECONDS", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

