/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.prc;

import com.atlassian.jira.migration.GroupedThreadFactory;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.jiraservice.JiraExtensionsKt;
import com.atlassian.jira.migration.prc.PrcCommandExecutor;
import com.atlassian.jira.migration.prc.model.PollerExecutionException;
import com.atlassian.jira.migration.prc.model.PrcCommandPayload;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.migration.prc.model.Command;
import com.atlassian.migration.prc.model.CommandName;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B%\b\u0017\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u001bJ\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00040\u000fH\u0002J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0007R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00040\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/jira/migration/prc/PrcCommandExecutionHandler;", "", "executors", "", "Lcom/atlassian/jira/migration/prc/PrcCommandExecutor;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Ljava/util/List;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "executorService", "Ljava/util/concurrent/ExecutorService;", "migrationMetadataAggregatorExecutorService", "(Ljava/util/List;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Ljava/util/concurrent/ExecutorService;Ljava/util/concurrent/ExecutorService;)V", "commandExecutor", "", "", "getExecutorService", "()Ljava/util/concurrent/ExecutorService;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "execute", "Ljava/util/concurrent/Future;", "Ljava/lang/Void;", "command", "Lcom/atlassian/migration/prc/model/Command;", "getAsCallback", "Lkotlin/Function1;", "getCommandExecutors", "getExecutorServiceForCommand", "preDestroy", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPrcCommandExecutionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrcCommandExecutionHandler.kt\ncom/atlassian/jira/migration/prc/PrcCommandExecutionHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,113:1\n1477#2:114\n1502#2,3:115\n1505#2,3:125\n1179#2,2:135\n1253#2,4:137\n372#3,7:118\n526#3:128\n511#3,6:129\n*S KotlinDebug\n*F\n+ 1 PrcCommandExecutionHandler.kt\ncom/atlassian/jira/migration/prc/PrcCommandExecutionHandler\n*L\n84#1:114\n84#1:115,3\n84#1:125,3\n91#1:135,2\n91#1:137,4\n84#1:118,7\n85#1:128\n85#1:129,6\n*E\n"})
public final class PrcCommandExecutionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PrcCommandExecutor> executors;
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final ExecutorService migrationMetadataAggregatorExecutorService;
    @NotNull
    private final Map<String, PrcCommandExecutor> commandExecutor;
    @NotNull
    private final ObjectMapper objectMapper;
    private static final Logger log = Logger.getLogger(PrcCommandExecutor.class);
    private static final int CORE_POOL_SIZE = 2;
    private static final int MAX_WORKER_THREADS = 2;
    private static final long KEEP_ALIVE_IN_SEC = 60L;

    public PrcCommandExecutionHandler(@NotNull List<? extends PrcCommandExecutor> executors, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull ExecutorService executorService, @NotNull ExecutorService migrationMetadataAggregatorExecutorService) {
        Intrinsics.checkNotNullParameter(executors, (String)"executors");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)migrationMetadataAggregatorExecutorService, (String)"migrationMetadataAggregatorExecutorService");
        this.executors = executors;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
        this.executorService = executorService;
        this.migrationMetadataAggregatorExecutorService = migrationMetadataAggregatorExecutorService;
        this.commandExecutor = this.getCommandExecutors();
        this.objectMapper = objectMapperFactory.createObjectMapperHandlingUnknownFields();
    }

    @NotNull
    public final ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Inject
    public PrcCommandExecutionHandler(@NotNull List<? extends PrcCommandExecutor> executors, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter(executors, (String)"executors");
        Intrinsics.checkNotNullParameter((Object)jiraThreadLocalUtil, (String)"jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        ExecutorService executorService = PrcCommandExecutionHandler.Companion.getExecutorPool();
        ExecutorService executorService2 = Executors.newSingleThreadExecutor(new GroupedThreadFactory("PrcCommandExecutionHandler"));
        Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"newSingleThreadExecutor(...)");
        this(executors, jiraThreadLocalUtil, objectMapperFactory, executorService, executorService2);
    }

    @NotNull
    public final Function1<Command, Future<Void>> getAsCallback() {
        return (Function1)new Function1<Command, Future<Void>>(this){
            final /* synthetic */ PrcCommandExecutionHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Future<Void> invoke(@NotNull Command command) {
                Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                return PrcCommandExecutionHandler.access$execute(this.this$0, command);
            }
        };
    }

    private final Future<Void> execute(Command command) {
        block2: {
            Object object;
            Object object2 = this;
            try {
                PrcCommandExecutionHandler $this$execute_u24lambda_u243 = object2;
                boolean bl = false;
                ExecutorService executorServiceForCommand = $this$execute_u24lambda_u243.getExecutorServiceForCommand(command);
                executorServiceForCommand.submit(() -> PrcCommandExecutionHandler.execute$lambda$3$lambda$2($this$execute_u24lambda_u243, command));
                log.info((Object)("Started execution :: command = " + command.getId() + " and name = " + command.getName()));
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            log.error((Object)("Failed to start execution :: command = " + command), (Throwable)it);
        }
        return new CompletableFuture();
    }

    private final ExecutorService getExecutorServiceForCommand(Command command) {
        if (command.getName().equals(CommandName.REPLACE_ALL_METADATA.toString())) {
            return this.migrationMetadataAggregatorExecutorService;
        }
        return this.executorService;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, PrcCommandExecutor> getCommandExecutors() {
        void $this$associateTo$iv$iv;
        void $this$filterTo$iv$iv;
        Map registeredExecutors;
        Object element$iv$iv2;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this.executors;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
            Object object;
            PrcCommandExecutor it = (PrcCommandExecutor)element$iv$iv2;
            boolean bl = false;
            CommandName key$iv$iv = it.getCommandName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv2);
        }
        Map $this$filter$iv = registeredExecutors = destination$iv$iv;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        element$iv$iv2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (element$iv$iv2.hasNext()) {
            Map.Entry element$iv$iv3;
            Map.Entry it = element$iv$iv3 = (Map.Entry)element$iv$iv2.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv2.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
        }
        Object violations = destination$iv$iv2;
        if (!violations.isEmpty()) {
            throw new PollerExecutionException("Single PRC Command should not be associated with Multiple executors = " + violations);
        }
        Iterable $this$associate$iv = registeredExecutors.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv4 : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv3;
            Map.Entry register = (Map.Entry)element$iv$iv4;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)((CommandName)register.getKey()).getValue(), (Object)CollectionsKt.first((List)((List)register.getValue())));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv3;
    }

    @PreDestroy
    public final void preDestroy() {
        this.executorService.shutdownNow();
    }

    private static final void execute$lambda$3$lambda$2(PrcCommandExecutionHandler $this_runCatching, Command $command) {
        Object $this$execute_u24lambda_u243_u24lambda_u242_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)$this_runCatching, (String)"$this_runCatching");
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        Object object = $this_runCatching;
        try {
            $this$execute_u24lambda_u243_u24lambda_u242_u24lambda_u240 = object;
            boolean bl = false;
            JiraThreadLocalUtil jiraThreadLocalUtil = ((PrcCommandExecutionHandler)$this$execute_u24lambda_u243_u24lambda_u242_u24lambda_u240).jiraThreadLocalUtil;
            Logger logger2 = log;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
            JiraExtensionsKt.wrap(jiraThreadLocalUtil, logger2, (Function0)new Function0<Unit>((PrcCommandExecutionHandler)$this$execute_u24lambda_u243_u24lambda_u242_u24lambda_u240, $command){
                final /* synthetic */ PrcCommandExecutionHandler $this_runCatching;
                final /* synthetic */ Command $command;
                {
                    this.$this_runCatching = $receiver;
                    this.$command = $command;
                    super(0);
                }

                public final void invoke() {
                    PrcCommandExecutor prcCommandExecutor = (PrcCommandExecutor)PrcCommandExecutionHandler.access$getCommandExecutor$p(this.$this_runCatching).get(this.$command.getName());
                    if (prcCommandExecutor == null) {
                        throw new PollerExecutionException("Executor not found for commandName = " + this.$command.getName());
                    }
                    PrcCommandExecutor executor = prcCommandExecutor;
                    PrcCommandPayload payload = (PrcCommandPayload)PrcCommandExecutionHandler.access$getObjectMapper$p(this.$this_runCatching).readValue(this.$command.getPayload(), JvmClassMappingKt.getJavaClass(executor.getPayloadClassType()));
                    Intrinsics.checkNotNull((Object)payload, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.prc.model.PrcCommandPayload");
                    executor.executeTask(payload, this.$command.getId());
                }
            });
            $this$execute_u24lambda_u243_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl) {
            $this$execute_u24lambda_u243_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$execute_u24lambda_u243_u24lambda_u242_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            log.error((Object)("Failed to execute :: command = " + $command), it);
        }
    }

    public static final /* synthetic */ Future access$execute(PrcCommandExecutionHandler $this, Command command) {
        return $this.execute(command);
    }

    public static final /* synthetic */ Map access$getCommandExecutor$p(PrcCommandExecutionHandler $this) {
        return $this.commandExecutor;
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(PrcCommandExecutionHandler $this) {
        return $this.objectMapper;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/prc/PrcCommandExecutionHandler$Companion;", "", "()V", "CORE_POOL_SIZE", "", "KEEP_ALIVE_IN_SEC", "", "MAX_WORKER_THREADS", "log", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "getExecutorPool", "Ljava/util/concurrent/ThreadPoolExecutor;", "jira-migration-plugin"})
    @SourceDebugExtension(value={"SMAP\nPrcCommandExecutionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrcCommandExecutionHandler.kt\ncom/atlassian/jira/migration/prc/PrcCommandExecutionHandler$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ThreadPoolExecutor getExecutorPool() {
            ThreadPoolExecutor threadPoolExecutor;
            ThreadPoolExecutor it = threadPoolExecutor = new ThreadPoolExecutor(2, 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue());
            boolean bl = false;
            it.allowCoreThreadTimeOut(true);
            return threadPoolExecutor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

