/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.prc;

import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.platform.TransferProgressRequest;
import com.atlassian.jira.migration.platform.TransferResultRequest;
import com.atlassian.jira.migration.prc.client.PrcHttpClient;
import com.atlassian.jira.migration.tracking.tasks.PrcTask;
import com.atlassian.migration.prc.model.CommandSource;
import com.atlassian.migration.statusrouter.model.CommandProgressRequest;
import com.atlassian.migration.statusrouter.model.CommandStatus;
import com.atlassian.migration.statusrouter.model.CommandStatusRequest;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J6\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService;", "", "prcHttpClient", "Lcom/atlassian/jira/migration/prc/client/PrcHttpClient;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "(Lcom/atlassian/jira/migration/prc/client/PrcHttpClient;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "publishFinalStatus", "", "task", "Lcom/atlassian/jira/migration/tracking/tasks/PrcTask;", "commandStatus", "Lcom/atlassian/migration/statusrouter/model/CommandStatus;", "transferResultRequest", "Lcom/atlassian/jira/migration/platform/TransferResultRequest;", "prcCommandId", "", "sourceCommandId", "containerToken", "commandSource", "Lcom/atlassian/migration/prc/model/CommandSource;", "publishProgress", "prcTask", "transferProgressRequest", "Lcom/atlassian/jira/migration/platform/TransferProgressRequest;", "sendHeartbeat", "setMigrationAsParentNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "payload", "Companion", "jira-migration-plugin"})
public final class PrcStatusUpdateService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrcHttpClient prcHttpClient;
    @NotNull
    private final ObjectMapper objectMapper;
    private static final Logger log = LoggerFactory.getLogger(PrcStatusUpdateService.class);
    @NotNull
    private static final String MIGRATION = "migration";

    @Inject
    public PrcStatusUpdateService(@NotNull PrcHttpClient prcHttpClient, @NotNull ObjectMapperFactory objectMapperFactory) {
        Intrinsics.checkNotNullParameter((Object)prcHttpClient, (String)"prcHttpClient");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        this.prcHttpClient = prcHttpClient;
        this.objectMapper = objectMapperFactory.createObjectMapper();
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public final void publishProgress(@NotNull PrcTask prcTask, @NotNull TransferProgressRequest transferProgressRequest) {
        Intrinsics.checkNotNullParameter((Object)prcTask, (String)"prcTask");
        Intrinsics.checkNotNullParameter((Object)transferProgressRequest, (String)"transferProgressRequest");
        JsonNode payload = (JsonNode)this.objectMapper.convertValue((Object)transferProgressRequest, JsonNode.class);
        Intrinsics.checkNotNull((Object)payload);
        JsonNode result2 = this.setMigrationAsParentNode(payload);
        CommandProgressRequest commandProgressRequest = new CommandProgressRequest(prcTask.getCommandSource(), prcTask.getTaskId(), result2);
        log.info("Publishing progress to PRC for migrationId: " + prcTask.getMigrationId() + ", prcCommandId: " + prcTask.getPrcCommandId() + ", lioCommandId: " + prcTask.getTaskId());
        this.prcHttpClient.publishProgress(prcTask.getPrcCommandId(), commandProgressRequest, prcTask.getCloudSite().getContainerToken());
    }

    public final void publishFinalStatus(@NotNull PrcTask task, @NotNull CommandStatus commandStatus, @NotNull TransferResultRequest transferResultRequest) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)commandStatus, (String)"commandStatus");
        Intrinsics.checkNotNullParameter((Object)transferResultRequest, (String)"transferResultRequest");
        this.publishFinalStatus(task.getPrcCommandId(), task.getTaskId(), task.getCloudSite().getContainerToken(), task.getCommandSource(), commandStatus, transferResultRequest);
    }

    public final void sendHeartbeat(@NotNull PrcTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        log.info("Sending heartbeat to PRC for migrationId: " + task.getMigrationId() + ", prcCommandId: " + task.getPrcCommandId() + ", lioCommandId: " + task.getTaskId() + "for command " + (Object)((Object)task.getMigrationTask().getMigrationTaskType()));
        this.prcHttpClient.sendHeartbeat(task.getPrcCommandId(), task.getCloudSite().getContainerToken());
    }

    public final void publishFinalStatus(@NotNull String prcCommandId, @NotNull String sourceCommandId, @NotNull String containerToken, @NotNull CommandSource commandSource, @NotNull CommandStatus commandStatus, @NotNull TransferResultRequest transferResultRequest) {
        Intrinsics.checkNotNullParameter((Object)prcCommandId, (String)"prcCommandId");
        Intrinsics.checkNotNullParameter((Object)sourceCommandId, (String)"sourceCommandId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Intrinsics.checkNotNullParameter((Object)commandSource, (String)"commandSource");
        Intrinsics.checkNotNullParameter((Object)commandStatus, (String)"commandStatus");
        Intrinsics.checkNotNullParameter((Object)transferResultRequest, (String)"transferResultRequest");
        JsonNode payload = (JsonNode)this.objectMapper.convertValue((Object)transferResultRequest, JsonNode.class);
        Intrinsics.checkNotNull((Object)payload);
        JsonNode result2 = this.setMigrationAsParentNode(payload);
        CommandStatusRequest commandStatusRequest = new CommandStatusRequest(commandSource, commandStatus, sourceCommandId, result2);
        log.info("Publishing final status: " + commandStatus.name() + " to PRC for prcCommandId: " + prcCommandId + ", lioCommandId: " + sourceCommandId);
        this.prcHttpClient.publishFinalStatus(prcCommandId, commandStatusRequest, containerToken);
    }

    private final JsonNode setMigrationAsParentNode(JsonNode payload) {
        JsonNode jsonNode = this.objectMapper.createObjectNode().set(MIGRATION, payload);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"set(...)");
        return jsonNode;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/prc/PrcStatusUpdateService$Companion;", "", "()V", "MIGRATION", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

