/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.prc.client;

import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.common.ObjectMapperFactory;
import com.atlassian.jira.migration.common.ObjectMapperFactoryKt;
import com.atlassian.jira.migration.httpclient.AbstractPluginHttpClientKt;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpClient;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpRequest;
import com.atlassian.jira.migration.httpclient.MigrationUserAgentProvider;
import com.atlassian.jira.migration.httpclient.exceptions.UnexpectedStatusCodeException;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.migration.prc.client.Response;
import com.atlassian.migration.prc.model.PrcRequest;
import com.atlassian.migration.statusrouter.model.CommandProgressRequest;
import com.atlassian.migration.statusrouter.model.CommandStatusRequest;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 12\u00020\u0001:\u00011B'\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u001f\b\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJN\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00192\u0006\u0010\u001a\u001a\u00020\u0011H\u0002J\u0006\u0010\u001b\u001a\u00020\u0013J2\u0010\u001c\u001a.\u0012\u0004\u0012\u00020\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001dJ\b\u0010\"\u001a\u00020\u0011H\u0002J\u001e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u0011J\u001e\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001a\u001a\u00020\u0011J6\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020\u001e2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00192\b\u0010-\u001a\u0004\u0018\u00010\u001f2\u0006\u0010.\u001a\u00020 H\u0002J\u0016\u0010/\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0011J \u00100\u001a\u00020\u000f*\u00020\u000f2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0019H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/atlassian/jira/migration/prc/client/PrcHttpClient;", "", "migrationServicesConfiguration", "Lcom/atlassian/jira/migration/MigrationServicesConfiguration;", "userAgentProvider", "Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;", "objectMapperFactory", "Lcom/atlassian/jira/migration/common/ObjectMapperFactory;", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "(Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/httpclient/MigrationUserAgentProvider;Lcom/atlassian/jira/migration/common/ObjectMapperFactory;Lcom/atlassian/jira/migration/sen/SENSupplier;)V", "httpClient", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;", "(Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClient;Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/sen/SENSupplier;)V", "createRequest", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;", "method", "", "uri", "Ljava/net/URI;", "body", "expectedStatusCodes", "", "", "headers", "", "containerToken", "getBaseUrl", "getPushAndPollAsCallback", "Lkotlin/Function4;", "Ljava/net/URL;", "Lcom/atlassian/migration/prc/model/PrcRequest;", "", "Lcom/atlassian/migration/prc/client/Response;", "getSen", "publishFinalStatus", "", "prcCommandId", "commandStatusRequest", "Lcom/atlassian/migration/statusrouter/model/CommandStatusRequest;", "publishProgress", "commandProgressRequest", "Lcom/atlassian/migration/statusrouter/model/CommandProgressRequest;", "pushAndPoll", "url", "requestBody", "retryable", "sendHeartbeat", "withHeaders", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nPrcHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrcHttpClient.kt\ncom/atlassian/jira/migration/prc/client/PrcHttpClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,150:1\n215#2,2:151\n*S KotlinDebug\n*F\n+ 1 PrcHttpClient.kt\ncom/atlassian/jira/migration/prc/client/PrcHttpClient\n*L\n135#1:151,2\n*E\n"})
public final class PrcHttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MigrationPluginHttpClient httpClient;
    @NotNull
    private final MigrationServicesConfiguration migrationServicesConfiguration;
    @NotNull
    private final SENSupplier senSupplier;
    private static final Logger log = LoggerFactory.getLogger(PrcHttpClient.class);
    @NotNull
    public static final String SEN_HEADER_KEY = "X-ASEN";
    @NotNull
    private static final String PRC_STATUS_ROUTER_BASE_URL = "migrations/prc/v1/";
    @NotNull
    private static final String PROGRESS = "/progress/{prcCommandId}";
    @NotNull
    private static final String FINAL_STATUS = "/status/{prcCommandId}";
    @NotNull
    private static final String HEARTBEAT = "/heartbeat/{prcCommandId}";
    @NotNull
    private static final String BEARER = "Bearer ";

    @VisibleForTesting
    public PrcHttpClient(@NotNull MigrationPluginHttpClient httpClient, @NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull SENSupplier senSupplier) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        this.httpClient = httpClient;
        this.migrationServicesConfiguration = migrationServicesConfiguration;
        this.senSupplier = senSupplier;
    }

    @Inject
    public PrcHttpClient(@NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull MigrationUserAgentProvider userAgentProvider, @NotNull ObjectMapperFactory objectMapperFactory, @NotNull SENSupplier senSupplier) {
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)userAgentProvider, (String)"userAgentProvider");
        Intrinsics.checkNotNullParameter((Object)objectMapperFactory, (String)"objectMapperFactory");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        this(new MigrationPluginHttpClient(userAgentProvider, ObjectMapperFactoryKt.safeEnums(ObjectMapperFactoryKt.handleUnknownFields(objectMapperFactory.createObjectMapper()))), migrationServicesConfiguration, senSupplier);
    }

    @NotNull
    public final URI getBaseUrl() {
        return this.migrationServicesConfiguration.getMigrationAPIBaseURI();
    }

    @NotNull
    public final Function4<URL, Map<String, String>, PrcRequest, Boolean, Response> getPushAndPollAsCallback() {
        return (Function4)new Function4<URL, Map<String, ? extends String>, PrcRequest, Boolean, Response>(this){
            final /* synthetic */ PrcHttpClient this$0;
            {
                this.this$0 = $receiver;
                super(4);
            }

            @NotNull
            public final Response invoke(@NotNull URL url, @NotNull Map<String, String> headers, @Nullable PrcRequest request, boolean retryable) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter(headers, (String)"headers");
                return PrcHttpClient.access$pushAndPoll(this.this$0, url, headers, request, retryable);
            }
        };
    }

    private final Response pushAndPoll(URL url, Map<String, String> headers, PrcRequest requestBody, boolean retryable) {
        Response response2;
        try {
            Set set = SetsKt.setOf((Object)200);
            URI uRI = url.toURI();
            Intrinsics.checkNotNull((Object)uRI);
            byte[] prcResponse = this.httpClient.execute(this.withHeaders(new MigrationPluginHttpRequest("POST", uRI, set, requestBody, null, null, 48, null), headers), byte[].class);
            response2 = new Response(200, ArraysKt.toTypedArray((byte[])prcResponse));
        }
        catch (UnexpectedStatusCodeException ex) {
            log.error("UnexpectedStatusCodeException in PRC client", (Throwable)ex);
            response2 = new Response(ex.getStatusCode(), null);
        }
        return response2;
    }

    public final void publishProgress(@NotNull String prcCommandId, @NotNull CommandProgressRequest commandProgressRequest, @NotNull String containerToken) {
        Intrinsics.checkNotNullParameter((Object)prcCommandId, (String)"prcCommandId");
        Intrinsics.checkNotNullParameter((Object)commandProgressRequest, (String)"commandProgressRequest");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Object object = new Integer[]{202, 200};
        Set set = SetsKt.setOf((Object[])object);
        URI uRI = this.getBaseUrl().resolve(PRC_STATUS_ROUTER_BASE_URL);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"resolve(...)");
        Object object2 = new String[]{prcCommandId};
        object = AbstractPluginHttpClientKt.buildURI$default(uRI, PROGRESS, object2, null, 8, null);
        object2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)SEN_HEADER_KEY, (Object)this.getSen()));
        this.httpClient.execute(this.createRequest("POST", (URI)object, commandProgressRequest, set, (Map<String, String>)object2, containerToken));
    }

    public final void publishFinalStatus(@NotNull String prcCommandId, @NotNull CommandStatusRequest commandStatusRequest, @NotNull String containerToken) {
        Intrinsics.checkNotNullParameter((Object)prcCommandId, (String)"prcCommandId");
        Intrinsics.checkNotNullParameter((Object)commandStatusRequest, (String)"commandStatusRequest");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Object object = new Integer[]{202, 200};
        Set set = SetsKt.setOf((Object[])object);
        URI uRI = this.getBaseUrl().resolve(PRC_STATUS_ROUTER_BASE_URL);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"resolve(...)");
        Object object2 = new String[]{prcCommandId};
        object = AbstractPluginHttpClientKt.buildURI$default(uRI, FINAL_STATUS, object2, null, 8, null);
        object2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)SEN_HEADER_KEY, (Object)this.getSen()));
        this.httpClient.execute(this.createRequest("POST", (URI)object, commandStatusRequest, set, (Map<String, String>)object2, containerToken));
    }

    public final void sendHeartbeat(@NotNull String prcCommandId, @NotNull String containerToken) {
        Intrinsics.checkNotNullParameter((Object)prcCommandId, (String)"prcCommandId");
        Intrinsics.checkNotNullParameter((Object)containerToken, (String)"containerToken");
        Object object = new Integer[]{202, 200};
        Set set = SetsKt.setOf((Object[])object);
        URI uRI = this.getBaseUrl().resolve(PRC_STATUS_ROUTER_BASE_URL);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"resolve(...)");
        Object object2 = new String[]{prcCommandId};
        object = AbstractPluginHttpClientKt.buildURI$default(uRI, HEARTBEAT, object2, null, 8, null);
        object2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)SEN_HEADER_KEY, (Object)this.getSen()));
        this.httpClient.execute(PrcHttpClient.createRequest$default(this, "PUT", (URI)object, null, set, (Map)object2, containerToken, 4, null));
    }

    private final MigrationPluginHttpRequest createRequest(String method, URI uri, Object body, Set<Integer> expectedStatusCodes, Map<String, String> headers, String containerToken) {
        return this.withHeaders(new MigrationPluginHttpRequest(method, uri, expectedStatusCodes, body, null, null, 48, null), headers).authorization(BEARER + containerToken);
    }

    static /* synthetic */ MigrationPluginHttpRequest createRequest$default(PrcHttpClient prcHttpClient, String string, URI uRI, Object object, Set set, Map map, String string2, int n, Object object2) {
        if ((n & 4) != 0) {
            object = null;
        }
        return prcHttpClient.createRequest(string, uRI, object, set, map, string2);
    }

    private final String getSen() {
        String string = this.senSupplier.getFirstSen();
        if (string == null) {
            string = "";
        }
        return string;
    }

    private final MigrationPluginHttpRequest withHeaders(MigrationPluginHttpRequest $this$withHeaders, Map<String, String> headers) {
        MigrationPluginHttpRequest migrationPluginHttpRequest;
        MigrationPluginHttpRequest $this$withHeaders_u24lambda_u241 = migrationPluginHttpRequest = $this$withHeaders;
        boolean bl = false;
        Map<String, String> $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> header = element$iv = iterator2.next();
            boolean bl2 = false;
            $this$withHeaders_u24lambda_u241.addHeader(header.getKey(), header.getValue());
        }
        $this$withHeaders_u24lambda_u241.contentTypeJson();
        $this$withHeaders_u24lambda_u241.acceptsJson();
        return migrationPluginHttpRequest;
    }

    public static final /* synthetic */ Response access$pushAndPoll(PrcHttpClient $this, URL url, Map headers, PrcRequest requestBody, boolean retryable) {
        return $this.pushAndPoll(url, headers, requestBody, retryable);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/jira/migration/prc/client/PrcHttpClient$Companion;", "", "()V", "BEARER", "", "FINAL_STATUS", "HEARTBEAT", "PRC_STATUS_ROUTER_BASE_URL", "PROGRESS", "SEN_HEADER_KEY", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

