/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.prediction;

import com.atlassian.jira.migration.MigrationServicesConfiguration;
import com.atlassian.jira.migration.cloud.CloudSite;
import com.atlassian.jira.migration.discovery.DiscoveryService;
import com.atlassian.jira.migration.httpclient.AbstractPluginHttpClientKt;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpClientGson;
import com.atlassian.jira.migration.httpclient.MigrationPluginHttpRequest;
import com.atlassian.jira.migration.platform.GsonFactory;
import com.atlassian.jira.migration.prediction.PredictionResult;
import com.atlassian.migration.api.MigrationId;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001d\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\u00020\u0016*\u00020\u00162\u0006\u0010\u0018\u001a\u00020\rH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/prediction/MigrationPredictionServiceClient;", "", "gsonFactory", "Lcom/atlassian/jira/migration/platform/GsonFactory;", "migrationServicesConfiguration", "Lcom/atlassian/jira/migration/MigrationServicesConfiguration;", "discoveryService", "Lcom/atlassian/jira/migration/discovery/DiscoveryService;", "(Lcom/atlassian/jira/migration/platform/GsonFactory;Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/discovery/DiscoveryService;)V", "httpClient", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClientGson;", "(Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpClientGson;Lcom/atlassian/jira/migration/MigrationServicesConfiguration;Lcom/atlassian/jira/migration/discovery/DiscoveryService;)V", "getContainerToken", "", "cloudId", "predict", "Lcom/atlassian/jira/migration/prediction/PredictionResult;", "migrationId", "Lcom/atlassian/migration/api/MigrationId;", "cloudAppKey", "addJsonHeaders", "", "Lcom/atlassian/jira/migration/httpclient/MigrationPluginHttpRequest;", "withDefaultHeaders", "containerToken", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nMigrationPredictionServiceClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationPredictionServiceClient.kt\ncom/atlassian/jira/migration/prediction/MigrationPredictionServiceClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class MigrationPredictionServiceClient {
    @NotNull
    private final MigrationPluginHttpClientGson httpClient;
    @NotNull
    private final MigrationServicesConfiguration migrationServicesConfiguration;
    @NotNull
    private final DiscoveryService discoveryService;

    public MigrationPredictionServiceClient(@NotNull MigrationPluginHttpClientGson httpClient, @NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull DiscoveryService discoveryService) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        this.httpClient = httpClient;
        this.migrationServicesConfiguration = migrationServicesConfiguration;
        this.discoveryService = discoveryService;
    }

    @Inject
    public MigrationPredictionServiceClient(@NotNull GsonFactory gsonFactory, @NotNull MigrationServicesConfiguration migrationServicesConfiguration, @NotNull DiscoveryService discoveryService) {
        Intrinsics.checkNotNullParameter((Object)gsonFactory, (String)"gsonFactory");
        Intrinsics.checkNotNullParameter((Object)migrationServicesConfiguration, (String)"migrationServicesConfiguration");
        Intrinsics.checkNotNullParameter((Object)discoveryService, (String)"discoveryService");
        this(new MigrationPluginHttpClientGson(gsonFactory.createGson()), migrationServicesConfiguration, discoveryService);
    }

    @NotNull
    public final PredictionResult predict(@NotNull MigrationId migrationId, @NotNull String cloudAppKey, @NotNull String cloudId2) {
        Intrinsics.checkNotNullParameter((Object)migrationId, (String)"migrationId");
        Intrinsics.checkNotNullParameter((Object)cloudAppKey, (String)"cloudAppKey");
        Intrinsics.checkNotNullParameter((Object)cloudId2, (String)"cloudId");
        URI uRI = new URI(this.migrationServicesConfiguration.getMigrationsPredictionsURL());
        String[] stringArray = new String[2];
        Intrinsics.checkNotNullExpressionValue((Object)migrationId.toString(), (String)"toString(...)");
        stringArray[1] = cloudAppKey;
        return this.httpClient.execute(this.withDefaultHeaders(new MigrationPluginHttpRequest("POST", AbstractPluginHttpClientKt.buildURI$default(uRI, "migration/{migrationId}/cloudAppKey/{cloudAppKey}/predict", stringArray, null, 8, null), null, null, null, null, 60, null), this.getContainerToken(cloudId2)), PredictionResult.class);
    }

    private final String getContainerToken(String cloudId2) {
        CloudSite cloudSite2 = this.discoveryService.retrieveCloudSiteForCloudId(cloudId2);
        if (cloudSite2 == null) {
            boolean bl = false;
            String string = "Failed to find cloudSite entry for requested cloudId: " + cloudId2;
            throw new IllegalArgumentException(string.toString());
        }
        return cloudSite2.getContainerToken();
    }

    private final MigrationPluginHttpRequest withDefaultHeaders(MigrationPluginHttpRequest $this$withDefaultHeaders, String containerToken) {
        MigrationPluginHttpRequest migrationPluginHttpRequest;
        MigrationPluginHttpRequest $this$withDefaultHeaders_u24lambda_u241 = migrationPluginHttpRequest = $this$withDefaultHeaders;
        boolean bl = false;
        $this$withDefaultHeaders_u24lambda_u241.authorization("Bearer " + containerToken);
        this.addJsonHeaders($this$withDefaultHeaders_u24lambda_u241);
        return migrationPluginHttpRequest;
    }

    private final void addJsonHeaders(MigrationPluginHttpRequest $this$addJsonHeaders) {
        $this$addJsonHeaders.contentTypeJson();
        $this$addJsonHeaders.acceptsJson();
    }
}

