/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.mapper.EmailFormatMapper;
import com.atlassian.jira.migration.common.Constants;
import com.atlassian.jira.migration.email.InvalidEmailsConfig;
import com.atlassian.jira.migration.plan.SinglePathMode;
import com.atlassian.jira.migration.preflight.BulkImportCompatibilityWithUdcService;
import com.atlassian.jira.migration.preflight.EmailFormatCheckService;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.migration.udc.common.model.EmailCheckType;
import com.atlassian.migration.udc.common.model.user.AccountType;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCMode;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/jira/migration/preflight/AbstractInvalidEmailCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "emailFormatCheckService", "Lcom/atlassian/jira/migration/preflight/EmailFormatCheckService;", "bulkImportCompatibilityWithUdcService", "Lcom/atlassian/jira/migration/preflight/BulkImportCompatibilityWithUdcService;", "(Lcom/atlassian/jira/migration/preflight/EmailFormatCheckService;Lcom/atlassian/jira/migration/preflight/BulkImportCompatibilityWithUdcService;)V", "accountType", "Lcom/atlassian/migration/udc/common/model/user/AccountType;", "getAccountType", "()Lcom/atlassian/migration/udc/common/model/user/AccountType;", "getBulkImportCompatibilityWithUdcService", "()Lcom/atlassian/jira/migration/preflight/BulkImportCompatibilityWithUdcService;", "emailFormatMapper", "Lcom/atlassian/cmpt/check/mapper/EmailFormatMapper;", "getEmailFormatMapper", "()Lcom/atlassian/cmpt/check/mapper/EmailFormatMapper;", "configIsUseCsv", "", "result", "performCheck", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "jira-migration-plugin"})
public abstract class AbstractInvalidEmailCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    private final EmailFormatCheckService emailFormatCheckService;
    @NotNull
    private final BulkImportCompatibilityWithUdcService bulkImportCompatibilityWithUdcService;
    @NotNull
    private final EmailFormatMapper emailFormatMapper;

    public AbstractInvalidEmailCheck(@NotNull EmailFormatCheckService emailFormatCheckService, @NotNull BulkImportCompatibilityWithUdcService bulkImportCompatibilityWithUdcService) {
        Intrinsics.checkNotNullParameter((Object)emailFormatCheckService, (String)"emailFormatCheckService");
        Intrinsics.checkNotNullParameter((Object)bulkImportCompatibilityWithUdcService, (String)"bulkImportCompatibilityWithUdcService");
        this.emailFormatCheckService = emailFormatCheckService;
        this.bulkImportCompatibilityWithUdcService = bulkImportCompatibilityWithUdcService;
        this.emailFormatMapper = new EmailFormatMapper(AbstractInvalidEmailCheck::emailFormatMapper$lambda$0);
    }

    @NotNull
    protected final BulkImportCompatibilityWithUdcService getBulkImportCompatibilityWithUdcService() {
        return this.bulkImportCompatibilityWithUdcService;
    }

    @NotNull
    public abstract AccountType getAccountType();

    @NotNull
    public final EmailFormatMapper getEmailFormatMapper() {
        return this.emailFormatMapper;
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Set<String> duplicatesInFix;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        CheckResult result2 = this.emailFormatCheckService.runCheck(checkRequest);
        UDCMode uDCMode = result2.details.getOrDefault("udcMode", UDCMode.BASIC);
        Intrinsics.checkNotNull((Object)uDCMode, (String)"null cannot be cast to non-null type com.atlassian.migration.udc.common.model.usermapping.model.UDCMode");
        UDCMode udcMode = uDCMode;
        if (PreflightCheckKt.getSinglePathMode(checkRequest) == SinglePathMode.LIFT_AND_SHIFT && (this.configIsUseCsv(result2) || udcMode == UDCMode.ADVANCED) && result2.success && !((Collection)(duplicatesInFix = this.bulkImportCompatibilityWithUdcService.findDuplicatesInFix(checkRequest, EmailCheckType.INV, udcMode))).isEmpty()) {
            Map details2;
            Map map = result2.details;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
            Map map2 = details2 = MapsKt.toMutableMap((Map)map);
            Pair pair = TuplesKt.to((Object)"isBulkImportWithCsvMerge", duplicatesInFix);
            map2.put(pair.getFirst(), pair.getSecond());
            result2 = new CheckResult(false, details2);
        }
        return result2;
    }

    private final boolean configIsUseCsv(CheckResult result2) {
        InvalidEmailsConfig.OnMigration onMigration = result2.details.getOrDefault("configOption", InvalidEmailsConfig.OnMigration.DO_NOTHING);
        Intrinsics.checkNotNull((Object)((Object)onMigration), (String)"null cannot be cast to non-null type com.atlassian.jira.migration.email.InvalidEmailsConfig.OnMigration");
        return InvalidEmailsConfig.OnMigration.USE_CSV == onMigration;
    }

    private static final String emailFormatMapper$lambda$0(String name) {
        return Constants.INSTANCE.buildPageUrl("secure/admin/user/ViewUser.jspa", (Pair<String, String>)TuplesKt.to((Object)"name", (Object)name));
    }
}

