/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.domain.Edition;
import com.atlassian.cmpt.domain.Product;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.ums.exceptions.UmsPreflightCheckException;
import com.atlassian.jira.migration.preflight.ums.model.UmsPreflightCheckDetails;
import com.atlassian.jira.migration.preflight.ums.model.UmsPreflightCheckType;
import com.atlassian.jira.migration.preflight.ums.model.UmsPreflightResponse;
import com.atlassian.jira.migration.serverdataextractors.usergroup.UsersGroupsExtractionResult;
import com.atlassian.jira.migration.usersmigrationservice.LicenceCheckStatusResponse;
import com.atlassian.jira.migration.usersmigrationservice.LicencesCheckResult;
import com.atlassian.jira.migration.usersmigrationservice.Result;
import com.atlassian.jira.migration.utils.CompletableFutureUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Future;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/preflight/AbstractLicenceCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "()V", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "performCheck", "checkRequest", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAbstractLicenceCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractLicenceCheck.kt\ncom/atlassian/jira/migration/preflight/AbstractLicenceCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n223#2,2:97\n*S KotlinDebug\n*F\n+ 1 AbstractLicenceCheck.kt\ncom/atlassian/jira/migration/preflight/AbstractLicenceCheck\n*L\n55#1:97,2\n*E\n"})
public abstract class AbstractLicenceCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, Product> CHECK_TYPE_TO_PRODUCTS_MAP;
    @NotNull
    public static final String PRODUCT = "product";
    @NotNull
    public static final String EDITION = "edition";
    @NotNull
    public static final String USERS_COUNT_KEY = "usersCount";
    @NotNull
    public static final String AVAILABLE_LICENCE_SEATS_KEY = "availableLicenceSeats";
    @NotNull
    public static final String REQUESTED_LICENCE_SEATS = "requestedLicenceSeats";

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"containerToken", (Object)ctx.getContainerToken()), TuplesKt.to((Object)"cloudId", (Object)ctx.getCloudId()), TuplesKt.to((Object)"usersAndGroups", ctx.getUsersAndGroups()), TuplesKt.to((Object)"umsPreflightCheckDetails", (Object)ctx.getUmsPreflightCheckDetails()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        CheckResult checkResult;
        Object element$iv2;
        block7: {
            Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
            if (Intrinsics.areEqual((Object)PreflightCheckKt.getUsersAndGroups(checkRequest), (Object)UsersGroupsExtractionResult.Companion.getEMPTY())) {
                return new CheckResult(true);
            }
            UmsPreflightCheckDetails umsPreflightCheckDetails = PreflightCheckKt.getUmsPreflightCheckDetails(checkRequest);
            CompletableFutureUtil.INSTANCE.getCompletedValue((Future)umsPreflightCheckDetails.getFileId());
            UmsPreflightResponse umsPreflightResponse = umsPreflightCheckDetails.getUmsPreflightCheckResults().get((Object)UmsPreflightCheckType.Licence);
            Intrinsics.checkNotNull((Object)umsPreflightResponse);
            UmsPreflightResponse umsLicenseCheckResults = umsPreflightResponse;
            Object object = CompletableFutureUtil.INSTANCE.getCompletedValue((Future)umsLicenseCheckResults.getResult());
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.atlassian.jira.migration.usersmigrationservice.LicenceCheckStatusResponse");
            LicenceCheckStatusResponse licenceCheckResponse = (LicenceCheckStatusResponse)object;
            if (!((Collection)licenceCheckResponse.getErrors()).isEmpty()) {
                throw new UmsPreflightCheckException(checkRequest.checkType + " LicenceCheckResults list for the product has the following error:" + licenceCheckResponse.getErrors());
            }
            List<LicencesCheckResult> list = licenceCheckResponse.getLicencesCheckResult();
            Intrinsics.checkNotNull(list);
            Iterable $this$first$iv = list;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                LicencesCheckResult it = (LicencesCheckResult)element$iv2;
                boolean bl = false;
                if (!(it.getProduct() == CHECK_TYPE_TO_PRODUCTS_MAP.get(checkRequest.checkType))) continue;
                break block7;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        LicencesCheckResult productLicenceInfo = (LicencesCheckResult)element$iv2;
        switch (WhenMappings.$EnumSwitchMapping$0[productLicenceInfo.getResult().ordinal()]) {
            case 1: {
                checkResult = new CheckResult(true);
                break;
            }
            case 2: {
                Pair[] pairArray = new Pair[3];
                Product product = CHECK_TYPE_TO_PRODUCTS_MAP.get(checkRequest.checkType);
                Intrinsics.checkNotNull((Object)product);
                pairArray[0] = TuplesKt.to((Object)PRODUCT, (Object)product.getKey());
                Edition edition = productLicenceInfo.getEdition();
                Intrinsics.checkNotNull((Object)edition);
                pairArray[1] = TuplesKt.to((Object)EDITION, (Object)edition.getKey());
                pairArray[2] = TuplesKt.to((Object)USERS_COUNT_KEY, (Object)productLicenceInfo.getUsersCount());
                CheckResult checkResult2 = new CheckResult(true, MapsKt.mapOf((Pair[])pairArray));
                checkResult = checkResult2;
                break;
            }
            default: {
                Pair[] pairArray = new Pair[5];
                Product product = CHECK_TYPE_TO_PRODUCTS_MAP.get(checkRequest.checkType);
                Intrinsics.checkNotNull((Object)product);
                pairArray[0] = TuplesKt.to((Object)PRODUCT, (Object)product.getKey());
                Edition edition = productLicenceInfo.getEdition();
                Intrinsics.checkNotNull((Object)edition);
                pairArray[1] = TuplesKt.to((Object)EDITION, (Object)edition.getKey());
                pairArray[2] = TuplesKt.to((Object)USERS_COUNT_KEY, (Object)productLicenceInfo.getUsersCount());
                pairArray[3] = TuplesKt.to((Object)AVAILABLE_LICENCE_SEATS_KEY, (Object)productLicenceInfo.getAvailableLicenceSeats());
                pairArray[4] = TuplesKt.to((Object)REQUESTED_LICENCE_SEATS, (Object)productLicenceInfo.getRequestedLicenceSeats());
                CheckResult checkResult3 = new CheckResult(false, MapsKt.mapOf((Pair[])pairArray));
                checkResult = checkResult3;
            }
        }
        return checkResult;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"JsmLicence", (Object)Product.JIRA_SERVICEDESK), TuplesKt.to((Object)"JswLicence", (Object)Product.JIRA_SOFTWARE), TuplesKt.to((Object)"JwmLicence", (Object)Product.JIRA_CORE)};
        CHECK_TYPE_TO_PRODUCTS_MAP = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/preflight/AbstractLicenceCheck$Companion;", "", "()V", "AVAILABLE_LICENCE_SEATS_KEY", "", "CHECK_TYPE_TO_PRODUCTS_MAP", "", "Lcom/atlassian/cmpt/domain/Product;", "EDITION", "PRODUCT", "REQUESTED_LICENCE_SEATS", "USERS_COUNT_KEY", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Result.values().length];
            try {
                nArray[Result.UNDEFINED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Result.TRUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

