/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.mapper.EmailDuplicateMapper;
import com.atlassian.jira.migration.common.Constants;
import com.atlassian.jira.migration.email.DuplicatedEmailsConfig;
import com.atlassian.jira.migration.plan.SinglePathMode;
import com.atlassian.jira.migration.preflight.BulkImportCompatibilityWithUdcService;
import com.atlassian.jira.migration.preflight.DuplicateEmailCheckService;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.migration.udc.common.model.EmailCheckType;
import com.atlassian.migration.udc.common.model.user.AccountType;
import com.atlassian.migration.udc.common.model.usermapping.model.UDCMode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/jira/migration/preflight/AbstractSharedEmailCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "emailCheckService", "Lcom/atlassian/jira/migration/preflight/DuplicateEmailCheckService;", "bulkImportCompatibilityWithUdcService", "Lcom/atlassian/jira/migration/preflight/BulkImportCompatibilityWithUdcService;", "(Lcom/atlassian/jira/migration/preflight/DuplicateEmailCheckService;Lcom/atlassian/jira/migration/preflight/BulkImportCompatibilityWithUdcService;)V", "accountType", "Lcom/atlassian/migration/udc/common/model/user/AccountType;", "getAccountType", "()Lcom/atlassian/migration/udc/common/model/user/AccountType;", "getBulkImportCompatibilityWithUdcService", "()Lcom/atlassian/jira/migration/preflight/BulkImportCompatibilityWithUdcService;", "emailDuplicateMapper", "Lcom/atlassian/cmpt/check/mapper/EmailDuplicateMapper;", "getEmailDuplicateMapper", "()Lcom/atlassian/cmpt/check/mapper/EmailDuplicateMapper;", "configIsMerge", "", "result", "configIsUseCsv", "performCheck", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "jira-migration-plugin"})
public abstract class AbstractSharedEmailCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    private final DuplicateEmailCheckService emailCheckService;
    @NotNull
    private final BulkImportCompatibilityWithUdcService bulkImportCompatibilityWithUdcService;
    @NotNull
    private final EmailDuplicateMapper emailDuplicateMapper;

    public AbstractSharedEmailCheck(@NotNull DuplicateEmailCheckService emailCheckService, @NotNull BulkImportCompatibilityWithUdcService bulkImportCompatibilityWithUdcService) {
        Intrinsics.checkNotNullParameter((Object)emailCheckService, (String)"emailCheckService");
        Intrinsics.checkNotNullParameter((Object)bulkImportCompatibilityWithUdcService, (String)"bulkImportCompatibilityWithUdcService");
        this.emailCheckService = emailCheckService;
        this.bulkImportCompatibilityWithUdcService = bulkImportCompatibilityWithUdcService;
        this.emailDuplicateMapper = new EmailDuplicateMapper(AbstractSharedEmailCheck::emailDuplicateMapper$lambda$0);
    }

    @NotNull
    protected final BulkImportCompatibilityWithUdcService getBulkImportCompatibilityWithUdcService() {
        return this.bulkImportCompatibilityWithUdcService;
    }

    @NotNull
    public abstract AccountType getAccountType();

    @NotNull
    public final EmailDuplicateMapper getEmailDuplicateMapper() {
        return this.emailDuplicateMapper;
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        CheckResult result2 = this.emailCheckService.runCheck(checkRequest);
        if (PreflightCheckKt.getSinglePathMode(checkRequest) == SinglePathMode.LIFT_AND_SHIFT && result2.success) {
            UDCMode uDCMode = result2.details.getOrDefault("udcMode", UDCMode.BASIC);
            Intrinsics.checkNotNull((Object)uDCMode, (String)"null cannot be cast to non-null type com.atlassian.migration.udc.common.model.usermapping.model.UDCMode");
            UDCMode udcMode = uDCMode;
            if (this.configIsUseCsv(result2) || udcMode == UDCMode.ADVANCED) {
                Set<String> duplicatesInFix = this.bulkImportCompatibilityWithUdcService.findDuplicatesInFix(checkRequest, EmailCheckType.DUP, udcMode);
                if (!((Collection)duplicatesInFix).isEmpty()) {
                    Map details2;
                    Map map = result2.details;
                    Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
                    Map map2 = details2 = MapsKt.toMutableMap((Map)map);
                    Pair pair = TuplesKt.to((Object)"isBulkImportWithCsvMerge", duplicatesInFix);
                    map2.put(pair.getFirst(), pair.getSecond());
                    result2 = new CheckResult(false, details2);
                }
            } else if (this.configIsMerge(result2)) {
                Map details3;
                Map map = result2.details;
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
                Map map3 = details3 = MapsKt.toMutableMap((Map)map);
                Pair pair = TuplesKt.to((Object)"isBulkImportWithMerge", (Object)true);
                map3.put(pair.getFirst(), pair.getSecond());
                result2 = new CheckResult(false, details3);
            }
        }
        return result2;
    }

    private final boolean configIsMerge(CheckResult result2) {
        DuplicatedEmailsConfig.OnMigration[] onMigrationArray = new DuplicatedEmailsConfig.OnMigration[]{DuplicatedEmailsConfig.OnMigration.MERGE_ALL, DuplicatedEmailsConfig.OnMigration.MERGE_BEFORE_CUT_OFF_DATE};
        List list = CollectionsKt.listOf((Object[])onMigrationArray);
        DuplicatedEmailsConfig.OnMigration onMigration = result2.details.getOrDefault("configOption", DuplicatedEmailsConfig.OnMigration.MERGE_ALL);
        Intrinsics.checkNotNull((Object)((Object)onMigration), (String)"null cannot be cast to non-null type com.atlassian.jira.migration.email.DuplicatedEmailsConfig.OnMigration");
        return list.contains((Object)onMigration);
    }

    private final boolean configIsUseCsv(CheckResult result2) {
        DuplicatedEmailsConfig.OnMigration onMigration = result2.details.getOrDefault("configOption", DuplicatedEmailsConfig.OnMigration.DO_NOTHING);
        Intrinsics.checkNotNull((Object)((Object)onMigration), (String)"null cannot be cast to non-null type com.atlassian.jira.migration.email.DuplicatedEmailsConfig.OnMigration");
        return DuplicatedEmailsConfig.OnMigration.USE_CSV == onMigration;
    }

    private static final String emailDuplicateMapper$lambda$0(String email) {
        return Constants.INSTANCE.buildPageUrl("secure/admin/user/UserBrowser.jspa", (Pair<String, String>)TuplesKt.to((Object)"userSearchFilter", (Object)email));
    }
}

