/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsPlanData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.PlanDataReader;
import com.atlassian.jira.migration.preflight.AdvancedRoadmapsMissingProjectsCheckKt;
import com.atlassian.jira.migration.preflight.AdvancedRoadmapsMissingProjectsCheckService;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.csv.AdvancedRoadmapsMissingProjectsCSVData;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.google.common.annotations.VisibleForTesting;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\"\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0010H\u0016J\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0017J\u0010\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u0015H\u0016JB\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\u00102\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0014\u0010)\u001a\u0010\u0012\u0004\u0012\u00020*\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020*0,H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/atlassian/jira/migration/preflight/AdvancedRoadmapsMissingProjectsCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "advancedRoadmapsMissingProjectsCheckService", "Lcom/atlassian/jira/migration/preflight/AdvancedRoadmapsMissingProjectsCheckService;", "planDataReader", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/PlanDataReader;", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "(Lcom/atlassian/jira/migration/preflight/AdvancedRoadmapsMissingProjectsCheckService;Lcom/atlassian/jira/migration/export/db/advancedroadmaps/PlanDataReader;Lcom/atlassian/jira/project/ProjectManager;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCSVMap", "", "", "", "checkStatus", "Lcom/atlassian/cmpt/check/base/CheckStatus;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "buildFinalMap", "beans", "", "Lcom/atlassian/jira/migration/preflight/csv/AdvancedRoadmapsMissingProjectsCSVData;", "getCSVFileName", "executionId", "type", "planName", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "performCheck", "checkRequest", "processMissingProjects", "planId", "advancedRoadmapsNameMap", "", "missingProjectsIds", "", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAdvancedRoadmapsMissingProjectsCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvancedRoadmapsMissingProjectsCheck.kt\ncom/atlassian/jira/migration/preflight/AdvancedRoadmapsMissingProjectsCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,172:1\n1549#2:173\n1620#2,3:174\n1208#2,2:177\n1238#2,4:179\n1855#2,2:185\n215#3,2:183\n*S KotlinDebug\n*F\n+ 1 AdvancedRoadmapsMissingProjectsCheck.kt\ncom/atlassian/jira/migration/preflight/AdvancedRoadmapsMissingProjectsCheck\n*L\n95#1:173\n95#1:174,3\n95#1:177,2\n95#1:179,4\n113#1:185,2\n101#1:183,2\n*E\n"})
public final class AdvancedRoadmapsMissingProjectsCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    private final AdvancedRoadmapsMissingProjectsCheckService advancedRoadmapsMissingProjectsCheckService;
    @NotNull
    private final PlanDataReader planDataReader;
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final CheckType checkType;

    @Inject
    public AdvancedRoadmapsMissingProjectsCheck(@NotNull AdvancedRoadmapsMissingProjectsCheckService advancedRoadmapsMissingProjectsCheckService, @NotNull PlanDataReader planDataReader, @NotNull ProjectManager projectManager) {
        Intrinsics.checkNotNullParameter((Object)advancedRoadmapsMissingProjectsCheckService, (String)"advancedRoadmapsMissingProjectsCheckService");
        Intrinsics.checkNotNullParameter((Object)planDataReader, (String)"planDataReader");
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        this.advancedRoadmapsMissingProjectsCheckService = advancedRoadmapsMissingProjectsCheckService;
        this.planDataReader = planDataReader;
        this.projectManager = projectManager;
        this.checkType = CheckType.AdvancedRoadmapsMissingProjects;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"projectKeys", ctx.getProjectKeys()), TuplesKt.to((Object)"preflightCheckExecutionId", (Object)ctx.getPreflightCheckExecutionId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId()), TuplesKt.to((Object)"containerToken", (Object)ctx.getContainerToken()), TuplesKt.to((Object)"loggedUser", (Object)ctx.getLoggedUser()), TuplesKt.to((Object)"migrationType", (Object)((Object)ctx.getMigrationType())), TuplesKt.to((Object)"planId", (Object)ctx.getPlanId()), TuplesKt.to((Object)"advancedRoadmapsPlanIds", ctx.getAdvancedRoadmapsPlanIds()), TuplesKt.to((Object)"crossProjectConfig", (Object)ctx.getCrossProjectConfig()), TuplesKt.to((Object)"cloudId", (Object)ctx.getCloudId()), TuplesKt.to((Object)"advancedRoadmapsMigrationMode", (Object)((Object)ctx.getAdvancedRoadmapsMigrationMode()))};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        return this.advancedRoadmapsMissingProjectsCheckService.performCheck(checkRequest);
    }

    @VisibleForTesting
    public void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        dto.setNumberOfOccurrences(Integer.valueOf(0));
        dto.setDetails(new CheckDetailsDto());
        Status status = dto.getStatus();
        switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                dto.setDescription("Checking if projects related to plans are selected");
                break;
            }
            case 2: {
                dto.setStatus(Status.EXECUTION_ERROR);
                dto.setDescription("We couldn't check if projects related to plans are selected");
                break;
            }
            default: {
                if (checkResult == null) {
                    dto.setStatus(Status.RUNNING);
                    dto.setDescription("Checking if projects related to plans are selected");
                    break;
                }
                if (checkResult.details.isEmpty()) {
                    dto.setStatus(Status.SUCCESS);
                    dto.setDescription("All projects related to plans selected");
                    break;
                }
                dto.setStatus(Status.WARNING);
                dto.setDescription("Some projects related to plans aren't selected");
            }
        }
    }

    @Override
    @NotNull
    public String getCSVFileName(@NotNull String executionId, @NotNull CheckType type, @Nullable String planName) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_hh-mm-ss");
        String dateTime = formatter.format(LocalDateTime.now());
        String string = planName;
        if (string == null) {
            string = executionId;
        }
        String migrationName = string;
        return migrationName + "_Pre-migration_checks_Plans_missing_projects_Jira_" + dateTime + "_result.csv";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Object> buildCSVMap(@NotNull CheckStatus checkStatus) {
        List beans;
        block6: {
            Map map;
            Object object;
            Intrinsics.checkNotNullParameter((Object)checkStatus, (String)"checkStatus");
            if (checkStatus.checkResult == null || checkStatus.checkResult.success && checkStatus.checkResult.details.isEmpty()) {
                return MapsKt.mapOf((Pair)TuplesKt.to((Object)"headers", (Object)AdvancedRoadmapsMissingProjectsCheckKt.getADVANCED_ROADMAPS_MISSING_PROJECTS_HEADERS()));
            }
            Map map2 = checkStatus.checkResult.details;
            Map missingProjectsFromPlansMap = map2 instanceof Map ? map2 : null;
            Map map3 = missingProjectsFromPlansMap;
            if (map3 != null && (map3 = map3.keySet()) != null) {
                void $this$associateByTo$iv$iv;
                Object object2;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map it = map3;
                boolean bl = false;
                Iterable iterable = (Iterable)((Object)it);
                object = this.planDataReader;
                boolean $i$f$map = false;
                void var11_13 = $this$map$iv;
                Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void id;
                    String string = (String)item$iv$iv;
                    object2 = destination$iv$iv;
                    boolean bl2 = false;
                    object2.add(Long.parseLong((String)id));
                }
                Iterable $this$associateBy$iv = ((PlanDataReader)object).getPlans((List)destination$iv$iv);
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                destination$iv$iv = $this$associateBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    AdvancedRoadmapsPlanData bl2 = (AdvancedRoadmapsPlanData)element$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl3 = false;
                    AdvancedRoadmapsPlanData plan2 = (AdvancedRoadmapsPlanData)element$iv$iv;
                    object2 = plan2.getId();
                    boolean bl4 = false;
                    String string = plan2.getTitle();
                    object.put(object2, string);
                }
                map = destination$iv$iv2;
            } else {
                map = new LinkedHashMap();
            }
            Map advancedRoadmapsNameMap = map;
            beans = new ArrayList();
            Map map4 = missingProjectsFromPlansMap;
            if (map4 == null) break block6;
            Map missingProjectsMap = map4;
            boolean bl = false;
            Map $this$forEach$iv = missingProjectsMap;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl5 = false;
                String planId = (String)entry.getKey();
                Set projectIds = (Set)entry.getValue();
                this.processMissingProjects(planId, beans, advancedRoadmapsNameMap, projectIds);
            }
        }
        return this.buildFinalMap(beans);
    }

    private final void processMissingProjects(String planId, List<AdvancedRoadmapsMissingProjectsCSVData> beans, Map<Long, String> advancedRoadmapsNameMap, Set<Long> missingProjectsIds) {
        String string = advancedRoadmapsNameMap.get(Long.parseLong(planId));
        if (string == null) {
            string = "";
        }
        String planName = string;
        Iterable $this$forEach$iv = missingProjectsIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String projectName;
            long projectId = ((Number)element$iv).longValue();
            boolean bl = false;
            Project project = this.projectManager.getProjectObj(Long.valueOf(projectId));
            String string2 = projectName = project != null ? project.getName() : null;
            if (projectName == null) continue;
            boolean bl2 = false;
            beans.add(new AdvancedRoadmapsMissingProjectsCSVData(planId, planName, String.valueOf(projectId), projectName));
        }
    }

    private final Map<String, Object> buildFinalMap(List<AdvancedRoadmapsMissingProjectsCSVData> beans) {
        Map map;
        if (beans.isEmpty()) {
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"headers", (Object)AdvancedRoadmapsMissingProjectsCheckKt.getADVANCED_ROADMAPS_MISSING_PROJECTS_HEADERS()));
        } else {
            Pair[] pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to((Object)"headers", (Object)AdvancedRoadmapsMissingProjectsCheckKt.getADVANCED_ROADMAPS_MISSING_PROJECTS_HEADERS());
            String[] stringArray = new String[]{"planId", "planName", "projectId", "projectName"};
            pairArray[1] = TuplesKt.to((Object)"mappings", (Object)stringArray);
            pairArray[2] = TuplesKt.to((Object)"beans", beans);
            map = MapsKt.mapOf((Pair[])pairArray);
        }
        return map;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.EXECUTION_ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

