/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.jira.migration.common.MigrationTaskMetadata;
import com.atlassian.jira.migration.export.advancedroadmaps.IssueSourceService;
import com.atlassian.jira.migration.export.framework.CompositeEventHandler;
import com.atlassian.jira.migration.export.framework.CrossProjectDataExportContext;
import com.atlassian.jira.migration.export.framework.ExportEventHandler;
import com.atlassian.jira.migration.plan.AdvancedRoadmapPlanMigrationMode;
import com.atlassian.jira.migration.plan.CrossProjectConfig;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/jira/migration/preflight/AdvancedRoadmapsMissingProjectsCheckService;", "", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "issueSourceService", "Lcom/atlassian/jira/migration/export/advancedroadmaps/IssueSourceService;", "(Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/migration/export/advancedroadmaps/IssueSourceService;)V", "performCheck", "Lcom/atlassian/jira/migration/preflight/model/NotBlockingCheckResult;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAdvancedRoadmapsMissingProjectsCheckService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvancedRoadmapsMissingProjectsCheckService.kt\ncom/atlassian/jira/migration/preflight/AdvancedRoadmapsMissingProjectsCheckService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,57:1\n1603#2,9:58\n1855#2:67\n1856#2:69\n1612#2:70\n1238#2,4:73\n1#3:68\n468#4:71\n414#4:72\n*S KotlinDebug\n*F\n+ 1 AdvancedRoadmapsMissingProjectsCheckService.kt\ncom/atlassian/jira/migration/preflight/AdvancedRoadmapsMissingProjectsCheckService\n*L\n22#1:58,9\n22#1:67\n22#1:69\n22#1:70\n51#1:73,4\n22#1:68\n51#1:71\n51#1:72\n*E\n"})
public final class AdvancedRoadmapsMissingProjectsCheckService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final IssueSourceService issueSourceService;
    private static final Logger log = LoggerFactory.getLogger(AdvancedRoadmapsMissingProjectsCheckService.class);

    @Inject
    public AdvancedRoadmapsMissingProjectsCheckService(@NotNull ProjectManager projectManager, @NotNull IssueSourceService issueSourceService) {
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)issueSourceService, (String)"issueSourceService");
        this.projectManager = projectManager;
        this.issueSourceService = issueSourceService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NotBlockingCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Map map;
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        CrossProjectDataExportContext context;
        Map<Long, Set<Long>> missingProjectsFromPlansMap;
        Object it$iv$iv;
        Object it;
        Object $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        log.info("Checking for missing projects related to advanced roadmaps plans in scope");
        Iterable $this$mapNotNull$iv = PreflightCheckKt.getProjectKeys(checkRequest);
        boolean $i$f$mapNotNull22 = false;
        Iterable iterable = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        AdvancedRoadmapPlanMigrationMode $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            it = (String)element$iv$iv;
            boolean bl2 = false;
            Project project = this.projectManager.getProjectObjByKeyIgnoreCase((String)it);
            if ((project != null ? project.getId() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List projectIds = (List)destination$iv$iv;
        MigrationTaskMetadata $i$f$mapNotNull22 = MigrationTaskMetadata.Companion.dummyMigrationMetadata(PreflightCheckKt.getLoggedUser(checkRequest), PreflightCheckKt.getCloudId(checkRequest), PreflightCheckKt.getContainerToken(checkRequest));
        $this$mapNotNullTo$iv$iv = new CompositeEventHandler(new ExportEventHandler[0]);
        destination$iv$iv = PreflightCheckKt.getCrossProjectConfig(checkRequest);
        List list = PreflightCheckKt.getAdvancedRoadmapsPlanIds(checkRequest);
        if (list == null) {
            list = $i$f$mapNotNullTo22 = CollectionsKt.emptyList();
        }
        if ((missingProjectsFromPlansMap = this.issueSourceService.getAllMissingProjectIdsFromPlansMap(context = new CrossProjectDataExportContext(projectIds, $i$f$mapNotNull22, (ExportEventHandler)$this$mapNotNullTo$iv$iv, null, null, null, null, null, null, (CrossProjectConfig)destination$iv$iv, null, $this$forEach$iv$iv$iv = PreflightCheckKt.getAdvancedRoadmapsMigrationMode(checkRequest), $i$f$mapNotNullTo22, null, 9720, null))).isEmpty()) {
            log.info("No missing projects related to advanced roadmaps plans in scope");
            return new NotBlockingCheckResult(true);
        }
        log.info("Found missing projects related to advanced roadmaps plans in scope");
        $this$mapNotNullTo$iv$iv = missingProjectsFromPlansMap;
        boolean bl = false;
        boolean $i$f$mapKeys = false;
        List $i$f$mapNotNullTo22 = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            it = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv2;
            boolean bl4 = false;
            it$iv$iv = (Map.Entry)element$iv$iv$iv;
            String string = String.valueOf(((Number)it.getKey()).longValue());
            Map map2 = map;
            boolean bl5 = false;
            Object v = it$iv$iv.getValue();
            map2.put(string, v);
        }
        Map map3 = map = destination$iv$iv2;
        boolean bl6 = bl;
        return new NotBlockingCheckResult(bl6, map3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/AdvancedRoadmapsMissingProjectsCheckService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

