/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.LinkDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.preflight.AdvancedRoadmapsOutdatedCheckService;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.model.CheckType;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001b\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0015H\u0016R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/preflight/AdvancedRoadmapsOutdatedCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "checkService", "Lcom/atlassian/jira/migration/preflight/AdvancedRoadmapsOutdatedCheckService;", "(Lcom/atlassian/jira/migration/preflight/AdvancedRoadmapsOutdatedCheckService;)V", "advancedRoadmapsOutdatedCheckService", "buildUpdateUrl", "Lkotlin/Function0;", "", "(Lcom/atlassian/jira/migration/preflight/AdvancedRoadmapsOutdatedCheckService;Lkotlin/jvm/functions/Function0;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "updateUrl", "getUpdateUrl", "()Ljava/lang/String;", "updateUrl$delegate", "Lkotlin/Lazy;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "performCheck", "checkRequest", "jira-migration-plugin"})
public final class AdvancedRoadmapsOutdatedCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    private final AdvancedRoadmapsOutdatedCheckService advancedRoadmapsOutdatedCheckService;
    @NotNull
    private final Lazy updateUrl$delegate;
    @NotNull
    private final CheckType checkType;

    public AdvancedRoadmapsOutdatedCheck(@NotNull AdvancedRoadmapsOutdatedCheckService advancedRoadmapsOutdatedCheckService, @NotNull Function0<String> buildUpdateUrl) {
        Intrinsics.checkNotNullParameter((Object)advancedRoadmapsOutdatedCheckService, (String)"advancedRoadmapsOutdatedCheckService");
        Intrinsics.checkNotNullParameter(buildUpdateUrl, (String)"buildUpdateUrl");
        this.advancedRoadmapsOutdatedCheckService = advancedRoadmapsOutdatedCheckService;
        this.updateUrl$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(buildUpdateUrl){
            final /* synthetic */ Function0<String> $buildUpdateUrl;
            {
                this.$buildUpdateUrl = $buildUpdateUrl;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return (String)this.$buildUpdateUrl.invoke();
            }
        }));
        this.checkType = CheckType.AdvancedRoadmapsOutdated;
    }

    @Inject
    public AdvancedRoadmapsOutdatedCheck(@NotNull AdvancedRoadmapsOutdatedCheckService checkService) {
        Intrinsics.checkNotNullParameter((Object)checkService, (String)"checkService");
        this(checkService, (Function0<String>)((Function0)1.INSTANCE));
    }

    private final String getUpdateUrl() {
        Lazy lazy = this.updateUrl$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mutableMapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        return this.advancedRoadmapsOutdatedCheckService.performCheck();
    }

    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        dto.setNumberOfOccurrences(Integer.valueOf(0));
        dto.setDetails(new CheckDetailsDto());
        Status status = dto.getStatus();
        switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                dto.setDescription("Advanced Roadmaps is up to date");
                break;
            }
            case 2: 
            case 3: {
                dto.setDescription("Advanced Roadmaps needs to be updated to be able to migrate");
                dto.getDetails().setLongDescription("Only plans with the improved interface are supported in Advanced Roadmaps 3.0 and later. After the migration, all live plans will become plans with the improved interface.");
                dto.setLink(new LinkDto("Update now", this.getUpdateUrl()));
                break;
            }
            case 4: {
                dto.setDescription("Checking version of Advanced Roadmaps");
                break;
            }
            case -1: 
            case 5: {
                dto.setDescription("We couldn't check your version of AR");
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.RUNNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.EXECUTION_ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

