/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\u0006H\u0002J\b\u0010\n\u001a\u00020\u0006H\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/jira/migration/preflight/AdvancedRoadmapsOutdatedCheckService;", "", "pluginAccessor", "Lcom/atlassian/plugin/PluginAccessor;", "(Lcom/atlassian/plugin/PluginAccessor;)V", "pluginVersion", "", "getPluginVersion", "()Ljava/lang/String;", "findPluginVersion", "findPluginVersionOrThrow", "isNeedToUpgradeAdvancedRoadmapsVersion", "", "isPluginVersionUnknown", "performCheck", "Lcom/atlassian/cmpt/check/base/CheckResult;", "Companion", "jira-migration-plugin"})
public final class AdvancedRoadmapsOutdatedCheckService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginAccessor pluginAccessor;
    private static final Logger log = LoggerFactory.getLogger(AdvancedRoadmapsOutdatedCheckService.class);
    @NotNull
    public static final String PLUGIN_KEY = "com.radiantminds.roadmaps-jira";
    @NotNull
    public static final String UNKNOWN_VERSION = "UNKNOWN";
    public static final int MIN_SUPPORTED_ADVANCED_ROADMAPS_VERSION = 3;

    @Inject
    public AdvancedRoadmapsOutdatedCheckService(@NotNull PluginAccessor pluginAccessor) {
        Intrinsics.checkNotNullParameter((Object)pluginAccessor, (String)"pluginAccessor");
        this.pluginAccessor = pluginAccessor;
    }

    @NotNull
    public final String getPluginVersion() {
        return this.findPluginVersion();
    }

    @NotNull
    public final CheckResult performCheck() {
        boolean bl;
        if (this.isPluginVersionUnknown()) {
            log.warn("Current version of the Advanced Roadmaps plugin is unknown. Will assume that Advanced Roadmaps plugin version is not outdated.");
            bl = false;
        } else {
            bl = this.isNeedToUpgradeAdvancedRoadmapsVersion();
        }
        boolean isOutdated = bl;
        return new CheckResult(!isOutdated);
    }

    public final boolean isPluginVersionUnknown() {
        return Intrinsics.areEqual((Object)this.getPluginVersion(), (Object)UNKNOWN_VERSION);
    }

    public final boolean isNeedToUpgradeAdvancedRoadmapsVersion() {
        String[] stringArray = new String[]{"."};
        List fullVersion = StringsKt.split$default((CharSequence)this.getPluginVersion(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        int major = Integer.parseInt((String)fullVersion.get(0));
        return major < 3;
    }

    private final String findPluginVersion() {
        String string;
        try {
            String version = this.findPluginVersionOrThrow();
            log.debug("Found version " + version + " for Advanced Roadmaps plugin with key com.radiantminds.roadmaps-jira.");
        }
        catch (RuntimeException e) {
            log.warn("Plugin version could not be determined for Advanced Roadmaps plugin with key com.radiantminds.roadmaps-jira. Reason=" + e.getMessage() + '.', (Throwable)e);
            string = UNKNOWN_VERSION;
        }
        return string;
    }

    private final String findPluginVersionOrThrow() {
        Object object = this.pluginAccessor.getPlugin(PLUGIN_KEY);
        if (object == null) {
            throw new IllegalStateException("Plugin accessor failed to find Advanced Roadmaps plugin with key com.radiantminds.roadmaps-jira");
        }
        Plugin plugin = object;
        PluginInformation pluginInformation = plugin.getPluginInformation();
        String string = object = pluginInformation != null ? pluginInformation.getVersion() : null;
        if (object == null) {
            throw new IllegalStateException("Found Advanced Roadmaps plugin, but failed to find its version.");
        }
        return object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/jira/migration/preflight/AdvancedRoadmapsOutdatedCheckService$Companion;", "", "()V", "MIN_SUPPORTED_ADVANCED_ROADMAPS_VERSION", "", "PLUGIN_KEY", "", "UNKNOWN_VERSION", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

