/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.plan.MigrationType;
import com.atlassian.jira.migration.preflight.AdvancedRoadmapsProjectMigratedConflictCheck;
import com.atlassian.jira.migration.preflight.AdvancedRoadmapsProjectMigratedConflictCheckKt;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.ProjectConflict;
import com.atlassian.jira.migration.preflight.ProjectConflictService;
import com.atlassian.jira.migration.preflight.csv.AdvancedRoadmapsProjectMigratedConflictCSVData;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.serverdataextractors.RelatedEntitiesDataReader;
import com.atlassian.jira.migration.serverdataextractors.ServerProjectDto;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001bH\u0002J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0013H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/atlassian/jira/migration/preflight/AdvancedRoadmapsProjectMigratedConflictCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "projectConflictService", "Lcom/atlassian/jira/migration/preflight/ProjectConflictService;", "relatedEntitiesDataReader", "Lcom/atlassian/jira/migration/serverdataextractors/RelatedEntitiesDataReader;", "(Lcom/atlassian/jira/migration/preflight/ProjectConflictService;Lcom/atlassian/jira/migration/serverdataextractors/RelatedEntitiesDataReader;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCSVMap", "", "", "", "checkStatus", "Lcom/atlassian/cmpt/check/base/CheckStatus;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "getCSVFileName", "executionId", "type", "planName", "getProjectKeysForARPlans", "", "arPlanIds", "", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "performCheck", "checkRequest", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAdvancedRoadmapsProjectMigratedConflictCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvancedRoadmapsProjectMigratedConflictCheck.kt\ncom/atlassian/jira/migration/preflight/AdvancedRoadmapsProjectMigratedConflictCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1549#2:133\n1620#2,3:134\n*S KotlinDebug\n*F\n+ 1 AdvancedRoadmapsProjectMigratedConflictCheck.kt\ncom/atlassian/jira/migration/preflight/AdvancedRoadmapsProjectMigratedConflictCheck\n*L\n93#1:133\n93#1:134,3\n*E\n"})
public final class AdvancedRoadmapsProjectMigratedConflictCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    private final ProjectConflictService projectConflictService;
    @NotNull
    private final RelatedEntitiesDataReader relatedEntitiesDataReader;
    @NotNull
    private final CheckType checkType;

    @Inject
    public AdvancedRoadmapsProjectMigratedConflictCheck(@NotNull ProjectConflictService projectConflictService, @NotNull RelatedEntitiesDataReader relatedEntitiesDataReader) {
        Intrinsics.checkNotNullParameter((Object)projectConflictService, (String)"projectConflictService");
        Intrinsics.checkNotNullParameter((Object)relatedEntitiesDataReader, (String)"relatedEntitiesDataReader");
        this.projectConflictService = projectConflictService;
        this.relatedEntitiesDataReader = relatedEntitiesDataReader;
        this.checkType = CheckType.AdvancedRoadmapsProjectMigratedConflict;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"projectKeys", ctx.getProjectKeys()), TuplesKt.to((Object)"preflightCheckExecutionId", (Object)ctx.getPreflightCheckExecutionId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId()), TuplesKt.to((Object)"containerToken", (Object)ctx.getContainerToken()), TuplesKt.to((Object)"loggedUser", (Object)ctx.getLoggedUser()), TuplesKt.to((Object)"migrationType", (Object)((Object)ctx.getMigrationType())), TuplesKt.to((Object)"planId", (Object)ctx.getPlanId()), TuplesKt.to((Object)"advancedRoadmapsPlanIds", ctx.getAdvancedRoadmapsPlanIds())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        List list = PreflightCheckKt.getAdvancedRoadmapsPlanIds(checkRequest);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List<String> projectKeys = this.getProjectKeysForARPlans(list);
        String containerToken = PreflightCheckKt.getContainerToken(checkRequest);
        MigrationType migrationType = PreflightCheckKt.getMigrationType(checkRequest);
        String planId = PreflightCheckKt.getPlanId(checkRequest);
        return this.projectConflictService.performProjectKeyNameConflictCheck(containerToken, projectKeys, migrationType, planId, false);
    }

    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        dto.setNumberOfOccurrences(Integer.valueOf(0));
        dto.setDetails(new CheckDetailsDto());
        Status status = dto.getStatus();
        switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                dto.setDescription("Checking for projects related to plans in cloud");
                break;
            }
            case 2: {
                dto.setStatus(Status.EXECUTION_ERROR);
                dto.setDescription("We couldn't check if projects related to plans are in cloud");
                break;
            }
            default: {
                if (checkResult == null) {
                    dto.setStatus(Status.RUNNING);
                    dto.setDescription("Checking for projects related to plans in cloud");
                    break;
                }
                if (checkResult.details.isEmpty()) {
                    dto.setStatus(Status.SUCCESS);
                    dto.setDescription("There are no projects related to plans in cloud");
                    break;
                }
                dto.setStatus(Status.WARNING);
                dto.setDescription("Some projects related to plans already present in cloud");
            }
        }
    }

    @Override
    @NotNull
    public String getCSVFileName(@NotNull String executionId, @NotNull CheckType type, @Nullable String planName) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_hh-mm-ss");
        String dateTime = formatter.format(LocalDateTime.now());
        String string = planName;
        if (string == null) {
            string = executionId;
        }
        String migrationName = string;
        return migrationName + "_Pre-migration_checks_Plans_Migrated_issue_sources_Jira_" + dateTime + "_result.csv";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Object> buildCSVMap(@NotNull CheckStatus checkStatus) {
        Intrinsics.checkNotNullParameter((Object)checkStatus, (String)"checkStatus");
        if (checkStatus.checkResult == null || checkStatus.checkResult.success && checkStatus.checkResult.details.isEmpty()) {
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)"headers", (Object)AdvancedRoadmapsProjectMigratedConflictCheckKt.getADVANCED_ROADMAPS_PROJECT_MIGRATION_HEADERS()));
        }
        Object v = checkStatus.checkResult.details.get("projectConflicts");
        List projects = v instanceof List ? (List)v : null;
        List projectKeys = CollectionsKt.emptyList();
        if (projects != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = projects;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p;
                ProjectConflict projectConflict = (ProjectConflict)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p.getServerKey());
            }
            projectKeys = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }
        List beans = new ArrayList();
        int n = projectKeys.size();
        for (int i = 0; i < n; ++i) {
            String key = i < projectKeys.size() ? (String)projectKeys.get(i) : "";
            beans.add(new AdvancedRoadmapsProjectMigratedConflictCSVData(key, "Project"));
        }
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"headers", (Object)AdvancedRoadmapsProjectMigratedConflictCheckKt.getADVANCED_ROADMAPS_PROJECT_MIGRATION_HEADERS());
        String[] stringArray = new String[]{"project", "type"};
        pairArray[1] = TuplesKt.to((Object)"mappings", (Object)stringArray);
        pairArray[2] = TuplesKt.to((Object)"beans", (Object)beans);
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final List<String> getProjectKeysForARPlans(List<Long> arPlanIds) {
        List<ServerProjectDto> advancedRoadmapsProjects = this.relatedEntitiesDataReader.getProjectsFromPlans(arPlanIds);
        List<String> list = advancedRoadmapsProjects.stream().map(arg_0 -> AdvancedRoadmapsProjectMigratedConflictCheck.getProjectKeysForARPlans$lambda$1(getProjectKeysForARPlans.1.INSTANCE, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        return list;
    }

    private static final String getProjectKeysForARPlans$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.EXECUTION_ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

