/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.jira.migration.advancedroadmaps.AdvancedRoadmapsProjectsService;
import com.atlassian.jira.migration.analytics.allinonpbp.AllInOnPbpEventService;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.plan.PbpMigrationMode;
import com.atlassian.jira.migration.plan.Plan;
import com.atlassian.jira.migration.plan.PlanRepository;
import com.atlassian.jira.migration.preflight.AllInOnPbpPlanInfo;
import com.atlassian.jira.migration.preflight.JiraDataInfo;
import com.atlassian.jira.migration.preflight.model.CheckMode;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.serverdataextractors.ServerDataAggregator;
import com.atlassian.jira.migration.serverdataextractors.ServerProjectDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/preflight/AllInOnPbpHelper;", "", "planRepository", "Lcom/atlassian/jira/migration/plan/PlanRepository;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "serverDataAggregator", "Lcom/atlassian/jira/migration/serverdataextractors/ServerDataAggregator;", "allInOnPbpEventService", "Lcom/atlassian/jira/migration/analytics/allinonpbp/AllInOnPbpEventService;", "advancedRoadmapsProjectsService", "Lcom/atlassian/jira/migration/advancedroadmaps/AdvancedRoadmapsProjectsService;", "(Lcom/atlassian/jira/migration/plan/PlanRepository;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/serverdataextractors/ServerDataAggregator;Lcom/atlassian/jira/migration/analytics/allinonpbp/AllInOnPbpEventService;Lcom/atlassian/jira/migration/advancedroadmaps/AdvancedRoadmapsProjectsService;)V", "computeJiraDataInfo", "Lcom/atlassian/jira/migration/preflight/JiraDataInfo;", "getPreflightChecksToRemove", "", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "checkMode", "Lcom/atlassian/jira/migration/preflight/model/CheckMode;", "isAllInOnPbpPlan", "", "plan", "Lcom/atlassian/jira/migration/plan/Plan;", "logAndEmitAllInOnDraftPlanPreflightStats", "", "executionId", "", "allInOnPbpPlanInfo", "Lcom/atlassian/jira/migration/preflight/AllInOnPbpPlanInfo;", "updatePlanIfNewDataAvailable", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAllInOnPbpHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllInOnPbpHelper.kt\ncom/atlassian/jira/migration/preflight/AllInOnPbpHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1549#2:153\n1620#2,3:154\n*S KotlinDebug\n*F\n+ 1 AllInOnPbpHelper.kt\ncom/atlassian/jira/migration/preflight/AllInOnPbpHelper\n*L\n116#1:153\n116#1:154,3\n*E\n"})
public final class AllInOnPbpHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlanRepository planRepository;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final ServerDataAggregator serverDataAggregator;
    @NotNull
    private final AllInOnPbpEventService allInOnPbpEventService;
    @NotNull
    private final AdvancedRoadmapsProjectsService advancedRoadmapsProjectsService;
    private static final Logger log = LoggerFactory.getLogger(AllInOnPbpHelper.class);
    @NotNull
    private static final String DRAFT_PLAN_KEY = "draftPlan";

    @Inject
    public AllInOnPbpHelper(@NotNull PlanRepository planRepository, @NotNull MigrationFeatures migrationFeatures, @NotNull ServerDataAggregator serverDataAggregator, @NotNull AllInOnPbpEventService allInOnPbpEventService, @NotNull AdvancedRoadmapsProjectsService advancedRoadmapsProjectsService) {
        Intrinsics.checkNotNullParameter((Object)planRepository, (String)"planRepository");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)serverDataAggregator, (String)"serverDataAggregator");
        Intrinsics.checkNotNullParameter((Object)allInOnPbpEventService, (String)"allInOnPbpEventService");
        Intrinsics.checkNotNullParameter((Object)advancedRoadmapsProjectsService, (String)"advancedRoadmapsProjectsService");
        this.planRepository = planRepository;
        this.migrationFeatures = migrationFeatures;
        this.serverDataAggregator = serverDataAggregator;
        this.allInOnPbpEventService = allInOnPbpEventService;
        this.advancedRoadmapsProjectsService = advancedRoadmapsProjectsService;
    }

    public final boolean isAllInOnPbpPlan(@NotNull Plan plan2) {
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        return this.migrationFeatures.getEnableAllInOnPbpFeature() && plan2.getPbpMigrationMode() == PbpMigrationMode.SELECT_ALL_DATA;
    }

    public final boolean updatePlanIfNewDataAvailable(@NotNull Plan plan2) {
        boolean bl;
        List list;
        List excludedProjectKeys;
        Intrinsics.checkNotNullParameter((Object)plan2, (String)"plan");
        List<String> planProjectKeys = plan2.getProjectKeys();
        List list2 = plan2.getExcludedProjectKeys();
        if (list2 == null) {
            list2 = excludedProjectKeys = CollectionsKt.emptyList();
        }
        if ((list = plan2.getAdvancedRoadmapsPlanIds()) == null) {
            list = CollectionsKt.emptyList();
        }
        List planArPlanIds = list;
        JiraDataInfo jiraDataInfo = this.computeJiraDataInfo();
        List<String> newProjectsPostPlanSave = jiraDataInfo.newProjectsAddedPostPlanSave(planProjectKeys, excludedProjectKeys);
        List<Long> newArPlansPostPlanSave = jiraDataInfo.newArPlansAddedPostPlanSave(planArPlanIds);
        if (!((Collection)newProjectsPostPlanSave).isEmpty() || !((Collection)newArPlansPostPlanSave).isEmpty()) {
            plan2.setProjectKeys(CollectionsKt.minus((Iterable)jiraDataInfo.getJiraProjectKeys(), (Iterable)CollectionsKt.toSet((Iterable)excludedProjectKeys)));
            plan2.setAdvancedRoadmapsPlanIds(jiraDataInfo.getJiraArPlanIds());
            this.planRepository.update(plan2);
            log.info("Updated all-in-on-pbp plan - " + plan2.getPlanName() + " with new project keys: " + newProjectsPostPlanSave + " and new AR plans: " + newArPlansPostPlanSave + " during preflight execution id: " + plan2.getPreflightCheckExecutionId());
            bl = true;
        } else {
            log.info("No new projects and AR plans found for SELECT ALL DATA plan after it was saved");
            bl = false;
        }
        boolean isUpdatedPostPlanSave = bl;
        this.allInOnPbpEventService.emitPreflightStatsEvent(plan2.getId(), plan2.getPreflightCheckExecutionId(), CheckMode.Preflight2, new AllInOnPbpPlanInfo(planProjectKeys, planArPlanIds, excludedProjectKeys, newProjectsPostPlanSave, newArPlansPostPlanSave, isUpdatedPostPlanSave));
        return isUpdatedPostPlanSave;
    }

    @NotNull
    public final List<CheckType> getPreflightChecksToRemove(@NotNull CheckMode checkMode) {
        List list;
        Intrinsics.checkNotNullParameter((Object)((Object)checkMode), (String)"checkMode");
        if (checkMode == CheckMode.Preflight2) {
            log.info("Skipping CPB, Dashboard and AR preflight runs for saved SELECT ALL DATA plan");
            CheckType[] checkTypeArray = new CheckType[]{CheckType.CrossProjectEntityMissingProjectSelection, CheckType.DashboardsMissingProjectSelection, CheckType.AdvancedRoadmapsMissingProjects};
            list = CollectionsKt.listOf((Object[])checkTypeArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void logAndEmitAllInOnDraftPlanPreflightStats(@NotNull String executionId, @NotNull AllInOnPbpPlanInfo allInOnPbpPlanInfo) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)allInOnPbpPlanInfo, (String)"allInOnPbpPlanInfo");
        log.info("Executing preflight checks with execution id " + executionId + " for Select All Data plan with project keys: " + allInOnPbpPlanInfo.getIncludedProjectKeys() + " and AR plan ids: " + allInOnPbpPlanInfo.getIncludedArPlanIds() + "excluding project keys: " + allInOnPbpPlanInfo.getExcludedProjectKeys());
        this.allInOnPbpEventService.emitPreflightStatsEvent(DRAFT_PLAN_KEY, executionId, CheckMode.Preflight1, allInOnPbpPlanInfo);
    }

    /*
     * WARNING - void declaration
     */
    private final JiraDataInfo computeJiraDataInfo() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.serverDataAggregator.getOrComputeProjectStats();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ServerProjectDto serverProjectDto = (ServerProjectDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey());
        }
        List allProjectKeys = (List)destination$iv$iv;
        List<Long> allArPlanIds = this.advancedRoadmapsProjectsService.getAllPlanIds();
        return new JiraDataInfo(allProjectKeys, allArPlanIds);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/atlassian/jira/migration/preflight/AllInOnPbpHelper$Companion;", "", "()V", "DRAFT_PLAN_KEY", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

