/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.AnonPermissionPreflightCheckKt;
import com.atlassian.jira.migration.preflight.AnonPermissionPreflightService;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.csv.AnonPermissionCSVData;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.google.common.annotations.VisibleForTesting;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0002H\u0002J\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0015H\u0016J\b\u0010%\u001a\u00020 H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006&"}, d2={"Lcom/atlassian/jira/migration/preflight/AnonPermissionPreflightCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "anonPermService", "Lcom/atlassian/jira/migration/preflight/AnonPermissionPreflightService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "(Lcom/atlassian/jira/migration/preflight/AnonPermissionPreflightService;Lcom/atlassian/jira/migration/features/MigrationFeatures;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getMigrationFeatures", "()Lcom/atlassian/jira/migration/features/MigrationFeatures;", "buildCSVMap", "", "", "", "checkStatus", "Lcom/atlassian/cmpt/check/base/CheckStatus;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "getCSVFileName", "executionId", "type", "planName", "getOccurrenceCount", "", "checkResult", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "performCheck", "checkRequest", "setStatusMessages", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAnonPermissionPreflightCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnonPermissionPreflightCheck.kt\ncom/atlassian/jira/migration/preflight/AnonPermissionPreflightCheck\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1#2:157\n*E\n"})
public final class AnonPermissionPreflightCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    private final AnonPermissionPreflightService anonPermService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final CheckType checkType;

    @Inject
    public AnonPermissionPreflightCheck(@NotNull AnonPermissionPreflightService anonPermService, @NotNull MigrationFeatures migrationFeatures) {
        Intrinsics.checkNotNullParameter((Object)anonPermService, (String)"anonPermService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        this.anonPermService = anonPermService;
        this.migrationFeatures = migrationFeatures;
        this.checkType = CheckType.AnonPermission;
    }

    @NotNull
    public final MigrationFeatures getMigrationFeatures() {
        return this.migrationFeatures;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"projectKeys", ctx.getProjectKeys()), TuplesKt.to((Object)"preflightCheckExecutionId", (Object)ctx.getPreflightCheckExecutionId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId()), TuplesKt.to((Object)"loggedUser", (Object)ctx.getLoggedUser()), TuplesKt.to((Object)"crossProjectConfig", (Object)ctx.getCrossProjectConfig()), TuplesKt.to((Object)"advancedRoadmapsPlanIds", ctx.getAdvancedRoadmapsPlanIds())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        this.setStatusMessages();
        return this.anonPermService.performCheck(checkRequest);
    }

    /*
     * WARNING - void declaration
     */
    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        Integer n;
        String string;
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Status status = dto.getStatus();
        switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                string = AnonPermissionPreflightCheckKt.getANON_PERMISSION_RUNNING_MESSAGE();
                break;
            }
            case 2: {
                string = AnonPermissionPreflightCheckKt.getANON_PERMISSION_SUCCESS_MESSAGE();
                break;
            }
            case 3: 
            case 4: {
                string = AnonPermissionPreflightCheckKt.getANON_PERMISSION_ERROR_MESSAGE();
                break;
            }
            case 5: {
                string = AnonPermissionPreflightCheckKt.getANON_PERMISSION_EXECUTION_ERROR_MESSAGE();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        dto.setDescription(string);
        CheckResultDto checkResultDto = dto;
        Status status2 = dto.getStatus();
        switch (status2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status2.ordinal()]) {
            case 3: 
            case 4: {
                int n2;
                CheckResult checkResult2 = checkResult;
                if (checkResult2 != null) {
                    void it;
                    CheckResult checkResult3 = checkResult2;
                    CheckResultDto checkResultDto2 = checkResultDto;
                    boolean bl = false;
                    int n3 = this.getOccurrenceCount((CheckResult)it);
                    checkResultDto = checkResultDto2;
                    n2 = n3;
                } else {
                    n2 = 0;
                }
                n = n2;
                break;
            }
            default: {
                n = 0;
            }
        }
        checkResultDto.setNumberOfOccurrences(n);
    }

    @Override
    @NotNull
    public String getCSVFileName(@NotNull String executionId, @NotNull CheckType type, @Nullable String planName) {
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (this.migrationFeatures.getEnablePublicDashboardCheck()) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_hh-mm-ss");
            String dateTime = formatter.format(LocalDateTime.now());
            String string = planName;
            if (string == null) {
                string = executionId;
            }
            String migrationName = string;
            return migrationName + "_Pre-migration checks_Entities_Public access_Jira_" + dateTime + ".csv";
        }
        return executionId + '-' + type.name() + "-result.csv";
    }

    @Override
    @NotNull
    public Map<String, Object> buildCSVMap(@NotNull CheckStatus checkStatus) {
        String[] stringArray;
        String[] stringArray2;
        Intrinsics.checkNotNullParameter((Object)checkStatus, (String)"checkStatus");
        if (checkStatus.checkResult.success) {
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)"headers", (Object)AnonPermissionPreflightCheckKt.getANON_PERMISSION_HEADERS()));
        }
        Object v = checkStatus.checkResult.details.get("projectKeyToPermissions");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
        Map projects = (Map)v;
        List projectKeys = CollectionsKt.toList((Iterable)projects.keySet());
        Object v2 = checkStatus.checkResult.details.get("publicFilters");
        Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
        List filters = (List)v2;
        Object v3 = checkStatus.checkResult.details.get("publicDashboards");
        List list = v3 instanceof List ? (List)v3 : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List dashboards = list;
        List beanPermissions = new ArrayList();
        int n = Math.max(projectKeys.size(), Math.max(filters.size(), dashboards.size()));
        for (int i = 0; i < n; ++i) {
            String key = i < projectKeys.size() ? (String)projectKeys.get(i) : "";
            String filter = i < filters.size() ? (String)filters.get(i) : "";
            String dashboard = i < dashboards.size() ? (String)dashboards.get(i) : "";
            beanPermissions.add(new AnonPermissionCSVData(key, filter, dashboard));
        }
        if (this.migrationFeatures.getEnablePublicDashboardCheck()) {
            stringArray2 = new String[]{"project", "filter", "dashboard"};
            stringArray = stringArray2;
        } else {
            stringArray2 = new String[]{"project", "filter"};
            stringArray = stringArray2;
        }
        String[] mappings = stringArray;
        stringArray2 = new Pair[]{TuplesKt.to((Object)"headers", (Object)AnonPermissionPreflightCheckKt.getANON_PERMISSION_HEADERS()), TuplesKt.to((Object)"mappings", (Object)mappings), TuplesKt.to((Object)"beans", (Object)beanPermissions)};
        return MapsKt.mapOf((Pair[])stringArray2);
    }

    private final int getOccurrenceCount(CheckResult checkResult) {
        int n;
        Map map = checkResult.details;
        if (map != null) {
            Map it = map;
            boolean bl = false;
            int totalCount = 0;
            if (checkResult.details.keySet().contains("projectKeyToPermissions")) {
                Object v = checkResult.details.get("projectKeyToPermissions");
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
                Map projects = (Map)v;
                totalCount += CollectionsKt.toList((Iterable)projects.keySet()).size();
            }
            if (checkResult.details.keySet().contains("publicFilters")) {
                Object v = checkResult.details.get("publicFilters");
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                List filters = (List)v;
                totalCount += filters.size();
            }
            if (checkResult.details.keySet().contains("publicDashboards")) {
                Object v = checkResult.details.get("publicDashboards");
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                List dashboards = (List)v;
                totalCount += dashboards.size();
            }
            n = totalCount;
        } else {
            n = 0;
        }
        return n;
    }

    @VisibleForTesting
    public final void setStatusMessages() {
        if (this.migrationFeatures.getEnablePublicDashboardCheck()) {
            AnonPermissionPreflightCheckKt.setANON_PERMISSION_RUNNING_MESSAGE("Checking for entities with public access");
            AnonPermissionPreflightCheckKt.setANON_PERMISSION_SUCCESS_MESSAGE("There are no entities that allow public access");
            AnonPermissionPreflightCheckKt.setANON_PERMISSION_ERROR_MESSAGE("Some projects, dashboards, or filters are publicly available");
            AnonPermissionPreflightCheckKt.setANON_PERMISSION_WARNING_MESSAGE("Some projects, dashboards, or filters are publicly available");
            AnonPermissionPreflightCheckKt.setANON_PERMISSION_EXECUTION_ERROR_MESSAGE("We couldn't check for entities with public access");
            String[] stringArray = new String[]{"Projects with public access", "Filters with public access", "Dashboards with public access"};
            AnonPermissionPreflightCheckKt.setANON_PERMISSION_HEADERS(stringArray);
        } else {
            AnonPermissionPreflightCheckKt.setANON_PERMISSION_RUNNING_MESSAGE("Checking for anonymous access");
            AnonPermissionPreflightCheckKt.setANON_PERMISSION_SUCCESS_MESSAGE("No project settings allow public access");
            AnonPermissionPreflightCheckKt.setANON_PERMISSION_ERROR_MESSAGE("Project settings will allow public access");
            AnonPermissionPreflightCheckKt.setANON_PERMISSION_WARNING_MESSAGE("Projects and data will be available to the public");
            AnonPermissionPreflightCheckKt.setANON_PERMISSION_EXECUTION_ERROR_MESSAGE("We couldn't check for anonymous access");
            String[] stringArray = new String[]{"Project with permissions set to anyone", "Filters that have share type as Share with everyone"};
            AnonPermissionPreflightCheckKt.setANON_PERMISSION_HEADERS(stringArray);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.SUCCESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.WARNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.EXECUTION_ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

