/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.migration.common.PluginAccessorExtensionsKt;
import com.atlassian.jira.migration.events.AnonPermissionCheckEvent;
import com.atlassian.jira.migration.events.ExportStatistics;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.export.core.filter.service.retrieve.FilterRetrieveService;
import com.atlassian.jira.migration.export.core.portalpage.DashboardsExtractionHelper;
import com.atlassian.jira.migration.export.db.advancedroadmaps.AdvancedRoadmapsIssueSourceData;
import com.atlassian.jira.migration.export.db.advancedroadmaps.IssueSourceDataReader;
import com.atlassian.jira.migration.export.db.advancedroadmaps.IssueSourceType;
import com.atlassian.jira.migration.export.software.board.retrieve.RapidViewRetrieveService;
import com.atlassian.jira.migration.export.utils.SchemeExtensionsKt;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.jiraservice.JswService;
import com.atlassian.jira.migration.jiraservice.ProjectRapidViewServiceException;
import com.atlassian.jira.migration.plan.CrossProjectBoardAndFiltersMigrationMode;
import com.atlassian.jira.migration.plan.CrossProjectBoardsAndFiltersMigrationOption;
import com.atlassian.jira.migration.plan.CrossProjectConfig;
import com.atlassian.jira.migration.plan.CrossProjectExportConfig;
import com.atlassian.jira.migration.plan.DashboardsMigrationMode;
import com.atlassian.jira.migration.preflight.AnonPermissionPreflightService;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.utils.ProjectKeysExtractorFromGadgets;
import com.atlassian.jira.migration.sen.JiraLicenseInfo;
import com.atlassian.jira.migration.sen.SENSupplier;
import com.atlassian.jira.migration.serverdataextractors.cpb.model.CrossProjectFilterReferringProjectsInfo;
import com.atlassian.jira.migration.serverdataextractors.cpb.service.CPBFilterService;
import com.atlassian.jira.permission.JiraPermissionHolderType;
import com.atlassian.jira.permission.PermissionGrant;
import com.atlassian.jira.permission.PermissionHolderType;
import com.atlassian.jira.permission.PermissionScheme;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageManager;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.portal.PortletConfigurationManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u008d\u0001\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u001f\u001a\u00020 \u0012\u0006\u0010!\u001a\u00020\"\u00a2\u0006\u0002\u0010#J\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020.0(2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0002J(\u00102\u001a\u0014\u0012\u0004\u0012\u00020.\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0(032\f\u00104\u001a\b\u0012\u0004\u0012\u0002050(H\u0002J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020.0(2\u0006\u00107\u001a\u000208H\u0007J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u00107\u001a\u000208H\u0002J\u0014\u0010;\u001a\b\u0012\u0004\u0012\u0002010(2\u0006\u00107\u001a\u000208J\u0014\u0010<\u001a\b\u0012\u0004\u0012\u0002010=2\u0006\u00107\u001a\u000208J\u001c\u0010<\u001a\b\u0012\u0004\u0012\u0002010=2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?0(H\u0002J\u0014\u0010@\u001a\b\u0012\u0004\u0012\u0002010(2\u0006\u00107\u001a\u000208J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u0002010=2\u0006\u00107\u001a\u000208H\u0002J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u000205H\u0002J\u0014\u0010E\u001a\b\u0012\u0004\u0012\u00020.0(2\u0006\u00107\u001a\u000208J$\u0010F\u001a\b\u0012\u0004\u0012\u00020.0(2\u0006\u0010G\u001a\u00020H2\f\u00104\u001a\b\u0012\u0004\u0012\u0002050(H\u0007J\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020?0(2\u0006\u00107\u001a\u000208H\u0002J\u000e\u0010J\u001a\u00020K2\u0006\u00107\u001a\u000208R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010$\u001a\n &*\u0004\u0018\u00010%0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010'\u001a\u0010\u0012\f\u0012\n &*\u0004\u0018\u00010)0)0(*\u00020*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006L"}, d2={"Lcom/atlassian/jira/migration/preflight/AnonPermissionPreflightService;", "", "projectManager", "Lcom/atlassian/jira/project/ProjectManager;", "permissionSchemeManager", "Lcom/atlassian/jira/permission/PermissionSchemeManager;", "searchRequestManager", "Lcom/atlassian/jira/issue/search/SearchRequestManager;", "portalPageManager", "Lcom/atlassian/jira/portal/PortalPageManager;", "jswService", "Lcom/atlassian/jira/migration/jiraservice/JswService;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "dashboardsExtractionHelper", "Lcom/atlassian/jira/migration/export/core/portalpage/DashboardsExtractionHelper;", "projectKeysExtractorFromGadgets", "Lcom/atlassian/jira/migration/preflight/utils/ProjectKeysExtractorFromGadgets;", "filterRetrieveService", "Lcom/atlassian/jira/migration/export/core/filter/service/retrieve/FilterRetrieveService;", "issueSourceDataReader", "Lcom/atlassian/jira/migration/export/db/advancedroadmaps/IssueSourceDataReader;", "rapidViewRetrieveServiceProvider", "Ljavax/inject/Provider;", "Lcom/atlassian/jira/migration/export/software/board/retrieve/RapidViewRetrieveService;", "portletConfigurationManager", "Lcom/atlassian/jira/portal/PortletConfigurationManager;", "cpbFilterService", "Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CPBFilterService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "senSupplier", "Lcom/atlassian/jira/migration/sen/SENSupplier;", "pluginAccessor", "Lcom/atlassian/plugin/PluginAccessor;", "(Lcom/atlassian/jira/project/ProjectManager;Lcom/atlassian/jira/permission/PermissionSchemeManager;Lcom/atlassian/jira/issue/search/SearchRequestManager;Lcom/atlassian/jira/portal/PortalPageManager;Lcom/atlassian/jira/migration/jiraservice/JswService;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/jira/migration/export/core/portalpage/DashboardsExtractionHelper;Lcom/atlassian/jira/migration/preflight/utils/ProjectKeysExtractorFromGadgets;Lcom/atlassian/jira/migration/export/core/filter/service/retrieve/FilterRetrieveService;Lcom/atlassian/jira/migration/export/db/advancedroadmaps/IssueSourceDataReader;Ljavax/inject/Provider;Lcom/atlassian/jira/portal/PortletConfigurationManager;Lcom/atlassian/jira/migration/serverdataextractors/cpb/service/CPBFilterService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/sen/SENSupplier;Lcom/atlassian/plugin/PluginAccessor;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "anonPermGrants", "", "Lcom/atlassian/jira/permission/PermissionGrant;", "Lcom/atlassian/jira/permission/PermissionScheme;", "getAnonPermGrants", "(Lcom/atlassian/jira/permission/PermissionScheme;)Ljava/util/List;", "checkFilterPermissions", "", "filterIdExportSet", "", "", "checkProjectPermissions", "", "projects", "Lcom/atlassian/jira/project/Project;", "getAllPublicFilters", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "getCrossProjectBoardsAndFiltersMigrationMode", "Lcom/atlassian/jira/migration/plan/CrossProjectBoardAndFiltersMigrationMode;", "getFilterIdsExportedWithAR", "getFilterIdsExportedWithDashboards", "", "dashboards", "Lcom/atlassian/jira/portal/PortalPage;", "getFilterIdsExportedWithProjects", "getFilterIdsExportedwithCrossProject", "getPermissionScheme", "Lcom/atlassian/jira/scheme/Scheme;", "project", "getPublicDashboards", "getPublicFilters", "loggedUser", "Lcom/atlassian/jira/user/ApplicationUser;", "getScopedDashboards", "performCheck", "Lcom/atlassian/cmpt/check/base/CheckResult;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAnonPermissionPreflightService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnonPermissionPreflightService.kt\ncom/atlassian/jira/migration/preflight/AnonPermissionPreflightService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,337:1\n1549#2:338\n1620#2,3:339\n1855#2,2:342\n1855#2,2:344\n766#2:346\n857#2,2:347\n1603#2,9:349\n1855#2:358\n1856#2:360\n1612#2:361\n766#2:362\n857#2,2:363\n1603#2,9:365\n1855#2:374\n1856#2:376\n1612#2:377\n1855#2:378\n1855#2:379\n1856#2:381\n1856#2:382\n1549#2:383\n1620#2,3:384\n1855#2,2:387\n766#2:389\n857#2,2:390\n1549#2:395\n1620#2,3:396\n1#3:359\n1#3:375\n1#3:380\n658#4:392\n739#4,2:393\n742#4:399\n*S KotlinDebug\n*F\n+ 1 AnonPermissionPreflightService.kt\ncom/atlassian/jira/migration/preflight/AnonPermissionPreflightService\n*L\n78#1:338\n78#1:339,3\n164#1:342,2\n185#1:344,2\n197#1:346\n197#1:347,2\n198#1:349,9\n198#1:358\n198#1:360\n198#1:361\n201#1:362\n201#1:363,2\n202#1:365,9\n202#1:374\n202#1:376\n202#1:377\n235#1:378\n237#1:379\n237#1:381\n235#1:382\n253#1:383\n253#1:384,3\n275#1:387,2\n317#1:389\n317#1:390,2\n329#1:395\n329#1:396,3\n198#1:359\n202#1:375\n328#1:392\n328#1:393,2\n328#1:399\n*E\n"})
public final class AnonPermissionPreflightService {
    @NotNull
    private final ProjectManager projectManager;
    @NotNull
    private final PermissionSchemeManager permissionSchemeManager;
    @NotNull
    private final SearchRequestManager searchRequestManager;
    @NotNull
    private final PortalPageManager portalPageManager;
    @NotNull
    private final JswService jswService;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final DashboardsExtractionHelper dashboardsExtractionHelper;
    @NotNull
    private final ProjectKeysExtractorFromGadgets projectKeysExtractorFromGadgets;
    @NotNull
    private final FilterRetrieveService filterRetrieveService;
    @NotNull
    private final IssueSourceDataReader issueSourceDataReader;
    @NotNull
    private final Provider<RapidViewRetrieveService> rapidViewRetrieveServiceProvider;
    @NotNull
    private final PortletConfigurationManager portletConfigurationManager;
    @NotNull
    private final CPBFilterService cpbFilterService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final SENSupplier senSupplier;
    @NotNull
    private final PluginAccessor pluginAccessor;
    private final Logger log;

    @Inject
    public AnonPermissionPreflightService(@NotNull ProjectManager projectManager, @NotNull PermissionSchemeManager permissionSchemeManager, @NotNull SearchRequestManager searchRequestManager, @NotNull PortalPageManager portalPageManager, @NotNull JswService jswService, @NotNull MigrationEventBus migrationEventBus, @NotNull DashboardsExtractionHelper dashboardsExtractionHelper, @NotNull ProjectKeysExtractorFromGadgets projectKeysExtractorFromGadgets, @NotNull FilterRetrieveService filterRetrieveService, @NotNull IssueSourceDataReader issueSourceDataReader, @NotNull Provider<RapidViewRetrieveService> rapidViewRetrieveServiceProvider, @NotNull PortletConfigurationManager portletConfigurationManager, @NotNull CPBFilterService cpbFilterService, @NotNull MigrationFeatures migrationFeatures, @NotNull SENSupplier senSupplier, @NotNull PluginAccessor pluginAccessor) {
        Intrinsics.checkNotNullParameter((Object)projectManager, (String)"projectManager");
        Intrinsics.checkNotNullParameter((Object)permissionSchemeManager, (String)"permissionSchemeManager");
        Intrinsics.checkNotNullParameter((Object)searchRequestManager, (String)"searchRequestManager");
        Intrinsics.checkNotNullParameter((Object)portalPageManager, (String)"portalPageManager");
        Intrinsics.checkNotNullParameter((Object)jswService, (String)"jswService");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)dashboardsExtractionHelper, (String)"dashboardsExtractionHelper");
        Intrinsics.checkNotNullParameter((Object)projectKeysExtractorFromGadgets, (String)"projectKeysExtractorFromGadgets");
        Intrinsics.checkNotNullParameter((Object)filterRetrieveService, (String)"filterRetrieveService");
        Intrinsics.checkNotNullParameter((Object)issueSourceDataReader, (String)"issueSourceDataReader");
        Intrinsics.checkNotNullParameter(rapidViewRetrieveServiceProvider, (String)"rapidViewRetrieveServiceProvider");
        Intrinsics.checkNotNullParameter((Object)portletConfigurationManager, (String)"portletConfigurationManager");
        Intrinsics.checkNotNullParameter((Object)cpbFilterService, (String)"cpbFilterService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)senSupplier, (String)"senSupplier");
        Intrinsics.checkNotNullParameter((Object)pluginAccessor, (String)"pluginAccessor");
        this.projectManager = projectManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.searchRequestManager = searchRequestManager;
        this.portalPageManager = portalPageManager;
        this.jswService = jswService;
        this.migrationEventBus = migrationEventBus;
        this.dashboardsExtractionHelper = dashboardsExtractionHelper;
        this.projectKeysExtractorFromGadgets = projectKeysExtractorFromGadgets;
        this.filterRetrieveService = filterRetrieveService;
        this.issueSourceDataReader = issueSourceDataReader;
        this.rapidViewRetrieveServiceProvider = rapidViewRetrieveServiceProvider;
        this.portletConfigurationManager = portletConfigurationManager;
        this.cpbFilterService = cpbFilterService;
        this.migrationFeatures = migrationFeatures;
        this.senSupplier = senSupplier;
        this.pluginAccessor = pluginAccessor;
        this.log = LoggerFactory.getLogger(AnonPermissionPreflightService.class);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        long startTime = System.nanoTime();
        List<String> projectKeys = PreflightCheckKt.getProjectKeys(checkRequest);
        List<String> publicFilters = CollectionsKt.emptyList();
        List<String> publicDashboards = CollectionsKt.emptyList();
        Iterable iterable = PreflightCheckKt.getProjectKeys(checkRequest);
        ProjectManager projectManager = this.projectManager;
        boolean $i$f$map = false;
        void var11_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(projectManager.getProjectObjByKey((String)p0));
        }
        List projects = (List)destination$iv$iv;
        Map<String, List<String>> projectToAnonPermissions2 = this.checkProjectPermissions(projects);
        try {
            boolean bl;
            publicFilters = this.migrationFeatures.getEnableIncreasePublicFilterCheckScope() ? this.getAllPublicFilters(checkRequest) : this.getPublicFilters(PreflightCheckKt.getLoggedUser(checkRequest), projects);
            if (this.migrationFeatures.getEnablePublicDashboardCheck()) {
                publicDashboards = this.getPublicDashboards(checkRequest);
                bl = publicFilters.isEmpty() && projectToAnonPermissions2.isEmpty() && publicDashboards.isEmpty();
            } else {
                bl = publicFilters.isEmpty() && projectToAnonPermissions2.isEmpty();
            }
            $i$f$map = bl;
        }
        catch (ProjectRapidViewServiceException ex) {
            this.log.error("Unable to get public filters", (Throwable)ex);
            $i$f$map = false;
        }
        boolean success = $i$f$map;
        Pair[] ex = new Pair[]{TuplesKt.to((Object)"projectKeyToPermissions", projectToAnonPermissions2), TuplesKt.to((Object)"publicFilters", publicFilters), TuplesKt.to((Object)"publicDashboards", publicDashboards)};
        CheckResult checkResult = new CheckResult(success, MapsKt.mapOf((Pair[])ex));
        long endTime = System.nanoTime();
        String string = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
        String string2 = PreflightCheckKt.getUniqueId(checkRequest);
        if (string2 == null) {
            string2 = "";
        }
        this.migrationEventBus.post(new AnonPermissionCheckEvent(string, string2, (endTime - startTime) / (long)1000000, success, ExportStatistics.Companion.getEMPTY(), projectKeys.size(), projectToAnonPermissions2.size(), publicFilters.size(), publicDashboards.size()));
        return checkResult;
    }

    @VisibleForTesting
    @NotNull
    public final List<String> getAllPublicFilters(@NotNull CheckRequest checkRequest) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        List searchRequestList = new ArrayList();
        CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode = this.getCrossProjectBoardsAndFiltersMigrationMode(checkRequest);
        if (crossProjectBoardAndFiltersMigrationMode == CrossProjectBoardAndFiltersMigrationMode.ALL) {
            this.filterRetrieveService.visitAllFilters((Function1<? super SearchRequest, Unit>)((Function1)new Function1<SearchRequest, Unit>((List<String>)searchRequestList){
                final /* synthetic */ List<String> $searchRequestList;
                {
                    this.$searchRequestList = $searchRequestList;
                    super(1);
                }

                public final void invoke(@NotNull SearchRequest it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (it.getPermissions().isGlobal() && it.getName() != null) {
                        String string = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        this.$searchRequestList.add(string);
                    }
                }
            }));
            return searchRequestList;
        }
        this.log.info("AnonPerm filter check: Cross-project boards and filters reference mode");
        JiraLicenseInfo licenses = this.senSupplier.getLicenses();
        Set $this$getAllPublicFilters_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$getAllPublicFilters_u24lambda_u240.addAll((Collection)this.getFilterIdsExportedwithCrossProject(checkRequest));
        if (licenses.getJiraSoftwareLicense() != null && PluginAccessorExtensionsKt.hasJswInstalled(this.pluginAccessor) && PluginAccessorExtensionsKt.hasArjInstalled(this.pluginAccessor)) {
            $this$getAllPublicFilters_u24lambda_u240.addAll((Collection)this.getFilterIdsExportedWithAR(checkRequest));
        }
        $this$getAllPublicFilters_u24lambda_u240.addAll((Collection)this.getFilterIdsExportedWithDashboards(checkRequest));
        $this$getAllPublicFilters_u24lambda_u240.addAll((Collection)this.getFilterIdsExportedWithProjects(checkRequest));
        Set filterIdExportSet = SetsKt.build((Set)set);
        return this.checkFilterPermissions(filterIdExportSet);
    }

    private final List<String> checkFilterPermissions(Set<Long> filterIdExportSet) {
        List publicFilterList = new ArrayList();
        Iterable $this$forEach$iv = filterIdExportSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            try {
                SearchRequest searchRequest = this.searchRequestManager.getSearchRequestById(Long.valueOf(it));
                if (searchRequest == null || !searchRequest.getPermissions().isGlobal() || searchRequest.getName() == null) continue;
                String string = searchRequest.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                publicFilterList.add(string);
            }
            catch (Exception e) {
                this.log.error("Failed to get filter with ID: " + it, (Throwable)e);
            }
        }
        return publicFilterList;
    }

    private final Set<Long> getFilterIdsExportedwithCrossProject(CheckRequest checkRequest) {
        CrossProjectBoardAndFiltersMigrationMode crossProjectBoardAndFiltersMigrationMode = this.getCrossProjectBoardsAndFiltersMigrationMode(checkRequest);
        Set filterIdsExportedWithCrossProject = null;
        filterIdsExportedWithCrossProject = new LinkedHashSet();
        if (crossProjectBoardAndFiltersMigrationMode == CrossProjectBoardAndFiltersMigrationMode.SELECTED_PROJECTS) {
            List<String> selectedProjectKeys = PreflightCheckKt.getProjectKeys(checkRequest);
            List<Long> selectedProjectIds = this.projectKeysExtractorFromGadgets.convertProjectKeysToProjectIds(selectedProjectKeys);
            Iterable $this$forEach$iv = this.cpbFilterService.getCrossProjectFilterReferringProjectsInfoList(selectedProjectIds);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CrossProjectFilterReferringProjectsInfo it = (CrossProjectFilterReferringProjectsInfo)element$iv;
                boolean bl = false;
                Long l = it.getCrossProjectFilter().getId();
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getId(...)");
                filterIdsExportedWithCrossProject.add(l);
            }
        }
        this.log.info("Filter count from CrossProject: " + filterIdsExportedWithCrossProject.size());
        return filterIdsExportedWithCrossProject;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Long> getFilterIdsExportedWithAR(@NotNull CheckRequest checkRequest) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        Object it;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        List list = PreflightCheckKt.getAdvancedRoadmapsPlanIds(checkRequest);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List advancedRoadmapsIds = list;
        List<AdvancedRoadmapsIssueSourceData> allIssueSourcesForPlans = this.issueSourceDataReader.getAllExistentIssueSourcesForPlans(advancedRoadmapsIds);
        Iterable iterable = allIssueSourcesForPlans;
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (AdvancedRoadmapsIssueSourceData)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)((AdvancedRoadmapsIssueSourceData)it).getSourceType(), (Object)IssueSourceType.FILTER.getValue()) && ((AdvancedRoadmapsIssueSourceData)it).getSourceValue() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        boolean $i$f$mapNotNull22 = false;
        $this$filterTo$iv$iv2 = $this$mapNotNull$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            Long it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            AdvancedRoadmapsIssueSourceData it2 = (AdvancedRoadmapsIssueSourceData)element$iv$iv;
            boolean bl2 = false;
            String string = it2.getSourceValue();
            if ((string != null ? StringsKt.toLongOrNull((String)string) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List allFilterSourcesForPlans = (List)destination$iv$iv;
        Iterable $i$f$mapNotNull22 = allIssueSourcesForPlans;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AdvancedRoadmapsIssueSourceData it3 = (AdvancedRoadmapsIssueSourceData)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it3.getSourceType(), (Object)IssueSourceType.BOARD.getValue()) && it3.getSourceValue() != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            Long l;
            Long boardId;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            AdvancedRoadmapsIssueSourceData it4 = (AdvancedRoadmapsIssueSourceData)element$iv$iv;
            boolean bl4 = false;
            String string = it4.getSourceValue();
            Long l2 = boardId = string != null ? StringsKt.toLongOrNull((String)string) : null;
            if (l2 != null) {
                RapidView rapidView;
                long it1 = ((Number)l2).longValue();
                boolean bl5 = false;
                Object object = (RapidViewRetrieveService)this.rapidViewRetrieveServiceProvider.get();
                RapidView rapidView2 = rapidView = object != null && (object = ((RapidViewRetrieveService)object).retrieveRapidViewById(it1)) != null ? (RapidView)((Optional)object).orElse(null) : null;
                l = rapidView2 != null ? rapidView2.getSavedFilterId() : null;
            } else {
                l = null;
            }
            if (l == null) continue;
            Long it$iv$iv = l;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List allBoardSourcesForPlans = (List)destination$iv$iv2;
        this.log.info("Filter count from AR filter issue source: " + allFilterSourcesForPlans.size());
        this.log.info("Filter count from AR RV issue source: " + allBoardSourcesForPlans.size());
        return CollectionsKt.toList((Iterable)CollectionsKt.union((Iterable)allFilterSourcesForPlans, (Iterable)allBoardSourcesForPlans));
    }

    @NotNull
    public final Set<Long> getFilterIdsExportedWithDashboards(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        Set<Long> filterIdsExportedWithDashboards = new LinkedHashSet();
        DashboardsMigrationMode dashboardsMigrationMode = this.dashboardsExtractionHelper.getDashboardsMigrationMode(PreflightCheckKt.getCrossProjectConfig(checkRequest));
        if (dashboardsMigrationMode == DashboardsMigrationMode.ALL) {
            List<PortalPage> allDashboardSet = this.dashboardsExtractionHelper.getAllPortalPages();
            filterIdsExportedWithDashboards = this.getFilterIdsExportedWithDashboards(allDashboardSet);
        } else if (dashboardsMigrationMode == DashboardsMigrationMode.SELECTED_PROJECTS) {
            List<PortalPage> scopedDashboardSet = this.getScopedDashboards(checkRequest);
            filterIdsExportedWithDashboards = this.getFilterIdsExportedWithDashboards(scopedDashboardSet);
        } else {
            this.log.info("No filters exported with dashboards as Dashboard Migration mode is NONE");
        }
        this.log.info("Filter count from dashboard user prefs: " + filterIdsExportedWithDashboards.size());
        return filterIdsExportedWithDashboards;
    }

    private final Set<Long> getFilterIdsExportedWithDashboards(List<PortalPage> dashboards) {
        Set filterIdSet = new LinkedHashSet();
        Iterable $this$forEach$iv = dashboards;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PortalPage portalPage = (PortalPage)element$iv;
            boolean bl = false;
            List portletConfigurations = this.portletConfigurationManager.getByPortalPage(portalPage.getId());
            Intrinsics.checkNotNull((Object)portletConfigurations);
            Iterable $this$forEach$iv2 = portletConfigurations;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Long l;
                String string;
                PortletConfiguration portletConfig = (PortletConfiguration)element$iv2;
                boolean bl2 = false;
                Map userPrefs = portletConfig.getUserPrefs();
                Object object = (String)userPrefs.get("filterId");
                if (object != null && (object = StringsKt.toLongOrNull((String)object)) != null) {
                    long it = ((Number)object).longValue();
                    boolean bl3 = false;
                    filterIdSet.add(it);
                }
                if ((string = (String)userPrefs.get("projectOrFilterId")) == null) continue;
                Object object2 = string;
                String it = object2;
                boolean bl4 = false;
                Object object3 = StringsKt.startsWith$default((String)it, (String)"filter-", (boolean)false, (int)2, null) ? object2 : null;
                if (object3 == null) continue;
                Object object4 = new String[]{"-"};
                object2 = StringsKt.split$default((CharSequence)((CharSequence)object3), (String[])object4, (boolean)false, (int)0, (int)6, null);
                if (object2 == null || (object4 = (String)CollectionsKt.getOrNull((List)object2, (int)1)) == null || (l = StringsKt.toLongOrNull((String)object4)) == null) continue;
                long it2 = ((Number)l).longValue();
                boolean bl5 = false;
                filterIdSet.add(it2);
            }
        }
        return filterIdSet;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Long> getFilterIdsExportedWithProjects(@NotNull CheckRequest checkRequest) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        Iterable iterable = PreflightCheckKt.getProjectKeys(checkRequest);
        ProjectManager projectManager = this.projectManager;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(projectManager.getProjectObjByKey((String)p0));
        }
        List projects = (List)destination$iv$iv;
        return SequencesKt.toList((Sequence)CollectionsKt.asSequence((Iterable)this.jswService.sharedFiltersByProjects(PreflightCheckKt.getLoggedUser(checkRequest), projects)));
    }

    private final CrossProjectBoardAndFiltersMigrationMode getCrossProjectBoardsAndFiltersMigrationMode(CheckRequest checkRequest) {
        Object object = PreflightCheckKt.getCrossProjectConfig(checkRequest);
        return object != null && (object = ((CrossProjectConfig)object).getCrossProjectExportConfig()) != null && (object = ((CrossProjectExportConfig)object).getCrossProjectDataMigrationOption()) != null ? ((CrossProjectBoardsAndFiltersMigrationOption)object).getBoardsAndFiltersMigrationMode() : null;
    }

    @NotNull
    public final List<String> getPublicDashboards(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        List portalPageList = new ArrayList();
        DashboardsMigrationMode dashboardsMigrationMode = this.dashboardsExtractionHelper.getDashboardsMigrationMode(PreflightCheckKt.getCrossProjectConfig(checkRequest));
        this.log.debug("Dashboards Migration Mode selected: {}", (Object)String.valueOf((Object)dashboardsMigrationMode));
        if (dashboardsMigrationMode == DashboardsMigrationMode.ALL) {
            this.portalPageManager.getAll().foreach(arg_0 -> AnonPermissionPreflightService.getPublicDashboards$lambda$14(portalPageList, arg_0));
        } else if (dashboardsMigrationMode == DashboardsMigrationMode.SELECTED_PROJECTS) {
            List<PortalPage> listOfScopedDashboards = this.getScopedDashboards(checkRequest);
            Iterable $this$forEach$iv = listOfScopedDashboards;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PortalPage it = (PortalPage)element$iv;
                boolean bl = false;
                if (it.isSystemDefaultPortalPage() || !it.getPermissions().isGlobal() || it.getName() == null) continue;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                portalPageList.add(string);
            }
        }
        return portalPageList;
    }

    private final List<PortalPage> getScopedDashboards(CheckRequest checkRequest) {
        List<String> selectedProjectKeys = PreflightCheckKt.getProjectKeys(checkRequest);
        List<Long> selectedProjectIds = this.projectKeysExtractorFromGadgets.convertProjectKeysToProjectIds(selectedProjectKeys);
        List<PortalPage> allPortalPages = this.dashboardsExtractionHelper.getAllPortalPages();
        List<PortalPage> listOfScopedDashboards = this.dashboardsExtractionHelper.getDashboardsReferringSelectedProjects(selectedProjectIds, allPortalPages);
        return listOfScopedDashboards;
    }

    @VisibleForTesting
    @NotNull
    public final List<String> getPublicFilters(@NotNull ApplicationUser loggedUser, @NotNull List<? extends Project> projects) {
        Set<Long> set;
        Intrinsics.checkNotNullParameter((Object)loggedUser, (String)"loggedUser");
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        Set<Long> it = set = this.jswService.sharedFiltersByProjects(loggedUser, projects);
        boolean bl = false;
        this.log.info("in total: " + it.size() + " search requests");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)((Function1)new Function1<Long, SearchRequest>(this, loggedUser){
            final /* synthetic */ AnonPermissionPreflightService this$0;
            final /* synthetic */ ApplicationUser $loggedUser;
            {
                this.this$0 = $receiver;
                this.$loggedUser = $loggedUser;
                super(1);
            }

            @Nullable
            public final SearchRequest invoke(long it) {
                return AnonPermissionPreflightService.access$getSearchRequestManager$p(this.this$0).getSearchRequestById(this.$loggedUser, Long.valueOf(it));
            }
        })), (Function1)getPublicFilters.3.INSTANCE), (Function1)getPublicFilters.4.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private final List<PermissionGrant> getAnonPermGrants(PermissionScheme $this$anonPermGrants) {
        void $this$filterTo$iv$iv;
        Collection collection = $this$anonPermGrants.getPermissions();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getPermissions(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PermissionGrant it = (PermissionGrant)element$iv$iv;
            boolean bl = false;
            PermissionHolderType permissionHolderType = it.getHolder().getType();
            Intrinsics.checkNotNullExpressionValue((Object)permissionHolderType, (String)"getType(...)");
            if (!SchemeExtensionsKt.isEqualTo(permissionHolderType, (PermissionHolderType)JiraPermissionHolderType.ANYONE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Scheme getPermissionScheme(Project project) {
        Scheme scheme = this.permissionSchemeManager.getSchemeFor(project);
        if (scheme == null) {
            Scheme scheme2 = this.permissionSchemeManager.getDefaultSchemeObject();
            scheme = scheme2;
            Intrinsics.checkNotNullExpressionValue((Object)scheme2, (String)"getDefaultSchemeObject(...)");
        }
        return scheme;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, List<String>> checkProjectPermissions(List<? extends Project> projects) {
        void $this$associateTo$iv$iv;
        Sequence $this$associate$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)projects), (Function1)((Function1)new Function1<Project, Pair<? extends Project, ? extends List<? extends PermissionGrant>>>(this){
            final /* synthetic */ AnonPermissionPreflightService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Pair<Project, List<PermissionGrant>> invoke(@NotNull Project it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return TuplesKt.to((Object)it, (Object)AnonPermissionPreflightService.access$getAnonPermGrants(this.this$0, SchemeExtensionsKt.toPermissionScheme(AnonPermissionPreflightService.access$getPermissionScheme(this.this$0, it))));
            }
        })), (Function1)checkProjectPermissions.projectToAnonPermissions.2.INSTANCE);
        boolean $i$f$associate = false;
        Sequence sequence = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map map = destination$iv$iv;
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            Project project = (Project)pair.component1();
            List permissions = (List)pair.component2();
            Iterable iterable = permissions;
            String string = project.getKey();
            boolean $i$f$map = false;
            void var18_17 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PermissionGrant permissionGrant = (PermissionGrant)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getPermission().permissionKey());
            }
            pair = TuplesKt.to((Object)string, (Object)((List)destination$iv$iv2));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map projectToAnonPermissions2 = destination$iv$iv;
        return projectToAnonPermissions2;
    }

    private static final void getPublicDashboards$lambda$14(List $portalPageList, PortalPage it) {
        Intrinsics.checkNotNullParameter((Object)$portalPageList, (String)"$portalPageList");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!it.isSystemDefaultPortalPage() && it.getPermissions().isGlobal() && it.getName() != null) {
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            $portalPageList.add(string);
        }
    }

    public static final /* synthetic */ SearchRequestManager access$getSearchRequestManager$p(AnonPermissionPreflightService $this) {
        return $this.searchRequestManager;
    }

    public static final /* synthetic */ List access$getAnonPermGrants(AnonPermissionPreflightService $this, PermissionScheme $receiver) {
        return $this.getAnonPermGrants($receiver);
    }

    public static final /* synthetic */ Scheme access$getPermissionScheme(AnonPermissionPreflightService $this, Project project) {
        return $this.getPermissionScheme(project);
    }
}

