/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.assessment.AppAssessmentInfo;
import com.atlassian.jira.migration.assessment.AppAssessmentService;
import com.atlassian.jira.migration.assessment.AppConsent;
import com.atlassian.jira.migration.assessment.NotConsentedApp;
import com.atlassian.jira.migration.assessment.PluginManager;
import com.atlassian.jira.migration.events.AppCheckEvent;
import com.atlassian.jira.migration.events.ExportStatistics;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.plan.ProjectDataMigrationMode;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.plugin.Plugin;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0007\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B\u001f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0014H\u0016J(\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u001a\u0010#\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!\u0018\u00010$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/atlassian/jira/migration/preflight/AppConsentCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "appAssessmentService", "Lcom/atlassian/jira/migration/assessment/AppAssessmentService;", "pluginManager", "Lcom/atlassian/jira/migration/assessment/PluginManager;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/assessment/AppAssessmentService;Lcom/atlassian/jira/migration/assessment/PluginManager;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "appNotConsentedOrScopesOutdated", "", "appKey", "", "appsNotRequiringConsentDueToAlternateMigrationPath", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "createAppDataConsent", "Lcom/atlassian/jira/migration/assessment/NotConsentedApp;", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "performCheck", "checkRequest", "retrieveNotConsentedApps", "", "", "details", "", "Companion", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppConsentCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppConsentCheck.kt\ncom/atlassian/jira/migration/preflight/AppConsentCheck\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,152:1\n603#2:153\n*S KotlinDebug\n*F\n+ 1 AppConsentCheck.kt\ncom/atlassian/jira/migration/preflight/AppConsentCheck\n*L\n43#1:153\n*E\n"})
public final class AppConsentCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppAssessmentService appAssessmentService;
    @NotNull
    private final PluginManager pluginManager;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final CheckType checkType;
    @NotNull
    public static final String VIOLATIONS_KEY = "violations";
    @NotNull
    public static final String PROJECT_DATA_MIGRATION_MODE = "projectDataMigrationMode";
    @NotNull
    public static final String EXCLUDED_APP_KEYS = "excludedApps";
    @NotNull
    public static final String SUCCESS_DESCRIPTION = "All apps marked as \u2018Needed in cloud\u2019 with automated data migration have consent to migrate";
    @NotNull
    public static final String RUNNING_DESCRIPTION = "Checking for apps marked as \u2019Needed in cloud\u2019 consented";
    @NotNull
    public static final String WARNING_ERROR_DESCRIPTION = "You have not consented to app data migration";
    @NotNull
    public static final String WARNING_DESCRIPTION = "App assessment is incomplete";
    @NotNull
    public static final String ERROR_DESCRIPTION = "We couldn\u2019t check for consented app data migration";
    @NotNull
    public static final String LONG_DESCRIPTION = "In order for automated app data migration paths to work, you must first consent to app data migration. If you've already consented, there may be app policy changes that require you to consent again.";
    @NotNull
    public static final String PRELOAD_SUCCESS_DESCRIPTION = "All apps marked as \u2018Needed in Cloud\u2019 with preloadable app data have consent to migrate";
    @NotNull
    public static final String PRELOAD_LONG_DESCRIPTION = "In order for app data preload path to work, you must first consent to app data migration. If you've already consented, there may be app policy changes that require you to consent again.";

    @Inject
    public AppConsentCheck(@NotNull AppAssessmentService appAssessmentService, @NotNull PluginManager pluginManager, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)appAssessmentService, (String)"appAssessmentService");
        Intrinsics.checkNotNullParameter((Object)pluginManager, (String)"pluginManager");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.appAssessmentService = appAssessmentService;
        this.pluginManager = pluginManager;
        this.migrationEventBus = migrationEventBus;
        this.checkType = CheckType.AppDataMigrationConsent;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        void $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        long startTime = System.nanoTime();
        Set<String> appKeysToCheck = PreflightCheckKt.getAppKeys(checkRequest);
        Sequence sequence = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)appKeysToCheck), (Function1)((Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ AppConsentCheck this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AppConsentCheck.access$appNotConsentedOrScopesOutdated(this.this$0, it);
            }
        })), (Function1)((Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ AppConsentCheck this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AppConsentCheck.access$appsNotRequiringConsentDueToAlternateMigrationPath(this.this$0, it);
            }
        })), (Function1)((Function1)new Function1<String, NotConsentedApp>(this){
            final /* synthetic */ AppConsentCheck this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final NotConsentedApp invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.createAppDataConsent(it);
            }
        }));
        boolean $i$f$sortedBy22 = false;
        List appsNeedingConsent2 = SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                NotConsentedApp it = (NotConsentedApp)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (NotConsentedApp)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        }));
        Pair[] $i$f$sortedBy22 = new Pair[]{TuplesKt.to((Object)VIOLATIONS_KEY, (Object)appsNeedingConsent2), TuplesKt.to((Object)PROJECT_DATA_MIGRATION_MODE, (Object)((Object)PreflightCheckKt.getProjectDataMigrationMode(checkRequest)))};
        CheckResult checkResult = new CheckResult(appsNeedingConsent2.isEmpty(), MapsKt.mapOf((Pair[])$i$f$sortedBy22));
        long endTime = System.nanoTime();
        String string = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
        String string2 = PreflightCheckKt.getUniqueId(checkRequest);
        if (string2 == null) {
            string2 = "";
        }
        this.migrationEventBus.post(new AppCheckEvent("appDataMigrationConsentCheck", string, string2, (endTime - startTime) / (long)1000000, checkResult.success, ExportStatistics.Companion.getEMPTY(), appKeysToCheck.size(), appsNeedingConsent2.size()));
        return checkResult;
    }

    @NotNull
    public final NotConsentedApp createAppDataConsent(@NotNull String appKey) {
        Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
        Plugin plugin = this.pluginManager.getPlugin(appKey);
        String name = plugin != null ? plugin.getName() : null;
        String string = name;
        if (string == null) {
            string = "Unknown";
        }
        return new NotConsentedApp(appKey, string);
    }

    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        String description = null;
        Object object = checkResult;
        boolean isAppPreload = (object != null && (object = ((CheckResult)object).details) != null ? object.get(PROJECT_DATA_MIGRATION_MODE) : null) == ProjectDataMigrationMode.APP_DATA_PRELOAD;
        Status status = dto.getStatus();
        switch (status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                description = isAppPreload ? PRELOAD_SUCCESS_DESCRIPTION : SUCCESS_DESCRIPTION;
                break;
            }
            case 2: 
            case 3: {
                description = WARNING_ERROR_DESCRIPTION;
                dto.setStatus(Status.ERROR);
                break;
            }
            case 4: {
                description = RUNNING_DESCRIPTION;
                break;
            }
            case 5: {
                description = ERROR_DESCRIPTION;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        dto.setDescription(description);
        CheckResult it = checkResult;
        boolean bl = false;
        CheckResult checkResult2 = checkResult;
        List<Object> list = this.retrieveNotConsentedApps(checkResult2 != null ? checkResult2.details : null);
        Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.List<com.atlassian.jira.migration.assessment.NotConsentedApp>");
        List<Object> appDataConsents = list;
        if (!((Collection)appDataConsents).isEmpty()) {
            CheckDetailsDto details2 = new CheckDetailsDto();
            details2.setListOfOccurrences(appDataConsents);
            details2.setLongDescription(isAppPreload ? PRELOAD_LONG_DESCRIPTION : LONG_DESCRIPTION);
            dto.setDetails(details2);
            dto.setNumberOfOccurrences(Integer.valueOf(appDataConsents.size()));
        }
    }

    @NotNull
    public final List<Object> retrieveNotConsentedApps(@Nullable Map<String, ? extends List<? extends Object>> details2) {
        Object object = details2;
        if (object == null || (object = object.get(VIOLATIONS_KEY)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"appKeys", ctx.getAppKeys()), TuplesKt.to((Object)"preflightCheckExecutionId", (Object)ctx.getPreflightCheckExecutionId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId()), TuplesKt.to((Object)PROJECT_DATA_MIGRATION_MODE, (Object)((Object)ctx.getProjectDataMigrationMode()))};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    private final boolean appNotConsentedOrScopesOutdated(String appKey) {
        boolean consented = this.appAssessmentService.isAppConsented(appKey);
        boolean consentedAccessScopesUpdated = this.appAssessmentService.savedAccessScopesAreCurrent(appKey);
        return !consented || !consentedAccessScopesUpdated;
    }

    private final boolean appsNotRequiringConsentDueToAlternateMigrationPath(String appKey) {
        Optional<AppAssessmentInfo> appAssessmentInfo = this.appAssessmentService.getAppAssessmentInfoByAppKey(appKey);
        if (appAssessmentInfo.isPresent()) {
            AppAssessmentInfo appAssessmentInfo2 = appAssessmentInfo.get();
            Intrinsics.checkNotNullExpressionValue((Object)appAssessmentInfo2, (String)"get(...)");
            AppConsent appConsent = this.appAssessmentService.buildAppConsent(appAssessmentInfo2);
            if (this.appAssessmentService.requiresUserConsent(appConsent.getStatus())) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean access$appNotConsentedOrScopesOutdated(AppConsentCheck $this, String appKey) {
        return $this.appNotConsentedOrScopesOutdated(appKey);
    }

    public static final /* synthetic */ boolean access$appsNotRequiringConsentDueToAlternateMigrationPath(AppConsentCheck $this, String appKey) {
        return $this.appsNotRequiringConsentDueToAlternateMigrationPath(appKey);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/jira/migration/preflight/AppConsentCheck$Companion;", "", "()V", "ERROR_DESCRIPTION", "", "EXCLUDED_APP_KEYS", "LONG_DESCRIPTION", "PRELOAD_LONG_DESCRIPTION", "PRELOAD_SUCCESS_DESCRIPTION", "PROJECT_DATA_MIGRATION_MODE", "RUNNING_DESCRIPTION", "SUCCESS_DESCRIPTION", "VIOLATIONS_KEY", "WARNING_DESCRIPTION", "WARNING_ERROR_DESCRIPTION", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.RUNNING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.EXECUTION_ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

