/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.dto.Status;
import com.atlassian.jira.migration.assessment.AppAssessmentService;
import com.atlassian.jira.migration.assessment.AppDto;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.NotBlockingCheck;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/jira/migration/preflight/AppDataPreLoadCheck;", "Lcom/atlassian/jira/migration/preflight/NotBlockingCheck;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "appAssessmentService", "Lcom/atlassian/jira/migration/assessment/AppAssessmentService;", "(Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/assessment/AppAssessmentService;)V", "getAppAssessmentService", "()Lcom/atlassian/jira/migration/assessment/AppAssessmentService;", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getMigrationFeatures", "()Lcom/atlassian/jira/migration/features/MigrationFeatures;", "createCheckDetailsDto", "Lcom/atlassian/cmpt/check/dto/CheckDetailsDto;", "checkResult", "Lcom/atlassian/cmpt/check/base/CheckResult;", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "performCheck", "Lcom/atlassian/jira/migration/preflight/model/NotBlockingCheckResult;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppDataPreLoadCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppDataPreLoadCheck.kt\ncom/atlassian/jira/migration/preflight/AppDataPreLoadCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n819#2:66\n847#2,2:67\n*S KotlinDebug\n*F\n+ 1 AppDataPreLoadCheck.kt\ncom/atlassian/jira/migration/preflight/AppDataPreLoadCheck\n*L\n30#1:66\n30#1:67,2\n*E\n"})
public final class AppDataPreLoadCheck
extends NotBlockingCheck {
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final AppAssessmentService appAssessmentService;

    @Inject
    public AppDataPreLoadCheck(@NotNull MigrationFeatures migrationFeatures, @NotNull AppAssessmentService appAssessmentService) {
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)appAssessmentService, (String)"appAssessmentService");
        super("We couldn\u2019t check for apps with preloadable data", "Checking for app data to preload", "App data preload check successful", "Some apps selected for migration don\u2019t have app data to preload");
        this.migrationFeatures = migrationFeatures;
        this.appAssessmentService = appAssessmentService;
    }

    @NotNull
    public final MigrationFeatures getMigrationFeatures() {
        return this.migrationFeatures;
    }

    @NotNull
    public final AppAssessmentService getAppAssessmentService() {
        return this.appAssessmentService;
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return CheckType.AppsDataPreLoadCheck;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public NotBlockingCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        if (this.migrationFeatures.getAppDataPreloadEnabledGA()) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = this.appAssessmentService.getAppsNeededInCloud().getApps();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                AppDto it = (AppDto)element$iv$iv;
                boolean bl = false;
                if (it.getPreloadable()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonPreloadableApps = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            if (!((Collection)nonPreloadableApps).isEmpty()) {
                Map details2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"listOfOccurrences", (Object)nonPreloadableApps));
                return new NotBlockingCheckResult(false, details2);
            }
        }
        return new NotBlockingCheckResult(true, MapsKt.emptyMap());
    }

    @Override
    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        super.inject(dto, checkResult);
        if (checkResult != null) {
            CheckResultDto checkResultDto;
            CheckResultDto $this$inject_u24lambda_u241 = checkResultDto = dto;
            boolean bl = false;
            Status status = dto.getStatus();
            if ((status == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) == 1) {
                dto.setDetails(this.createCheckDetailsDto(checkResult));
            } else {
                return;
            }
        }
    }

    private final CheckDetailsDto createCheckDetailsDto(CheckResult checkResult) {
        CheckDetailsDto details2 = new CheckDetailsDto();
        Object object = checkResult;
        Object v1 = object != null && (object = ((CheckResult)object).details) != null ? object.get("listOfOccurrences") : null;
        Intrinsics.checkNotNull(v1, (String)"null cannot be cast to non-null type kotlin.collections.List<com.atlassian.jira.migration.assessment.AppDto>");
        List listOfOccurrences = v1;
        details2.setListOfOccurrences(listOfOccurrences);
        return details2;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

