/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.dto.CheckDetailsDto;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.jira.migration.preflight.AppLicenseCheckService;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.NotBlockingCheck;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0016J \u0010\u0019\u001a\u00020\u001a2\u0016\u0010\u001b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/jira/migration/preflight/AppLicenseCheck;", "Lcom/atlassian/jira/migration/preflight/NotBlockingCheck;", "checkService", "Lcom/atlassian/jira/migration/preflight/AppLicenseCheckService;", "(Lcom/atlassian/jira/migration/preflight/AppLicenseCheckService;)V", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "Lcom/atlassian/cmpt/check/base/CheckResult;", "performCheck", "Lcom/atlassian/jira/migration/preflight/model/NotBlockingCheckResult;", "checkRequest", "retrieveExecutionError", "", "checkResultDetails", "", "", "", "jira-migration-plugin"})
public final class AppLicenseCheck
extends NotBlockingCheck {
    @NotNull
    private final AppLicenseCheckService checkService;
    @NotNull
    private final CheckType checkType;
    private final Logger log;

    @Inject
    public AppLicenseCheck(@NotNull AppLicenseCheckService checkService) {
        Intrinsics.checkNotNullParameter((Object)checkService, (String)"checkService");
        super("We couldn't complete the cloud license check for apps", "Checking cloud license of all apps", "All apps meet cloud license check requirements", "Some apps need a cloud license update");
        this.checkService = checkService;
        this.checkType = CheckType.AppLicenseCheck;
        this.log = LoggerFactory.getLogger(AppLicenseCheck.class);
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"cloudId", (Object)ctx.getCloudId()), TuplesKt.to((Object)"appKeys", ctx.getAppKeys()), TuplesKt.to((Object)"preflightCheckExecutionId", (Object)ctx.getPreflightCheckExecutionId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public NotBlockingCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        NotBlockingCheckResult notBlockingCheckResult;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        try {
            notBlockingCheckResult = this.checkService.performCheck(checkRequest);
        }
        catch (Exception e) {
            this.log.error("Failed to perform app license check", (Throwable)e);
            return new NotBlockingCheckResult(false, MapsKt.mapOf((Pair)TuplesKt.to((Object)"executionError", (Object)true)));
        }
        return notBlockingCheckResult;
    }

    @Override
    protected void inject(@NotNull CheckResultDto dto, @Nullable CheckResult checkResult) {
        block2: {
            Collection apps;
            Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
            super.inject(dto, checkResult);
            dto.setNumberOfOccurrences(Integer.valueOf(0));
            dto.setDetails(new CheckDetailsDto());
            CheckResult checkResult2 = checkResult;
            if (checkResult2 == null) break block2;
            CheckResult it = checkResult2;
            boolean bl = false;
            Object v = checkResult.details.get("appLicenseCheck");
            Collection collection = v instanceof Collection ? (Collection)v : null;
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            Collection $this$inject_u24lambda_u241_u24lambda_u240 = apps = collection;
            boolean bl2 = false;
            dto.setNumberOfOccurrences(Integer.valueOf($this$inject_u24lambda_u241_u24lambda_u240.size()));
            dto.getDetails().setListOfOccurrences(CollectionsKt.toList((Iterable)$this$inject_u24lambda_u241_u24lambda_u240));
            Map map = checkResult.details;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"details");
            if (this.retrieveExecutionError(map)) {
                dto.setDescription("We couldn't complete the cloud license check for apps");
                dto.getDetails().setLongDescription("Retry the check. If the problem persists, contact Atlassian Support.");
            }
        }
    }

    private final boolean retrieveExecutionError(Map<String, ? extends Object> checkResultDetails) {
        Object object = checkResultDetails.getOrDefault("executionError", (Object)false);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        return (Boolean)object;
    }
}

