/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.jira.migration.amsclient.DefaultAppMigrationServiceClient;
import com.atlassian.jira.migration.assessment.AppAggregatorClient;
import com.atlassian.jira.migration.assessment.AppAggregatorResponse;
import com.atlassian.jira.migration.assessment.AppAssessmentServiceKt;
import com.atlassian.jira.migration.assessment.PluginManager;
import com.atlassian.jira.migration.events.AppLicenseCheckEvent;
import com.atlassian.jira.migration.events.ExportStatistics;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.preflight.AppLicenseCheckResult;
import com.atlassian.jira.migration.preflight.AppLicenseCheckService;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import com.atlassian.migration.app.MigratabliltyInfo;
import com.atlassian.migration.app.dto.AppsLicenseDetailDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/jira/migration/preflight/AppLicenseCheckService;", "", "amsClient", "Lcom/atlassian/jira/migration/amsclient/DefaultAppMigrationServiceClient;", "appAggregatorClient", "Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;", "pluginManager", "Lcom/atlassian/jira/migration/assessment/PluginManager;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "migratibilityInfo", "Lcom/atlassian/migration/app/MigratabliltyInfo;", "(Lcom/atlassian/jira/migration/amsclient/DefaultAppMigrationServiceClient;Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;Lcom/atlassian/jira/migration/assessment/PluginManager;Lcom/atlassian/jira/migration/events/MigrationEventBus;Lcom/atlassian/migration/app/MigratabliltyInfo;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "performCheck", "Lcom/atlassian/jira/migration/preflight/model/NotBlockingCheckResult;", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppLicenseCheckService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLicenseCheckService.kt\ncom/atlassian/jira/migration/preflight/AppLicenseCheckService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1194#2,2:120\n1222#2,4:122\n766#2:126\n857#2,2:127\n1549#2:129\n1620#2,3:130\n1045#2:133\n*S KotlinDebug\n*F\n+ 1 AppLicenseCheckService.kt\ncom/atlassian/jira/migration/preflight/AppLicenseCheckService\n*L\n40#1:120,2\n40#1:122,4\n58#1:126\n58#1:127,2\n59#1:129\n59#1:130,3\n75#1:133\n*E\n"})
public final class AppLicenseCheckService {
    @NotNull
    private final DefaultAppMigrationServiceClient amsClient;
    @NotNull
    private final AppAggregatorClient appAggregatorClient;
    @NotNull
    private final PluginManager pluginManager;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    @NotNull
    private final MigratabliltyInfo migratibilityInfo;
    private final Logger log;

    @Inject
    public AppLicenseCheckService(@NotNull DefaultAppMigrationServiceClient amsClient, @NotNull AppAggregatorClient appAggregatorClient, @NotNull PluginManager pluginManager, @NotNull MigrationEventBus migrationEventBus, @NotNull MigratabliltyInfo migratibilityInfo) {
        Intrinsics.checkNotNullParameter((Object)amsClient, (String)"amsClient");
        Intrinsics.checkNotNullParameter((Object)appAggregatorClient, (String)"appAggregatorClient");
        Intrinsics.checkNotNullParameter((Object)pluginManager, (String)"pluginManager");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        Intrinsics.checkNotNullParameter((Object)migratibilityInfo, (String)"migratibilityInfo");
        this.amsClient = amsClient;
        this.appAggregatorClient = appAggregatorClient;
        this.pluginManager = pluginManager;
        this.migrationEventBus = migrationEventBus;
        this.migratibilityInfo = migratibilityInfo;
        this.log = LoggerFactory.getLogger(AppLicenseCheckService.class);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NotBlockingCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object object;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        long startTime = System.nanoTime();
        String cloudId2 = PreflightCheckKt.getCloudId(checkRequest);
        Set<String> serverAppKeys = PreflightCheckKt.getAppKeys(checkRequest);
        Iterable $this$associateBy$iv = serverAppKeys;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            String string = (String)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String cloudAppKeyFromMAA = this.appAggregatorClient.getServerAppData((String)it).getCloudKey();
            object.put((String)CollectionsKt.first((Iterable)this.migratibilityInfo.getCloudAppKeys((String)it, cloudAppKeyFromMAA)), element$iv$iv);
        }
        Map cloudAppKeysToServerAppKeys = destination$iv$iv;
        List missingAppLicenses = this.amsClient.getAppsLicense(cloudId2, CollectionsKt.toList((Iterable)cloudAppKeysToServerAppKeys.keySet())).getAppLicenses();
        if (missingAppLicenses.size() == 1 && Intrinsics.areEqual((Object)((AppsLicenseDetailDto)missingAppLicenses.get(0)).getAppKey(), (Object)"APP_LICENSE_CHECK_DISABLED")) {
            this.log.warn("App license check is disabled in App migration service for cloud id: {}", (Object)cloudId2);
            return new NotBlockingCheckResult(true);
        }
        Iterable capacity$iv22 = missingAppLicenses;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AppsLicenseDetailDto it = (AppsLicenseDetailDto)element$iv$iv;
            boolean bl = false;
            if (!(!it.getLicensed())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            String serverAppKey;
            AppsLicenseDetailDto it = (AppsLicenseDetailDto)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            String cloudAppKey = it.getAppKey();
            AppAggregatorResponse appAggregatorResponse = this.appAggregatorClient.getCloudAppData(cloudAppKey);
            String string2 = (String)cloudAppKeysToServerAppKeys.get(cloudAppKey);
            if (string2 == null) {
                string2 = serverAppKey = "unknown";
            }
            if ((string = appAggregatorResponse.getCloudUrl()) == null) {
                string = "";
            }
            String cloudUrl = string;
            String appName = AppAssessmentServiceKt.getAppName(appAggregatorResponse, this.pluginManager.getPlugin(serverAppKey), cloudAppKey);
            object.add(new AppLicenseCheckResult(cloudAppKey, appName, cloudUrl));
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$sortedBy = false;
        Set appLicenseCheckResults = CollectionsKt.toSet((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AppLicenseCheckResult it = (AppLicenseCheckResult)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (AppLicenseCheckResult)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        }));
        NotBlockingCheckResult checkResult = new NotBlockingCheckResult(appLicenseCheckResults.isEmpty(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"appLicenseCheck", (Object)appLicenseCheckResults)));
        long endTime = System.nanoTime();
        Set<String> appWithFailedCheck2 = appLicenseCheckResults.stream().map(arg_0 -> AppLicenseCheckService.performCheck$lambda$4(performCheck.appWithFailedCheck.1.INSTANCE, arg_0)).collect(Collectors.toSet());
        String string = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
        String string3 = PreflightCheckKt.getUniqueId(checkRequest);
        if (string3 == null) {
            string3 = "";
        }
        long l = (endTime - startTime) / (long)1000000;
        boolean bl = !checkResult.getHasWarnings();
        ExportStatistics exportStatistics = ExportStatistics.Companion.getEMPTY();
        int n = PreflightCheckKt.getAppKeys(checkRequest).size();
        int n2 = appWithFailedCheck2.size();
        Set<String> set = PreflightCheckKt.getAppKeys(checkRequest);
        Intrinsics.checkNotNull(appWithFailedCheck2);
        this.migrationEventBus.post(new AppLicenseCheckEvent("appLicenseCheck", string, string3, l, bl, exportStatistics, n, n2, SetsKt.minus(set, (Iterable)appWithFailedCheck2), appWithFailedCheck2, PreflightCheckKt.getCloudId(checkRequest)));
        return checkResult;
    }

    private static final String performCheck$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }
}

