/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.jira.migration.assessment.AppAggregatorClient;
import com.atlassian.jira.migration.assessment.AppAggregatorResponse;
import com.atlassian.jira.migration.assessment.AppAssessmentServiceKt;
import com.atlassian.jira.migration.assessment.PluginManager;
import com.atlassian.jira.migration.common.Constants;
import com.atlassian.jira.migration.events.AppMissingListenerCheckEvent;
import com.atlassian.jira.migration.events.ExportStatistics;
import com.atlassian.jira.migration.events.MigrationEventBus;
import com.atlassian.jira.migration.listeners.AppListenerIssueService;
import com.atlassian.jira.migration.listeners.AppListenerIssueType;
import com.atlassian.jira.migration.preflight.AppMissingListenerCheckResult;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.model.NotBlockingCheckResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J6\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/jira/migration/preflight/AppMissingListenerCheckService;", "", "appListenerIssueService", "Lcom/atlassian/jira/migration/listeners/AppListenerIssueService;", "appAggregatorClient", "Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;", "pluginManager", "Lcom/atlassian/jira/migration/assessment/PluginManager;", "migrationEventBus", "Lcom/atlassian/jira/migration/events/MigrationEventBus;", "(Lcom/atlassian/jira/migration/listeners/AppListenerIssueService;Lcom/atlassian/jira/migration/assessment/AppAggregatorClient;Lcom/atlassian/jira/migration/assessment/PluginManager;Lcom/atlassian/jira/migration/events/MigrationEventBus;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "createCheckResult", "Lcom/atlassian/jira/migration/preflight/AppMissingListenerCheckResult;", "appKey", "", "isAppMissingListener", "", "logAnalyticEvent", "", "checkRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "hasWarnings", "appsMissingListenerSet", "", "startTime", "", "endTime", "performCheck", "Lcom/atlassian/jira/migration/preflight/model/NotBlockingCheckResult;", "jira-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nAppMissingListenerCheckService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppMissingListenerCheckService.kt\ncom/atlassian/jira/migration/preflight/AppMissingListenerCheckService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n766#2:94\n857#2,2:95\n1549#2:97\n1620#2,3:98\n1549#2:101\n1620#2,3:102\n*S KotlinDebug\n*F\n+ 1 AppMissingListenerCheckService.kt\ncom/atlassian/jira/migration/preflight/AppMissingListenerCheckService\n*L\n33#1:94\n33#1:95,2\n33#1:97\n33#1:98,3\n45#1:101\n45#1:102,3\n*E\n"})
public final class AppMissingListenerCheckService {
    @NotNull
    private final AppListenerIssueService appListenerIssueService;
    @NotNull
    private final AppAggregatorClient appAggregatorClient;
    @NotNull
    private final PluginManager pluginManager;
    @NotNull
    private final MigrationEventBus migrationEventBus;
    private final Logger log;

    @Inject
    public AppMissingListenerCheckService(@NotNull AppListenerIssueService appListenerIssueService, @NotNull AppAggregatorClient appAggregatorClient, @NotNull PluginManager pluginManager, @NotNull MigrationEventBus migrationEventBus) {
        Intrinsics.checkNotNullParameter((Object)appListenerIssueService, (String)"appListenerIssueService");
        Intrinsics.checkNotNullParameter((Object)appAggregatorClient, (String)"appAggregatorClient");
        Intrinsics.checkNotNullParameter((Object)pluginManager, (String)"pluginManager");
        Intrinsics.checkNotNullParameter((Object)migrationEventBus, (String)"migrationEventBus");
        this.appListenerIssueService = appListenerIssueService;
        this.appAggregatorClient = appAggregatorClient;
        this.pluginManager = pluginManager;
        this.migrationEventBus = migrationEventBus;
        this.log = LoggerFactory.getLogger(AppMissingListenerCheckService.class);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NotBlockingCheckResult performCheck(@NotNull CheckRequest checkRequest) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        String it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        long startTime = System.nanoTime();
        this.log.info("Checking apps: " + PreflightCheckKt.getAppKeys(checkRequest) + " for missing migration listeners");
        Iterable $this$filter$iv = PreflightCheckKt.getAppKeys(checkRequest);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = (Pair[])new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!this.isAppMissingListener(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(this.createCheckResult(it));
        }
        Set checkResultSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        long endTime = System.nanoTime();
        destination$iv$iv = new Pair[]{TuplesKt.to((Object)"appMissingListenerCheck", (Object)checkResultSet), TuplesKt.to((Object)"disableEnableAppUrl", (Object)Constants.buildPageUrl$default(Constants.INSTANCE, "/plugins/servlet/upm", null, 2, null))};
        NotBlockingCheckResult checkResult = new NotBlockingCheckResult(checkResultSet.isEmpty(), MapsKt.mapOf((Pair[])destination$iv$iv));
        this.log.warn("Automated apps missing listener: " + checkResultSet);
        destination$iv$iv = checkResultSet;
        boolean bl = checkResult.getHasWarnings();
        CheckRequest checkRequest2 = checkRequest;
        object = this;
        boolean $i$f$map2 = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            AppMissingListenerCheckResult appMissingListenerCheckResult = (AppMissingListenerCheckResult)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it2.getKey());
        }
        collection = (List)destination$iv$iv2;
        super.logAnalyticEvent(checkRequest2, bl, CollectionsKt.toSet((Iterable)collection), startTime, endTime);
        return checkResult;
    }

    private final boolean isAppMissingListener(String appKey) {
        AppListenerIssueType issueType = this.appListenerIssueService.determineIssue(appKey);
        this.log.debug("{} has listener issue type: {}", (Object)appKey, (Object)issueType);
        return issueType == AppListenerIssueType.AUTOMATED_WITHOUT_SERVER_LISTENER;
    }

    private final AppMissingListenerCheckResult createCheckResult(String appKey) {
        this.log.debug("Retrieving appName for {}", (Object)appKey);
        AppAggregatorResponse appAggregatorResponse = this.appAggregatorClient.getServerAppData(appKey);
        String appName = AppAssessmentServiceKt.getAppName(appAggregatorResponse, this.pluginManager.getPlugin(appKey), appKey);
        this.log.debug("{} has app name {}", (Object)appKey, (Object)appName);
        return new AppMissingListenerCheckResult(appKey, appName);
    }

    private final void logAnalyticEvent(CheckRequest checkRequest, boolean hasWarnings, Set<String> appsMissingListenerSet, long startTime, long endTime) {
        String string = PreflightCheckKt.getPreflightCheckExecutionId(checkRequest);
        String string2 = PreflightCheckKt.getUniqueId(checkRequest);
        if (string2 == null) {
            string2 = "";
        }
        this.migrationEventBus.post(new AppMissingListenerCheckEvent("appMissingListenerCheck", string, string2, (endTime - startTime) / (long)1000000, !hasWarnings, ExportStatistics.Companion.getEMPTY(), PreflightCheckKt.getAppKeys(checkRequest).size(), appsMissingListenerSet.size(), SetsKt.minus(PreflightCheckKt.getAppKeys(checkRequest), (Iterable)appsMissingListenerSet), appsMissingListenerSet, PreflightCheckKt.getCloudId(checkRequest)));
    }
}

