/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.migration.preflight;

import com.atlassian.cmpt.check.base.CheckRequest;
import com.atlassian.cmpt.check.base.CheckResult;
import com.atlassian.cmpt.check.base.CheckStatus;
import com.atlassian.cmpt.check.dto.CheckResultDto;
import com.atlassian.cmpt.check.mapper.AppOutdatedMapper;
import com.atlassian.cmpt.check.version.AppOutdatedChecker;
import com.atlassian.cmpt.check.version.AppOutdatedContext;
import com.atlassian.jira.migration.features.MigrationFeatures;
import com.atlassian.jira.migration.preflight.CheckExecutionContext;
import com.atlassian.jira.migration.preflight.PluginVersionCheckResult;
import com.atlassian.jira.migration.preflight.PreflightCheck;
import com.atlassian.jira.migration.preflight.PreflightCheckKt;
import com.atlassian.jira.migration.preflight.model.CheckType;
import com.atlassian.jira.migration.version.JiraMigrationVersionService;
import com.atlassian.jira.migration.version.remote.AppOutdatedInfoProvider;
import com.atlassian.jira.migration.version.remote.AppOutdatedResponse;
import java.time.ZoneId;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001)B\u001f\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u001c\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\u0002H\u0014J\u0012\u0010\"\u001a\u00020 2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u0015H\u0016J\f\u0010'\u001a\u00020(*\u00020\u0019H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/atlassian/jira/migration/preflight/AppOutdatedCheck;", "Lcom/atlassian/jira/migration/preflight/PreflightCheck;", "Lcom/atlassian/cmpt/check/base/CheckResult;", "jiraMigrationVersionService", "Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;", "migrationFeatures", "Lcom/atlassian/jira/migration/features/MigrationFeatures;", "appOutdatedInfoProvider", "Lcom/atlassian/jira/migration/version/remote/AppOutdatedInfoProvider;", "(Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/version/remote/AppOutdatedInfoProvider;)V", "buildPageUrl", "Lkotlin/Function0;", "", "(Lcom/atlassian/jira/migration/version/JiraMigrationVersionService;Lcom/atlassian/jira/migration/features/MigrationFeatures;Lcom/atlassian/jira/migration/version/remote/AppOutdatedInfoProvider;Lkotlin/jvm/functions/Function0;)V", "appOutdatedMapper", "Lcom/atlassian/cmpt/check/mapper/AppOutdatedMapper;", "checkType", "Lcom/atlassian/jira/migration/preflight/model/CheckType;", "getCheckType", "()Lcom/atlassian/jira/migration/preflight/model/CheckType;", "buildCheckRequest", "Lcom/atlassian/cmpt/check/base/CheckRequest;", "ctx", "Lcom/atlassian/jira/migration/preflight/CheckExecutionContext;", "checkIfThereIsNewerVersion", "Lcom/atlassian/jira/migration/preflight/PluginVersionCheckResult;", "cloudId", "pluginVersion", "checkPluginVersion", "inject", "", "dto", "Lcom/atlassian/cmpt/check/dto/CheckResultDto;", "checkResult", "map", "checkStatus", "Lcom/atlassian/cmpt/check/base/CheckStatus;", "performCheck", "checkRequest", "toAppOutdatedContext", "Lcom/atlassian/cmpt/check/version/AppOutdatedContext;", "Companion", "jira-migration-plugin"})
public final class AppOutdatedCheck
extends PreflightCheck<CheckResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JiraMigrationVersionService jiraMigrationVersionService;
    @NotNull
    private final MigrationFeatures migrationFeatures;
    @NotNull
    private final AppOutdatedInfoProvider appOutdatedInfoProvider;
    @NotNull
    private final AppOutdatedMapper appOutdatedMapper;
    @NotNull
    private final CheckType checkType;
    private static final Logger log = LoggerFactory.getLogger(AppOutdatedChecker.class);

    public AppOutdatedCheck(@NotNull JiraMigrationVersionService jiraMigrationVersionService, @NotNull MigrationFeatures migrationFeatures, @NotNull AppOutdatedInfoProvider appOutdatedInfoProvider, @NotNull Function0<String> buildPageUrl) {
        Intrinsics.checkNotNullParameter((Object)jiraMigrationVersionService, (String)"jiraMigrationVersionService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)appOutdatedInfoProvider, (String)"appOutdatedInfoProvider");
        Intrinsics.checkNotNullParameter(buildPageUrl, (String)"buildPageUrl");
        this.jiraMigrationVersionService = jiraMigrationVersionService;
        this.migrationFeatures = migrationFeatures;
        this.appOutdatedInfoProvider = appOutdatedInfoProvider;
        this.appOutdatedMapper = new AppOutdatedMapper((String)buildPageUrl.invoke());
        this.checkType = CheckType.AppOutdated;
    }

    @Inject
    public AppOutdatedCheck(@NotNull JiraMigrationVersionService jiraMigrationVersionService, @NotNull MigrationFeatures migrationFeatures, @NotNull AppOutdatedInfoProvider appOutdatedInfoProvider) {
        Intrinsics.checkNotNullParameter((Object)jiraMigrationVersionService, (String)"jiraMigrationVersionService");
        Intrinsics.checkNotNullParameter((Object)migrationFeatures, (String)"migrationFeatures");
        Intrinsics.checkNotNullParameter((Object)appOutdatedInfoProvider, (String)"appOutdatedInfoProvider");
        this(jiraMigrationVersionService, migrationFeatures, appOutdatedInfoProvider, (Function0<String>)((Function0)1.INSTANCE));
    }

    @Override
    @NotNull
    public CheckType getCheckType() {
        return this.checkType;
    }

    @Override
    @NotNull
    public CheckRequest buildCheckRequest(@NotNull CheckExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"cloudId", (Object)ctx.getCloudId()), TuplesKt.to((Object)"uniqueId", (Object)ctx.getUniqueId())};
        return new CheckRequest(this.getCheckType().name(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Override
    @NotNull
    public CheckResult performCheck(@NotNull CheckRequest checkRequest) {
        AppOutdatedContext appOutdatedContext;
        Intrinsics.checkNotNullParameter((Object)checkRequest, (String)"checkRequest");
        if (this.migrationFeatures.getSkipAppOutdatedCheck()) {
            return new CheckResult(true);
        }
        PluginVersionCheckResult pluginVersionCheckResult = this.checkPluginVersion(PreflightCheckKt.getCloudId(checkRequest));
        CheckResult checkResult = new AppOutdatedChecker().check(pluginVersionCheckResult != null && (appOutdatedContext = this.toAppOutdatedContext(pluginVersionCheckResult)) != null ? appOutdatedContext : new AppOutdatedContext(false));
        Intrinsics.checkNotNullExpressionValue((Object)checkResult, (String)"check(...)");
        return checkResult;
    }

    @NotNull
    public CheckResultDto map(@Nullable CheckStatus checkStatus) {
        CheckResultDto checkResultDto = this.appOutdatedMapper.map(checkStatus);
        Intrinsics.checkNotNullExpressionValue((Object)checkResultDto, (String)"map(...)");
        return checkResultDto;
    }

    protected void inject(@Nullable CheckResultDto dto, @Nullable CheckResult checkResult) {
        throw new IllegalStateException("Shouldn't be called, mapping is delegated");
    }

    private final PluginVersionCheckResult checkIfThereIsNewerVersion(String cloudId2, String pluginVersion) {
        PluginVersionCheckResult pluginVersionCheckResult;
        try {
            AppOutdatedResponse response2 = this.appOutdatedInfoProvider.getPluginOutdatedVersionInfo(cloudId2, pluginVersion);
            pluginVersionCheckResult = response2.isAppOutdated() ? new PluginVersionCheckResult(PluginVersionCheckResult.Result.OUTDATED, null, 2, null) : (response2.getNextRelease() == null ? new PluginVersionCheckResult(PluginVersionCheckResult.Result.LATEST, null, 2, null) : new PluginVersionCheckResult(PluginVersionCheckResult.Result.WITHIN_GRACE, response2.getNextRelease().getUpgradeBy().atStartOfDay(ZoneId.of("UTC")).toInstant()));
        }
        catch (Exception e) {
            log.error("Error occurred when communicating with Cloud", (Throwable)e);
            pluginVersionCheckResult = null;
        }
        return pluginVersionCheckResult;
    }

    private final PluginVersionCheckResult checkPluginVersion(String cloudId2) {
        PluginVersionCheckResult pluginVersionCheckResult;
        if (this.jiraMigrationVersionService.isPluginVersionUnknown()) {
            log.warn("Current version of the plugin is unknown. Will assume that plugin version is not outdated.");
            pluginVersionCheckResult = null;
        } else {
            pluginVersionCheckResult = this.checkIfThereIsNewerVersion(cloudId2, this.jiraMigrationVersionService.getPluginVersion());
        }
        return pluginVersionCheckResult;
    }

    private final AppOutdatedContext toAppOutdatedContext(PluginVersionCheckResult $this$toAppOutdatedContext) {
        return $this$toAppOutdatedContext.getResult() == PluginVersionCheckResult.Result.OUTDATED ? new AppOutdatedContext(true) : new AppOutdatedContext(false, $this$toAppOutdatedContext.getUpgradeBy());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/jira/migration/preflight/AppOutdatedCheck$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jira-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

